# underOverlay レイヤー制御システム - 設定ガイド

## 📌 概要

挿入系イベントで「局部パーツが衣装に干渉する」場合に`underOverlay`を使用することで、
パーツが衣装の下に描画され、自然な表現が可能になります。

**v2.0の改善点：**
- ✅ モンスターごとに挿入時のレイヤーを設定可能
- ✅ 部位ごとに個別設定も可能
- ✅ デフォルトは`overlay`（干渉しない場合が標準的）
- ✅ 干渉するモンスターのみ明示的に`underOverlay`を指定

## 🔧 設定方法

### 方法1: モンスター全体のデフォルト設定（推奨）

`VisualOverlayData.js`の各モンスター設定に`insertedBehavior.layer`を追加：

```javascript
slime: {
  insertedBehavior: {
    layer: "underOverlay",  // 挿入時は衣装の下に描画
    alwaysShowBreast: true,
    // ... その他の設定
  },
  mapping: { ... }
}
```

### 方法2: 部位ごとの個別設定

特定の部位だけ異なるレイヤーを使いたい場合：

```javascript
slime: {
  insertedBehavior: {
    layer: "underOverlay",  // デフォルトはunderOverlay
    alwaysShowBreast: true
  },
  mapping: {
    insert: {
      pussy: {
        soft: "insert_pussy_soft",
        hard: "insert_pussy_hard",
        // layer指定なし → insertedBehavior.layerが使われる
      },
      mouth: {
        soft: "insert_mouth_soft",
        hard: "insert_mouth_hard",
        layer: "overlay"  // 口だけは例外でoverlay
      }
    }
  }
}
```

## 📋 設定済みモンスター一覧

| モンスター | 挿入時のレイヤー | 理由 |
|-----------|----------------|------|
| **slime** | `underOverlay` | 膣挿入：衣装に干渉する |
| **goblin** | `overlay` | 膣挿入：衣装に干渉しない（立ち絵の上に描画） |
| **tentacle** | `underOverlay` | 膣挿入：衣装に干渉する |
| **tentacle_hebe** | `underOverlay` | 膣挿入：衣装に干渉する |
| **breastTentacle** | `underOverlay` | 膣挿入：衣装に干渉する |
| **aphrodisiacSlime** | `overlay` | 口挿入：衣装に干渉しない |
| **reider** | `underOverlay` | 膣挿入：衣装に干渉する |
| **hypnoticGhost** | `overlay` | 精神攻撃：物理的干渉なし |

## 🎯 レイヤーの優先順位

設定は以下の優先順位で適用されます：

1. **部位個別の`layer`設定**（最優先）
   ```javascript
   insert: {
     pussy: {
       layer: "underOverlay"  // ← これが最優先
     }
   }
   ```

2. **`insertedBehavior.layer`設定**
   ```javascript
   insertedBehavior: {
     layer: "underOverlay"  // ← 部位指定がない場合
   }
   ```

3. **デフォルト**：`overlay`（干渉しない場合が標準的なため）

## 🆕 新しいモンスターの追加手順

### Step 1: 挿入時に衣装と干渉するか判断

- **干渉する**（膣挿入など）→ `underOverlay`
- **干渉しない**（口挿入、精神攻撃など）→ `overlay`

### Step 2: VisualOverlayData.jsに設定追加

```javascript
newMonster: {
  insertedBehavior: {
    layer: "underOverlay"  // または "overlay"
  },
  mapping: {
    attack: { ... },
    insert: { ... }
  }
}
```

### Step 3: テストプレイで確認

1. 挿入イベントを発動
2. F8でコンソールを開く
3. 以下のログを確認：
   ```
   [OverlayBuilder] Layer decision: enemyKey=newMonster, targetPart=pussy, isInserted=true, layer=underOverlay
   [OverlayBuilder] → underOverlays: insert_pussy_soft
   ```

## 🐛 トラブルシューティング

### 症状：局部パーツが衣装の上に出てしまう

**原因：** `layer: "overlay"`になっている

**解決策：**
```javascript
insertedBehavior: {
  layer: "underOverlay"  // これを追加
}
```

### 症状：局部パーツが衣装の下に隠れて見えない

**原因：** `layer: "underOverlay"`になっているが、干渉しないタイプ

**解決策：**
```javascript
insertedBehavior: {
  layer: "overlay"  // overlayに変更
}
```

### 症状：設定が反映されない

**確認項目：**
1. `insertedBehavior`のスペルミス
2. プラグインの読み込み順序（`VisualOverlayData.js` → `OverlayBuilder.js`）
3. F5でリロードしてキャッシュクリア

## 💡 ベストプラクティス

### ✅ 推奨

```javascript
// モンスター全体でデフォルトを設定
insertedBehavior: {
  layer: "underOverlay"
}
```

### ⚠️ 非推奨

```javascript
// 各部位に個別設定（冗長）
insert: {
  pussy: { layer: "underOverlay" },
  mouth: { layer: "underOverlay" },
  breast: { layer: "underOverlay" }
}
```

### 🎯 例外時のみ部位個別設定

```javascript
insertedBehavior: {
  layer: "underOverlay"  // デフォルト
},
mapping: {
  insert: {
    pussy: {
      // layer指定なし → デフォルトが使われる
    },
    mouth: {
      layer: "overlay"  // 口だけ例外
    }
  }
}
```

## 📊 実装の仕組み

### OverlayBuilder.js

```javascript
function getDefaultInsertLayer(enemySets, targetPart, isInserted) {
  if (!isInserted) return "overlay";
  
  // 1. insertedBehavior.layer から取得
  const behaviorLayer = enemySets?.insertedBehavior?.layer;
  if (behaviorLayer) return behaviorLayer;
  
  // 2. デフォルト（設定がない場合）
  return "overlay";
}
```

### BattleBustManager.js

```javascript
if (preferredLayer === "underOverlay") {
  // 衣装の下に配置
  group._under.addChild(sprite);
} else {
  // 衣装の上に配置
  group._overlay.addChild(sprite);
}
```

## 🎨 視覚的な説明

```
【overlay】（衣装の上）
┌────────────────┐
│  擬音バブル     │ ← 最前面
├────────────────┤
│  局部パーツ     │ ← ここに表示（干渉しない）
├────────────────┤
│  衣装           │
├────────────────┤
│  キャラ本体     │
└────────────────┘

【underOverlay】（衣装の下）
┌────────────────┐
│  擬音バブル     │ ← 最前面
├────────────────┤
│  衣装           │
├────────────────┤
│  局部パーツ     │ ← ここに表示（干渉する）
├────────────────┤
│  キャラ本体     │
└────────────────┘
```

## ✨ まとめ

- モンスターごとに`insertedBehavior.layer`を設定するだけでOK
- デフォルトは`underOverlay`（後方互換）
- 干渉しないモンスターは明示的に`overlay`を指定
- 部位ごとの例外設定も可能

