import json
from pathlib import Path
import sys

sys.stdout.reconfigure(encoding='utf-8')

# 削除対象
target_overlays = [
    'ひゃあっ1-1_right',
    'おほッ1-1_left',
    'んむっ1-1_right',
    'ひゃあっ1-1_left',
    'あっ1-1_right',
    'あっ1-1_left'
]

def collect_overlays(obj):
    overlays = set()
    if isinstance(obj, dict):
        if 'overlays' in obj and isinstance(obj['overlays'], list):
            overlays.update(obj['overlays'])
        if 'underOverlays' in obj and isinstance(obj['underOverlays'], list):
            overlays.update(obj['underOverlays'])
        for value in obj.values():
            overlays.update(collect_overlays(value))
    elif isinstance(obj, list):
        for item in obj:
            overlays.update(collect_overlays(item))
    return overlays

# JSONを読み込み
json_path = Path('dataEx/restraintProfiles/slime_restrained_high.json')
with open(json_path, encoding='utf-8') as f:
    data = json.load(f)

all_overlays = collect_overlays(data)

# 削除対象が残っているか確認
remaining = [o for o in target_overlays if o in all_overlays]

print("=" * 60)
print("削除確認: slime_restrained_high.json")
print("=" * 60)
print(f"削除対象: {len(target_overlays)}個")
print(f"残っている: {len(remaining)}個")

if remaining:
    print("\n❌ まだ削除されていない擬音:")
    for o in remaining:
        print(f"  - {o}")
else:
    print("\n✅ 全ての擬音が正常に削除されました！")

# 現在の擬音オーバーレイを表示
onomatopoeia = [o for o in all_overlays if any(ord(c) > 127 for c in o)]
if onomatopoeia:
    print(f"\n現在残っている擬音オーバーレイ: {len(onomatopoeia)}個")
    for o in sorted(onomatopoeia):
        print(f"  - {o}")
else:
    print("\n現在、擬音オーバーレイはありません")

