# 衣装耐久回復システムの使い方

## 1. プラグインの有効化

`js/plugins/ClothingDurabilityItem.js` を作成済みです。
RPGツクールMZのプラグイン管理で以下の順序で有効化してください：

1. `PleasureActorStatus.js` （既存）
2. `ClothingDurabilityItem.js` （新規作成）

## 2. アイテムでの衣装耐久回復

### 方法A: 部分回復アイテム

データベースでアイテムを作成し、メモ欄に以下を記入：

```
<RepairClothing:50>
```

- 数値（この例では50）が回復量です
- 1〜100の範囲で自由に設定できます

**例：**
- 「簡易修繕キット」: `<RepairClothing:30>`
- 「衣装修繕キット」: `<RepairClothing:50>`
- 「高級修繕キット」: `<RepairClothing:80>`

### 方法B: 全回復アイテム

データベースでアイテムを作成し、メモ欄に以下を記入：

```
<RestoreClothing>
```

- 衣装耐久を100（最大値）まで回復します

**例：**
- 「新しい衣装」: `<RestoreClothing>`

### アイテムの基本設定（RPGツクールMZでの設定）

データベース → アイテムで以下のように設定：

- **アイテムタイプ**: 通常アイテム
- **価格**: お好みで（例：500G）
- **消耗**: する
- **使用可能時**: 常時（メニュー＆戦闘両方で使える）または メニュー画面のみ
- **範囲**: 味方単体 または 味方全体
- **速度補正**: 0
- **成功率**: 100%
- **命中タイプ**: 必中
- **⚠️ 効果**: **何も設定しなくてOK！**（プラグインが自動判定します）
  - HPやMPも回復させたい場合は追加可能（例：HP回復 +0% +50）

## 3. イベントでの衣装耐久回復

イベントコマンド「スクリプト」で以下を実行します。

### 特定のアクターの衣装を回復

```javascript
// アクター1の衣装を50回復
repairActorClothing(1, 50);

// アクター1の衣装を全回復
restoreActorClothingFully(1);
```

### パーティ全員の衣装を回復

```javascript
// パーティ全員の衣装を50回復
repairPartyClothing(50);

// パーティ全員の衣装を全回復
restorePartyClothingFully();
```

### 衣装耐久を確認

```javascript
// アクター1の現在の衣装耐久を取得
const durability = getActorClothingDurability(1);
```

## 4. 使用例：イベント終了時に全回復

イベントの最後に以下のスクリプトを追加：

```javascript
restorePartyClothingFully();
```

または、テキストの表示と組み合わせて：

```
◆テキスト：なし, ウィンドウ, 中
：　　　　：安全な場所に到着した。
：　　　　：衣装を整えることができた。
◆スクリプト：restorePartyClothingFully();
```

## 5. 条件分岐での使用例

衣装の状態によって分岐する場合：

```javascript
// 条件分岐 → スクリプトで条件指定
getActorClothingDurability(1) < 30

// または変数に代入
$gameVariables.setValue(10, getActorClothingDurability(1));
```

その後、変数10を使って条件分岐できます。

## 6. 宿屋での全回復例

宿屋イベントで通常の回復と一緒に衣装も回復：

```
◆テキスト：なし, ウィンドウ, 中
：　　　　：ゆっくり休んだ。
◆全回復
◆スクリプト：restorePartyClothingFully();
◆テキスト：なし, ウィンドウ, 中
：　　　　：体も衣装も元通りになった！
```

## 7. 注意事項

- アクターIDは1から始まります（データベースで確認してください）
- 衣装耐久は0〜100の範囲です
- 戦闘中にアイテムを使用した場合、バトルログに回復メッセージが表示されます
- 回復量が現在値+指定量で100を超える場合、自動的に100でキャップされます

## 📋 最新版の改善点（2025年1月）

**v2.1の新機能：**
- ✅ **回復SE（効果音）が自動再生されます**
- ✅ **メッセージ表示機能**（「○○は破れた衣装を修復した…」）
- ✅ メニュー画面から使用できます
- ✅ 戦闘中も正しく効果が反映されます
- ✅ アイテムに「効果」を設定しなくても使用可能です
- ✅ 衣装耐久が最大の時は使用不可（無駄遣い防止）

**メッセージ表示について：**
- **戦闘中**：バトルログに即座に表示されます
  - 例：「セリアの衣装が修復された！（+50）」
- **メニュー画面**：マップに戻った時にメッセージウィンドウで表示されます
  - 例：「セリアは破れた衣装を修復した…」
  - 複数回使用した場合、まとめて表示されます

**重要な変更：**
プラグインを最新版に更新した場合、アイテムの「効果」欄は空でOKです。
メモ欄の `<RepairClothing:50>` または `<RestoreClothing>` だけで動作します。

## トラブルシューティング

### アイテムが効かない場合
1. プラグイン管理で `ClothingDurabilityItem.js` が有効になっているか確認
2. プラグインの順序が正しいか確認（PleasureActorStatusの後に配置）
3. F8でコンソールを開いて、エラーメッセージを確認
4. **アイテムの「範囲」が設定されているか確認**（「なし」だと使用できません）
5. 衣装耐久が既に100の場合、メニュー画面では使用できません（仕様）

### メニューで「使用できません」と表示される場合
- アイテムの「範囲」を「味方単体」または「味方全体」に設定してください
- 「使用可能時」を「常時」または「メニュー画面」に設定してください
- 対象キャラの衣装耐久が既に100の場合は使用できません

### 戦闘中に効果が表示されない場合
- F8キーでコンソールを開いて `[CDI] Clothing repaired` というログが出ているか確認
- ログが出ていれば内部では機能しています
- 衣装耐久ウィンドウの表示は次のターンで更新されます

### スクリプトコマンドでエラーが出る場合
1. アクターIDが正しいか確認
2. 関数名のスペルミスがないか確認
3. セミコロン（;）を忘れていないか確認

## 🧪 動作テスト手順

プラグインが正しく動作しているか確認する方法：

1. **テストプレイを開始**（F12キー）

2. **デベロッパーツールを開く**（F8キー）

3. **Consoleタブで以下を実行**：
   ```javascript
   // アクター1の衣装耐久を50に減らす（テスト用）
   $gameActors.actor(1).setClothingDurability(50);
   
   // 現在値を確認
   $gameActors.actor(1).getClothingDurability();
   // → 50 と表示されればOK
   ```

4. **アイテムを入手**（Consoleで実行）：
   ```javascript
   // アイテムID 1を入手（アイテムIDは自分で確認）
   $gameParty.gainItem($dataItems[1], 1);
   ```

5. **メニューを開いてアイテムを使用**
   - 使用できればOK
   - 使用後、Consoleに `[CDI] Clothing repaired` と表示されれば成功

6. **効果を確認**：
   ```javascript
   // 再度衣装耐久を確認
   $gameActors.actor(1).getClothingDurability();
   // → 回復量分増えていればOK
   ```

**期待される出力例：**
```
[CDI] Clothing repaired by item: +50 (50 -> 100) for キャラ名
[PAS] Clothing durability set: 100
```

