/*:
 * @target MZ
 * @plugindesc メニューを開いたときにコモンイベントを実行するプラグイン（ID指定）
 * @author ChatGPT
 *
 * @param CommonEventID
 * @text 実行するコモンイベントID
 * @type common_event
 * @desc メニューを開くたびに実行するコモンイベントのID
 * @default 1
 */

(() => {
    const pluginName = "CallCommonOnMenu";
    const parameters = PluginManager.parameters(pluginName);
    const commonEventId = Number(parameters["CommonEventID"] || 1);

    const _Scene_Menu_create = Scene_Menu.prototype.create;
    Scene_Menu.prototype.create = function () {
        if ($dataCommonEvents[commonEventId]) {
            $gameTemp.reserveCommonEvent(commonEventId);
        }
        _Scene_Menu_create.call(this);
    };
})();
