/*:
 * @target MZ
 * @plugindesc 名前入力画面を画面サイズにピッタリ収める（横幅=Graphics.boxWidth、X=0）
 * @help 画面幅を小さくしている環境で、名前入力ウィンドウが左にズレたり見切れる問題を修正します。
 * 他プラグインでScene_Name/Window_NameEdit/Window_NameInputを触っている場合は、
 * 本プラグインをそれらの「下（後）」に並べてください。
 */
(() => {
  const GAP = 8; // 編集欄と入力パネルのすき間

  // 幅は常に画面幅に
  Window_NameEdit.prototype.windowWidth = function() {
    return Graphics.boxWidth;
  };
  Window_NameInput.prototype.windowWidth = function() {
    return Graphics.boxWidth;
  };

  // 生成後に位置・サイズを強制的に再配置
  const _Scene_Name_create = Scene_Name.prototype.create;
  Scene_Name.prototype.create = function() {
    _Scene_Name_create.call(this);

    // 編集ウィンドウ：X=0、幅=画面幅に固定
    const ew = this._editWindow;
    ew.move(0, ew.y, Graphics.boxWidth, ew.height);
    ew.refresh();

    // 入力ウィンドウ：編集欄の直下に、画面下端までを確保
    const iw = this._inputWindow;
    const iy = ew.y + ew.height + GAP;
    const ih = Math.max(120, Graphics.boxHeight - iy); // 高さが足りないときの最低値
    iw.move(0, iy, Graphics.boxWidth, ih);
    iw.refresh();
  };
})();
