﻿class RomashaTopEffectData {
    constructor(xPos , yPos) {
        this.xPos = xPos;
        this.yPos = yPos;
        this.stopFlg = false;
        this.endFlg = false;
        this.nullFlg = false;
        /** @type {Game_Interpreter} */
        this.gi = null;
    }
    /** @param {Game_Interpreter} gi */
    Start(gi, nullFlg)  {
        nullFlg = typeof nullFlg !== 'undefined' ? nullFlg : false;
        this.gi = gi;
        let animeImg = "PN_RomaTopHart";
        if (nullFlg) animeImg = "PN_RomaTopNull";
        gi.PlaySpriteAnimeC(PN_RomaTopHart , PlayEffectPicPath + animeImg ,
            15 , 4, this.xPos , this.yPos , 2545);
    }
    /** @param {Game_Interpreter} gi */
    Update(gi) {
        if (MenuFlgSwich || MenuModeStr == _MMode.TalkMode || battleflg || $gameMessage.isBusy() || $gameMap.isEventRunning()) {
            this.Stop(gi);
            return;
        }
        this.ReStart(gi);
        if (overPointerSpCk(PN_RomaTopHart) && TouchInput.isTriggered()) {
            gi.SetCmnEventSc(CN_RomaTopHartClick);
            gi.RomaTopHeartEff_End(); 
        }
    }
    /** @param {Game_Interpreter} gi */
    End(gi) {
        gi.DelSprite(PN_RomaTopHart);
        this.endFlg = true;
    }
    /** @param {Game_Interpreter} gi */
    Stop() {
        if (!this.stopFlg) {
            this.stopFlg = true;
            this.gi.DelSprite(PN_RomaTopHart);
        }
    }
    /** @param {Game_Interpreter} gi */
    ReStart() {
        if (this.stopFlg) {
            this.stopFlg = false;
            this.Start(this.gi , this.nullFlg);
        }
    }
}
Game_Interpreter.prototype.RomaTopHeartEffTouchEff = function () {
    this.PlayPtcPic("RomaTopTouch",PL_MouseX,PL_MouseY);
}
/** @type {RomashaTopEffectData} */
let romashaTopEffectData = null;
Game_Interpreter.prototype.RomaTopHeartEff_Start = function (xPos , yPos) {
    romashaTopEffectData = new RomashaTopEffectData(xPos , yPos);
    romashaTopEffectData.nullFlg = false;
    romashaTopEffectData.Start(this);
}
Game_Interpreter.prototype.RomaTopHeartEff_StartNull = function (xPos , yPos) {
    console.log("RomaTopHeartEff_StartNull：" + xPos + "/" + yPos);
    romashaTopEffectData = new RomashaTopEffectData(xPos , yPos);
    romashaTopEffectData.nullFlg = true;
    romashaTopEffectData.Start(this , true);
}
let RomaTopEffect_NUpdateSc = Game_Interpreter.prototype.NUpdateSc;
Game_Interpreter.prototype.NUpdateSc = function () {
    RomaTopEffect_NUpdateSc.call(this);
    if (romashaTopEffectData != null) {
        romashaTopEffectData.Update(this);
    }
}
Game_Interpreter.prototype.RomaTopHeartEff_End = function () {
    if (romashaTopEffectData != null) romashaTopEffectData.End(this);
    romashaTopEffectData = null;
}
let RomaTopHeart_performTransfer = Game_Player.prototype.performTransfer;
Game_Player.prototype.performTransfer = function () {
    RomaTopHeart_performTransfer.call(this);
    if (romashaTopEffectData != null) RomaTopReStartFrame = 2;
}
let RomaTopReStartFrame = 0;
let RomaTopHeart_NUpdateSc = Game_Interpreter.prototype.NUpdateSc;
Game_Interpreter.prototype.NUpdateSc = function () {
    RomaTopHeart_NUpdateSc.call(this);
    if (RomaTopReStartFrame > 0) {
        RomaTopReStartFrame--;
        if (RomaTopReStartFrame == 0) {
            if (romashaTopEffectData != null) {
                romashaTopEffectData.Stop();
                romashaTopEffectData.ReStart();
            }
        }
    }
}
