﻿let DropItem_Initialize = Game_System.prototype.initialize;
Game_System.prototype.initialize = function () { 
    DropItem_Initialize.call(this);
    this.DropItems = []; 
};
const _Game_Map_setup = Game_Map.prototype.setup;
Game_Map.prototype.setup = function(mapId) {
    _Game_Map_setup.call(this, mapId);
    if ($gameSystem.DropItems == undefined) $gameSystem.DropItems = [];
    let events = this.events();
    for (let ev of events) {
        let _event = ev.event();
        let ckDropMemo = MetaChecker(_event , "DropItemID" , false);
        if (ckDropMemo != false) {
            if ($gameSystem.DropItems.indexOf(ckDropMemo) != -1) {
                ev.erase();
            }
        }
    }
};
let DropItemDataArr = []; 
DropItemDataArr.push(["尋問室" , 0]);
DropItemDataArr.push(["武器庫" , 0]);
DropItemDataArr.push(["3階夜" , 0]);
DropItemDataArr.push(["アーカイブルーム" , 0]);
DropItemDataArr.push(["多目的室" , 0]);
DropItemDataArr.push(["4番隊会議室" , 0]);
DropItemDataArr.push(["左訓練室" , 0]);
DropItemDataArr.push(["市街地1" , 1]);
DropItemDataArr.push(["プール" , 1]);
DropItemDataArr.push(["テレビ局スタジオ" , 1]);
DropItemDataArr.push(["4Fお部屋B" , 1]);
DropItemDataArr.push(["竜里右下" , 2]);
DropItemDataArr.push(["竜里民家1" , 2]);
DropItemDataArr.push(["竜里民家2" , 2]);
DropItemDataArr.push(["竜里民家4" , 2]);
DropItemDataArr.push(["中央ブロック1" , 3]);
DropItemDataArr.push(["地下都市A" , 3]);
DropItemDataArr.push(["地下都市B" , 3]);
DropItemDataArr.push(["地下都市C" , 3]);
DropItemDataArr.push(["倉庫" , 3]);
Game_Interpreter.prototype.GetDropItem = function () {
    let _event = $dataMap.events[this._eventId];
    let ckDropMemo = MetaChecker(_event , "DropItemID" , false);
    if (ckDropMemo != false) {
        if ($gameSystem.DropItems.indexOf(ckDropMemo) == -1) {
            $gameSystem.DropItems.push(ckDropMemo);
            $gameSwitches.setValue(SW_検索端末使用可能 , true);
        }
    }
}
Game_Interpreter.prototype.DropHintStart = function () {
    let max0Cnt = 0;
    let max1Cnt = 0;
    let max2Cnt = 0;
    let max3Cnt = 0;
    let ckDropArr = [];
    for (let i = 0; i < DropItemDataArr.length; i++) {
        let dropItemData = DropItemDataArr[i];
        if (dropItemData[1] == 0) max0Cnt++;
        if (dropItemData[1] == 1) max1Cnt++;
        if (dropItemData[1] == 2) max2Cnt++;
        if (dropItemData[1] == 3) max3Cnt++;
        if ($gameSystem.DropItems.indexOf(dropItemData[0]) != -1) {
            ckDropArr.push(dropItemData[1]);
        }
    }
    let viewStr = "【カード破片取得状況】\n\n";
    let count0 = 0;
    for (const ckDrop of ckDropArr) if (ckDrop == 0) count0++;
    viewStr += "ソリティア本部：" + count0 + "/" + max0Cnt + "\n";
    let count1 = 0;
    for (const ckDrop of ckDropArr) if (ckDrop == 1) count1++;
    viewStr += "市街地エリア：" + count1 + "/" + max1Cnt + "\n";
    let count2 = 0;
    for (const ckDrop of ckDropArr) if (ckDrop == 2) count2++;
    let basyo2Str = "竜の里";
    if (count2 == 0) basyo2Str = "？？？";
    viewStr += basyo2Str + "：" + count2 + "/" + max2Cnt + "\n";
    let count3 = 0;
    for (const ckDrop of ckDropArr) if (ckDrop == 3) count3++;
    let basyo3Str = "ストレージ";
    if (count3 == 0) basyo3Str = "？？？";
    viewStr += basyo3Str + "：" + count3 + "/" + max3Cnt + "\n";
    this.SetPictFIn( PN_LoadSucTop , "Black" , 0 , 0 , 0 , 0 , 10 , 240);
    this.SetPicStr(PN_LoadSucTop + 1 , viewStr , 32 , 100 , 100 , 0);
    this.MovePict(PN_LoadSucTop + 1 , true , true , 10);
}
Game_Interpreter.prototype.DropHintEnd = function () {
    this.MovePict(PN_LoadSucTop , true , true , 10 , 0);
    this.MovePict(PN_LoadSucTop + 1 , true , true , 10 , 0);
}
let DropItemGetCardEffect_Frame = 0;
Game_Interpreter.prototype.DropItemGetCardEffect = function (No) {
    let exitFlg = false;
    if (DropItemGetCardEffect_Frame == 0) {
        this.SetSpriteFIn( PN_AcCardBase , "PN_AcCardBase" , 0 , 0 , 0 , 0 , 30);
    }
    if (DropItemGetCardEffect_Frame == 30) {
        this.NPicFlash(PNo_Ensyutu ,"White" , 30);
        this.PlaySe("zb_Feary");
    }
    if (DropItemGetCardEffect_Frame == 30 + 60) {
        this.NPicFlash(PNo_Ensyutu ,"White" , 30);
        this.PlaySe("zb_Feary");
    }
    if (DropItemGetCardEffect_Frame == 30 + 115) {
        this.PlayPtcPic("LastAccessCard",true,true);
    }
    if (DropItemGetCardEffect_Frame == 30 + 150) {
        this.NPicFlash(PNo_Ensyutu ,"White" , 120);
        this.SetSpriteFIn( PN_AcCardBase , "PN_AcCard" + No , 0 , 0 , 0 , 0 , 10);
        this.PlaySe("Up3");
        this.PlayPtcPic("CCRea2",true,true);
    }
    if (DropItemGetCardEffect_Frame == 30 + 150 + 180) {
        this.MoveSprite(PN_AcCardBase , true , true , 30 , 0);
        exitFlg = true; 
    }
    DropItemGetCardEffect_Frame++;
    if (!exitFlg) {
        this.wait(1); 
        this._index--; 
    } else {
        DropItemGetCardEffect_Frame = 0; 
    }
}
