﻿const CN_Mg_Start = -1; 
const CN_Mg_Kekka = -1; 
const VN_ミニゲーム結果 = 1003;
const Mg_PicPath = "pictures/UI_MiniGame";
class Mini_Game { 
    constructor(_setMiniGameType) {
        this.var_max = 100;
        this.startFlg = false; 
        this.flame = 0;
        this.var = 0; 
        this.type = _setMiniGameType;
        this.tgt_var = 50;   
        this.tgt_lengh = 10; 
        this.tgt_yoyu = 30;  
        this.tgt_speed = 3.5; 
        this.tgt_ZureX = 0;   
        this.gage_Width = 45; 
        this.gage_Height = 372; 
        this.gage_Pos_X = 1077; 
        this.gage_Pos_Y = 274;  
        this.sd_CharaX = 0;
        this.sd_CharaY = 0;
        this.sd_Angle = 0; 
        this.csr_width = 104; 
        this.csr_height = 42; 
        this.speed = 3.5;      
        this.stopFlg = false; 
        this.stopFlame = 0;   
        switch (this.type) {
            case miniGameType._Tobikomi: 
                this.speed = 3.5;      
                this.tgt_var = 50;   //ターゲットの位置(%)
                this.tgt_lengh = 10; //ターゲットの長さ(%))
                this.tgt_yoyu = 30; 
                this.tgt_ZureX = 27;   
                this.gage_Width = 55; 
                this.gage_Height = 450; 
                this.gage_Pos_X = 1084; 
                this.gage_Pos_Y = 198;  
                this.sd_CharaX = 1264;  
                this.sd_CharaY = 172;   
                this.csr_width = 67; 
                this.csr_height = 88; 
                break;
            case miniGameType._Sumou: 
                this.speed = -3.5;      
                this.tgt_var = 5;   //ターゲットの位置(%)
                this.tgt_lengh = 10; //ターゲットの長さ(%))
                this.tgt_yoyu = 40; 
                this.tgt_ZureX = -25;   
                this.gage_Width = 75;   
                this.gage_Height = 313; 
                this.gage_Pos_X = 1152; 
                this.gage_Pos_Y = 239;  
                this.sd_CharaX = 1280;  
                this.sd_CharaY = 160;   
                this.csr_width = 92; 
                this.csr_height = 91; 
                break;
            case miniGameType._Bilibili: 
                this.speed = -3.5;      
                this.tgt_var = 5;   //ターゲットの位置(%)
                this.tgt_lengh = 10; //ターゲットの長さ(%))
                this.tgt_yoyu = 40; 
                this.tgt_ZureX = -25;   
                this.gage_Width = 179;   
                this.gage_Height = 485; 
                this.gage_Pos_X = 1088; 
                this.gage_Pos_Y = 198;  
                this.sd_CharaX = 1280;  
                this.sd_CharaY = 160;   
                this.csr_width = 92; 
                this.csr_height = 91; 
                break;
            case miniGameType._Biriyad: 
                this.speed = -3.5;      
                this.tgt_speed = -1;    
                this.tgt_var = 50;   //ターゲットの位置(%)
                this.tgt_lengh = 10; //ターゲットの長さ(%))
                this.tgt_yoyu = 30; 
                this.tgt_ZureX = 30;   
                this.gage_Width = 63; 
                this.gage_Height = 343; 
                this.gage_Pos_X = 1080; 
                this.gage_Pos_Y = 240;  
                this.sd_CharaX = 1277;  
                this.sd_CharaY = 134;   
                this.csr_width = 92; 
                this.csr_height = 91; 
                break;
        }
        this.speed /= 2;
    }
    get TgtX() {
        return this.gage_Pos_X + this.gage_Width / 2;
    }
    get TgtY() {
        let _TgtZureY = (this.gage_Height / 2) * ((this.tgt_var - 50) / 50);
        return  this.gage_Pos_Y + (this.gage_Height / 2) + _TgtZureY;
    }
    get MarkX() {
        return this.gage_Pos_X;
    }
    get MarkY() {
        let _MarkZureY = (this.gage_Height / 2) * ((this.var - 50) / 50); 
        let _MarkPsY = this.gage_Pos_Y + (this.gage_Height / 2) + _MarkZureY;
        return _MarkPsY;
    }
    Update() {
        this.flame++;
        this.sd_Angle = Math.sin(this.flame / 20) * 10;
        if (this.stopFlg) {
            this.stopFlame++;
            return; 
        }
        this.Var_Update();
    }
    Var_Update () {
        switch (this.type) {
            case miniGameType._Tobikomi: 
                this.var += this.speed;
                if(this.var < 0) {
                    this.var = 0;
                    this.speed *= -1; 
                }
                if(this.var > this.var_max) {
                    this.var = this.var_max;
                    this.speed *= -1; 
                }
                break;
            case miniGameType._Sumou: 
                this.var += this.speed;
                if(this.var > this.var_max) {
                    this.var = 0; 
                }
                if(this.var < 0) {
                    this.var = this.var_max;
                }
                break;
            case miniGameType._Bilibili: 
                this.var += this.speed;
                if(this.var > this.var_max) {
                    this.var = 0; 
                }
                if(this.var < 0) {
                    this.var = this.var_max;
                }
                break;
            case miniGameType._Biriyad: 
                this.var += this.speed;
                if(this.var > this.var_max) {
                    this.var = 0; 
                }
                if(this.var < 0) {
                    this.var = this.var_max;
                }
                this.tgt_var += this.tgt_speed;
                if(this.tgt_var < 0) {
                    this.tgt_var = 0;
                    this.tgt_speed *= -1; 
                }
                if(this.tgt_var > this.var_max) {
                    this.tgt_var = this.var_max;
                    this.tgt_speed *= -1; 
                }
                break;
        }
    }
    Var_Stop() {
        this.stopFlg = true;
    }
    Kekka_Get() {
        if(this.tgt_var - (this.tgt_lengh / 2) <= this.var &&
            this.var <= this.tgt_var + (this.tgt_lengh / 2)) {
            return miniGameRank._1_大成功; 
        }
        if(this.tgt_var - (this.tgt_yoyu / 2) <= this.var &&
            this.var <= this.tgt_var + (this.tgt_yoyu / 2)) {
            return miniGameRank._2_成功; 
        }
        return miniGameRank._3_失敗; 
    }
}
let miniGameType = {
    _Tobikomi: 1,    
    _Sumou: 2,       
    _Biriyad: 3,      
    _Bilibili: 4      
};
let miniGameRank = {
    _1_大成功:1,
    _2_成功:2,
    _3_失敗:3
};
Game_Interpreter.prototype.MiniPicTest = function () { 
    this.SetPict(PN_MgBase , miniFolPath + "PN_MgTgt_1");
    this.SetPict(PN_MgBase + 1 , miniFolPath + "PN_MgTgt_2" , 20 , 100);
}
let _mini_Game;
let miniFolPath = "";
const VN_ミニゲーム速度 = 1050;
const VN_ミニゲームバー速度 = 1051;
const VN_ミニゲームバー広さ = 1052;
const VN_ミニゲームバー位置 = 1053;
const VN_ミニゲームバー余裕広さ = 1054;
Game_Interpreter.prototype.TimingGame_Start = function (_setMiniGameType) { 
    setSpeed = typeof setSpeed !== 'undefined' ? setSpeed : null;
    setTargetSpeed = typeof setTargetSpeed !== 'undefined' ? setTargetSpeed : null;
    setVarPos = typeof setVarPos !== 'undefined' ? setVarPos : null;
    setLengh = typeof setLengh !== 'undefined' ? setLengh : null;
    setYoyu = typeof setYoyu !== 'undefined' ? setYoyu : null;
    _mini_Game = new Mini_Game(_setMiniGameType);
    if ($gameVariables.value(VN_ミニゲーム速度) != 0) {
        _mini_Game.speed = $gameVariables.value(VN_ミニゲーム速度) / 10;
    }
    if ($gameVariables.value(VN_ミニゲームバー速度) != 0) {
        _mini_Game.tgt_speed = $gameVariables.value(VN_ミニゲームバー速度) / 10;
    }
    if ($gameVariables.value(VN_ミニゲームバー広さ) != 0) {
        _mini_Game.tgt_lengh = $gameVariables.value(VN_ミニゲームバー広さ);
    }
    if ($gameVariables.value(VN_ミニゲームバー位置) != 0) {
        _mini_Game.tgt_var = $gameVariables.value(VN_ミニゲームバー位置);
    }
    if ($gameVariables.value(VN_ミニゲームバー余裕広さ) != 0) {
        _mini_Game.tgt_yoyu = $gameVariables.value(VN_ミニゲームバー余裕広さ);
    }
    isFastOff = true;
    switch (_mini_Game.type) {
        case miniGameType._Tobikomi:    
            miniFolPath = Mg_PicPath + "/Tobikomi/";
            break;
        case miniGameType._Sumou:   
            miniFolPath = Mg_PicPath + "/Sumou/";
            break;
        case miniGameType._Biriyad: 
            miniFolPath = Mg_PicPath + "/Biriyad/";
            break;
        case miniGameType._Bilibili: 
            miniFolPath = Mg_PicPath + "/bilibili/";
            break;
    }
    EasingStr = "easeOutQuad";
    this.SetPictFIn(PN_MgGageBase , miniFolPath + "GageTop" , 0,0,0,0,60);
    this.SetPictFInC(PN_MgTgt + 1 , miniFolPath + "PN_MgTgt_2",
        _mini_Game.TgtX , _mini_Game.TgtY,0,0,60 , 255 , 100, _mini_Game.tgt_lengh);
    this.SetPictFInC(PN_MgTgt + 0 , miniFolPath + "PN_MgTgt_1",
        _mini_Game.TgtX , _mini_Game.TgtY,0,0,60 , 255 , 100, _mini_Game.tgt_lengh +  _mini_Game.tgt_yoyu);
    this.TimingGame_GageReDraw();
    this.SetPictFInC(PN_MgIcon , miniFolPath + "PN_MgIcon" , _mini_Game.sd_CharaX , _mini_Game.sd_CharaY,0,0,60);
    this.SetPictFInC(PN_MgMark , miniFolPath + "PN_MgMark",
        _mini_Game.MarkX + _mini_Game.tgt_ZureX  , _mini_Game.MarkY,0,0,60);
    EasingStr = "";
}
Game_Interpreter.prototype.TimingGame_GageReDraw = function () {
    this.SetPict(PN_MgTgt_Mask , miniFolPath + "PN_MgTgtMask" , _mini_Game.gage_Pos_X , _mini_Game.gage_Pos_Y);
    this.SetPicMask(PN_MgTgt + 0 , PN_MgTgt_Mask);
    this.SetPicMask(PN_MgTgt + 1 , PN_MgTgt_Mask);
}
Game_Interpreter.prototype.TimingGame_Update = function () { 
    this.AnglePict(PN_MgIcon , _mini_Game.sd_Angle); 
    this.SetPictC(PN_MgMark , miniFolPath + "PN_MgMark"  ,
        _mini_Game.MarkX + _mini_Game.tgt_ZureX , _mini_Game.MarkY);
    if (_mini_Game.type == miniGameType._Biriyad) {
        this.SetPictC(PN_MgTgt + 1 , miniFolPath + "PN_MgTgt_2" , _mini_Game.TgtX , _mini_Game.TgtY,
            255 , 100, _mini_Game.tgt_lengh);
        this.SetPictC(PN_MgTgt + 0 , miniFolPath + "PN_MgTgt_1", _mini_Game.TgtX , _mini_Game.TgtY,
            255 , 100, _mini_Game.tgt_lengh + _mini_Game.tgt_yoyu);
    }
    if (_mini_Game.flame > 60) {
        if (TouchInput.isTriggered()) {
            _mini_Game.Var_Stop(); 
        }
    }
    _mini_Game.Update(); 
    if(_mini_Game.stopFlg) { 
        $gameVariables.setValue(VN_ミニゲーム結果 ,_mini_Game.Kekka_Get()); 
        isFastOff = false;
        return false; 
    }
    return true; 
}
Game_Interpreter.prototype.TimingGame_Close = function () { 
    this.DelPictSpan(PN_MgGageBase , PN_MgBase);
}
