﻿/*:
 * @plugindesc 
 * @author You
 * @help 
 */
(function() {
    'use strict';
    function currentSpriteset() {
        const scene = SceneManager._scene;
        if (scene && scene._spriteset) return scene._spriteset;
        return null;
    }
    class N_ScreenAnimationSprite extends Sprite_Base {
        constructor(data) {
            super();
            this._data = data; 
        }
        setupAfterAdd() {
            const data = this._data;
            this.x = Math.round(data.x || 0);
            this.y = Math.round(data.y || 0);
            const s = (data.scale != null ? Number(data.scale) : 1.0) || 1.0;
            this.scale.x = s;
            this.scale.y = s;
            this._zOrder = (data.z != null ? Number(data.z) : 200) || 200;
            this._mirror = !!data.mirror;
            this._animId = Number(data.animId);
            const anim = $dataAnimations[this._animId];
            if (anim) {
                this.startAnimation(anim, this._mirror, 0);
            } else {
                this._dead = true;
            }
        }
        update() {
            super.update();
            if (this._dead || !this.isAnimationPlaying()) {
                if (this.parent) this.parent.removeChild(this);
                this.destroy({ children: true });
            }
        }
        isAnimationPlaying() {
            const list = this._animationSprites;
            return list && list.length > 0;
        }
        z() { return this._zOrder; }
    }
    const ScreenAnim = {
        _queue: [],
        play(x, y, animId, opts) {
            const spriteset = currentSpriteset();
            if (!spriteset) return;
            const container =
                spriteset._effectsContainer ||
                spriteset._baseSprite ||
                spriteset;
            const data = {
                x: Number(x),
                y: Number(y),
                animId: Number(animId),
                mirror: !!(opts && opts.mirror),
                scale: (opts && opts.scale != null) ? Number(opts.scale) : 1.0,
                z: (opts && opts.z != null) ? Number(opts.z) : 200
            };
            const spr = new N_ScreenAnimationSprite(data);
            spr.z = spr.z();
            container.addChild(spr);
            spr.setupAfterAdd(); 
            if (container.children && typeof container.children.sort === 'function') {
                container.children.sort((a, b) => (a.z || 0) - (b.z || 0));
            }
        }
    };
    window.ScreenAnim = ScreenAnim;
    const _Game_Interpreter_pluginCommand = Game_Interpreter.prototype.pluginCommand;
    Game_Interpreter.prototype.pluginCommand = function(command, args) {
        _Game_Interpreter_pluginCommand.call(this, command, args);
        if (command === 'ScreenAnim') {
            const x      = Number(args[0] || 0);
            const y      = Number(args[1] || 0);
            const animId = Number(args[2] || 1);
            const mirror = args.length >= 4 ? Number(args[3]) !== 0 : false;
            const scale  = args.length >= 5 ? Number(args[4]) : 1.0;
            const z      = args.length >= 6 ? Number(args[5]) : 200;
            ScreenAnim.play(x, y, animId, { mirror, scale, z });
        }
    };
})();
