﻿// Copyright (c) 2017 Tsumio
// http://opensource.org/licenses/mit-license.php
// [Blog]   : http://ntgame.wpblog.jp/
// [Twitter]: https://twitter.com/TsumioNtGame
/*:
 * @plugindesc 
 * @author Tsumio
 *
 * @param ItemName
 * @type string
 * @desc It is a setting item name displayed on Options.
 * @default Type of Key Operation
 * 
 * @param SymbolName(DefaultType)
 * @type string
 * @desc It is a setting symbol name displayed on Options(Default setting use this key type).
 * @default Default
 * 
 * @param SymbolName(FPSType)
 * @type string
 * @desc It is a setting symbol name displayed on Options(FPS setting use this key type).
 * @default FPS
 * 
 * @help 
 */
/*:ja
 * @plugindesc 
 * @author ツミオ
 *
 * @param 項目名称
 * @type string
 * @desc オプション画面に表示される設定項目名称。
 * @default キー操作タイプ
 * 
 * @param 設定名称（通常キー）
 * @type string
 * @desc オプション画面に表示される設定名称（ツクールで通常使用されるキー設定）。
 * @default 両手操作
 * 
 * @param 設定名称（FPSキー）
 * @type string
 * @desc オプション画面に表示される設定名称（FPS寄りのキー設定）。
 * @default 片手操作
 * 
 * @help 
 */
(function() {
    'use strict';
    var pluginName = 'JsScript17Set';
    var NTMO = NTMO || {};
    var _Game_Interpreter_pluginCommand = Game_Interpreter.prototype.pluginCommand;
    Game_Interpreter.prototype.pluginCommand = function (command, args) {
        _Game_Interpreter_pluginCommand.call(this, command, args);
        if (command === 'Change_Key_FPS') {
            NTMO.COTS.setFPSKeyMapper();
        }
        else if(command === 'Change_Key_Default') {
            NTMO.COTS.setDefaultKeyMapper();
        }
    };
    var getParamString = function(paramNames) {
        if (!Array.isArray(paramNames)) paramNames = [paramNames];
        for (var i = 0; i < paramNames.length; i++) {
            var name = PluginManager.parameters(pluginName)[paramNames[i]];
            if (name) return name;
        }
        return '';
    };
    var getParamNumber = function(paramNames, min, max) {
        var value = getParamString(paramNames);
        if (arguments.length < 2) min = -Infinity;
        if (arguments.length < 3) max = Infinity;
        return (parseInt(value) || 0).clamp(min, max);
    };
    var param             = {};
    param.itemName        = getParamString(['ItemName', '項目名称']);
    param.symbolDefault   = getParamString(['SymbolName(DefaultType)', '設定名称（通常キー）']);
    param.symbolFPS       = getParamString(['SymbolName(FPSType)', '設定名称（FPSキー）']);
    //    yout to correct it. If possible, please notify me.)
    ConfigManager.keyMapper = false;
    var _ConfigManager_makeData = ConfigManager.makeData;
    ConfigManager.makeData      = function() {
        var config        = _ConfigManager_makeData.apply(this, arguments);
        config.keyMapper  = this.keyMapper;
        return config;
    };
    var _ConfigManager_applyData = ConfigManager.applyData;
    ConfigManager.applyData      = function(config) {
        _ConfigManager_applyData.apply(this, arguments);
        this.keyMapper = this.readFlag(config, 'keyMapper');
        if(this.keyMapper){
            NTMO.COTS.setDefaultKeyMapper();
        }else{
            NTMO.COTS.setFPSKeyMapper();
        }
    };
    NTMO.COTS = function(){
    };
    NTMO.COTS.getDefaultKeyMapper = function(){
        return NTMO.COTS.defaultKeyMapper;
    };
    NTMO.COTS.getFPSKeyMapper = function(){
        return NTMO.COTS.FPSKeyMapper;
    };
    NTMO.COTS.setDefaultKeyMapper = function(){
        //Clear method is necessary to avoid input bug(ex. keep moving).
        Input.clear();
        Input.keyMapper         = NTMO.COTS.getDefaultKeyMapper();
        ConfigManager.keyMapper = true;
    };
    NTMO.COTS.setFPSKeyMapper = function(){
        //Clear method is necessary to avoid input bug(ex. keep moving).
        Input.clear();
        Input.keyMapper         = NTMO.COTS.getFPSKeyMapper();
        ConfigManager.keyMapper = false;
    };
    var _Window_Options_makeCommandList      = Window_Options.prototype.makeCommandList;
    Window_Options.prototype.makeCommandList = function() {
        _Window_Options_makeCommandList.call(this);
        this.addKeyMapperOption();
    };
    Window_Options.prototype.addKeyMapperOption = function() {
        //this.addCommand(param.itemName, 'keyMapper');
    };
    var _Window_Options_statusText      = Window_Options.prototype.statusText;
    Window_Options.prototype.statusText = function(index) {
        var result = _Window_Options_statusText.apply(this, arguments);
        var symbol = this.commandSymbol(index);
        var value  = this.getConfigValue(symbol);
        if(this.isKeyMapperSymbol(symbol)){
            result = this.keyMapperStatusText(value);
        }
        return result;
    };
    Window_Options.prototype.isKeyMapperSymbol = function(symbol) {
        return symbol.contains('keyMapper');
    };
    Window_Options.prototype.keyMapperStatusText = function(value) {
        return value ? param.symbolDefault : param.symbolFPS;
    };
    var _Window_Options_cursorRight      = Window_Options.prototype.cursorRight;
    Window_Options.prototype.cursorRight = function(wrap) {
        _Window_Options_cursorRight.apply(this, arguments);
        var index = this.index();
        var symbol = this.commandSymbol(index);
        var value = this.getConfigValue(symbol);
        if(this.isKeyMapperSymbol(symbol)) {
            NTMO.COTS.setDefaultKeyMapper();
        }
    };
    var _Window_Options_cursorLeft      = Window_Options.prototype.cursorLeft;
    Window_Options.prototype.cursorLeft = function(wrap) {
        _Window_Options_cursorLeft.apply(this, arguments);
        var index = this.index();
        var symbol = this.commandSymbol(index);
        var value = this.getConfigValue(symbol);
        if(this.isKeyMapperSymbol(symbol)) {
            NTMO.COTS.setFPSKeyMapper();
        }
    };
    NTMO.COTS.defaultKeyMapper = {
        9: 'tab',       
        13: 'ok',       
        16: 'shift',    
        17: 'control',  
        18: 'control',  
        27: 'escape',   
        32: 'ok',       
        33: 'pageup',   
        34: 'pagedown', 
        37: 'left',     
        38: 'up',       
        39: 'right',    
        40: 'down',     
        45: 'escape',   
        81: 'pageup',   
        87: 'pagedown', 
        88: 'escape',   
        90: 'ok',       
        96: 'escape',   
        98: 'down',     
        100: 'left',    
        102: 'right',   
        104: 'up',      
        120: 'debug'    
    };
    NTMO.COTS.FPSKeyMapper = {
        9: 'tab',       
        13: 'ok',       
        16: 'shift',    
        17: 'control',  
        18: 'control',  
        27: 'escape',   
        33: 'pageup',   
        34: 'pagedown', 
        37: 'left',     
        38: 'up',       
        39: 'right',    
        40: 'down',     
        45: 'escape',   
        88: 'escape',   
        90: 'ok',       
        96: 'escape',   
        98: 'down',     
        100: 'left',    
        102: 'right',   
        104: 'up',      
        120: 'debug',    
        48: 'dbg_0',    
        49: 'dbg_1',    
        50: 'dbg_2',    
        51: 'dbg_3',    
        52: 'dbg_4',    
        53: 'dbg_5',    
        54: 'dbg_6',    
        55: 'dbg_7',    
        56: 'dbg_8',    
        57: 'dbg_9',    
        80: 'dbg_Ex',    
        76: 'dbg_BtlEff',   
        65: 'left',      
        68: 'right',     
        83: 'down',      
        87: 'up',        
        81: 'escape',    
        69: 'ok',  
        70: 'R2GamePad',        
        32: 'next',    
        67: 'c_key', 
        72: 'h_key', 
        86: 'escape'     
    };
    //※ここで指定した値はInput.isPressed('next')でtrue/falseを指定できる。
})();
