﻿/*:
 * @plugindesc 
 * @author okara
 *
 * @help 
 */
const resetTargetMapIds = [
  1, 5, 12, 45, 96, 101, 146,
  241, 242, 296, 297, 298, 305,
  321, 324, 327, 332, 333, 334, 336, 337,
  466, 467, 468, 469, 470,
  500, 515
];
function resetAllResetABEvents(mapIdArray) {
    let targetMaps;
    if (Array.isArray(mapIdArray) && mapIdArray.length > 0) {
        targetMaps = mapIdArray.map(function(id) {
            return String(id);
        });
    } else {
        targetMaps = resetTargetMapIds.map(function(id) {
            return String(id);
        });
    }
    for (let idx = 0; idx < targetMaps.length; idx++) {
        const mapIdStr = targetMaps[idx];
        const mapId = Number(mapIdStr);
        const filename = "Map" + String(mapId).padStart(3, "0") + ".json";
        const xhr = new XMLHttpRequest();
        xhr.open("GET", "data/" + filename, false);
        try {
            xhr.send();
            if (xhr.status >= 400) {
                console.warn("Map load failed:", filename);
                continue;
            }
        } catch (e) {
            console.warn("Map load error:", filename, e);
            continue;
        }
        let json;
        try {
            json = JSON.parse(xhr.responseText);
        } catch (e) {
            console.warn("Map json parse error:", filename, e);
            continue;
        }
        const events = json.events;
        if (!events) continue;
        for (let evId = 1; evId < events.length; evId++) {
            const ev = events[evId];
            if (!ev) continue;
            if (!ev.name || ev.name.indexOf("[resetA]") === -1) continue;
            const keyA = [mapId, evId, "A"];
            const keyB = [mapId, evId, "B"];
            $gameSelfSwitches.setValue(keyA, false);
            $gameSelfSwitches.setValue(keyB, false);
            if ($gameMap && $gameMap.mapId && $gameMap.mapId() === mapId) {
                const liveEv = $gameMap.event(evId);
                if (liveEv) liveEv.refresh();
            }
        }
    }
}
