﻿// Copyright (c) 2017 Sanshiro
// http://opensource.org/licenses/mit-license.php
/*:
 * @plugindesc 
 * キャラクターの残像スプライトを生成します。
 * @author サンシロ https://twitter.com/rev2nym
 * @version 1.0.2 2017/02/23 ヘルプの誤りを修正。
 * 1.0.1 2017/02/23 セーブデータ互換対策。
 * 1.0.0 2017/02/23 作成
 * 
 * @help 
 */
var Imported = Imported || {};
Imported.SAN_ResidualSprites = true;
var Sanshiro = Sanshiro || {};
Sanshiro.ResidualSprites = Sanshiro.ResidualSprites || {};
Sanshiro.ResidualSprites.version = '1.0.2';
(function(SAN) {
'use strict';
function Residual() {
    this.initialize.apply(this, arguments);
}
Residual.prototype.initialize = function() {
    this._version = SAN.ResidualSprites.version;
    this._valid = false;
    this._aliveCount = 0;
    this._period = 4;
    this._duration = 30;
    this._colorTone = [0, 0, 255, 255];
    this._opacity = 128;
};
Residual.prototype.isCurrentVersion = function() {
    return this._version === SAN.ResidualSprites.version;
};
Residual.prototype.setValid = function(valid) {
    this._valid = valid;
    this._count = 0;
};
Residual.prototype.valid = function() {
    return this._valid;
};
Residual.prototype.setPeriod = function(period) {
    this._period = period;
};
Residual.prototype.setDuration = function(duration) {
    this._duration = duration;
};
Residual.prototype.duration = function() {
    return this._duration;
};
Residual.prototype.setColorTone = function(colorTone) {
    this._colorTone = colorTone;
};
Residual.prototype.colorTone = function() {
    return this._colorTone;
};
Residual.prototype.setOpacity = function(opacity) {
    this._opacity = opacity;
};
Residual.prototype.opacity = function() {
    return this._opacity;
};
Residual.prototype.update = function() {
    if (this._valid) {
        this._aliveCount += 1;
    }
};
Residual.prototype.needs = function() {
    return this._valid && this._aliveCount % this._period === 0;
};
var _Game_Character_initMembers = Game_Character.prototype.initMembers;
Game_Character.prototype.initMembers = function() {
    _Game_Character_initMembers.call(this);
    this.initResidual();
};
Game_Character.prototype.initResidual = function() {
    this._residual = new Residual();
};
Game_Character.prototype.residual = function() {
    if (!this._residual ||
        !this._residual.isCurrentVersion ||
        !this._residual.isCurrentVersion())
    {
        this.initResidual();
    }
    return this._residual;
};
Game_Character.prototype.updateResidual = function() {
    this.residual().update();
};
var _Game_Battler_initMembers = Game_Battler.prototype.initMembers;
Game_Battler.prototype.initMembers = function() {
    _Game_Battler_initMembers.call(this);
    this.initResidual();
};
Game_Battler.prototype.initResidual = function() {
    this._residual = new Residual();
};
Game_Battler.prototype.residual = function() {
    if (!this._residual ||
        !this._residual.isCurrentVersion ||
        !this._residual.isCurrentVersion())
    {
        this.initResidual();
    }
    return this._residual;
};
Game_Battler.prototype.updateResidual = function() {
    this.residual().update();
};
Sprite.prototype.frame = function() {
    return this._frame;
};
function Sprite_Residual() {
    this.initialize.apply(this, arguments);
}
Sprite_Residual.prototype = Object.create(Sprite.prototype);
Sprite_Residual.prototype.constructor = Sprite_Residual;
Sprite_Residual.prototype.initialize = function() {
    Sprite.prototype.initialize.call(this);
    this.initMembers();
};
Sprite_Residual.prototype.initMembers = function() {
    this._orgX = 0.0;
    this._orgY = 0.0;
    this._orgOpacity = 0;
    this._duration = 0;
    this._aliveCount = 0;
};
Sprite_Residual.prototype.setup =
    function(containerSprite, sourceSprite, colorTone, opacity, duration)
{
    this.setupPosition(containerSprite);
    this.setupBitmap(sourceSprite);
    this.setColorTone(colorTone);
    this._orgOpacity = opacity;
    this._duration = duration;
    this._aliveCount = 0;
};
Sprite_Residual.prototype.setupPosition = function(sourceSprite) {
    this.x = sourceSprite.x;
    this.y = sourceSprite.y;
    this.z = sourceSprite.z ? sourceSprite.z - 0.5 : 0.0;
    this._orgX = this.x;
    this._orgY = this.y;
    if (!!sourceSprite.parent.origin) {
        this._orgX += sourceSprite.parent.origin.x;
        this._orgY += sourceSprite.parent.origin.y;
    }
    this.scale.x = sourceSprite.scale.x;
    this.scale.y = sourceSprite.scale.y;
    this.anchor.x = sourceSprite.anchor.x;
    this.anchor.y = sourceSprite.anchor.y;
    this.rotation = sourceSprite.rotation;
};
Sprite_Residual.prototype.setupBitmap = function(sourceSprite) {
    var frame = sourceSprite.frame();
    if (frame.width !== 0 && frame.height !== 0) {
        this.bitmap = sourceSprite.bitmap;
        this.setFrame(frame.x, frame.y, frame.width, frame.height);
    }
};
Sprite_Residual.prototype.isAlive = function() {
    return this._aliveCount < this._duration;
};
Sprite_Residual.prototype.update = function() {
    this.updatePosition();
    this.updateOpacity();
    this.updateAlive();
    Sprite.prototype.update.call(this);
};
Sprite_Residual.prototype.updatePosition = function() {
    if (!!this.parent.origin) {
        this.x = this._orgX - this.parent.origin.x;
        this.y = this._orgY - this.parent.origin.y;
    }
};
Sprite_Residual.prototype.updateOpacity = function() {
    this.opacity = this._orgOpacity * (1.0 - (this._aliveCount / this._duration));
};
Sprite_Residual.prototype.updateAlive = function() {
    if (this.isAlive()) {
        this._aliveCount++;
    } else {
        this.parent.removeChild(this);
    }
};
var _Sprite_Character_update = Sprite_Character.prototype.update;
Sprite_Character.prototype.update = function() {
    _Sprite_Character_update.call(this)
    this.updateResidual();
};
Sprite_Character.prototype.updateResidual = function() {
    this._character.updateResidual();
    if (this._character.residual().needs()) {
        this.createResidualSprite();
    }
};
Sprite_Character.prototype.createResidualSprite = function() {
    var residual = this._character.residual();
    var residualSprite = new Sprite_Residual();
    residualSprite.setup(
        this,
        this,
        residual.colorTone(),
        residual.opacity(),
        residual.duration()
    );
    var index = this.parent.getChildIndex(this);
    this.parent.addChildAt(residualSprite, index);
};
var _Sprite_Actor_update = Sprite_Actor.prototype.update;
Sprite_Actor.prototype.update = function() {
    _Sprite_Actor_update.call(this)
    this.updateResidual();
};
Sprite_Actor.prototype.updateResidual = function() {
    if (!!this._actor) {
        this._actor.updateResidual();
        if (this._actor.residual().needs()) {
            this.createResidualSprite();
        }
    }
};
Sprite_Actor.prototype.createResidualSprite = function() {
    var residual = this._actor.residual();
    var residualSprite = new Sprite_Residual();
    residualSprite.setup(
        this,
        this._mainSprite,
        residual.colorTone(),
        residual.opacity(),
        residual.duration()
    );
    var index = this.parent.getChildIndex(this);
    this.parent.addChildAt(residualSprite, index);
};
var _Sprite_Enemy_update = Sprite_Enemy.prototype.update;
Sprite_Enemy.prototype.update = function() {
    _Sprite_Enemy_update.call(this)
    this.updateResidual();
};
Sprite_Enemy.prototype.updateResidual = function() {
    this._battler.updateResidual();
    if (this._battler.residual().needs()) {
        this.createResidualSprite();
    }
};
Sprite_Enemy.prototype.createResidualSprite = function() {
    var residual = this._battler.residual();
    var residualSprite = new Sprite_Residual();
    residualSprite.setup(
        this,
        this,
        residual.colorTone(),
        residual.opacity(),
        residual.duration()
    );
    var index = this.parent.getChildIndex(this);
    this.parent.addChildAt(residualSprite, index);
};
}) (Sanshiro);
