﻿// StopSelfMovementWithPlayer.js (ver 1.02)
/*:
 * @plugindesc 
 * @author Sasuke KANNAZUKI
 *
 * @param Varidate Switch ID
 * @desc It works only when the id's switch is on. If set 0, always works.
 * @default 0
 *
 * @help 
 */
/*:ja
 * @plugindesc 
 * @author 神無月サスケ
 *
 * @param Varidate Switch ID
 * @desc このIDのスイッチがONの時に有効になります。0を指定すると常に有効です。
 * @default 0
 *
 * @help 
 */
(function() {
  var parameters = PluginManager.parameters('JsScript201Set');
  var validateSwitchId = Number(parameters['Varidate Switch ID'] || 0);
  var _Game_Interpreter_pluginCommand =
   Game_Interpreter.prototype.pluginCommand;
  Game_Interpreter.prototype.pluginCommand = function(command, args) {
    _Game_Interpreter_pluginCommand.call(this, command, args);
    if (command === 'JsScript201Set') {
      switch (args[0]) {
      case 'on':
      case 'ON':
        $gameSystem.forceStopEvent = true;
        break;
      case 'off':
      case 'OFF':
        $gameSystem.forceStopEvent = false;
        break;
      }
    }
  };
  var _Game_System_initialize = Game_System.prototype.initialize;
  Game_System.prototype.initialize = function () {
    _Game_System_initialize.call(this);
    this.forceStopEvent = false;
  };
  var isStopWithPlayerMode = function () {
    return validateSwitchId === 0 || !$gameSwitches.value(validateSwitchId); 
  };
  var shouldStopWithPlayer = function () {
    if ($gameSystem.forceStopEvent) {
      return true;
    }
    if (isStopWithPlayerMode()) {
      var mw;
      if ($gameMap.isEventRunning()) {
        return true;
      } else if ((mw = SceneManager._scene._messageWindow) && mw.isOpen()) {
        return true;
      }
    }
    return false;
  };
  var _Game_CharacterBase_updateStop = Game_CharacterBase.prototype.updateStop;
  Game_CharacterBase.prototype.updateStop = function() {
    if (!shouldStopWithPlayer()) {
      _Game_CharacterBase_updateStop.call(this);
    }
  };
  var _Game_Event_updateSelfMovement = Game_Event.prototype.updateSelfMovement;
  Game_Event.prototype.updateSelfMovement = function() {
    if (!shouldStopWithPlayer()) {
      _Game_Event_updateSelfMovement.call(this);
    }
  };
})();
