﻿// Copyright (c) 2015-2017 Triacontane
// http://opensource.org/licenses/mit-license.php
// 2.1.0 2017/03/11 本体v1.3.5(コミュニティ版)で機能しなくなる問題を修正
// [Blog]   : https://triacontane.blogspot.jp/
// [Twitter]: https://twitter.com/triacontane/
// [GitHub] : https://github.com/triacontane/
/*:
 * @plugindesc 
 * @author triacontane
 *
 * @param InvalidIfTest
 * @desc Not through if test play.
 * @default true
 * @type boolean
 *
 * @param InvalidIfWeb
 * @desc Not through if Web mode.
 * @default false
 * @type boolean
 *
 * @param ThroughType
 * @desc 無視する素材の種別です。
 * @default 3
 * @type select
 * @option Audio Only
 * @value 1
 * @option Image Only
 * @value 2
 * @option All
 * @value 3
 *
 * @help 
 */
/*:ja
 * @plugindesc 
 * @author トリアコンタン
 *
 * @param テストプレー時無効
 * @desc テストプレー時は本プラグインの機能が無効になります。
 * @default true
 * @type boolean
 *
 * @param Web版で無効
 * @desc Web版実行時は本プラグインの機能が無効になります。
 * @default false
 * @type boolean
 *
 * @param 無視種別
 * @desc 無視する素材の種別です。
 * @default 3
 * @type select
 * @option 音声のみ
 * @value 1
 * @option 画像のみ
 * @value 2
 * @option 全て
 * @value 3
 *
 * @help 
 */
(function() {
    'use strict';
    var pluginName = 'JsScript203Set';
    var getParamOther = function(paramNames) {
        if (!Array.isArray(paramNames)) paramNames = [paramNames];
        for (var i = 0; i < paramNames.length; i++) {
            var name = PluginManager.parameters(pluginName)[paramNames[i]];
            if (name) return name;
        }
        return null;
    };
    var getParamBoolean = function(paramNames) {
        var value = (getParamOther(paramNames) || '').toUpperCase();
        return value === 'ON' || value === 'TRUE';
    };
    var getParamNumber = function(paramNames, min, max) {
        var value = getParamOther(paramNames);
        if (arguments.length < 2) min = -Infinity;
        if (arguments.length < 3) max = Infinity;
        return (parseInt(value) || 0).clamp(min, max);
    };
    var paramInvalidIfTest = getParamBoolean(['InvalidIfTest', 'テストプレー時無効']);
    var paramInvalidIfWeb  = getParamBoolean(['InvalidIfWeb', 'Web版で無効']);
    var paramThroughType   = getParamNumber(['ThroughType', '無視種別'], 1, 3);
    if (paramInvalidIfTest && Utils.isOptionValid('test')) {
        return;
    } else if (paramInvalidIfWeb && !Utils.isNwjs()) {
        return;
    }
    if (paramThroughType !== 1) {
        var _Bitmap_isReady = Bitmap.prototype.isReady;
        Bitmap.prototype.isReady = function() {
            if (this.isError()) {
                this.eraseError();
            }
            return _Bitmap_isReady.apply(this, arguments);
        };
        var _Bitmap_decode = Bitmap.prototype.decode;
        Bitmap.prototype.decode = function(){
            _Bitmap_decode.apply(this, arguments);
            if (this._loadingState === 'requesting') {
                this._image.addEventListener('error', this._onError.bind(this));
            }
        };
        Bitmap.prototype.eraseError = function() {
            this._hasError     = false;
            this._isLoading    = false;
            this._loadingState = 'loaded';
        };
        var _Graphics__playVideo = Graphics._playVideo;
        Graphics._playVideo      = function(src) {
            _Graphics__playVideo.apply(this, arguments);
            this._video.onerror = this._videoLoader || this._onVideoError.bind(this);
        };
    }
    if (paramThroughType !== 2) {
        AudioManager.checkErrors = function() {};
    }
    if (typeof ResourceHandler !== 'undefined') {
        var _ResourceHandler_createLoader = ResourceHandler.createLoader;
        ResourceHandler.createLoader = function(url, retryMethod, resignMethod, retryInterval) {
            return this.isNeedLoader(url) ? _ResourceHandler_createLoader.apply(this, arguments) : null;
        };
        ResourceHandler.isNeedLoader = function(url) {
            if (paramThroughType === 1 && !url.match(/^audio\//)) {
                return true;
            } else if (paramThroughType === 2 && (!url.match(/^img\//) && !url.match(/^movie\//))) {
                return true;
            } else {
                return false;
            }
        };
    }
})();
