﻿// https://github.com/AlecYawata/TkoolMV_PluginCommandBook
// Copyright (c) 2015 Alec
// http://opensource.org/licenses/mit-license.php
/*:
 * @plugindesc 
 * @author 有志の皆さん
 *
 * @param 制御文字の拡張
 * @desc このプラグインで使えるパラメータの制御文字を
 * 通常のメッセージなどで使用できるようにするか(はい/いいえ)
 * Default: はい
 * @default はい
 *
 * @param スクリプトに制御文字適用
 * @desc スクリプト実行時に制御文字を使用できるようにするか(はい/いいえ)
 * Default: いいえ
 * @default いいえ
 *
 * @help 
 */
(function(){
    'use strict';
    Game_Interpreter.prototype.pluginCommandBook_unescape = function(text) {
        var wstringToString = function(text) {
            text = text.replace(/[０-９]/g, function(c) {
                return String.fromCharCode(c.charCodeAt(0) - 0xFEE0);
            });
            return text;
        };
        var getActorName = function(n) {
            var actor = n >= 1 ? $gameActors.actor(n) : null;
            return actor ? actor.name() : '';
        };
        var getPartyMemberName = function(n) {
            var actor = n >= 1 ? $gameParty.members()[n - 1] : null;
            return actor ? actor.name() : '';
        };
        var prevText = "";
        text = text.replace(/\\/g, '\x1b');
        while (prevText != text) {
            prevText = text;
            text = text.replace(/\x1b\x1b/g, '\\');
            text = text.replace(/\x1bV\[([０-９\d]+)\]/gi, function() {
                return $gameVariables.value(parseInt(wstringToString(arguments[1]), 10));
            }.bind(this));
            text = text.replace(/\x1bN\[([０-９\d]+)\]/gi, function() {
                return getActorName(parseInt(wstringToString(arguments[1]), 10));
            }.bind(this));
            text = text.replace(/\x1bP\[([０-９\d]+)\]/gi, function() {
                return getPartyMemberName(parseInt(wstringToString(arguments[1]), 10));
            }.bind(this));
            text = text.replace(/\x1bG/gi, TextManager.currencyUnit);
            text = text.replace(/\x1bIn\[([０-９\d]+)\]/gi, function() {
                return $dataItems[parseInt(wstringToString(arguments[1]), 10)].name;
            }.bind(this));
            text = text.replace(/\x1bNi\[([０-９\d]+)\]/gi, function() {
                return $dataItems[parseInt(wstringToString(arguments[1]), 10)].name;
            }.bind(this));
            text = text.replace(/\x1bIp\[([０-９\d]+)\]/gi, function() {
                return $dataItems[parseInt(wstringToString(arguments[1]), 10)].price;
            }.bind(this));
            text = text.replace(/\x1bPi\[([０-９\d]+)\]/gi, function() {
                return $dataItems[parseInt(wstringToString(arguments[1]), 10)].price;
            }.bind(this));
            text = text.replace(/\x1bSn\[([０-９\d]+)\]/gi, function() {
                return $dataSkills[parseInt(wstringToString(arguments[1]), 10)].name;
            }.bind(this));
            text = text.replace(/\x1bNs\[([０-９\d]+)\]/gi, function() {
                return $dataSkills[parseInt(wstringToString(arguments[1]), 10)].name;
            }.bind(this));
            text = text.replace(/\x1bNc\[([０-９\d]+)\]/gi, function() {
                return $dataClasses[parseInt(wstringToString(arguments[1]), 10)].name;
            }.bind(this));
            text = text.replace(/\x1bNt\[([０-９\d]+)\]/gi, function() {
                return $dataStates[parseInt(wstringToString(arguments[1]), 10)].name;
            }.bind(this));
            text = text.replace(/\x1bNw\[([０-９\d]+)\]/gi, function() {
                return $dataWeapons[parseInt(wstringToString(arguments[1]), 10)].name;
            }.bind(this));
            text = text.replace(/\x1bNa\[([０-９\d]+)\]/gi, function() {
                return $dataArmors[parseInt(wstringToString(arguments[1]), 10)].name;
            }.bind(this));
            text = text.replace(/\x1bJs\[(.*)\]\x1bJs/gi, function() {
                try{
                    var value = eval(arguments[1]);
                    if (value != null){return value}else{
                        console.log('制御文字 \\JS のパラメータでエラー  詳細：評価値が無い(null or undefined)');
                        return 0;
                    }
                } catch(ex){
                    console.log( '制御文字 \\JS のパラメータでエラー  詳細： ' + ex.toString());
                    return 0;
                }
            }.bind(this));
        }
        text = text.replace(/\x1bG/gi, TextManager.currencyUnit);
        return text;
    };
    /**
     * 厳密な数値チェックを行います。引数が数値でなければ例外を発生されます。
     * プラグインコマンド集では、例外が発生してもその場でゲームは中断されず
     * 実行したコマンドのみが無効になり、さらにテストプレーなら自動でデベロッパツールが起動します。
     *
     * @method parseIntStrict
     * @param {Number} value
     * @param {String} errorMessage
     * @type Number
     * @return {Number} 数値に変換した結果
     */
    var parseIntStrict = function(value, errorMessage) {
        var result = parseInt(value, 10);
        if (isNaN(result)) throw Error('指定した値[' + value + ']が数値ではありません。' + errorMessage);
        return result;
    };
    var parameters = PluginManager.parameters('JsScript204Set');
    var _Game_Interpreter_pluginCommand      = Game_Interpreter.prototype.pluginCommand;
    Game_Interpreter.prototype.pluginCommand = function (command, args) {
        _Game_Interpreter_pluginCommand.call(this, command, args);
        if (command.length == 0) {
            return;
        }
        this.executePluginCommand(command, args);
    };
    Game_Interpreter.prototype.executePluginCommand = function(command, args) {
        var methodName = 'pluginCommandBook_' + command;
        if (typeof this[methodName] === 'function') {
            for (var i=0; i<args.length; i++) {
                args[i] = Game_Interpreter.prototype.pluginCommandBook_unescape(args[i]);
            }
            try {
                this[methodName](args);
            } catch (e) {
                if ($gameTemp.isPlaytest() && Utils.isNwjs()) {
                    var window = require('nw.gui').Window.get();
                }
                console.log('プラグインコマンドの実行中にエラーが発生しました。');
                console.log('- コマンド名 　: ' + command);
                console.log('- コマンド引数 : ' + args);
                console.log('- エラー原因   : ' + e.toString());
            }
        }
    };
    /**
     * 名前の変更
     *  主人公の名前を変更する
     *  製作者 Alec
     *
     *  使用例
     *  名前の変更 1 ライアン　　（アクター0001の名前をライアンに変更
     *  名前の変更 2 \V[1]　　　（アクター0002の名前を変数0001の内容に変更
     */
    Game_Interpreter.prototype.pluginCommandBook_名前の変更 = function(args) {
        var actorId = args[0]; 
        var name = args[1]; 
        $gameActors.actor(actorId).setName(name);
    };
    /**
     * 呼び出し元アイテム取得
     *  コモンイベントを呼び出したアイテムのIDを変数に入れる
     *  製作者 Alec
     *
     *  使用例
     *  呼び出し元アイテム取得 1　　（変数0001にコモンイベントを呼び出したアイテムIDを入れる
     */
    Game_Interpreter.prototype.pluginCommandBook_呼び出し元アイテム取得 = function(args) {
        var varId = parseInt(args[0]); 
        if (!$gameParty.lastItem()) {
            return;
        }
        $gameVariables.setValue(varId, $gameParty.lastItem().id);
    };
    /**
     * 呼び出し元スキル取得
     *  コモンイベントを呼び出したスキルのIDを変数に入れる
     *  製作者 Alec
     *
     *  使用例
     *  呼び出し元スキル取得 1　　（変数0001にコモンイベントを呼び出したスキルIDを入れる
     */
    Game_Interpreter.prototype.pluginCommandBook_呼び出し元スキル取得 = function(args) {
        if (eval(String(parameters['呼び出し元スキルの記録を使わない']||'false'))) {
            window.alert("「呼び出し元スキル取得」を使うにはプラグインマネージャーから「TkoolMV_PluginCommandBook.js」の「呼び出し元スキルの記録を使わない」を「はい」してください");
            return;
        }
        var varId = parseInt(args[0]); 
        var skillId = 0;
        if ($gameParty.inBattle()) {
            skillId = BattleManager._subject.lastBattleSkill().id;
        } else {
            skillId = $gameParty.menuActor().lastMenuSkill().id;
        }
        $gameVariables.setValue(varId, skillId);
    };
    /**
     * レベルの変更
     *  アクターのレベルを変更します。増減ではなく変更後のレベルを指定できます。
     *  製作者 Alec
     *
     *  パラメータ
     *  　アクターのID（もし0なら全員）
     *    変更後のレベル
     *    レベルアップをメッセージで表示するかどうか（表示・非表示）
     *
     *  使用例
     *  レベルの変更 1 50 表示　　（アクター0001のレベルを50に変更
     *  レベルの変更 0 10 非表示　（仲間全員のレベルを10に変更、レベルアップは表示しない
     */
    Game_Interpreter.prototype.pluginCommandBook_レベルの変更 = function(args) {
        var actorId = parseInt(args[0], 10);
        var level = parseInt(args[1], 10) || 1;
        var show = {"表示":true,"非表示":false,"はい":true,"いいえ":false}[args[2]||'表示'];
        show = show === null ? false : show;
        console.log(show);
        if (actorId == 0) {
            $gameParty.members().forEach(function(actor){
                var exp = actor.expForLevel(level);
                actor.changeExp(exp, show);
            });
        } else {
            var actor = $gameActors.actor(actorId);
            if (!actor) {
                return;
            }
            var exp = actor.expForLevel(level);
            actor.changeExp(exp, show);
        }
    };
    Game_Interpreter.prototype.pluginCommandBook_バイブレーション = function(args) {
        if(Utils.isMobileDevice() && typeof navigator.vibrate === 'function') {
            var frame = parseIntStrict(args[0]);
            navigator.vibrate(Math.floor(frame * 1000 / 60));
            var wait = (args[1] || '').toUpperCase();
            if (wait === 'ウェイトあり' || wait === 'WAIT') this.wait(frame);
        }
    };
    Game_Interpreter.prototype.pluginCommandBook_Vibration = function(args) {
        this.pluginCommandBook_バイブレーション(args);
    };
    Game_Interpreter.prototype.pluginCommandBook_指定位置の通行判定取得 = function(args) {
        var x = parseIntStrict(args[1]);
        var y = parseIntStrict(args[2]);
        var value = 0;
        value += $gamePlayer.isMapPassable(x, y, 8) ? 1000 : 0;
        value += $gamePlayer.isMapPassable(x, y, 6) ? 100  : 0;
        value += $gamePlayer.isMapPassable(x, y, 2) ? 10   : 0;
        value += $gamePlayer.isMapPassable(x, y, 4) ? 1    : 0;
        $gameVariables.setValue(args[0], value);
    };
    Game_Interpreter.prototype.pluginCommandBook_Get_Location_Pass = function(args) {
        this.pluginCommandBook_指定位置の通行判定取得(args);
    };
    Game_Interpreter.prototype.pluginCommandBook_スイッチの初期化 = function(args) {
        var exceptionValues = [];
        args.forEach(function(arg) {
            arg = parseIntStrict(arg);
            exceptionValues[arg] = $gameSwitches.value(arg);
        });
        $gameSwitches.clear();
        args.forEach(function(arg) {
            arg = parseIntStrict(arg);
            $gameSwitches.setValue(arg, exceptionValues[arg]);
        });
    };
    Game_Interpreter.prototype.pluginCommandBook_Init_Switches = function(args) {
        this.pluginCommandBook_スイッチの初期化(args);
    };
    Game_Interpreter.prototype.pluginCommandBook_変数の初期化 = function(args) {
        var exceptionValues = [];
        args.forEach(function(arg) {
            arg = parseIntStrict(arg);
            exceptionValues[arg] = $gameVariables.value(arg);
        });
        $gameVariables.clear();
        args.forEach(function(arg) {
            arg = parseIntStrict(arg);
            $gameVariables.setValue(arg, exceptionValues[arg]);
        });
    };
    Game_Interpreter.prototype.pluginCommandBook_Init_Variables = function(args) {
        this.pluginCommandBook_変数の初期化(args);
    };
    Game_Interpreter.prototype.pluginCommandBook_セルフスイッチの初期化 = function(args) {
        $gameSelfSwitches.clear();
    };
    Game_Interpreter.prototype.pluginCommandBook_Init_Self_Switch = function(args) {
        this.pluginCommandBook_セルフスイッチの初期化(args);
    };
    Game_Interpreter.prototype.pluginCommandBook_セルフスイッチの遠隔操作 = function(args) {
        var mapId   = Math.max(parseIntStrict(args[0]), 1);
        var eventId = Math.max(parseIntStrict(args[1]), 1);
        var type  = args[2].toUpperCase();
        var value = args[3].toUpperCase();
        $gameSelfSwitches.setValue([mapId, eventId, type], value === 'ON');
    };
    Game_Interpreter.prototype.pluginCommandBook_Remote_Control_Self_Switch = function(args) {
        this.pluginCommandBook_セルフスイッチの遠隔操作(args);
    };
    Game_Interpreter.prototype.pluginCommandBook_ピクチャの読み込み = function(args) {
        ImageManager.loadPicture(args[0], 0);
    };
    Game_Interpreter.prototype.pluginCommandBook_Load_Picture = function(args) {
        this.pluginCommandBook_ピクチャの読み込み();
    };
    Game_Interpreter.prototype.pluginCommandBook_戦闘アニメの読み込み = function(args) {
        var hue = parseInt(args[1], 10).clamp(0, 360);
        ImageManager.loadAnimation(args[0], hue);
    };
    Game_Interpreter.prototype.pluginCommandBook_Load_Animation = function(args) {
        this.pluginCommandBook_戦闘アニメの読み込み(args);
    };
    Game_Interpreter.prototype.pluginCommandBook_シャットダウン = function(args) {
        SceneManager.terminate();
    };
    Game_Interpreter.prototype.pluginCommandBook_Shutdown = function(args) {
        this.pluginCommandBook_シャットダウン(args);
    };
    Game_Interpreter.prototype.pluginCommandBook_ウェブサイト起動 = function(args) {
        if (Utils.isNwjs()) {
            var newWindow = require('nw.gui').Window.open(args[0]);
            var x = parseInt(args[1], 10) || 0;
            var y = parseInt(args[2], 10) || 0;
            var width = parseInt(args[3], 10) || Graphics.width;
            var height = parseInt(args[4], 10) || Graphics.height;
            newWindow.moveTo(x, y);
            newWindow.resizeTo(width, height);
        }
    };
    Game_Interpreter.prototype.pluginCommandBook_Startup_Website = function(args) {
        this.pluginCommandBook_ウェブサイト起動(args);
    };
    Game_Interpreter.prototype.pluginCommandBook_変数の操作 = function(args) {
        args[0]=args[0].replace('#' ,'');
        args[1]=args[1].replace(/set/i,'=');
        args[1]=args[1].replace(/add/i,'+=');
        args[1]=args[1].replace(/sub/i,'-=');
        args[1]=args[1].replace(/mult/i,'*=');
        args[1]=args[1].replace(/div/i,'/=');
        args[1]=args[1].replace(/mod/i,'%=');
        var VarId1 = parseIntStrict(args[0]);
        if(isFinite(args[2]) && args[3]!='1'){
            var Var1 = parseInt(args[2],10);
        } else {
            var Var1 = args[2];
        }
        var Var2 = $gameVariables.value(VarId1);
        switch (args[1]) {
          case '=':
            $gameVariables.setValue(VarId1,Var1);
            break;
          case '+=':
            $gameVariables.setValue(VarId1,Var2+Var1);
            break;
          case '-=':
            Var1 =parseIntStrict(Var1);
            Var2 = parseIntStrict(Var2);
            $gameVariables.setValue(VarId1,Var2-Var1);
            break;
          case '*=':
            Var1 =parseIntStrict(Var1);
            Var2 = parseIntStrict(Var2);
            $gameVariables.setValue(VarId1,Var2*Var1);
            break; 
          case '/=':
            Var1 =parseIntStrict(Var1);
            Var2 = parseIntStrict(Var2);
            $gameVariables.setValue(VarId1,(Var2-(Var2%Var1))/Var1);
            break;
          case '%=':
            Var1 =parseIntStrict(Var1);
            Var2 = parseIntStrict(Var2);
            $gameVariables.setValue(VarId1,Var2%Var1);
            break;
        }
    };
    Game_Interpreter.prototype.pluginCommandBook_ControlVariable = function(args) {
        this.pluginCommandBook_変数の操作(args);
    };
    Game_Interpreter.prototype.pluginCommandBook_ConVar = function(args) {
        this.pluginCommandBook_変数の操作(args);
    };
    Game_Interpreter.prototype.pluginCommandBook_タッチ座標の取得 = function(args) {
        var x, y;
        if (TouchInput.isPressed()) {
            if (args[2] === 'マップ座標' || args[2] === 'Map') {
                x = $gameMap.canvasToMapX(TouchInput.x);
                y = $gameMap.canvasToMapY(TouchInput.y);
            } else {
                x = TouchInput.x;
                y = TouchInput.y;
            }
        } else {
            x = -1;
            y = -1;
        }
        $gameVariables.setValue(parseIntStrict(args[0]), x);
        $gameVariables.setValue(parseIntStrict(args[1]), y);
    };
    Game_Interpreter.prototype.pluginCommandBook_Get_Touch_Info = function(args) {
        this.pluginCommandBook_タッチ座標の取得(args);
    };
    Game_Interpreter.prototype.pluginCommandBook_マップタッチ禁止の変更 = function(args) {
        $gameSystem._mapTouchDisable = (args[0] === '禁止' || args[0] === 'Disable');
    };
    Game_Interpreter.prototype.pluginCommandBook_Change_Map_Touch = function(args) {
        this.pluginCommandBook_マップタッチ禁止の変更(args);
    };
    Game_Interpreter.prototype.pluginCommandBook_マップタッチ移動中判定 = function(args) {
        $gameSwitches.setValue(parseIntStrict(args[0]), $gameTemp.isDestinationValid());
    };
    Game_Interpreter.prototype.pluginCommandBook_Get_Map_Touch_Moving = function(args) {
        this.pluginCommandBook_マップタッチ移動中判定(args);
    };
    Game_Interpreter.prototype.pluginCommandBook_マップタッチ移動 = function(args) {
        $gameTemp.setDestination(parseInt(args[0], 10), parseInt(args[1], 10));
    };
    Game_Interpreter.prototype.pluginCommandBook_Map_Touch_Move = function(args) {
        this.pluginCommandBook_マップタッチ移動(args);
    };
    Game_Interpreter.prototype.pluginCommandBook_ピクチャの移動 = function(args) {
        var pictureId = parseInt(args[0], 10);
        var origin = args[1] === '左上' || args[1] === 'Upper_Left' ? 0 : 1;
        var x = parseIntStrict(args[2]);
        var y = parseIntStrict(args[3]);
        var scaleX = parseIntStrict(args[4]);
        var scaleY = parseIntStrict(args[5]);
        var opacity = parseIntStrict(args[6]);
        var blendMode;
        switch ((args[7] || '').toUpperCase()) {
            case '加算':
            case 'ADDITIVE':
                blendMode = 1;
                break;
            case '減算':
            case 'SUBTRACTIVE':
                blendMode = 2;
                break;
            default :
                blendMode = 0;
                break;
        }
        var duration = parseInt(args[8], 10);
        $gameScreen.movePicture(pictureId, origin, x, y, scaleX, scaleY, opacity, blendMode, duration);
        var wait = (args[9] || '').toUpperCase();
        if (wait === 'ウェイトあり' || wait === 'WAIT') this.wait(duration);
    };
    Game_Interpreter.prototype.pluginCommandBook_Move_Picture = function(args) {
        this.pluginCommandBook_ピクチャの移動(args);
    };
    Game_Interpreter.prototype.pluginCommandBook_数値入力範囲の設定 = function(args) {
        $gameMessage.setNumInputRange(
            parseIntStrict(args[0]).clamp(0, 99999999),
            parseIntStrict(args[1]).clamp(0, 99999999));
    };
    Game_Interpreter.prototype.pluginCommandBook_Set_Input_Num_Range = function(args) {
        this.pluginCommandBook_数値入力範囲の設定(args);
    };
    Game_Interpreter.prototype.pluginCommandBook_数値入力ウィンドウの設定 = function(args) {
        var background;
        switch (args[0].toUpperCase()) {
            case 'ウィンドウ':
            case 'WINDOW':
                background = 0;
                break;
            case '暗くする':
            case 'DIM':
                background = 1;
                break;
            case '透明':
            case 'TRANSPARENT':
                background = 2;
                break;
            default:
                throw new Error('背景に指定した値['+ args[0] +']が不正です。');
        }
        var position;
        switch (args[1].toUpperCase()) {
            case '左':
            case 'LEFT':
                position = 0;
                break;
            case '中':
            case 'MIDDLE':
                position = 1;
                break;
            case '右':
            case 'RIGHT':
                position = 2;
                break;
            default:
                throw new Error('位置に指定した値['+ args[1] +']が不正です。');
        }
        $gameMessage.setNumInputBackground(background);
        $gameMessage.setNumInputPositionType(position);
    };
    Game_Interpreter.prototype.pluginCommandBook_Set_Num_Input_Window = function(args) {
        this.pluginCommandBook_数値入力ウィンドウの設定(args);
    };
    Game_Interpreter.prototype.pluginCommandBook_数値入力有効桁の設定 = function(args) {
        $gameMessage._numInputValidDigit = parseIntStrict(args[0]).clamp(1, 8);
    };
    Game_Interpreter.prototype.pluginCommandBook_Set_Num_Input_Valid_Digit = function(args) {
        this.pluginCommandBook_数値入力有効桁の設定(args);
    };
    Game_Interpreter.prototype.pluginCommandBook_ピクチャの有効判定 = function(args) {
        var picture = $gameScreen.picture($gameScreen.realPictureId(parseIntStrict(args[1])));
        $gameSwitches.setValue(parseIntStrict(args[0]), picture != null);
    };
    Game_Interpreter.prototype.pluginCommandBook_Get_Picture_Valid = function(args) {
        this.pluginCommandBook_ピクチャの有効判定(args);
    };
    Game_Interpreter.prototype.pluginCommandBook_ピクチャの表示優先度設定 = function(args) {
        var picture = $gameScreen.picture($gameScreen.realPictureId(parseIntStrict(args[0])));
        if (picture) {
            picture.setZ(parseIntStrict(args[1]));
        } else {
            throw new Error('指定された番号[' + args[0] + ']のピクチャは無効です。');
        }
    };
    Game_Interpreter.prototype.pluginCommandBook_Set_Picture_Priority = function(args) {
        this.pluginCommandBook_ピクチャの表示優先度設定(args);
    };
    Game_Interpreter.prototype.pluginCommandBook_ピクチャのトリミング = function(args) {
        var picture = $gameScreen.picture($gameScreen.realPictureId(parseIntStrict(args[0])));
        if (picture) {
            picture.setFrameDirect(parseIntStrict(args[1]), parseIntStrict(args[2]),
                parseIntStrict(args[3]), parseIntStrict(args[4]));
        } else {
            throw new Error('指定された番号[' + args[0] + ']のピクチャは無効です。');
        }
    };
    Game_Interpreter.prototype.pluginCommandBook_Trimming_Picture = function(args) {
        this.pluginCommandBook_ピクチャのトリミング(args);
    };
    Game_Interpreter.prototype.pluginCommandBook_ピクチャの回転角設定 = function(args) {
        var picture = $gameScreen.picture($gameScreen.realPictureId(parseIntStrict(args[0])));
        if (picture) {
            picture.setAngleDirect(parseIntStrict(args[1]));
        } else {
            throw new Error('指定された番号[' + args[0] + ']のピクチャは無効です。');
        }
    };
    Game_Interpreter.prototype.pluginCommandBook_Angle_Picture = function(args) {
        this.pluginCommandBook_ピクチャの回転角設定(args);
    };
    Game_Interpreter.prototype.pluginCommandBook_文字の連結 = function(args) {
        args[0]=args[0].replace('#' ,'');
        var VarId1 = parseIntStrict(args[0]);
        var Str = String(args[1]) + String(args[2]);
        if(isFinite(Str) && args[3] == '1') Str = parseInt(Str,10);
        $gameVariables.setValue(VarId1,Str);
    };
    Game_Interpreter.prototype.pluginCommandBook_ConcatenStrings = function(args) {
        this.pluginCommandBook_文字の連結(args);
    };
    Game_Interpreter.prototype.pluginCommandBook_CatStr = function(args) {
        this.pluginCommandBook_文字の連結(args);
    };
    Game_Interpreter.prototype.pluginCommandBook_文字の置換 = function(args) {
        args[0]=args[0].replace('#' ,'');
        var VarId1   = parseInt(args[0],10);
        VarId1 = parseIntStrict(VarId1);
        var Str = String(args[1]);
        var Str2 = String(args[2]);
        var Str3 = String(args[3]);
        Str = Str.replace(/\x1b/gi);
        Str2 = Str2.replace(/\x1b/gi);
        Str3 = Str3.replace(/\x1b/gi);
        if (args[4] == null) args[4] = '全て';
        args[4]=args[4].replace(/front/i,'前方');
        args[4]=args[4].replace(/back/i,'後方');
        args[4]=args[4].replace(/all/i,'全て');
        switch (args[4]){
          case '前方':
            Str = Str.replace(Str2,Str3);
            break;
          case '後方':
            Str = RvStr(Str);
            Str2 = RvStr(Str2);
            Str3 = RvStr(Str3);
            Str = Str.replace(Str2,Str3);
            Str = RvStr(Str);
            break;
          case '全て':
          default:               
            while (Str.indexOf(Str2,0) != -1 ) Str = Str.replace(Str2,Str3); 
            break;
        }
        $gameVariables.setValue(VarId1,Str);
        function RvStr(st) {
            var rv = "";
            for (var i = 0, n = st.length; i < n; i++) rv += st[n - i - 1];
            return rv;
        }
    };
    Game_Interpreter.prototype.pluginCommandBook_ReplaceStrings = function(args) {
        this.pluginCommandBook_文字の置換(args);
    };
    Game_Interpreter.prototype.pluginCommandBook_RepStr = function(args) {
        this.pluginCommandBook_文字の置換(args);
    };
    Game_Interpreter.prototype.pluginCommandBook_文字の切取 = function(args) {
        args[0]=args[0].replace('#' ,'');
        var VarId1 = parseIntStrict(args[0]);
        var Str = String(args[1]);
        var Nm1 = parseIntStrict(args[2]);
        var Nm2 = args[3]
        if (Nm2.toLowerCase() == 'end' || Nm2 == '最後' ) Nm2 = Str.length;
        var Nm2 = parseIntStrict(Nm2);
        if (args[4] == null) args[4] = '前方';
        args[4]=args[4].replace(/front/i,'前方');
        args[4]=args[4].replace(/back/i,'後方');
        switch (args[4]){
          case '前方':
          default:
            Str = Str.substring(Nm1-1,Nm1+Nm2-1);
            break;
          case '後方':
            Str = Str.substring(Str.length-Nm1+1,Str.length-Nm1-Nm2+1);
            break;
        }
        $gameVariables.setValue(VarId1,Str);
    };
    Game_Interpreter.prototype.pluginCommandBook_CutStrings = function(args) {
        this.pluginCommandBook_文字の切取(args);
    };
    Game_Interpreter.prototype.pluginCommandBook_CutStr = function(args) {
        this.pluginCommandBook_文字の切取(args);
    };
    Game_Interpreter.prototype.pluginCommandBook_文字一致カウント = function(args) {
        args[0]=args[0].replace('#' ,'');
        var VarId1 = parseIntStrict(args[0]);
        var Str = String(args[1]);
        var Str2 = String(args[2]);
        var StrCnt = 0
        var StrLen
        if (args[3] == '1') {
          StrCnt = (Str.match(new RegExp(Str2, "g"))||[]).length;
        } else {
          while (Str.indexOf(Str2,0) != -1 ){
          StrCnt ++
          StrLen = Str.indexOf(Str2,0) + 1
          Str = Str.substring(StrLen,Str.length);
          }
        }
        $gameVariables.setValue(VarId1,StrCnt);
    };
    Game_Interpreter.prototype.pluginCommandBook_CountMatchString = function(args) {
        this.pluginCommandBook_文字一致カウント(args);
    }; 
    Game_Interpreter.prototype.pluginCommandBook_CntStr = function(args) {
        this.pluginCommandBook_文字一致カウント(args);
    };
    Game_Interpreter.prototype.pluginCommandBook_文字の検索 = function(args) {
        args[0]=args[0].replace('#' ,'');
        var VarId1 = parseIntStrict(args[0]);
        var Str = String(args[1]);
        var Str2 = String(args[2]);
        var StrLen
        if (args[3] == null) args[4] = '前方';
        args[3]=args[3].replace(/front/i,'前方');
        args[3]=args[3].replace(/back/i,'後方');
        switch (args[3]){
          case '前方':
          default:
            StrLen = Str.indexOf(Str2) + 1
            break;
          case '後方':
            StrLen = Str.lastIndexOf(Str2) + 1
            break;
        }
        $gameVariables.setValue(VarId1,StrLen);
   };
   Game_Interpreter.prototype.pluginCommandBook_SearchString = function(args) {
        this.pluginCommandBook_文字の検索(args);
   };
   Game_Interpreter.prototype.pluginCommandBook_SchStr = function(args) {
        this.pluginCommandBook_文字の検索(args);
   };
   Game_Interpreter.prototype.pluginCommandBook_文字数カウント = function(args) {
        args[0]=args[0].replace('#' ,'');
        var VarId1 = parseIntStrict(args[0]);
        var Str = String(args[1]);
        var StrLen = Str.length
        $gameVariables.setValue(VarId1,StrLen);
   };
   Game_Interpreter.prototype.pluginCommandBook_CountStringlength = function(args) {
        this.pluginCommandBook_文字数カウント(args);
   };
   Game_Interpreter.prototype.pluginCommandBook_SchStr = function(args) {
        this.pluginCommandBook_文字数カウント(args);
   };
   Game_Interpreter.prototype.pluginCommandBook_文字の反転 = function(args) {
        args[0]=args[0].replace('#' ,'');
        var VarId1 = parseIntStrict(args[0]);
        var Str = String(args[1]);
        var RevStr = "";
        for (var i = 0, n = Str.length; i < n; i++) RevStr += Str[n - i - 1];
        $gameVariables.setValue(VarId1,RevStr);
   };
 Game_Interpreter.prototype.pluginCommandBook_ReverseString = function(args) {
        this.pluginCommandBook_文字の反転(args);
   };
 Game_Interpreter.prototype.pluginCommandBook_RevStr = function(args) {
        this.pluginCommandBook_文字の反転(args);
   };
    Game_Interpreter.prototype.pluginCommandBook_強制セーブ = function(args) {
        $gameSystem.onBeforeSave();
        if (!DataManager.saveGame(DataManager.lastAccessedSavefileId())) {
            throw new Error('！！！セーブに失敗しました。セーブファイルは消去されています。！！！');
        }
    };
    Game_Interpreter.prototype.pluginCommandBook_Force_Save = function(args) {
        this.pluginCommandBook_強制セーブ(args);
    };
    Game_Interpreter.prototype.pluginCommandBook_指定位置にアニメーション表示 = function(args) {
        var x = parseIntStrict(args[0]);
        var y = parseIntStrict(args[1]);
        var id =  parseIntStrict(args[2]);
        var wait = args[3] && (args[3] === 'ウェイトあり' || args[3].toUpperCase() === 'wait');
        $gameScreen.startAnimation(x, y, id, false);
        if (wait) this.wait($dataAnimations[id].frames.length * 4);
    };
    Game_Interpreter.prototype.pluginCommandBook_Show_Animation = function(args) {
        this.pluginCommandBook_指定位置にアニメーション表示(args);
    };
    Game_Interpreter.prototype.pluginCommandBook_指定位置にループアニメーション表示 = function(args) {
        var x = parseIntStrict(args[0]);
        var y = parseIntStrict(args[1]);
        var id =  parseIntStrict(args[2]);
        $gameScreen.startAnimation(x, y, id, true);
    };
    Game_Interpreter.prototype.pluginCommandBook_Show_Loop_Animation = function(args) {
        this.pluginCommandBook_指定位置にループアニメーション表示(args);
    };
    Game_Interpreter.prototype.pluginCommandBook_ループアニメーション消去 = function(args) {
        $gameScreen.animationLoop = false;
    };
    Game_Interpreter.prototype.pluginCommandBook_Erase_Loop_Animation = function(args) {
        this.pluginCommandBook_ループアニメーション消去(args);
    };
    /*
     * ここからはプラグインコマンドの実装のために必要な関数などを追加する
     */
    var はい = true;
    var いいえ = false;
    /*
     * 制御文字の拡張
     *  このプラグインで使っている制御文字の拡張を通常のウィンドウにも適用します
     *  製作者 Alec
     */
    if (eval(String(parameters['制御文字の拡張']||'false'))) {
        (function () {
            var Window_Base_convertEscapeCharacters = Window_Base.prototype.convertEscapeCharacters;
            Window_Base.prototype.convertEscapeCharacters = function(text) {
                text = Game_Interpreter.prototype.pluginCommandBook_unescape(text);
                return Window_Base_convertEscapeCharacters.call(this, text);
            };
        })();
    }
    if (eval(String(parameters['スクリプトに制御文字適用']||'false'))) {
        (function () {
            var _Game_Interpreter_command355 = Game_Interpreter.prototype.command355;
            Game_Interpreter.prototype.command355 = function() {
                var oldParams = [], i = 0, result, index = this._index;
                oldParams.push(this._list[index].parameters[0]);
                this._list[index].parameters[0] = this.pluginCommandBook_unescape(this._list[index].parameters[0]);
                while (this._list[index + ++i].code === 655) {
                    oldParams.push(this._list[index + i].parameters[0]);
                    this._list[index + i].parameters[0] = this.pluginCommandBook_unescape(this._list[index + i].parameters[0]);
                }
                try {
                    result = _Game_Interpreter_command355.apply(this, arguments);
                } catch(e) {
                    console.log('スクリプトの実行中にエラーが発生しました。');
                    console.log('- スクリプト 　: ' + this.currentCommand().parameters[0]);
                    console.log('- エラー原因   : ' + e.toString());
                    result = true;
                }
                this._list[index].parameters[0] = oldParams.shift();
                i = 0;
                while (this._list[index + ++i].code === 655) {
                    this._list[index + i].parameters[0] = oldParams.shift();
                }
                return result;
            };
            var _Game_Interpreter_command111 = Game_Interpreter.prototype.command111;
            Game_Interpreter.prototype.command111 = function() {
                if (this._params[0] === 12) {
                    var oldParam = this._params[1];
                    var result;
                    this._params[1] = this.pluginCommandBook_unescape(this._params[1]);
                    try {
                        result = _Game_Interpreter_command111.apply(this, arguments);
                    } catch(e) {
                        console.log('スクリプトの実行中にエラーが発生しました。');
                        console.log('- スクリプト 　: ' + this._params[1]);
                        console.log('- エラー原因   : ' + e.toString());
                        result = true;
                    }
                    this._params[1] = oldParam;
                } else {
                    result = _Game_Interpreter_command111.apply(this, arguments);
                }
                return result;
            };
            var _Game_Character_processMoveCommand = Game_Character.prototype.processMoveCommand;
            Game_Character.prototype.processMoveCommand = function(command) {
                if (command.code === Game_Character.ROUTE_SCRIPT) {
                    var oldParam = command.parameters[0];
                    command.parameters[0] = Game_Interpreter.prototype.pluginCommandBook_unescape(command.parameters[0]);
                    try {
                        _Game_Character_processMoveCommand.apply(this, arguments);
                    } catch(e) {
                        console.log('スクリプトの実行中にエラーが発生しました。');
                        console.log('- スクリプト 　: ' + command.parameters[0]);
                        console.log('- エラー原因   : ' + e.toString());
                    }
                    command.parameters[0] = oldParam;
                } else {
                    _Game_Character_processMoveCommand.apply(this, arguments);
                }
            };
        })();
    }
    var _Game_System_initialize = Game_System.prototype.initialize;
    Game_System.prototype.initialize = function() {
        _Game_System_initialize.call(this);
        this._mapTouchDisable = false;
    };
    var _Game_Message_initialize= Game_Message.prototype.initialize;
    Game_Message.prototype.initialize = function() {
        _Game_Message_initialize.call(this);
        this._numInputBackground = 0;
        this._numInputPositionType = 1;
        this._numInputValidDigit = 1;
        this.clearNumInputRange();
    };
    Game_Message.prototype.clearNumInputRange = function() {
        this._numInputMaxValue = Infinity;
        this._numInputMinValue = -Infinity;
        this._numInputValidDigit = 1;
    };
    Game_Message.prototype.setNumInputRange = function(min, max) {
        this._numInputMaxValue = max;
        this._numInputMinValue = min;
    };
    Game_Message.prototype.setNumInputBackground = function(background) {
        this._numInputBackground = background;
    };
    Game_Message.prototype.setNumInputPositionType = function(positionType) {
        this._numInputPositionType = positionType;
    };
    Game_Message.prototype.numInputBackground = function() {
        return this._numInputBackground;
    };
    Game_Message.prototype.numInputPositionType = function() {
        return this._numInputPositionType;
    };
    var _Game_Screen_clear = Game_Screen.prototype.clear;
    Game_Screen.prototype.clear = function() {
        _Game_Screen_clear.apply(this, arguments);
        this.clearAnimation();
    };
    Game_Screen.prototype.startAnimation = function(x, y, id, loop) {
        this._animationContainerX = x;
        this._animationContainerY = y;
        this._animationId         = id;
        this._animationLoop       = loop;
    };
    Game_Screen.prototype.clearAnimation = function() {
        this._animationContainerX = 0;
        this._animationContainerY = 0;
        this._animationId         = 0;
    };
    Object.defineProperty(Game_Screen.prototype, 'animationContainerX', {
        get: function() {
            return this._animationContainerX;
        },
        configurable: false
    });
    Object.defineProperty(Game_Screen.prototype, 'animationContainerY', {
        get: function() {
            return this._animationContainerY;
        },
        configurable: false
    });
    Object.defineProperty(Game_Screen.prototype, 'animationId', {
        get: function() {
            return this._animationId;
        },
        configurable: false
    });
    Object.defineProperty(Game_Screen.prototype, 'animationLoop', {
        get: function() {
            return this._animationLoop;
        },
        set: function(value) {
            this._animationLoop = value;
        },
        configurable: false
    });
    var _Game_Screen_clearPictures = Game_Screen.prototype.clearPictures;
    Game_Screen.prototype.clearPictures = function() {
        _Game_Screen_clearPictures.apply(this, arguments);
        this.needsSortPictures = false;
    };
    var _Game_Picture_initBasic = Game_Picture.prototype.initBasic;
    Game_Picture.prototype.initBasic = function() {
        _Game_Picture_initBasic.apply(this, arguments);
        this._frameX      = 0;
        this._frameY      = 0;
        this._frameWidth  = 0;
        this._frameHeight = 0;
        this.z            = 100;
    };
    Game_Picture.prototype.setZ = function(value) {
        this.z = value;
    };
    Game_Picture.prototype.setFrameDirect = function(x, y, width, height) {
        this._frameX = x;
        this._frameY = y;
        this._frameWidth = width;
        this._frameHeight = height;
    };
    Game_Picture.prototype.isValidFrame = function() {
        return this._frameX + this._frameY + this._frameWidth + this._frameHeight > 0;
    };
    Game_Picture.prototype.setAngleDirect = function(value) {
        this._rotationSpeed = 0;
        this._angle = value % 360;
    };
    var _Scene_Map_isMapTouchOk = Scene_Map.prototype.isMapTouchOk;
    Scene_Map.prototype.isMapTouchOk = function() {
        return (!$gameSystem._mapTouchDisable || $gameTemp.isDestinationValid()) && _Scene_Map_isMapTouchOk.call(this);
    };
    var _Window_NumberInput_refresh = Window_NumberInput.prototype.refresh;
    Window_NumberInput.prototype.refresh = function() {
        if (this._number != null) this._number = this._number.clamp(
            $gameMessage._numInputMinValue, $gameMessage._numInputMaxValue);
        _Window_NumberInput_refresh.apply(this, arguments);
    };
    var _Window_NumberInput_start = Window_NumberInput.prototype.start;
    Window_NumberInput.prototype.start = function() {
        _Window_NumberInput_start.apply(this, arguments);
        this.updateBackground();
    };
    var _Window_NumberInput_processOk = Window_NumberInput.prototype.processOk;
    Window_NumberInput.prototype.processOk = function() {
        _Window_NumberInput_processOk.apply(this, arguments);
        $gameMessage.clearNumInputRange();
    };
    var _Window_NumberInput_updatePlacement = Window_NumberInput.prototype.updatePlacement;
    Window_NumberInput.prototype.updatePlacement = function() {
        _Window_NumberInput_updatePlacement.apply(this, arguments);
        var positionType = $gameMessage.numInputPositionType();
        this.width = this.windowWidth();
        switch (positionType) {
            case 0:
                this.x = 0;
                break;
            case 1:
                this.x = (Graphics.boxWidth - this.width) / 2;
                break;
            case 2:
                this.x = Graphics.boxWidth - this.width;
                break;
        }
    };
    var _Window_NumberInput_changeDigit = Window_NumberInput.prototype.changeDigit;
    Window_NumberInput.prototype.changeDigit = function(up) {
        if (this.maxItems() - this.index() < $gameMessage._numInputValidDigit) {
            return;
        }
        _Window_NumberInput_changeDigit.apply(this, arguments);
    };
    Window_NumberInput.prototype.updateBackground = function() {
        this._background = $gameMessage.numInputBackground();
        this.setBackgroundType(this._background);
    };
    var _Sprite_Picture_initialize = Sprite_Picture.prototype.initialize;
    Sprite_Picture.prototype.initialize = function(pictureId) {
        _Sprite_Picture_initialize.apply(this, arguments);
        this.z = 0;
    };
    var _Sprite_Picture_update = Sprite_Picture.prototype.update;
    Sprite_Picture.prototype.update = function() {
        _Sprite_Picture_update.call(this);
        if (this.visible) {
            var newZ = this.picture().z;
            if (newZ != this.z) {
                this.z = newZ;
                $gameScreen.needsSortPictures = true;
            }
            this.updateFrame();
        }
    };
    Sprite_Picture.prototype.updateFrame = function() {
        if (this.picture().isValidFrame()) {
            var p = this.picture();
            this.setFrame(p._frameX, p._frameY, p._frameWidth, p._frameHeight);
        }
    };
    var _Spriteset_Base_createUpperLayer = Spriteset_Base.prototype.createUpperLayer;
    Spriteset_Base.prototype.createUpperLayer = function() {
        _Spriteset_Base_createUpperLayer.apply(this, arguments);
        this.createAnimationContainer();
    };
    Spriteset_Base.prototype.createAnimationContainer = function() {
        this._animationContainer = new Sprite_Base();
        this._animationId = 0;
        this.addChild(this._animationContainer);
    };
    var _Spriteset_Base_update = Spriteset_Base.prototype.update;
    Spriteset_Base.prototype.update = function() {
        _Spriteset_Base_update.call(this);
        if ($gameScreen.needsSortPictures) {
            this.sortPictures();
            $gameScreen.needsSortPictures = false;
        }
        this.updateAnimationContainer();
    };
    Spriteset_Base.prototype.updateAnimationContainer = function() {
        var id = $gameScreen.animationId;
        if (id > 0 && id < $dataAnimations.length) {
            this._animationContainer.x = $gameScreen.animationContainerX;
            this._animationContainer.y = $gameScreen.animationContainerY;
            this._animationContainer.startAnimation($dataAnimations[id], false, 0);
            this._animationId = id;
            $gameScreen.clearAnimation();
        }
        if (!this._animationContainer.isAnimationPlaying() && this._animationId > 0) {
            if ($gameScreen.animationLoop) {
                this._animationContainer.startAnimation($dataAnimations[this._animationId], false, 0);
            } else {
                this._animationId = 0;
            }
        }
    };
    Spriteset_Base.prototype.sortPictures = function() {
        this._pictureContainer.children.sort(this._comparePictureChildOrder.bind(this));
    };
    Spriteset_Base.prototype._comparePictureChildOrder = function(a, b) {
        if (a.z !== b.z) {
            return a.z - b.z;
        } else {
            return a._pictureId - b._pictureId;
        }
    };
})();
