﻿// Copyright (c) 2017 tomoaky
// http://opensource.org/licenses/mit-license.php
/*:
 * @plugindesc 
 * パーティにいないときのみ同じ歩行グラフィックで出現します。
 *
 * @author tomoaky (https://twitter.com/tomoaky)
 *
 * @param actorTag
 * @desc イベントにアクターを設定するためのタグ名
 * 初期値: actor
 * @default actor
 *
 * @param useActorPosition
 * @type boolean
 * @desc アクター座標記憶システムを利用する
 * 初期値: OFF ( ON = 有効 / OFF = 無効 )
 * @default false
 * 
 * @param useActorDirection
 * @type boolean
 * @desc アクターの向きも記憶させる
 * 初期値: OFF ( ON = 有効 / OFF = 無効 )
 * @default false
 *
 * @help 
 */
var Imported = Imported || {};
Imported.TMActorEvent = true;
var TMPlugin = TMPlugin || {};
TMPlugin.ActorEvent = {};
TMPlugin.ActorEvent.Parameters = PluginManager.parameters('JsScript205Set');
TMPlugin.ActorEvent.ActorTag = TMPlugin.ActorEvent.Parameters['actorTag'] || 'actor';
TMPlugin.ActorEvent.UseActorPosition = JSON.parse(TMPlugin.ActorEvent.Parameters['useActorPosition'] || 'false');
TMPlugin.ActorEvent.UseActorDirection = JSON.parse(TMPlugin.ActorEvent.Parameters['useActorDirection'] || 'false');
if (!TMPlugin.InterpreterBase) {
TMPlugin.InterpreterBase = true;
(function() {
Game_Interpreter.prototype.convertEscapeCharactersTM = function(text) {
text = text.replace(/\\/g, '\x1b');
text = text.replace(/\x1b\x1b/g, '\\');
text = text.replace(/\x1bV\[(\d+)\]/gi, function() {
return $gameVariables.value(parseInt(arguments[1]));
}.bind(this));
text = text.replace(/\x1bV\[(\d+)\]/gi, function() {
return $gameVariables.value(parseInt(arguments[1]));
}.bind(this));
text = text.replace(/\x1bN\[(\d+)\]/gi, function() {
return this.actorNameTM(parseInt(arguments[1]));
}.bind(this));
text = text.replace(/\x1bP\[(\d+)\]/gi, function() {
return this.partyMemberNameTM(parseInt(arguments[1]));
}.bind(this));
text = text.replace(/\x1bG/gi, TextManager.currencyUnit);
return text;
};
Game_Interpreter.prototype.actorNameTM = function(n) {
var actor = n >= 1 ? $gameActors.actor(n) : null;
return actor ? actor.name() : '';
};
Game_Interpreter.prototype.partyMemberNameTM = function(n) {
var actor = n >= 1 ? $gameParty.members()[n - 1] : null;
return actor ? actor.name() : '';
};
})();
} 
(function() {
Game_Actor.prototype.getActorPosition = function() {
return this._actorPosition;
};
Game_Actor.prototype.setActorPosition = function(mapId, x, y, direction) {
this._actorPosition = { mapId: mapId, x: x, y: y, direction: direction };
};
Game_Actor.prototype.clearActorPosition = function() {
this._actorPosition = null;
};
var _Game_Party_removeActor = Game_Party.prototype.removeActor;
Game_Party.prototype.removeActor = function(actorId) {
if (TMPlugin.ActorEvent.UseActorPosition && this._actors.contains(actorId)) {
var actor = $gameActors.actor(actorId);
var events = $gameMap.events();
var flag = events.some(function(event) {
return +event.event().meta[TMPlugin.ActorEvent.ActorTag] === actorId;
});
if (flag) {
actor.setActorPosition($gameMap.mapId(), $gamePlayer.x, $gamePlayer.y, $gamePlayer.direction());
}
}
_Game_Party_removeActor.call(this, actorId);
};
var _Game_Event_findProperPageIndex = Game_Event.prototype.findProperPageIndex;
Game_Event.prototype.findProperPageIndex = function() {
var actorId = this.event().meta[TMPlugin.ActorEvent.ActorTag];
if (actorId) {
var actor = $gameActors.actor(+actorId);
if ($gameParty.allMembers().contains(actor)) return -1;
if (TMPlugin.ActorEvent.UseActorPosition) {
var pos = actor.getActorPosition();
if (pos && pos.mapId !== $gameMap.mapId()) return -1;
}
$gameMap._events.forEach(evnt => {
if (evnt && typeof evnt._eventId === 'number' && evnt._eventId === this._eventId) {
evnt._originalPattern = 1;
}
});
}
return _Game_Event_findProperPageIndex.call(this);
};
var _Game_Event_setupPageSettings = Game_Event.prototype.setupPageSettings;
Game_Event.prototype.setupPageSettings = function() {
_Game_Event_setupPageSettings.call(this);
var actorId = this.event().meta[TMPlugin.ActorEvent.ActorTag];
if (actorId) {
var actor = $gameActors.actor(+actorId);
this.setImage(actor.characterName(), actor.characterIndex());
if (TMPlugin.ActorEvent.UseActorPosition) {
var pos = actor.getActorPosition();
if (pos) {
this.locate(pos.x, pos.y);
if (TMPlugin.ActorEvent.UseActorDirection) {
this.setDirection(pos.direction);
}
}
}
$gameMap._events.forEach(evnt => {
if (evnt && typeof evnt._eventId === 'number' && evnt._eventId === this._eventId) {
evnt._originalPattern = 1;
}
});
}
};
var _Game_Interpreter_pluginCommand = Game_Interpreter.prototype.pluginCommand;
Game_Interpreter.prototype.pluginCommand = function(command, args) {
_Game_Interpreter_pluginCommand.call(this, command, args);
if (command === 'clearActorPosition') {
var arr = args.map(this.convertEscapeCharactersTM, this);
var actor = $gameActors.actor(+arr[0]);
if (actor) actor.clearActorPosition();
}
};
})();
