﻿var Imported = Imported || {};
Imported.Galv_CharacterFrames = true;
var Galv = Galv || {}; 
Galv.CF = Galv.CF || {}; 
/*:
 * @plugindesc 
 * 
 * @author Galv - galvs-scripts.com
 *
 * @param Frame Speed Modifier
 * @desc Equation SUBRTRACTED from frame speed (when not 3 frames). See help for more info on this.
 * @default f * 0.8
 *
 * @help 
 */
(function () {
    Galv.CF.y = PluginManager.parameters('JsScript27Set')["Frame Speed Modifier"];
    let Glv_FuncSave = new Function('f', 'return (' + Galv.CF.y + ");"); 
    Game_CharacterBase.prototype._cframes = 3;
    Game_CharacterBase.prototype._spattern = 1;
    var f = Game_CharacterBase.prototype._cframes;
    Game_CharacterBase.prototype._patSpd = 0;
    Game_CharacterBase.prototype._SetPtn = -1; 
    Galv.CF.Galv_Window_Base_drawCharacter = Window_Base.prototype.drawCharacter;
    Window_Base.prototype.drawCharacter = function (characterName, characterIndex, x, y) {
        var setFrame = characterName.match(/\%\((.*)\)/i);
        if (setFrame) {
            this._cframes = Number(setFrame[1]);
            var f = this._cframes;
            var bitmap = ImageManager.loadCharacter(characterName);
            var big = ImageManager.isBigCharacter(characterName);
            var pw = bitmap.width / (big ? f : f * 4);
            var ph = bitmap.height / (big ? 4 : 8);
            var n = characterIndex;
            var sx = (n % 4 * 3 + 1) * pw;
            var sy = (Math.floor(n / 4) * 4) * ph;
            this.contents.blt(bitmap, sx, sy, pw, ph, x - pw / 2, y - ph);
        } else {
            Galv.CF.Galv_Window_Base_drawCharacter.call(this, characterName, characterIndex, x, y);
        }
    };
    Galv.CF.Galv_Sprite_Character_setCharacterBitmap = Sprite_Character.prototype.setCharacterBitmap;
    Sprite_Character.prototype.setCharacterBitmap = function () {
        var setFrame = this._characterName.match(/\%\((.*)\)/i);
        if (setFrame) {
            this._cframes = Number(setFrame[1]);
            this._character._spattern = 0;
            var f = this._cframes;
            this._character._patSpd = Glv_FuncSave(f); 
        } else {
            this._cframes = 3;
            this._character._spattern = 1;
            this._character._patSpd = 0;
        }
        this._character._cframes = this._cframes;
        Galv.CF.Galv_Sprite_Character_setCharacterBitmap.call(this);
    };
    Game_CharacterBase.prototype.pattern = function () {
        if (this._SetPtn != -1) { 
            return this._SetPtn;
        }
        return this._pattern < this._cframes ? this._pattern : this._spattern;
    };
    Game_CharacterBase.prototype.updatePattern = function () {
        if (!this.hasStepAnime() && this._stopCount > 0) {
            this.resetPattern();
        } else {
            this._pattern = (this._pattern + 1) % (this._cframes + this._spattern);
        }
    };
    Galv.CF.Galv_Game_CharacterBase_animationWait = Game_CharacterBase.prototype.animationWait;
    Game_CharacterBase.prototype.animationWait = function () {
        return Galv.CF.Galv_Game_CharacterBase_animationWait.call(this) - this._patSpd;
    };
    Sprite_Character.prototype.characterBlockX = function () {
        if (this._isBigCharacter) {
            return 0;
        } else {
            var index = this._character.characterIndex();
            return index % 4 * this._cframes;
        }
    };
    Sprite_Character.prototype.patternWidth = function () {
        if (this._tileId > 0) {
            return $gameMap.tileWidth();
        } else if (this._isBigCharacter) {
            return this.bitmap.width / this._cframes;
        } else {
            return this.bitmap.width / (this._cframes * 4);
        }
    };
})();
