﻿// Copyright (c) 2015 Mokusei Penguin
// http://opensource.org/licenses/mit-license.php
/*:
 * @plugindesc 
 * @author 木星ペンギン
 *
 * @help 
 * @param Search Limit
 * @desc 移動できる距離
 * @default 12
 *
 */
(function() {
var parameters = PluginManager.parameters('JsScript51Set');
var searchLimit = Number(parameters['Search Limit']);
Game_Character.prototype.movePos = function(x, y, skippable) {
    skippable = !!skippable;
    var direction = this.findDirectionTo(x, y);
    if (direction > 0) {
        if (skippable && !this.canPass(this.x, this.y, direction)) {
            this.setMovementSuccess(true);   
            return;
        }
        this.moveStraight(direction);
        if (skippable && !this.isMovementSucceeded()) {
            this.setMovementSuccess(true);
        } else {
            this.setMovementSuccess(false);  
        }
    } else if (Math.abs(this._x - x) + Math.abs(this._y - y) < searchLimit) {
        this.setMovementSuccess(skippable || this.pos(x, y));
    }
};
Game_Character.prototype.searchLimit = function() {
    return searchLimit;
};
})();
