﻿/*:
 * @plugindesc 
 * @author ぬぷ竜
 */
/* 使用方法
    var _sc = new N_Scroll("PicName" , 500 , 15,100,100);
    _sc.ViewCount = 10; 
    _sc.ItemCount = 15; 
    _sc.ZureAdd(1); 
*/
class N_Scroll { 
    /**
     *
     * @param {string} _ImgName ファイル名
     * @param {number} _ImgYSize 画像ファイルの縦px
     * @param {number} _PicNo 表示Picture番号
     * @param {number} _PosX 表示位置X
     * @param {number} _PosY 表示位置Y
     */
    constructor(_ImgName, _ImgYSize, _PicNo, _PosX, _PosY) {
        this.ItemCount = 0;     
        this.ViewCount = 0;     
        this.ZureNo = 0;        
        this.BarMinSize = 0.1;  
        this.BarMinPar = 0.1;  
        this.ImgName = _ImgName;    
        this.ImgYSize = _ImgYSize;  
        this.PicNo = _PicNo;        
        this.posX = _PosX;          
        this.posY = _PosY;          
    }
    SetZure(_Var) {
        this.ZureNo = _Var;
    }
    ZureAdd(_Var) { 
        this.ZureNo += _Var;
        let _SkCnt = this.ItemCount - this.ViewCount; 
        if (_SkCnt < 0) _SkCnt = 0;
        if (0 > this.ZureNo) this.ZureNo = 0;
        if (_SkCnt < this.ZureNo) this.ZureNo = _SkCnt;
    }
    SetMaxZure() { 
        let _SkCnt = this.ItemCount - this.ViewCount; 
        if (_SkCnt < 0) _SkCnt = 0;
        this.ZureNo = _SkCnt;
        return _SkCnt;
    }
}
let ScrollSpriteFlg = false;
/**
 * @param {N_Scroll} _NScroll
 * @param {number} _SetOpi
 */
Game_Interpreter.prototype.ScView = function (_NScroll, _SetOpi) {
    _SetOpi = typeof _SetOpi !== 'undefined' ? _SetOpi : 255;
    let _SkCnt = _NScroll.ItemCount - _NScroll.ViewCount; 
    if (_SkCnt <= 0) { 
        if(ScrollSpriteFlg) {
            this.SetSprite(_NScroll.PicNo, _NScroll.ImgName, _NScroll.posX, _NScroll.posY, _SetOpi);
        } else {
            this.SetPict(_NScroll.PicNo, _NScroll.ImgName, _NScroll.posX, _NScroll.posY, _SetOpi);
        }
        return;
    }
    let _BarMy = 1 - (_SkCnt * _NScroll.BarMinPar);
    if (_BarMy <= _NScroll.BarMinSize) _BarMy = _NScroll.BarMinSize;
    let _SkmY = _NScroll.ImgYSize * (1 - _BarMy); 
    let _SkmPxcel = _SkmY / _SkCnt; 
    if (0 > _NScroll.ZureNo) _NScroll.ZureNo = 0;
    if (_SkCnt < _NScroll.ZureNo) _NScroll.ZureNo = _SkCnt;
    let _ZureY = _SkmPxcel * _NScroll.ZureNo; 
    if(ScrollSpriteFlg) {
        this.SetSprite(_NScroll.PicNo, _NScroll.ImgName, _NScroll.posX, _NScroll.posY + _ZureY,
            _SetOpi, 100, _BarMy * 100);
    } else {
        this.SetPict(_NScroll.PicNo, _NScroll.ImgName, _NScroll.posX, _NScroll.posY + _ZureY,
            _SetOpi, 100, _BarMy * 100);
    }
    ScrollSpriteFlg = false;
}
/**
 * @param {N_Scroll} _NScroll
 * @param {number} _SetOpi
 */
Game_Interpreter.prototype.ScrollView = function (_NScroll, _SetOpi) {
    ScrollSpriteFlg = false;
    this.ScView(_NScroll, _SetOpi)
}
/**
 * @param {N_Scroll} _NScroll
 * @param {number} _SetOpi
 */
Game_Interpreter.prototype.ScrollSpView = function (_NScroll, _SetOpi) {
    ScrollSpriteFlg = true;
    this.ScView(_NScroll, _SetOpi);
}
