﻿class Card {
    constructor(CardData) {
        this.CardData = CardData; 
        this.setPNo = -1; 
        this.XPos = 0;  
        this.YPos = 0;  
        this.PicName = CardData.id;    
        if (CardData.meta["Cost"] == undefined) {
            this.Cost = 0;
        } else if (CardData.meta["Cost"] == "All") {
            this.Cost = "All"
        } else {
            this.Cost = Number(CardData.meta["Cost"]);  
        }
        this.selectFlg = false; 
        this.KeepPicData = null; 
        this.CardRoot = []; 
        this._使用禁止 = false; 
        this._一時カード = false; 
        this.MoveAftPtc = ""; 
    }
}
let CardBaseStr = function (cardId) {
    let setCardReaNo = $dataWeapons[cardId].meta["Rea"];
    if (setCardReaNo == undefined) {
        setCardReaNo = "Err";
    }
    if ($dataWeapons[cardId].meta["NCNo"] != undefined) {
        setCardReaNo = "_Ex";
    }
    if ($dataWeapons[cardId].meta["エロカード"] != undefined) {
        setCardReaNo = "H";
    }
    if ($dataWeapons[cardId].meta["デバフ"] != undefined) {
        setCardReaNo = "De";
    }
    return CardPicPath + "wk_Rea" + setCardReaNo;
}
let CardKoukaCk = function (_CardData, _KSkillId) {
    for (let i = 0; i <= _CardData.traits.length - 1; i++) {
        if (_CardData.traits[i].dataId == _KSkillId) return true;
    }
    return false;
}
let CardKoukaCk_DType = function (cardData, _DTypeId) {
    for (let i = 0; i <= cardData.traits.length - 1; i++) {
        if (cardData.traits[i].code == 43) {
            let _ckSkill = $dataSkills[cardData.traits[i].dataId];
            if (_ckSkill.damage.elementId == _DTypeId) {
                return true;
            }
        }
    }
    return false;
}
let CardPicDataArr = null; 
class CardPicData {
    constructor(_CNo) {
        this._PicObj = []; 
        this._NoCost_PicObj = []; 
    }
}
Game_Interpreter.prototype.Set_CPicArr = function (CardNo, picNo, costFlg) {
    costFlg = typeof costFlg !== 'undefined' ? costFlg : true;
    if (CardPicDataArr == null) CardPicDataArr = new CardPicData();
    if (costFlg) { 
        if (CardPicDataArr._PicObj[CardNo] == null) {
            CardPicDataArr._PicObj[CardNo] = this.PicObjGet(picNo);
        }
    } else {
        if (CardPicDataArr._NoCost_PicObj[CardNo] == null) {
            CardPicDataArr._NoCost_PicObj[CardNo] = this.PicObjGet(picNo);
        }
    }
}
let _CLoadStopFlg = false;
let _CLoadNo = -1;
let _CLoad_flame = 0;
const _LoadSpan = 30;
let CardCmpLoad = Game_Interpreter.prototype.NUpdateSc;
Game_Interpreter.prototype.NUpdateSc = function () {
    CardCmpLoad.call(this);
    if (!_CLoadStopFlg) {
        CardPicDataArr = new CardPicData();
        for (let i = 0; i <= $dataWeapons.length - 1; i++) { 
            CardPicDataArr._PicObj.push(null);
            CardPicDataArr._NoCost_PicObj.push(null);
        }
    }
}
Game_Interpreter.prototype.CLoad_Stop = function () {
    _CLoad_flame = 0;
    _CLoadStopFlg = true;
}
Game_Interpreter.prototype.CLoad_Start = function () {
    _CLoadStopFlg = false;
    _CLoad_flame = 0;
}
let NotDelPicNo = [PN_CLoader, PN_CLoader + 1]; 
let NSet_DelPict = Game_Interpreter.prototype.DelPict;
Game_Interpreter.prototype.DelPict = function (PicNo) {
    if (NotDelPicNo.indexOf(PicNo) != -1) {
        return; 
    }
    NSet_DelPict.call(this, PicNo);
}
Game_Interpreter.prototype.CardSpriteSet = function (cardNo, setPicNo, setx, sety, opi, mx, my) {
    setx = typeof setx !== 'undefined' ? setx : 0;
    sety = typeof sety !== 'undefined' ? sety : 0;
    opi = typeof opi !== 'undefined' ? opi : 255;
    mx = typeof mx !== 'undefined' ? mx : 100;
    my = typeof my !== 'undefined' ? my : 100;
    let picPath = CardPicPath + cardNo;
    let costPicPath = CardPicPath + "PN_Cost";
    let setCost = $dataWeapons[cardNo].meta["Cost"];
    if (_cCostDrawMp != -1) {
        setCost = _cCostDrawMp;
    }
    costPicPath += setCost;
    if (_cscenFlg) {
        this.SetSpriteC(setPicNo + 0, CardBaseStr(cardNo), setx, sety, opi, mx, my);
        this.SetSpriteC(setPicNo + 1, picPath, setx, sety, opi, mx, my);
        if (_cCostDrawFlg) this.SetSpriteC(setPicNo + 2, costPicPath, setx, sety, opi, mx, my);
    } else {
        this.SetSprite(setPicNo + 0, CardBaseStr(cardNo), setx, sety, opi, mx, my);
        this.SetSprite(setPicNo + 1, picPath, setx, sety, opi, mx, my);
        if (_cCostDrawFlg) this.SetSprite(setPicNo + 2, costPicPath, setx, sety, opi, mx, my);
    }
    _cCostDrawFlg = true;
    _cscenFlg = false;
    _cCostDrawMp = -1;
}
Game_Interpreter.prototype.CardSpriteSetC = function (cardNo, setPicNo, setx, sety, opi, mx, my) {
    _cscenFlg = true;
    this.CardSpriteSet(cardNo, setPicNo, setx, sety, opi, mx, my);
}
Game_Interpreter.prototype.CardSpriteMove = function (cardNo, setx, sety, flame, opi, mx, my) {
    opi = typeof opi !== 'undefined' ? opi : 255;
    mx = typeof mx !== 'undefined' ? mx : 100;
    my = typeof my !== 'undefined' ? my : 100;
    if (GetSpriteData(cardNo) == null) return;
    if (setx == true) setx = GetSpriteData(cardNo)._x;
    if (sety == true) sety = GetSpriteData(cardNo)._y;
    if (opi == true) opi = GetSpriteData(cardNo)._opacity;
    if (mx == true) mx = GetSpriteData(cardNo)._scaleX;
    if (my == true) my = GetSpriteData(cardNo)._scaleY;
    this.MoveSprite(cardNo + 0, setx, sety, flame, opi, mx, my);
    this.MoveSprite(cardNo + 1, setx, sety, flame, opi, mx, my);
    this.MoveSprite(cardNo + 2, setx, sety, flame, opi, mx, my);
}
let _cCostDrawFlg = true; 
let _cscenFlg = false; 
let _cCostDrawMp = -1;  
Game_Interpreter.prototype.CardPicDraw = function (cardNo, setPicNo, cmpPicNo, setx, sety, opi, mx, my) {
    cmpPicNo = typeof cmpPicNo !== 'undefined' ? cmpPicNo : 450;
    setx = typeof setx !== 'undefined' ? setx : 0;
    sety = typeof sety !== 'undefined' ? sety : 0;
    opi = typeof opi !== 'undefined' ? opi : 255;
    mx = typeof mx !== 'undefined' ? mx : 100;
    my = typeof my !== 'undefined' ? my : 100;
    if (_cscenFlg) {
        this.SetPictC(setPicNo, CardBaseStr(cardNo), setx, sety, opi, mx, my);
    } else {
        this.SetPict(setPicNo, CardBaseStr(cardNo), setx, sety, opi, mx, my);
    }
    let picPath = CardPicPath + cardNo;
    this.SetPict(cmpPicNo, picPath);
    this.CmpPict(setPicNo, cmpPicNo);
    if (_cCostDrawFlg) {
        let setCost = $dataWeapons[cardNo].meta["Cost"];
        if (_cCostDrawMp != -1) {
            setCost = _cCostDrawMp
        }
        this.SetPict(cmpPicNo, BtlPicPath + "PN_Cost" + setCost);
        this.CmpPict(setPicNo, cmpPicNo);
    }
    this.Set_CPicArr(cardNo, setPicNo, _cCostDrawFlg); 
    _cCostDrawFlg = true;
    _cscenFlg = false;
    _cCostDrawMp = -1;
};
Game_Interpreter.prototype.CardPicDrawC = function (cardNo, setPicNo, cmpPicNo, setx, sety, opi, mx, my) {
    _cscenFlg = true;
    this.CardPicDraw(cardNo, setPicNo, cmpPicNo, setx, sety, opi, mx, my);
};
Game_Interpreter.prototype.CardReDrawC = function (handCardNo) {
    let cmpPicNo = PN_Cmp;
    let setPicNo = CardData[handCardNo].setPNo;
    if (CardData[handCardNo].setPNo == -1){
        return; 
    }
    let cardId = CardData[handCardNo].CardData.id;
    let setx = this.PicObjGet(CardData[handCardNo].setPNo)._x;
    let sety = this.PicObjGet(CardData[handCardNo].setPNo)._y;
    let opi = this.PicObjGet(CardData[handCardNo].setPNo)._opacity;
    let mx = this.PicObjGet(CardData[handCardNo].setPNo)._scaleX;
    let my = this.PicObjGet(CardData[handCardNo].setPNo)._scaleY;
    this.SetPictC(setPicNo, CardBaseStr(cardId), setx, sety, opi, mx, my);
    _cCostDrawFlg = true;
    let picName = CardPicPath + cardId;
    this.SetPict(cmpPicNo, picName);
    this.CmpPict(setPicNo, cmpPicNo);
    if (_cCostDrawFlg) {
        let setMp = CardData[handCardNo].Cost;
        this.SetPict(cmpPicNo, BtlPicPath + "PN_Cost" + setMp);
        this.CmpPict(setPicNo, cmpPicNo);
    }
}
let _CardSetuGet_StList = []; 
Game_Interpreter.prototype.CardSetuGet = function (cardNo) {
    _CardSetuGet_StList = [];
    let turnCount = 1;
    try {
        turnCount = NPlayer[0]._TurnCount;
    } catch (e) {
    }
    let rtnStrArr = [];
    let a = new CardStatus($dataWeapons[cardNo], turnCount); 
    if ($dataWeapons[cardNo].meta["Cost"] == "All") {
        rtnStrArr.push("●使用時にMPを全て消費する");
    }
    let setStateList = [];
    let ckTraits = $dataWeapons[cardNo].traits;
    for (let i = 0; i <= ckTraits.length - 1; i++) {
        if (ckTraits[i].code == 43) { 
            let setId = ckTraits[i].dataId;
            if (setId == KSkill.武器説明表示) {
                rtnStrArr = $dataWeapons[cardNo].description.split('\n');
                return rtnStrArr;
            }
        }
    }
    let kakeruSkipFlg = false;
    let cardName = $dataWeapons[cardNo].name;
    for (let i = 0; i <= ckTraits.length - 1; i++) {
        let setId = -1;
        if (ckTraits[i].code == 43) { 
            setId = ckTraits[i].dataId;
            if (setId == 102 || setId == 103) { 
                kakeruSkipFlg = true;
            }
            let sikiStr = $dataSkills[setId].damage.formula;
            let calcValue = Math.floor(ReUseBtlFunc(sikiStr)(a)); 
            let setCSText = $dataSkills[setId].description;
            if (setCSText == undefined) continue;
            if (!battleflg) { 
                setCSText = setCSText.replace("(現在calc)", ""); 
            }
            setCSText = setCSText.replace(/calc/g, calcValue);
            setCSText = setCSText.replace(/cname/g, cardName);
            if (BtlData.EndGetGold倍率 > 1) {
                setCSText = setCSText.replace(/greadcheck/g, "※使用済み");
            } else {
                setCSText = setCSText.replace(/greadcheck/g, "一度だけ");
            }
            let stateList = GetStateList($dataSkills[setId]);
            if (stateList.length > 0) {
                for (let j = 0; j <= stateList.length - 1; j++) {
                    let stateName = $dataStates[stateList[j]._No].name;
                    setCSText = setCSText.replace(/state/g, stateName);
                    setStateList.push(stateList[j]);
                }
            }
            let re = /<([^<>:]+)(:?)([^>]*)>/g;
            for (; ;) {
                let match = re.exec(setCSText);
                if (match) {
                    if (match[2] === ':') {
                        let _Syu = match[1]; 
                        let _Var = match[3]; 
                        switch (_Syu) {
                            case "i":
                                let _ckAdSys = GetBtlItemData(_Var);
                                setCSText = setCSText.replace(match[0], "アイテム「" + _ckAdSys._name + "」");
                                break;
                        }
                    }
                } else {
                    break;
                }
            }
            rtnStrArr.push(setCSText);
        }
        if (setId == KSkill.以下曜日効果変化) {
            if ($gameSwitches.value(SW_Yobi + 0)) rtnStrArr.push("★風曜日（２枚ドロー）");
            if ($gameSwitches.value(SW_Yobi + 1)) rtnStrArr.push("★火曜日（25ダメージ）");
            if ($gameSwitches.value(SW_Yobi + 2)) rtnStrArr.push("★水曜日（MP2回復）");
            if ($gameSwitches.value(SW_Yobi + 3)) rtnStrArr.push("★土曜日（防御値+25）");
            break;
        }
    }
    _CardSetuGet_StList = setStateList;
    for (let i = 0; i <= rtnStrArr.length - 1; i++) {
        if (rtnStrArr[i] == "") {
            rtnStrArr.splice(i, 1);
            i--;
        }
        if (i > 2) {
            rtnStrArr.splice(i, 1);
            i--;
        }
    }
    if (!kakeruSkipFlg) {
        for (let i = 0; i < rtnStrArr.length; i++) {
            let cnt = 1;
            for (let j = i + 1; j < rtnStrArr.length; j++) {
                if (rtnStrArr[i] == rtnStrArr[j]) {
                    cnt++;
                    rtnStrArr.splice(j, 1);
                    j--;
                }
            }
            if (cnt > 1) {
                rtnStrArr[i] = rtnStrArr[i] + "×" + cnt;
            }
        }
    }
    return rtnStrArr;
}
let _CEType = {
    DeckAdd: 1, 
    TrashAdd: 2, 
    HandAdd: 3 
};
class CardEffStac { 
    constructor (tgtType, cardId, flame, cngCost, _使捨Flg) {
        cngCost = typeof cngCost !== 'undefined' ? cngCost : -1;
        _使捨Flg = typeof _使捨Flg !== 'undefined' ? _使捨Flg : false;
        this._EType = tgtType; 
        this._CardId = cardId; 
        this._Flame = flame; 
        this._CngCost = cngCost;   
        this._使捨Flg = _使捨Flg;   
    }
}
class CardEffData { 
    constructor(tgtType, cardId, _CngCost, _使捨Flg) {
        _CngCost = typeof _CngCost !== 'undefined' ? _CngCost : -1;
        _使捨Flg = typeof _使捨Flg !== 'undefined' ? _使捨Flg : false;
        this._EType = tgtType; 
        this._CardId = cardId; 
        this._CngCost = _CngCost;   
        this._使捨Flg = _使捨Flg;   
        this._PicNo; 
        this._Flame = 0; 
    }
}
Game_Interpreter.prototype.DeckCardAdd = function (cardId, addValue) {
    if (!battleflg) return; 
    for (let i = 0; i <= addValue - 1; i++) {
        CardEffectStac.push(new CardEffStac(_CEType.DeckAdd, cardId, 5 * i));
    }
};
Game_Interpreter.prototype.DeckTrashAdd = function (cardId, addValue) {
    for (let i = 0; i <= addValue - 1; i++) {
        CardEffectStac.push(new CardEffStac(_CEType.TrashAdd, cardId, 5 * i));
    }
}
let _DeckHandAdd_使捨Flg = false;
Game_Interpreter.prototype.DeckHandAdd = function (cardId, addValue, mustFlg, cngCost) {
    mustFlg = typeof mustFlg !== 'undefined' ? mustFlg : false;
    cngCost = typeof cngCost !== 'undefined' ? cngCost : -1;
    if (CardData.length + mustFlg - 7 > 0) { 
        let _TrCVar = CardData.length + mustFlg - 7;
        for (let i = 0; i <= _TrCVar - 1; i++) {
            CardData.splice(Math.floor(Math.random() * CardData.length), 1);
        }
    }
    for (let i = 0; i <= addValue - 1; i++) {
        CardEffectStac.push(new CardEffStac(_CEType.HandAdd, cardId, 5 * i, cngCost, _DeckHandAdd_使捨Flg));
    }
    _DeckHandAdd_使捨Flg = false;
}
Game_Interpreter.prototype.SetDeckTop = function (cardNo, _INNo) {
    _INNo = typeof _INNo !== 'undefined' ? _INNo : 0;
    DeckCard.splice(_INNo, 0, cardNo);
}
let _手札カード存在確認 = function (_ckNo) {
    let _rtnCnt = 0;
    for (let i = 0; i <= CardData.length - 1; i++) {
        if (CardData[i].CardData.id == _ckNo) _rtnCnt++;
    }
    return _rtnCnt;
}
let _デッキカード存在確認 = function (_ckNo) {
    let _rtnCnt = 0;
    for (let i = 0; i <= BtlDeck.length - 1; i++) {
        if (BtlDeck[i] == _ckNo) _rtnCnt++;
    }
    return _rtnCnt;
}
let CardEffectStac = []; 
let CardEffectViewStac = []; 
Game_Interpreter.prototype.CardEffectUpdate = function () {
    for (let i = 0; i <= CardEffectStac.length - 1; i++) {
        CardEffectStac[i]._Flame--; 
        if (CardEffectStac[i]._Flame <= 0) { 
            let _CardType = CardEffectStac[i]._EType; 
            let _CardId = CardEffectStac[i]._CardId; 
            let _CngCost = CardEffectStac[i]._CngCost; 
            let _使捨Flg = CardEffectStac[i]._使捨Flg; 
            CardEffectViewStac.push(new CardEffData(_CardType, _CardId, _CngCost, _使捨Flg)); 
        }
        if (CardEffectStac[i]._Flame <= 0) {
            CardEffectStac.splice(i, 1);
            i--;
        }
    }
    this.CardEffectViewUpdate(); 
};
let PEPosArr = [null, null, null, null, null];
Game_Interpreter.prototype.CardEffectViewUpdate = function () {
    for (let i = 0; i <= CardEffectViewStac.length - 1; i++) {
        CardEffectViewStac[i]._Flame++; 
        let cardType = CardEffectViewStac[i]._EType; 
        let cardId = CardEffectViewStac[i]._CardId;  
        let cngCost = CardEffectViewStac[i]._CngCost;  
        let _使捨Flg = CardEffectViewStac[i]._使捨Flg;  
        let picNo = CardEffectViewStac[i]._PicNo;    
        if (CardEffectViewStac[i]._Flame == 1) { 
            let setPicNo = 0;
            for (let j = 0; j <= PEPosArr.length - 1; j++) {
                if (PEPosArr[j] == null) {
                    setPicNo = j;
                    PEPosArr[j] = 1; 
                    break;
                }
            }
            CardEffectViewStac[i]._PicNo = PN_ECard + setPicNo;
            picNo = CardEffectViewStac[i]._PicNo;
            let posX = CardEVPosXGet(setPicNo) * 199 + 300; 
            if (cngCost != -1) _cCostDrawMp = cngCost;
            this.CardPicDrawC(cardId, picNo, PN_Cmp, 580, 344, 0, 0, 0);
            EasingStr = "easeOutBack";
            this.MovePict(picNo, posX, 244, 20, 255, 85, 85);
            EasingStr = "";
        }
        if (CardEffectViewStac[i]._Flame == 90) { 
            let setPicNo = picNo - PN_ECard;
            PEPosArr[setPicNo] = null; 
            switch (cardType) {
                case _CEType.DeckAdd: 
                    let inNo = Math.floor(Math.random() * DeckCard.length);
                    DeckCard.splice(inNo, 0, cardId);
                    BtlDeck.push(cardId);
                    this.MovePict(picNo, 55, 713, 20, 0, 0, 0);
                    this.DeckMaisuView(); 
                    break;
                case _CEType.TrashAdd: 
                    BtlDeck.push(cardId);
                    this.MovePict(picNo, 975, 713, 20, 0, 0, 0);
                    this.DeckMaisuView(); 
                    break;
                case _CEType.HandAdd: 
                    if (CardData.length < BtlStatic._手札最大枚数) {
                        this.MovePict(picNo, true, 713, 20, 0, 0, 0);
                        this.HandCardDraw(); 
                        this.CardDrawSetting(cardId, 500, 300, cngCost, _使捨Flg);
                        this.CardDrawMove();
                        BtlDeck.push(cardId);
                        this.BtlLive2DParamSet_HandCard();
                    } else {
                        this.MovePict(picNo, true, 713, 20, 0, 0, 0);
                    }
                    break;
            }
            CardEffectViewStac.splice(i, 1);
            i--;
        }
    }
}
let CardEVPosXGet = function (posNo) { 
    if (posNo == 0) return 0;
    if (posNo == 1) return 1;
    if (posNo == 2) return -1;
    if (posNo == 3) return 2;
    if (posNo == 4) return -2;
    return 0;
}
let reloadDeckPicDelFlame = -1;
let _一時CardFlg = false; 
let _NotSeCardDrawSetting = false; 
Game_Interpreter.prototype.CardDrawSetting = function (cardNo , startX , startY , cngCost , _使捨Flg) {
    cardNo = typeof cardNo !== 'undefined' ? cardNo : -1;
    startX = typeof startX !== 'undefined' ? startX : 31;
    startY = typeof startY !== 'undefined' ? startY : 643;
    cngCost = typeof cngCost !== 'undefined' ? cngCost : -1; 
    _使捨Flg = typeof _使捨Flg !== 'undefined' ? _使捨Flg : false;
    for (let i = 0; i <= DeckCard.length - 1; i++) {
        if (DeckCard[i] == -1) {
            DeckCard.splice(i, 1);
            i--;
        }
    }
    if (CardData.length >= BtlStatic._手札最大枚数) {
        this.BLogAdd(180, SCol.Red + "手札の枚数上限により、ドロー失敗");
        this.SetPicStrPop(PN_ExText, SCol.Red + "手札枚数上限", 20,
            NPlayer[0]._screenX - 64, NPlayer[0]._screenY - 129);
        _CardSetting_DeckFlg = false;
        return;
    }
    if (DeckCard.length == 0) { 
        SpriteAnimeLoopFlg = false;
        reloadDeckPicDelFlame = 50;
        this.PlaySpriteAnime(PN_DeckReload, BtlPicPath + "BAnime/DeckReload", 18, 2, 64 - 131, 705 - 90);
        this.DeckReSetting();
    }
    let starCardDrawFlg = StarCardSettingFlg && DeckCard[0] == $gameSystem.StarCardNo[$gameSystem.SelDeck];
    if (starCardDrawFlg) StarCardSettingFlg = false;
    let drawCardNo = DeckCard[0];
    if (cardNo == -1) {
        DeckCard.shift(); 
        if (drawCardNo == undefined) drawCardNo = CId_待機;
        console.log("drawCardNo：" + drawCardNo);
        if ($dataWeapons[drawCardNo] == undefined) {
            return;
        }
        let setCard = new Card($dataWeapons[drawCardNo]);
        setCard._一時カード = _一時CardFlg;
        //if (setCard.Cost != "All" && starCardDrawFlg) setCard.Cost = 0;
        if (cngCost != -1) setCard.Cost = cngCost;
        if (CheckStateInType(NPlayer[0]._NState, StType.DrawCostRnd)) {
            if (setCard.Cost != "All") {
                setCard.Cost = Math.floor(Math.random() * 3);
            }
        }
        if (_使捨Flg) {
            setCard._一時カード = true;
        }
        CardData.push(setCard); 
    } else {
        if (_CardSetting_DeckFlg) { 
            _CardSetting_DeckFlg = false;
            let setCardNo = DeckCard.indexOf(cardNo);
            if (setCardNo != -1) {
                DeckCard.splice(setCardNo, 1); 
            }
        }
        let setCard = new Card($dataWeapons[cardNo]);
        if (cngCost != -1) setCard.Cost = cngCost;
        if (CheckStateInType(NPlayer[0]._NState, StType.DrawCostRnd)) {
            if (setCard.Cost != "All") {
                setCard.Cost = Math.floor(Math.random() * 3);
            }
        }
        setCard._一時カード = _一時CardFlg;
        if (_使捨Flg) {
            setCard._一時カード = true;
        }
        CardData.push(setCard); 
    }
    _一時CardFlg = false;
    this.DeckMaisuView(); 
    let setNo = CardData.length - 1;
    let setOpi = 200;
    CardData[setNo].setPNo = PN_Card + setNo;
    CardData[setNo].XPos = startX;
    CardData[setNo].YPos = startY;
    let drawCardId = CardData[setNo].CardData.id;
    _cCostDrawMp = CardData[setNo].Cost; 
    this.CardPicDrawC(drawCardId, CardData[setNo].setPNo, PN_Cmp, CardData[setNo].XPos, CardData[setNo].YPos, setOpi, 20, 20);
    CardData[setNo].KeepPicData = this.PicObjGet(CardData[setNo].setPNo);
    $gameScreen.tintPicture(CardData[setNo].setPNo, [-20, -20, -20, 0], 0);
    if (!_NotSeCardDrawSetting) this.PlaySe("card");
    _NotSeCardDrawSetting = false;
    this._ドロー時レリック効果発動();
};
let _CardSetting_DeckFlg = false; 
Game_Interpreter.prototype.Deck_CardSetting = function (_CardNo, _開始X, _開始Y, _CngCost) {
    _CardNo = typeof _CardNo !== 'undefined' ? _CardNo : -1;
    _開始X = typeof _開始X !== 'undefined' ? _開始X : 31;
    _開始Y = typeof _開始Y !== 'undefined' ? _開始Y : 643;
    _CngCost = typeof _CngCost !== 'undefined' ? _CngCost : -1; 
    let _ckNo = BtlDeck.indexOf(_CardNo);
    if (_ckNo != -1) {
        _CardSetting_DeckFlg = true;
        this.CardDrawSetting(_CardNo, _開始X, _開始Y, _CngCost);
    }
}
const Btl_手札拡大率 = 67;
Game_Interpreter.prototype.HandCardDraw = function () {
    this.DelPictSpan(PN_Card, PN_Card + BtlStatic._手札最大枚数 - 1); 
    let Cardxset = HandZureX(); 
    for (let i = 0; i <= CardData.length - 1; i++) {
        let CardId = CardData[i].CardData.id;
        CardData[i].setPNo = PN_Card + i;
        CardData[i].XPos = 217 + Cardxset * i;
        CardData[i].YPos = 579;
        this.CardPicDrawC(CardId, CardData[i].setPNo, PN_Cmp, CardData[i].XPos, CardData[i].YPos, 0, Btl_手札拡大率, Btl_手札拡大率);
        this.MovePict(CardData[i].setPNo, true, true, 10, 255, true, true);
    }
}
Game_Interpreter.prototype.DeckMaisuView = function () {
    this.SetSprite(PN_Deck, BtlPicPath + "PN_Deck4", 15, 669);
    if (DeckCard.length > 1) this.SetSprite(PN_Deck, BtlPicPath + "PN_Deck3", 15, 669);
    if (DeckCard.length > 7) this.SetSprite(PN_Deck, BtlPicPath + "PN_Deck2", 15, 669);
    if (DeckCard.length > 14) this.SetSprite(PN_Deck, BtlPicPath + "PN_Deck1", 15, 669);
    setmaisu = " " + String(DeckCard.length);
    this.SpriteStrC(PN_T_Maisu, setmaisu, 21, 124, 774);
    const ckDeckArr = BtlDeck.slice();
    let sumHandCount = CardData.length;
    for (let i = 0; i < CardData.length; i++) {
        let ckIndex = ckDeckArr.indexOf(CardData[i].CardData.id);
        if (ckIndex != -1) { 
            ckDeckArr.splice(ckIndex, 1); 
        } else {
            sumHandCount--; 
        }
    }
    //■捨て札の設定(デッキ総数 - デッキ残り枚数 - 手札)
    let _suteCount = (BtlDeck.length - DeckCard.length - sumHandCount);
    if (_suteCount <= 0) _suteCount = 0;
    let _smaisu = " " + _suteCount;
    this.SetSprite(PN_Trash, BtlPicPath + "trash", 932, 728);
    this.SpriteStrC(PN_Trash + 1, _smaisu, 16, 1000, 786);
}
Game_Interpreter.prototype.KeepCardMove = function () {
    let Cardxset = HandZureX();
    for (let i = 0; i <= CardData.length - 1; i++) {
        CardData[i].XPos = 217 + Cardxset * i;
        CardData[i].YPos = 579;
    }
}
let BtlCardSelectionMode = -1;
let btlCardSelection選択完了 = false;
let BtlCardSelectionFlg = false; 
let BtlCardSelectionMaisu = 0; 
let btlCardSelectionFlame = 0; 
let btlCardSelectionCardDataArr = [];
let btlCardSelectionSelectFlgArr = [];
let BtlCardSelectionPicArr = [];
for (let i = 0; i <= 10 - 1; i++) {
    BtlCardSelectionPicArr.push(PN_CSelCard + i);
}
Game_Interpreter.prototype.BtlCardSelectionUpdate = function () {
    if (BtlCardSelectionFlg) {
        if (!btlCardSelection選択完了) {
            this.BtlCardSelection_SelectUpdate(); 
        } else {
            this.BtlCardSelection_選択完了(); 
        }
        btlCardSelectionFlame++;
    }
    return BtlCardSelectionFlg; 
}
Game_Interpreter.prototype.BtlCardSelectionSetting = function (mode, maisu) {
    this.DelPictSpan(PN_CSelBack, PN_CSelTxt); 
    BtlCardSelectionFlg = true;
    btlCardSelectionFlame = 0;
    BtlCardSelectionMode = mode; 
    btlCardSelection選択完了 = false;
    BtlCardSelectionMaisu = maisu; 
    BtlCardSelectionPicArr = []; 
    for (let i = 0; i <= 10 - 1; i++) {
        BtlCardSelectionPicArr.push(PN_CSelCard + i);
    }
    this.BLogStop(); 
    this.BtlCardSelectionView(BtlCardSelectionMode); 
    _CardSelRow = 0; 
}
let _CardSelectX = 358;
let _CardSelectY = 315;
let _BtlCardSelect_IdArr = [];    
let _BtlCardSelect_Cost = -1;   
Game_Interpreter.prototype.BtlCardSelectionView = function () {
    btlCardSelectionSelectFlgArr = [];
    btlCardSelectionCardDataArr = []; 
    let _SetStr = ""; 
    switch (BtlCardSelectionMode) {
        case DType.CSHandTr: 
            _SetStr = "捨札に送るカードを選択してください（" + BtlCardSelectionMaisu + "枚）";
            for (let i = 0; i <= CardData.length - 1; i++) {
                btlCardSelectionCardDataArr.push(CardData[i].CardData.id);
                btlCardSelectionSelectFlgArr.push(false);
            }
            break;
        case DType.CSCardGet: 
        case DType.CSTrCardGet: 
            _SetStr = "手札に加えるカードを選択してください（" + BtlCardSelectionMaisu + "枚）";
            for (let i = 0; i <= _BtlCardSelect_IdArr.length - 1; i++) {
                btlCardSelectionCardDataArr.push(_BtlCardSelect_IdArr[i]);
                btlCardSelectionSelectFlgArr.push(false);
            }
            break;
    }
    this.SetPict(PN_CSelBack, "Black", 0, 0, 0);
    this.MovePict(PN_CSelBack, true, true, 10, 200);
    this.SetPicStrC(PN_CSelTxt, _SetStr, 35, 720, 117);
    this.BtlCardSelectionCardDraw(); 
}
let _CardSelRow = 0;
Game_Interpreter.prototype.BtlCardSelectionCardDraw = function () {
    this.DelPictSpan(PN_CSelCard, PN_CSelCard + BtlStatic._手札最大枚数);
    for (let i = 0; i <= btlCardSelectionCardDataArr.length - 1; i++) {
        let ckNo = (_CardSelRow * 5) + i;
        let CardId = btlCardSelectionCardDataArr[ckNo];
        let _Xi = i % 5;
        let _Yi = Math.floor(i / 5);
        switch (BtlCardSelectionMode) {
            case DType.CSHandTr: 
                _cCostDrawMp = CardData[i].Cost; 
                this.CardPicDrawC(CardId, PN_CSelCard + i, PN_Cmp, _CardSelectX + (170 * _Xi), _CardSelectY + (260 * _Yi), 255, Btl_手札拡大率, Btl_手札拡大率);
                break;
            case DType.CSCardGet: 
            case DType.CSTrCardGet: 
                if (_BtlCardSelect_Cost != -1) {
                    _cCostDrawMp = _BtlCardSelect_Cost;
                }
                this.CardPicDrawC(CardId, PN_CSelCard + i, PN_Cmp, _CardSelectX + (170 * _Xi), _CardSelectY + (260 * _Yi), 255, Btl_手札拡大率, Btl_手札拡大率);
                break;
        }
    }
    this.DelPictSpan(PN_CSelScBtn + 0, PN_CSelScBtn + 1);
    if (_CardSelRow > 0) {
        this.SetPict(PN_CSelScBtn + 0, BtlPicPath + "PN_CSelScBtn_0", 338, 143, 255);
    }
    if (CardData.length > _CardSelRow * 5 + 10) {
        this.SetPict(PN_CSelScBtn + 1, BtlPicPath + "PN_CSelScBtn_1", 338, 700, 255);
    }
}
let BCSCardArr = [];
Game_Interpreter.prototype.BtlCardSelection_SelectUpdate = function () {
    this.DelPictSpan(PN_BDSetuWaku, PN_BDSetuWaku + 3); 
    this.DelPictSpan(_STY_SetuPicNo, _STY_SetuPicNo + 3);
    let cardPicNo = overPointerCkArr(BtlCardSelectionPicArr);
    if (cardPicNo != -1) {
        let cardId = btlCardSelectionCardDataArr[cardPicNo - PN_CSelCard];
        let cardPosX = $gameScreen.picture(cardPicNo).x() - 224;
        if (cardPosX <= 0) cardPosX = 0;
        let cardPosY = $gameScreen.picture(cardPicNo).y() - 225;
        this.PL_Select_デッキ確認_説明描画(cardId, cardPosX, cardPosY);
        if (TouchInput.isTriggered()) {
            this.PlaySe("change_day");
            btlCardSelectionSelectFlgArr[cardPicNo - PN_CSelCard + (_CardSelRow * 5)] = !btlCardSelectionSelectFlgArr[cardPicNo - PN_CSelCard];
        }
        this.BtlCardSelection_HikariDraw(cardPicNo - PN_CSelCard);
    } else {
        this.SetumeiDel(); 
        this.BtlCardSelection_HikariDraw();
    }
    this.PicCngColorArr([PN_CSelScBtn + 0, PN_CSelScBtn + 1]);
    cardPicNo = overPointerCkArr([PN_CSelScBtn + 0, PN_CSelScBtn + 1]);
    if (cardPicNo != -1) {
        this.PicCngColor(cardPicNo, [50, 50, 50, 0]);
        if (TouchInput.isTriggered()) {
            if (cardPicNo == PN_CSelScBtn + 0) { 
                _CardSelRow--;
                this.BtlCardSelectionCardDraw();
            }
            if (cardPicNo == PN_CSelScBtn + 1) { 
                _CardSelRow++;
                this.BtlCardSelectionCardDraw();
            }
        }
    }
    let checkCount = 0;
    BCSCardArr = [];
    for (let i = 0; i <= btlCardSelectionSelectFlgArr.length - 1; i++) {
        if (btlCardSelectionSelectFlgArr[i]) {
            BCSCardArr.push(i);
            checkCount++;
        }
    }
    if (checkCount == BtlCardSelectionMaisu) btlCardSelection選択完了 = true;
    if (checkCount == btlCardSelectionSelectFlgArr.length) btlCardSelection選択完了 = true; 
}
Game_Interpreter.prototype.BtlCardSelection_選択完了 = function () {
    for (let i = 0; i <= btlCardSelectionCardDataArr.length - 1; i++) {
        if (btlCardSelectionSelectFlgArr[i]) {
            switch (BtlCardSelectionMode) {
                case DType.CSHandTr: 
                    CardData.splice(i, 1);
                    btlCardSelectionCardDataArr.splice(i, 1);
                    btlCardSelectionSelectFlgArr.splice(i, 1);
                    i--;
                    break;
                case DType.CSCardGet: 
                case DType.CSTrCardGet: 
                    _DeckHandAdd_使捨Flg = (BtlCardSelectionMode == DType.CSTrCardGet); 
                    this.DeckHandAdd(btlCardSelectionCardDataArr[i], 1, false, _BtlCardSelect_Cost);
                    break;
            }
        }
    }
    this.DelPictSpan(PN_BDSetuWaku, PN_BDSetuWaku + 3); 
    this.DelPictSpan(_STY_SetuPicNo, _STY_SetuPicNo + 3);
    this.BtlCardSelection_PicDel();
    btlWaitFlame = 10;
    this.HandCardDraw(); 
    this.CardDrawMove(); 
    BtlCardSelectionFlg = false;
    this.BLogStart(); 
    this.DeckMaisuView(); 
}
Game_Interpreter.prototype.BtlCardSelection_PicDel = function () {
    for (let i = PN_CSelBack; i <= PN_CSelScBtn + 1; i++) {
        this.MovePict(i, true, true, 10, 0, true, true);
    }
}
Game_Interpreter.prototype.BtlCardSelection_HikariDraw = function (select_i) {
    select_i = typeof select_i !== 'undefined' ? select_i : -1;
    for (let i = 0; i <= 10 - 1; i++) {
        let _Xi = i % 5;
        let _Yi = Math.floor(i / 5);
        if (select_i == i) {
            this.SetPictC(PN_CSelCardH + i, BtlPicPath + "PN_CHikari_Y",
                _CardSelectX + (170 * _Xi), _CardSelectY + (260 * _Yi), 255, Btl_手札拡大率, Btl_手札拡大率);
            continue;
        }
        if (btlCardSelectionSelectFlgArr[i + (_CardSelRow * 5)]) {
            this.SetPictC(PN_CSelCardH + i, BtlPicPath + "PN_CHikari2",
                _CardSelectX + (170 * _Xi), _CardSelectY + (260 * _Yi), 255, Btl_手札拡大率, Btl_手札拡大率);
        } else {
            this.DelPict(PN_CSelCardH + i);
        }
    }
}
let PN_DV_DeckBack = -1
let PN_DV_DeckBar = -1;
let PN_DV_DeckCard = -1;
let PN_DV_DeckTop = -1;
let PN_DV_DeckBtm = -1;
let PN_DV_DeckEndBtn = -1;
let PN_DV_RSetuWaku = -1;
let DV_Scroll = null;
let DV_Seli = 0;
let DV_flame = 0;
let DV_DeckArr = [];
let DV_DeckTPArr = [];
Game_Interpreter.prototype.Deck一覧View = function (_PicNo, _VDeckArr, _BackImgStr) {
    _BackImgStr = typeof _BackImgStr !== 'undefined' ? _BackImgStr : "PN_BDeckBack";
    PN_DV_DeckBack = _PicNo;
    PN_DV_DeckBar = PN_DV_DeckBack + 1;
    PN_DV_DeckCard = PN_DV_DeckBar + 1;
    PN_DV_DeckTop = PN_DV_DeckCard + 12;
    PN_DV_DeckBtm = PN_DV_DeckTop + 1;
    PN_DV_DeckEndBtn = PN_DV_DeckBtm + 1;
    PN_DV_RSetuWaku = PN_DV_DeckEndBtn + 1;
    DV_Scroll = new N_Scroll(Rd_DeckPath + "PN_BDeckBar", 457, PN_DV_DeckBar, 1312, 188);
    this.SetPictFIn(PN_DV_DeckBack, Rd_DeckPath + _BackImgStr, 0, 0, 0, 0, 10);
    DV_flame = 0;
    DV_Seli = 0;
    DV_DeckArr = [];
    for (let i = 0; i <= _VDeckArr.length - 1; i++) {
        let _nAddFlg = true;
        for (let j = 0; j <= DV_DeckArr.length - 1; j++) {
            if (DV_DeckArr[j]._CNo == _VDeckArr[i]) {
                _nAddFlg = false;
                DV_DeckArr[j]._Cnt++;
            }
        }
        if (_nAddFlg) { 
            DV_DeckArr.push(new Deck_Edit(_VDeckArr[i]));
        }
    }
    this.Deck一覧CardDraw(true);
    this.SetPictFIn(PN_DV_DeckEndBtn, Rd_DeckPath + "PN_BDeckEndBtn", 617, 725, 0, 0, 10);
    DV_Scroll.ViewCount = 2; 
    DV_Scroll.ItemCount = Math.ceil(DV_DeckArr.length / 6);
    DV_Scroll.ZureNo = 0;
    this.ScrollView(DV_Scroll, 255);
}
Game_Interpreter.prototype.Deck一覧CardDraw = function (_SetFlg) {
    _SetFlg = typeof _SetFlg !== 'undefined' ? _SetFlg : false;
    let _SetOpi = 255;
    if (_SetFlg) {
        _SetOpi = 0;
    } else {
        this.DelPictSpan(PN_DV_DeckCard, PN_DV_DeckCard + 11);
    }
    let _DPsX = 192 + 80;
    let _DPsY = 178 + 100;
    DV_DeckTPArr = [];
    for (let i = 0; i <= 12 - 1; i++) { 
        let ix = i % 6;
        let iy = Math.floor(i / 6);
        let _cki = DV_Seli * 6 + i;
        if (DV_DeckArr.length > _cki) {
            let _cardNo = DV_DeckArr[_cki]._CNo;
            DV_DeckTPArr.push(PN_DV_DeckCard + i);
            this.CardPicDrawC(_cardNo, PN_DV_DeckCard + i, PN_Cmp, _DPsX + (ix * 172), _DPsY + (iy * 257), _SetOpi, 62, 62);
            if (DV_DeckArr[_cki]._Cnt >= 1) {
                let _SetCnt = DV_DeckArr[_cki]._Cnt;
                if (_SetCnt >= 10) _SetCnt = 10;
                this.SetPict(PN_Cmp, CardPicPath + "wk_cnt" + _SetCnt);
                this.CmpPict(PN_DV_DeckCard + i, PN_Cmp);
            }
            this.MovePict(PN_DV_DeckCard + i, true, true, 10, 255, true, true);
            if (_AddDcCNo == _cardNo) {
                this.PlayPtcScTop("S_Click", _cXPos + (ix * 108), _cYPos + (iy * 148));
            }
        }
    }
}
Game_Interpreter.prototype.Deck一覧Update = function () {
    if (DV_flame > 20) {
        this.DelPictSpan(PN_DV_RSetuWaku, PN_DV_RSetuWaku + 3);
        this.DelPictSpan(_STY_SetuPicNo, _STY_SetuPicNo + 3);
        let _CNo = overPointerCkArr(DV_DeckTPArr);
        if (_CNo != -1) {
            _CNo -= PN_DV_DeckCard;
            let ix = _CNo % 6;
            let iy = Math.floor(_CNo / 6);
            let _CNoX = 50 + (ix * 172);
            let _CNoY = 70 + (iy * 257);
            _CNo += (DV_Seli * 6);
            let _CardNo = DV_DeckArr[_CNo]._CNo;
            this.Deck一覧説明描画(_CardNo, _CNoX, _CNoY);
        }
        if (TouchInput.wheelY > 0) { 
            if (DV_Seli >= Math.ceil(DV_DeckArr.length / 6) - 2) {
                DV_Seli = Math.ceil(DV_DeckArr.length / 6) - 2;
            } else {
                DV_Seli++;
                DV_Scroll.ZureNo = DV_Seli;
                this.ScrollView(DV_Scroll, 255);
                this.Deck一覧CardDraw(false);
            }
        }
        if (TouchInput.wheelY < 0) { 
            if (DV_Seli > 0) {
                DV_Seli--;
                DV_Scroll.ZureNo = DV_Seli;
                this.ScrollView(DV_Scroll, 255);
                this.Deck一覧CardDraw(false);
            }
        }
        if (DV_Seli < 0) DV_Seli = 0;
        let _DcEndFlg = false;
        if (Input.isTriggered('menu') || TouchInput.isCancelled()) {
            _DcEndFlg = true;
        }
        this.PicCngColor(PN_DV_DeckEndBtn);
        if (overPointerCk(PN_DV_DeckEndBtn)) {
            this.PicCngColor(PN_DV_DeckEndBtn, [80, 80, 80, 0]);
            if (TouchInput.isTriggered()) _DcEndFlg = true;
        }
        if (_DcEndFlg) {
            this.Deck一覧End();
            return true;
        }
    }
    DV_flame++;
}
Game_Interpreter.prototype.Deck一覧End = function () {
    this.DelPictSpan(PN_DV_DeckBack, PN_DV_DeckEndBtn);
    this.DelPictSpan(PN_DV_RSetuWaku, PN_DV_RSetuWaku + 3);
    this.DelPictSpan(_STY_SetuPicNo, _STY_SetuPicNo + 3);
}
Game_Interpreter.prototype.Deck一覧説明描画 = function (_CardNo, _PosX, _PosY) {
    _STY_SetuPicNo = PN_DV_RSetuWaku;
    this.Btl_STYCard説明_DrawPict(_CardNo, _PosX, _PosY)
}
Game_Interpreter.prototype.PL_Select_デッキ確認_説明描画 = function (_CardNo, _PosX, _PosY) {
    _STY_SetuPicNo = PN_BDSetuWaku;
    this.Btl_STYCard説明_DrawPict(_CardNo, _PosX, _PosY)
}
