﻿Game_Interpreter.prototype.EnemyStartDraw = function () {
    this.DelSpriteSpan(PN_Character, PN_Character + 4); 
    for (let i = 0; i <= NEnemy.length - 1; i++) {
        NEnemy[i]._screenX += EnemyZureX; 
        NEnemy[i]._screenY += EnemyZureY;
        NEnemy[i]._UsePtnNo = this.GetEnemyNextActionNo_ENo(i, 0); 
        this.EnemyDraw(i); 
    }
}
Game_Troop.prototype.setup = function (troopId) {
    this.clear();
    this._troopId = troopId;
    this._enemies = [];
    this.troop().members.forEach(function (member) {
        if ($dataEnemies[member.enemyId]) {
            let enemyId = member.enemyId;
            enemyId = RandEnemyIdGet(enemyId);
            let x = member.x;
            let y = member.y;
            let enemy = new Game_Enemy(enemyId, x, y);
            if (member.hidden) enemy.hide();
            this._enemies.push(enemy);
        }
    }, this);
    this.makeUniqueNames();
};
let RandEnemyIdGet = function (enemyId) {
    let metaStr = MetaChecker($dataEnemies[enemyId], "敵選出", "");
    if (metaStr != "") {
        let ckArr = metaStr.split(',');
        let rndValue = Math.floor(Math.random() * ckArr.length);
        return Number(ckArr[rndValue]);
    }
    return enemyId;
}
let ViewSpinePicNo = -1;
let View_ENo = -1;
let GetEnemyIdlName = function (GameEnemyData) {
    if (GameEnemyData._enemyId == null) return "Idl";
    let enemyData = $dataEnemies[GameEnemyData._enemyId];
    var ckData = MetaChecker(enemyData, 'SpineHPIdl' , false);
    if (!ckData) return "Idl";
    let strs = ckData.split(',');
    return strs[1];
}
Game_Interpreter.prototype.EnemyDraw = function (ENo , setOpi) {
    setOpi = typeof setOpi !== 'undefined' ? setOpi : 255; 
    if (NEnemy[ENo]._hp == 0) return;
    let enemyPicPath = GetEnemyData_ENo(ENo).battlerName; 
    if (NEnemy[ENo].SpineFlg) { 
        NEnemy[ENo]._pWidth = MetaChecker($dataEnemies[NEnemy[ENo]._enemyId], 'Spine_幅', 200);
        NEnemy[ENo]._pHeight = MetaChecker($dataEnemies[NEnemy[ENo]._enemyId], 'Spine_縦', 200);
        NEnemy[ENo].SpineScale = Number(MetaChecker($dataEnemies[NEnemy[ENo]._enemyId], 'Spine_Scale', 1));
        NEnemy[ENo].SpineXScale = NEnemy[ENo].SpineScale;
        if (MetaChecker($dataEnemies[NEnemy[ENo]._enemyId], 'Spine反転' , false))
            NEnemy[ENo].SpineXScale *= -1;
        let idlName = GetEnemyIdlName(NEnemy[ENo]);
        this.SpineView(PN_Character + NEnemy[ENo]._PicNo, enemyPicPath, idlName, true,
            NEnemy[ENo]._screenX, NEnemy[ENo]._screenY , 255 ,
            100 * NEnemy[ENo].SpineXScale , 100 * NEnemy[ENo].SpineScale);
        this.delSpineSkinMdl(enemyPicPath);
        let addSkinFlg = false;
        for (let i = 1; i <= 5; i++) { 
            let ckSpineTrack = MetaChecker($dataEnemies[NEnemy[ENo]._enemyId], 'Spine_Track_' + i, false);
            if (ckSpineTrack != false)
                this.SetSpineAnime(PN_Character + NEnemy[ENo]._PicNo, ckSpineTrack, true, i, 100);
            let ckSpineSkin = MetaChecker($dataEnemies[NEnemy[ENo]._enemyId], 'SpineSkin_' + i, false);
            if (ckSpineSkin != false) {
                addSkinFlg = true;
                this.AddSpineSkin(enemyPicPath , ckSpineSkin);
            }
        }
        if (addSkinFlg) this.SpineSkinCng(PN_Character + NEnemy[ENo]._PicNo , enemyPicPath);
        this.SetSpriteC(PN_Character + NEnemy[ENo]._PicNo, "enemies/_HitBox", NEnemy[ENo]._screenX, NEnemy[ENo]._screenY);
        let viewSpineCmnEvNo = MetaChecker($dataEnemies[NEnemy[ENo]._enemyId], 'Spine表示コモン', false);
        NEnemy[ENo].AtkStr = MetaChecker($dataEnemies[NEnemy[ENo]._enemyId], 'Spine_Atk', "Atk");
        if (viewSpineCmnEvNo != false) {
            View_ENo = ENo;
            ViewSpinePicNo = PN_Character + NEnemy[ENo]._PicNo;
            CmnEnemyData = NEnemy[ENo];
            this.SetCmnEvent(viewSpineCmnEvNo);
        }
    } else {
        if (!MetaChecker($dataEnemies[NEnemy[ENo]._enemyId], '静止画表示', false)) {
            this.PlaySpriteAnimeC(PN_Character + NEnemy[ENo]._PicNo, "enemies/BAnime/" + enemyPicPath,
                4, 8 + Math.floor( Math.random() * 5), NEnemy[ENo]._screenX, NEnemy[ENo]._screenY);
        } else {
            this.SetSpriteC(PN_Character + NEnemy[ENo]._PicNo, "enemies/" + enemyPicPath,
                NEnemy[ENo]._screenX, NEnemy[ENo]._screenY);
        }
    }
}
var EnemyChange_SetOpi = 255;
Game_Interpreter.prototype.EnemyChange = function (ENo, enemyId, hpKeepFlg) {
    hpKeepFlg = typeof hpKeepFlg !== 'undefined' ? hpKeepFlg : true; 
    let _ckEmData = $dataEnemies[enemyId];
    NEnemy[ENo]._enemyId = enemyId;
    NEnemy[ENo]._name = _以降文字削除(_ckEmData.name, "::");
    if (hpKeepFlg) { 
        NEnemy[ENo]._hp = _ckEmData.params[0]; 
        NEnemy[ENo].hp = _ckEmData.params[0]; 
    }
    NEnemy[ENo].mhp = _ckEmData.params[0];
    NEnemy[ENo].mp = _ckEmData.params[1];
    NEnemy[ENo]._mp = _ckEmData.params[1];
    NEnemy[ENo].mmp = _ckEmData.params[1];
    NEnemy[ENo].atk = _ckEmData.params[2];
    NEnemy[ENo].def = _ckEmData.params[3];
    NEnemy[ENo].mat = _ckEmData.params[4];
    NEnemy[ENo].mdf = _ckEmData.params[5];
    NEnemy[ENo].agi = _ckEmData.params[6];
    NEnemy[ENo].luk = _ckEmData.params[7];
    NEnemy[ENo]._befhp = -1;
    this.EnemyDraw(ENo , EnemyChange_SetOpi); 
    EnemyChange_SetOpi = 255;
    NEnemy[ENo]._RePtnArr = [];
    TCDataReset_EnemyChange(ENo, enemyId);
    this.TCPicReDraw();
}
Game_Interpreter.prototype.EnemyChange_HpOn = function (ENo, enemyId, hpKeepFlg) {
    if (NEnemy[ENo].hp <= 0) return;
    this.EnemyChange(ENo, enemyId, hpKeepFlg);
}
Game_Enemy.prototype.meetsTurnCondition = function (param1, param2) {
    let n = this._TurnCount; 
    if (param2 === 0) {
        return n === param1;
    } else {
        return n > 0 && n >= param1 && n % param2 === param1 % param2;
    }
};
let MustSetActionNo = -1; 
Game_Interpreter.prototype.SetEnemyNextAction = function (ENo, resetFlg) {
    resetFlg = typeof resetFlg !== 'undefined' ? resetFlg : false;
    let ckChara = GetBtlChara_ENo(ENo);
    let plusTurnCount = 1;
    if (resetFlg) {
        plusTurnCount = 0;
        ckChara._UsePtnNo = -1;
    }
    let befPtn = ckChara._UsePtnNo;
    if (MustSetActionNo != -1) {
        ckChara._UsePtnNo = MustSetActionNo
    } else {
        ckChara._UsePtnNo = this.GetEnemyNextActionNo_ENo(ENo, plusTurnCount);
    }
    if (befPtn != ckChara._UsePtnNo && !resetFlg) { 
        console.log("行動パターン変化！！"); 
    }
    SetBtlChara_ENo(ENo, ckChara);
    MustSetActionNo = -1; 
}
Game_Interpreter.prototype.GetEnemyNextActionNo_ENo = function (ckENo, plusTurnCount) {
    plusTurnCount = typeof plusTurnCount !== 'undefined' ? plusTurnCount : 0; 
    let ckChara = GetBtlChara_ENo(ckENo); 
    let useSkillArr = [];
    let rtnActionId = null; 
    ckChara._TurnCount += plusTurnCount;
    let enemyData = GetEnemyData_ENo(ckENo);
    for (let i = 0; i <= enemyData.actions.length - 1; i++) {
        if (ckChara.meetsCondition(enemyData.actions[i])) {
            let skipflg = false; 
            for (let j = 0; j <= ckChara._OneSkillNo.length - 1; j++) {
                if (ckChara._OneSkillNo[j] == i) {
                    skipflg = true; 
                }
            }
            if (!skipflg && this.EnemySkillCheck(ckENo, i)) {
                useSkillArr.push([enemyData.actions[i], i]);
            }
        }
    }
    let copyArr = []; 
    for (let i = 0; i <= useSkillArr.length - 1; i++) { 
        switch (useSkillArr[i][0].rating) {
            case 8:
            case 9:
                rtnActionId = useSkillArr[i][1];
                break;
        }
    }
    if (rtnActionId == null) {
        let DelLowSkillFlg = false;
        for (let i = 0; i <= useSkillArr.length - 1; i++) {
            if (useSkillArr[i][0].rating > 2) {
                copyArr.push(useSkillArr[i]); 
                DelLowSkillFlg = true;
            }
        }
        if (DelLowSkillFlg) {
            useSkillArr = copyArr; 
        }
        let RateCounter = 0; 
        for (let i = 0; i <= useSkillArr.length - 1; i++) {
            RateCounter += useSkillArr[i][0].rating;
        }
        let ckRateValue = Math.floor(Math.random() * RateCounter);
        for (let i = 0; i <= useSkillArr.length - 1; i++) {
            ckRateValue -= useSkillArr[i][0].rating;
            if (ckRateValue < 0) {
                rtnActionId = useSkillArr[i][1];
                break;
            }
        }
    }
    ckChara._TurnCount -= plusTurnCount;
    SetBtlChara_ENo(ckENo, ckChara);
    return rtnActionId; 
}
Game_Interpreter.prototype.ReActionSet_ENo = function (ENo) {
    if (ENo < -1) { 
        ENo = (ENo * -1) - 1;
        for (let i = 1; i <= NPlayer.length - 1; i++) {
            if (ENo == i) {
                this.SetEnemyNextAction(i, true); 
            }
        }
    } else {
        for (let i = 0; i <= NEnemy.length - 1; i++) {
            if (ENo == i) {
                this.SetEnemyNextAction(i, true); 
            }
        }
    }
}
Game_Interpreter.prototype.TargetArrReActionSet = function () {
    for (let i = 0; i <= TargetArr.length - 1; i++) {
        this.ReActionSet_ENo(TargetArr[i]);
    }
}
Game_Interpreter.prototype.BtlEnemyActionUpdate = function (ckSWNo) {
    ckSWNo = typeof ckSWNo !== 'undefined' ? ckSWNo : -1;
    for (let i = 0; i <= NEnemy.length - 1; i++) {
        if (NEnemy[i]._hp <= 0) continue;
        let ckSwArr = MetaChecker(NEnemy[i].enemy(), "Re行動SW").split(',');
        for (let j = 0; j <= ckSwArr.length - 1; j++) {
            let swNo = BtlSwCk(ckSwArr[j]); 
            if ($gameSwitches._data[swNo] && NEnemy[i]._RePtnArr.indexOf(swNo) == -1) {
                this.BLogAdd(180, NEnemy[i]._name + "の行動が変化した");
                this.SetEnemyNextAction(i, true); 
                NEnemy[i]._RePtnArr.push(swNo);
            }
            if (swNo == ckSWNo) { 
                this.SetEnemyNextAction(i, true); 
            }
        }
    }
    for (let i = 1; i <= NPlayer.length - 1; i++) {
        if (NPlayer[i]._hp <= 0) continue;
        let ckSwArr = MetaChecker(NPlayer[i].enemy(), "Re行動SW").split(',');
        for (let j = 0; j <= ckSwArr.length - 1; j++) {
            let swNo = BtlSwCk(ckSwArr[j]); 
            if ($gameSwitches._data[swNo] && NPlayer[i]._RePtnArr.indexOf(swNo) == -1) {
                this.BLogAdd(180, NPlayer[i]._name + "の行動が変化した");
                this.SetEnemyNextAction(i, true); 
                NPlayer[i]._RePtnArr.push(swNo);
            }
            if (swNo == ckSWNo) { 
                this.SetEnemyNextAction(i, true); 
            }
        }
    }
}
let BtlSwCk = function (ckSWNo) {
    if (ckSWNo.indexOf("ed") != -1) { 
        return Number(ckSWNo.replace("ed", "")) + BtlEnemy行動Check.SW_EnemyDown - 1;
    }
    if (ckSWNo.indexOf("b") != -1) { 
        return Number(ckSWNo.replace("b", "")) + BtlStatic.SW_戦闘用SW - 1;
    }
    return Number(ckSWNo);
}
Game_Interpreter.prototype.EnemySkillCheck = function (ENo, skillNo) {
    try {
        GetSkillMemoData(GetEnemyData_ENo(ENo), skillNo); 
        switch (memoSkillArr[0]) {
            case "ジャミング": 
                if (AllJumingCk()) return false; 
                break;
            default:
        }
    } catch (ex) {
    }
    return true; 
}
let EmaePosX = 0;
let EmaePosY = 0;
let setMoveType = 0;
Game_Interpreter.prototype.EnemyTargetSelect = function (skillNo) {
    TargetArr = [];
    TgEffArr = []; 
    let ckSkill = $dataSkills[skillNo];
    let targetScope = $dataSkills[skillNo].scope;
    let moveType = $dataSkills[skillNo].stypeId;
    if (TurnCard[0]._Type != EnemyTCType.EmSkill && TurnCard[0]._No >= 0) {
        EmaePosX = NEnemy[TurnCard[0]._No]._screenX;
        EmaePosY = NEnemy[TurnCard[0]._No]._screenY;
    }
    let targetENo = 0;
    let sumTgtRnk = 0;
    for (let i = 0; i <= NPlayer.length - 1; i++) {
        if (NPlayer[i]._hp <= 0) continue
        sumTgtRnk += NPlayer[i]._TgtRnk;
    }
    let ckTargetRank = Math.random() * sumTgtRnk;
    sumTgtRnk = 0;
    for (let i = 0; i <= NPlayer.length - 1; i++) {
        if (NPlayer[i]._hp <= 0) continue
        if (sumTgtRnk < ckTargetRank && sumTgtRnk + NPlayer[i]._TgtRnk >= ckTargetRank) {
            targetENo = i; 
            break;
        }
        sumTgtRnk += NPlayer[i]._TgtRnk;
    }
    if (MetaChecker(ckSkill  , "Player狙い" , false) != false) {
        targetENo = 0; 
    }
    switch (moveType) {
        case EnBtlMove.m_近接: 
            TgMoveX = NPlayer[targetENo]._screenX - 80;
            TgMoveY = NPlayer[targetENo]._screenY;
            break;
        case EnBtlMove.m_正面: 
            TgMoveX = EmaePosX;
            TgMoveY = NPlayer[targetENo]._screenY;
            break;
        case EnBtlMove.m_中央: 
            TgMoveX = NPlayer[targetENo]._screenX - 80;
            TgMoveY = NPlayer[targetENo]._screenY;
            break;
        case EnBtlMove.m_少し前: 
            TgMoveX = EmaePosX + 80;
            TgMoveY = EmaePosY;
            break;
        default: 
            TgMoveX = EmaePosX;
            TgMoveY = EmaePosY;
            break;
    }
    setMoveType = moveType;
    switch (targetScope) {
        case EnAtkRange.敵単体: 
        case EnAtkRange.敵ランダム1:
            TargetArr.push(-targetENo - 1);
            TgEffArr.push(
                new Pos2D(NPlayer[targetENo]._screenX, NPlayer[targetENo]._screenY)
            );
            break;
        case EnAtkRange.敵全体:
            for (let i = 0; i <= NPlayer.length - 1; i++) { 
                if (NPlayer[i]._hp < 1) {
                    continue;
                }
                NPlayer[i]._TgtOpi = 225; 
                TargetArr.push(-i - 1);
            }
            TgEffArr.push(
                new Pos2D(NPlayer[0]._screenX, NPlayer[0]._screenY) 
            );
            break;
        case EnAtkRange.味方単体: 
            for (let i = 0; i <= NEnemy.length - 1; i++) {
                if (NEnemy[i]._hp < 1) {
                    continue;
                }
                if (TurnCard[0]._No != i) {
                    TargetArr.push(i); 
                    TgEffArr.push(
                        new Pos2D(NEnemy[i]._screenX, NEnemy[i]._screenY)
                    );
                    break;
                }
            }
            if (TargetArr.length == 0) {
                TargetArr.push(TurnCard[0]._No); 
            }
            break;
        case EnAtkRange.味方全体: 
            for (let i = 0; i <= NEnemy.length - 1; i++) {
                if (NEnemy[i]._hp < 1) continue; 
                if (ckSkill.damage.critical && TurnCard[0]._No == i) continue;
                if (MetaChecker(ckSkill , "自身は対象外" , false) != false) {
                    if (i == TurnCard[0]._No) continue; 
                }
                TargetArr.push(i);
                TgEffArr.push(new Pos2D(NEnemy[i]._screenX, NEnemy[i]._screenY));
            }
            break;
        case EnAtkRange.味方全体_戦闘不能:
            let calcValue = Number(ckSkill.damage.formula);
            this.EnemyExSkillUse("他復活" , [calcValue / 100 , ckSkill.animationId])
            break;
        case EnAtkRange.使用者: 
            TargetArr.push(TurnCard[0]._No);
            TgEffArr.push(new Pos2D(EmaePosX, EmaePosY));
            break;
        default:
            break;
    }
}
Game_Interpreter.prototype.PlayBtlEffect = function (eNo , ptcName) {
    let setX = 0;
    let setY = 0;
    if (eNo <= -1) {
        setX = NPlayer[(eNo * -1) - 1]._screenX;
        setY = NPlayer[(eNo * -1) - 1]._screenY;
    } else {
        setX = NEnemy[eNo]._screenX;
        setY = NEnemy[eNo]._screenY;
    }
    this.PlayPtcPic(ptcName, setX, setY);
}
Game_Interpreter.prototype.EnemySkillUsePicMove = function () {
    let moveFlame = PLMoveBaseTime;
    if (MetaChecker(CardSkills[UseCard_SkillCounter], "mvtime") != "") { 
        moveFlame = Number(MetaChecker(CardSkills[UseCard_SkillCounter], "mvtime"));
    }
    switch (befTurnType) {
        case EnBefTurn.Mikata:
            this.TargetSelect(-TurnCard[0]._No - 1, CardSkills[UseCard_SkillCounter].id, moveTypeCng);
            this.MovePict(PN_CharacterPL + NPlayer[-TurnCard[0]._No - 1]._PicNo, TgMoveX, TgMoveY, moveFlame, 255,
                -100 * NPlayer[-TurnCard[0]._No - 1].SpineXScale , 100 * Math.abs(NPlayer[-TurnCard[0]._No - 1].SpineXScale));
            break;
        case EnBefTurn.Enemy:
            if (TurnCard[0]._No >= 0) {
                this.EnemyTargetSelect(CardSkills[UseCard_SkillCounter].id); 
                this.MoveSprite(PN_Character + NEnemy[TurnCard[0]._No]._PicNo,
                    TgMoveX, TgMoveY, moveFlame, 255 , true);
            }
            break;
        case EnBefTurn.Skill:
            this.TargetSelect(0, CardSkills[UseCard_SkillCounter].id, moveTypeCng);
            break;
        case EnBefTurn.EmSkill:
            this.EnemyTargetSelect(CardSkills[UseCard_SkillCounter].id); 
            break;
    }
    cardUseMoveTimer = PLMoveBaseTime;
    if (setMoveType == EnBtlMove.m_少し前) {
        cardUseMoveTimer = 5;
    }
}
Game_Interpreter.prototype.EnemySkillEndPicMove = function () {
    TgMoveX = EmaePosX;
    TgMoveY = EmaePosY;
    switch (befTurnType) {
        case EnBefTurn.Mikata:
            this.MovePict(PN_CharacterPL + NPlayer[-TurnCard[0]._No - 1]._PicNo, TgMoveX , TgMoveY, PLMoveBaseTime , 255 ,
                -100 * NPlayer[-TurnCard[0]._No - 1].SpineXScale , 100 * Math.abs(NPlayer[-TurnCard[0]._No - 1].SpineXScale));
            break;
        case EnBefTurn.Enemy:
            if (TurnCard[0]._No >= 0) {
                this.MoveSprite(PN_Character + NEnemy[TurnCard[0]._No]._PicNo, TgMoveX, TgMoveY, PLMoveBaseTime, 255 , true);
            }
            break;
    }
}
Game_Interpreter.prototype.EnemySkillEffectSet = function () {
    cardUseEffTimer = Base_Eefftime; 
    let skillAnimeId = 0;
    let effectFlame = MetaChecker(CardSkills[UseCard_SkillCounter], "efftime");
    if (effectFlame != "") cardUseEffTimer = Number(effectFlame);
    if (_TnSkillNo != -1) EnemySkillAnimeId = EnemyNomalAnimeId = -1;
    if (_SkillOneEffectAnime != null) {
        if (UseCard_SkillCounter == 0) {
            for (let i = 0; i <= TgEffArr.length - 1; i++) {
                let setX = TgEffArr[i]._x - 20 + _SkillOneEffectAnime.SetX;
                let setY = TgEffArr[i]._y - 20 + _SkillOneEffectAnime.SetY;
                if (_SkillOneEffectAnime.AnimeId != -1) {
                    this.PlayAnime(_SkillOneEffectAnime.AnimeId, setX, setY);
                } else {
                    if (!_SkillOneEffectAnime.ComboFlg) {
                        this.PlayPtcPic(_SkillOneEffectAnime.Ptc, setX, setY);
                    } else {
                        this.NPtcComboSet(_SkillOneEffectAnime.Ptc, Ptc_CType.Pic, [setX, setY]);
                    }
                }
            }
        }
    } else {
        switch (CardSkills[UseCard_SkillCounter].animationId) {
            case 0: 
                break;
            case -1: 
                if (EnemySkillAnimeId != -1) {
                    skillAnimeId = EnemySkillAnimeId; 
                } else if (EnemyNomalAnimeId == -1) {
                    skillAnimeId = EnemyAtkAnimeId; 
                } else {
                    skillAnimeId = EnemyNomalAnimeId; 
                }
                break;
            default:
                skillAnimeId = CardSkills[UseCard_SkillCounter].animationId;
        }
        if (skillAnimeId != 0) {
            for (let i = 0; i <= TgEffArr.length - 1; i++) {
                let setX = TgEffArr[i]._x - 20;
                let setY = TgEffArr[i]._y - 20;
                if (skillAnimeId == AN_PtcNo || skillAnimeId == AN_KPtcNo) {
                    let ptcMemoStr = "";
                    let memoStr = "Ptc";
                    if (skillAnimeId == AN_KPtcNo) memoStr = "KPtc";
                    ptcMemoStr = MetaChecker(CardSkills[UseCard_SkillCounter], memoStr, "");
                    let ckArr = ptcMemoStr.split(',');
                    let ptcName = ckArr[0];
                    if (ckArr.length > 1) { 
                        setX += Number(ckArr[1]);
                    }
                    if (ckArr.length > 2) { 
                        setY += Number(ckArr[2]);
                    }
                    if (skillAnimeId == AN_PtcNo) {
                        this.PlayPtcPic(ptcName, setX, setY);
                    } else {
                        this.NPtcComboSet(ptcName, Ptc_CType.Pic, [setX, setY]);
                    }
                } else {
                    this.PlayAnime(skillAnimeId, setX, setY);
                }
            }
            TgEffArr = [];
        }
    }
    if (animeOneShotFlg == false) { 
        if (MetaChecker(CardSkills[UseCard_SkillCounter], "Anime") != "") {
            let spineAnimeStr = MetaChecker(CardSkills[UseCard_SkillCounter], "Anime");
            if (BtlRomashaFlg) {
                this.SetSpineAnime(PN_CharacterPL, spineAnimeStr, false);
            } else {
                if (IsSpineLoading(PlayerBtlChara.Name, spineAnimeStr)) {
                    this.SetSpineAnime(PN_CharacterPL, spineAnimeStr, false);
                } else {
                    this.SetSpineAnime(PN_CharacterPL, "Atk", false);
                }
            }
            animeOneShotFlg = true;
        }
    }
}
//記述方法 this.EnemyExSkillUse("他復活",[0,1]);
Game_Interpreter.prototype.EnemyExSkillUse = function (skillName, valueArr) {
    switch (skillName) {
        case "他復活": //倒れた他の敵を復活させる _VarArr[回復体力割合(0~1) , アニメNo]
            let rENo = -1;
            for (let i = 0; i <= NEnemy.length - 1; i++) { 
                if (NEnemy[i]._hp > 0) rENo = i;
            }
            for (let i = 0; i <= NEnemy.length - 1; i++) {
                $gameSwitches.setValue(BtlEnemy行動Check.SW_EnemyDown + i, false);
                let _回復HP = valueArr[0];
                let _再生アニメNo = valueArr[1];
                if (NEnemy[i]._hp == 0) {
                    NEnemy[i]._hp = Math.floor(NEnemy[i].mhp * _回復HP);
                    if (NEnemy[i]._hp > NEnemy[i].mhp) NEnemy[i]._hp = NEnemy[i].mhp;
                    let setX = NEnemy[i]._screenX - 20;
                    let setY = NEnemy[i]._screenY - 20;
                    if (_再生アニメNo != -1) {
                        this.PlayAnime(_再生アニメNo, setX, setY);
                    }
                    this.AddEnemyTC(rENo, i); 
                }
                this.EnemyDraw(i);
                NEnemy[i].FstHidden = false;
            }
            break;
        case "他登場": 
            var addENo = valueArr[0];
            var setPosENo = -1;
            if (valueArr.length > 1) setPosENo = valueArr[1];
            if (setPosENo == -1) setPosENo = valueArr[0]; 
            $gameSwitches.setValue(BtlEnemy行動Check.SW_EnemyDown + addENo, false);
            NEnemy[addENo]._hp = NEnemy[addENo].mhp;
            if (setPosENo != -1) {
                NEnemy[addENo]._screenX = NEnemy[setPosENo]._screenX;
                NEnemy[addENo]._screenY = NEnemy[setPosENo]._screenY;
            }
            NEnemy[addENo].RebornEmFlg = true;
            this.AddEnemyTC(-1, addENo); 
            this.EnemyDraw(addENo);
            this.MoveSpriteAdd(PN_Character + NEnemy[addENo]._PicNo, -50, true, 0, 0);
            this.MoveSpriteAdd(PN_Character + NEnemy[addENo]._PicNo, 50, true, 15, 255);
            NEnemy[addENo].FstHidden = false;
            break;
        case "チェンジ": 
            let cngENo = valueArr[0];
            let cngCharaX = 0;
            let cngCharaY = 0;
            let targetZureX = 0;
            let targetZureY = 0;
            if (valueArr[1] != undefined) cngCharaX = valueArr[1];
            if (valueArr[2] != undefined) cngCharaY = valueArr[2];
            if (valueArr[3] != undefined) targetZureX = valueArr[3];
            if (valueArr[4] != undefined) targetZureY = valueArr[4];
            if (NEnemy[cngENo]._hp <= 0) {
                this.BLogAdd(120, "発動に失敗した！"); 
                break;
            }
            let targetENo = TurnCard[0]._No; 
            let setX = NEnemy[targetENo]._screenX;
            let setY = NEnemy[targetENo]._screenY;
            NEnemy[targetENo]._screenX = NEnemy[cngENo]._screenX + cngCharaX;
            NEnemy[targetENo]._screenY = NEnemy[cngENo]._screenY + cngCharaY;
            NEnemy[cngENo]._screenX = setX + targetZureX;
            NEnemy[cngENo]._screenY = setY + targetZureY;
            if (NEnemy[cngENo].SpineFlg) {
                this.MovePict(PN_Character + NEnemy[cngENo]._PicNo,
                    NEnemy[cngENo]._screenX, NEnemy[cngENo]._screenY, 15 , true , true , true);
            } else {
                this.MoveSprite(PN_Character + NEnemy[cngENo]._PicNo,
                    NEnemy[cngENo]._screenX, NEnemy[cngENo]._screenY, 15 , true , true , true);
            }
            if (NEnemy[targetENo].SpineFlg) {
                this.MovePict(PN_Character + NEnemy[targetENo]._PicNo,
                    NEnemy[targetENo]._screenX, NEnemy[targetENo]._screenY, 15 , true , true , true);
            } else {
                this.MoveSprite(PN_Character + NEnemy[targetENo]._PicNo,
                    NEnemy[targetENo]._screenX, NEnemy[targetENo]._screenY, 15 , true , true , true);
            }
            EmaePosX = NEnemy[TurnCard[0]._No]._screenX;
            EmaePosY = NEnemy[TurnCard[0]._No]._screenY;
            break;
    }
}
Game_Interpreter.prototype.AddEnemyTC = function (addENo, setENo, set間隔) {
    set間隔 = typeof set間隔 !== 'undefined' ? set間隔 : 1;
    let _間隔Counter = 0;
    for (let i = 0; i <= TurnCard.length - 1; i++) {
        if (TurnCard[i]._No == addENo) {
            let _tcStr = MetaChecker(GetEnemyData_ENo(setENo), "TCPic" , GetEnemyData_ENo(setENo).battlerName);
            let _SetTC = new TCData(EnemyTCType.Chara, _tcStr, (setENo));
            if (_間隔Counter == set間隔) {
                TurnCard.splice(i + 1, 0, _SetTC);
                _間隔Counter = 0;
            }
            _間隔Counter++;
        }
    }
    TCPicNoSetting(); 
    this.TCPicReDraw(); 
}
Game_Interpreter.prototype.PlayPtcAnimeEnemy = function (ptcName, comboPtcFlg, EmNo, zureX, zureY) {
    let setX = NEnemy[EmNo]._screenX + zureX;
    let setY = NEnemy[EmNo]._screenY + zureY;
    if (!comboPtcFlg) {
        this.PlayPtcPic(ptcName, setX, setY);
    } else {
        this.NPtcComboSet(ptcName, Ptc_CType.Pic, [setX, setY]);
    }
}
Game_Interpreter.prototype.PlayPtcAnimeEnemyAll = function (ptcName, comboPtcFlg, zureX, zureY) {
    for (let i = 0; i <= NEnemy.length - 1; i++) {
        if (NEnemy[i]._hp <= 0) continue;
        let setX = NEnemy[i]._screenX + zureX;
        let setY = NEnemy[i]._screenY + zureY;
        if (!comboPtcFlg) {
            this.PlayPtcPic(ptcName, setX, setY);
        } else {
            this.NPtcComboSet(ptcName, Ptc_CType.Pic, [setX, setY]);
        }
    }
}
Game_Interpreter.prototype.PlayAnimeEnemyAll = function (animeId) {
    for (let i = 0; i <= NEnemy.length - 1; i++) {
        if (NEnemy[i]._hp > 0) {
            this.PlayAnimeTopBtlChara(i, animeId, -13, -71);
        }
    }
}
