﻿class TCData {
    constructor(_SetType, _SetPic, _SetNo) {
        this._Type = _SetType;  
        this._PicStr = _SetPic; 
        this._No = _SetNo;      
        this._PicNo = -1;       
        this._SkillNo = -1;     
        this._ViewFlg = false;  
    }
}
let _TCMaxPic = 14; 
const _TCPosX_M = 895; 
const _TCPosY_M = 58;
const _TCPosY_T = 58 - 5;
const _TCX_Sa = 71;
let EnemyTCType = {
    Chara: 1, 
    PlSkill: 2, 
    EmSkill: 3, 
    EmDoSkill: 4    
};
let TCPicNoSetting = function () {
    let usePicNoArr = []; 
    for (let i = 0; i <= TurnCard.length - 1; i++) {
        if (TurnCard[i]._PicNo != -1 && i <= 10) {
            usePicNoArr.push(TurnCard[i]._PicNo);
        } else {
            TurnCard[i]._PicNo = -1;
        }
        if (i >= _TCMaxPic) TurnCard[i]._PicNo = -1;
    }
    for (let i = 0; i <= TurnCard.length - 1; i++) {
        if (TurnCard[i]._PicNo == -1) {
            for (let tj = 0; tj <= _TCMaxPic - 1; tj++) {
                if (usePicNoArr.indexOf(tj) == -1) {
                    TurnCard[i]._PicNo = tj;
                    usePicNoArr.push(TurnCard[i]._PicNo);
                    break; 
                }
            }
        }
        if (i >= _TCMaxPic) break;
    }
}
let TCDataReset_EnemyChange = function (ENo, enemyId) {
    let enemyData = $dataEnemies[enemyId];
    for (let i = 0; i < TurnCard.length; i++) {
        if(TurnCard[i]._No == ENo) {
            TurnCard[i]._PicStr = enemyData.battlerName;
        }
    }
}
Game_Interpreter.prototype.TCPicReDraw = function () {
    N_Sprite_DLayer = 1;
    for (let i = 11; i < TurnCard.length; i++) {
        TurnCard[i]._ViewFlg = false
    }
    for (let i = 0; i < TurnCard.length; i++) {
        if (TurnCard[i]._PicNo >= 0 && TurnCard[i]._ViewFlg) {
            let setSpriteFileName = GetTCPicName_TCNo(i);
            this.CngSprite(PN_RTCard + TurnCard[i]._PicNo , setSpriteFileName);
        }
    }
    let drawPicArr = [];
    for (let i = 0; i < 9; i++) {
        let picDrawFlg = false;
        if (!TurnCard[i]._ViewFlg) {
            picDrawFlg = true;
        }
        switch (TurnCard[i]._Type) {
            case EnemyTCType.Chara:
            case EnemyTCType.EmDoSkill:
                if (TurnCard[i]._No >= 0) {
                    let ckEnemyData = $dataEnemies[NEnemy[TurnCard[i]._No]._enemyId];
                    let _ckPicName = MetaChecker(ckEnemyData, "TCPic" , ckEnemyData.battlerName);
                    if (_ckPicName != TurnCard[i]._PicStr) {
                        TurnCard[i]._PicStr = _ckPicName;
                        picDrawFlg = true;
                    }
                }
                break;
            case EnemyTCType.PlSkill:
                break;
            case EnemyTCType.EmSkill:
                break;
        }
        if (picDrawFlg) {
            TurnCard[i]._ViewFlg = true;
            var setSpriteFile = GetTCPicName_TCNo(i);
            this.SetSpriteC(PN_RTCard + TurnCard[i]._PicNo, setSpriteFile, _TCPosX_M + (_TCX_Sa * i), _TCPosY_M, 0);
        }
        if (i == 0) {
            this.MoveSprite(PN_RTCard + TurnCard[i]._PicNo, _TCPosX_M + (_TCX_Sa * i), _TCPosY_T, 10 , 255);
        } else {
            this.MoveSprite(PN_RTCard + TurnCard[i]._PicNo, _TCPosX_M + (_TCX_Sa * i), _TCPosY_M, 10 , 255);
        }
        drawPicArr.push(TurnCard[i]._PicNo);
    }
    for (let i = 0; i < 11; i++) {
        if (drawPicArr.indexOf(i) == -1) {
            this.DelSprite(PN_RTCard + i);
        }
    }
    N_Sprite_DLayer = 0;
}
let GetTCPicName_TCNo = function (TCNo) { 
    switch (TurnCard[TCNo]._Type) {
        case EnemyTCType.Chara:
            return "enemies/TC/" + TurnCard[TCNo]._PicStr;
        case EnemyTCType.PlSkill:
            if (TurnCard[TCNo]._PicStr == "") return "enemies/TC/" + TurnCard[TCNo]._No;
            return "enemies/TC/" + TurnCard[TCNo]._PicStr;
        case EnemyTCType.EmSkill:
            return "enemies/TC/" + TurnCard[TCNo]._No;
        case EnemyTCType.EmDoSkill:
            return "enemies/TC/" + TurnCard[TCNo]._PicStr;
    }
}
Game_Interpreter.prototype.RemoveTCData_ENo = function (ENo) {
    N_Sprite_DLayer = 1;
    for (let i = 0; i <= TurnCard.length - 1; i++) {
        if (TurnCard[i]._Type == EnemyTCType.Chara && TurnCard[i]._No == ENo) {
            this.DelSprite(PN_RTCard + TurnCard[i]._PicNo);
            TurnCard.splice(i, 1); 
            i--;
        }
    }
    TCDataSetting(); 
    this.TCPicReDraw();
    N_Sprite_DLayer = 0;
}
let TCDataSetting = function () {
    if (TurnCard.length == 0) {
        for (let i = 0; i <= NEnemy.length - 1; i++) {
            if (NEnemy[i]._hidden) continue;
            let enemyData = $dataEnemies[NEnemy[i]._enemyId];
            for (let j = 0; j <= enemyData.traits.length - 1; j++) {
                if (enemyData.traits[j].code == 43) {
                    let TcPicName = MetaChecker(GetEnemyData_ENo(i), "TCPic" , GetEnemyData_ENo(i).battlerName);
                    let setTC = new TCData(EnemyTCType.EmDoSkill, TcPicName, i);
                    setTC._SkillNo = enemyData.traits[j].dataId;
                    TurnCard.push(setTC);
                }
            }
        }
        if ($gameActors._data[1].equips()[3] != null) {
            if ($gameActors._data[1].equips()[3].params[7] != 0) {
                let setTC = new TCData(EnemyTCType.PlSkill, "", $gameActors._data[1].equips()[3].params[7]);
                TurnCard.push(setTC);
            }
        }
    }
    while (TurnCard.length < 100) { 
        for (let i = 0; i <= NPlayer.length - 1; i++) {
            if (NPlayer[i]._hp <= 0) continue;
            NPlayer[i]._TurnGage -= NPlayer[i].agi;
            if (NPlayer[i]._TurnGage <= 0) {
                let turnCardStr = "";
                if (i == 0) {
                    turnCardStr = BtlData.PlTurnCardPic;
                } else {
                    turnCardStr = MetaChecker(GetEnemyData_ENo(-i - 1), "TCPic" , GetEnemyData_ENo(-i - 1).battlerName);
                }
                let setTC = new TCData(EnemyTCType.Chara, turnCardStr, (-i - 1));
                TurnCard.push(setTC);
                NPlayer[i]._TurnGage += 100; 
            }
        }
        for (let i = 0; i <= NEnemy.length - 1; i++) { 
            if (NEnemy[i]._hp <= 0) continue;
            NEnemy[i]._TurnGage -= NEnemy[i].agi;
            if (NEnemy[i]._TurnGage <= 0) {
                let _tcStr = MetaChecker(GetEnemyData_ENo(i), "TCPic" , GetEnemyData_ENo(i).battlerName);
                let setTC = new TCData(EnemyTCType.Chara, _tcStr, i)
                TurnCard.push(setTC);
                NEnemy[i]._TurnGage += 100; 
            }
        }
    }
    TCPicNoSetting(); 
}
Game_Interpreter.prototype.NextTCSetting = function (firstFlg) {
    firstFlg = typeof firstFlg !== 'undefined' ? firstFlg : false;
    if (!firstFlg) {
        this.NextTCPicMove(); 
        TurnCard.shift(); 
    }
    TCDataSetting(); 
    this.SetSprite(PN_RTHikari, BtlPicPath + "PN_RTHikari", 856, 4);
    if (firstFlg) {
        this.TCPicReDraw(); 
    }
}
Game_Interpreter.prototype.NextTCPicMove = function () {
    N_Sprite_DLayer = 1;
    this.MoveSprite(PN_RTCard + TurnCard[0]._PicNo, _TCPosX_M - _TCX_Sa, _TCPosY_T, 10, 0);
    for (let i = 0; i <= 10 - 1; i++) {
        let ckSpriteData = GetSpriteData(PN_RTCard + TurnCard[i]._PicNo);
        let picDrawFlg = false;
        if (!TurnCard[i]._ViewFlg) {
            picDrawFlg = true;
        }
        if (ckSpriteData == null) {
            picDrawFlg = true;
        } else {
            if (ckSpriteData._name != TurnCard[i]._PicStr) {
                picDrawFlg = true;
            }
        }
        if (picDrawFlg) {
            TurnCard[i]._ViewFlg = true;
            this.SetSpriteC(PN_RTCard + TurnCard[i]._PicNo, GetTCPicName_TCNo(i), _TCPosX_M + (_TCX_Sa * i), _TCPosY_M, 0);
        }
        if (i == 0) {
            this.MoveSprite(PN_RTCard + TurnCard[i + 1]._PicNo, _TCPosX_M + (_TCX_Sa * i), _TCPosY_T, 10);
        } else {
            this.MoveSprite(PN_RTCard + TurnCard[i + 1]._PicNo, _TCPosX_M + (_TCX_Sa * i), _TCPosY_M, 10);
        }
    }
    N_Sprite_DLayer = 0;
}
Game_Interpreter.prototype.TCPicOverUpdate = function () {
    N_Sprite_DLayer = 1;
    let ckPicArr = []; 
    for (let i = 0; i <= 8 - 1; i++) {
        if (TurnCard[i]._Type == EnemyTCType.Chara) {
            ckPicArr.push(PN_RTCard + TurnCard[i]._PicNo); 
        }
    }
    let overNo = overPointerSpCkArr(ckPicArr);
    if (overNo != -1) { 
        for (let i = 0; i <= TurnCard.length - 1; i++) {
            if ((overNo - PN_RTCard) == TurnCard[i]._PicNo) {
                if (i <= 0) {
                    this.SetSpriteC(PN_SelTurnC, BtlPicPath + "PN_SelTurnC", _TCPosX_M + (_TCX_Sa * i) - 3, _TCPosY_T);
                } else {
                    this.SetSpriteC(PN_SelTurnC, BtlPicPath + "PN_SelTurnC", _TCPosX_M + (_TCX_Sa * i), _TCPosY_M);
                }
                for (let j = 0; j <= NPlayer.length - 1; j++) { 
                    NPlayer[j]._TgtOpi = 0;
                }
                for (let j = 0; j <= NEnemy.length - 1; j++) { //ターゲット判定処理(エネミー)
                    NEnemy[j]._TgtOpi = 0;
                }
                if (TurnCard[i]._No <= -1) {
                    NPlayer[(-TurnCard[i]._No - 1)]._TgtOpi = 255;
                } else {
                    NEnemy[TurnCard[i]._No]._TgtOpi = 255;
                }
                N_Sprite_DLayer = 0;
                return TurnCard[i]._No;
            }
        }
    } else {
        N_Sprite_DLayer = 0;
        return null; 
    }
}
//_ENo:キャラNo _Move:移動数値 _Cnt:移動させる枚数(-1の場合全て)
Game_Interpreter.prototype.TCShift_ENo = function (ENo, moveValue, TCMaisu) {
    moveValue = typeof moveValue !== 'undefined' ? moveValue : 1; 
    TCMaisu = typeof TCMaisu !== 'undefined' ? TCMaisu : -1;
    if (TCMaisu == -1) TCMaisu = 999;
    let TCCopyArr = TurnCard.slice();
    let rtnArr = []; 
    if (moveValue > 0) { 
        let _CkCnt = 0;
        for (let i = 0; i <= TCCopyArr.length - 1; i++) { 
            if (TCCopyArr[i]._No == ENo && i != 0) _CkCnt++;
        }
        for (let i = TCCopyArr.length - 1; i >= 0; i--) {
            if (TCCopyArr[i]._No == ENo && i != 0 && TCMaisu >= _CkCnt) {
                if (rtnArr.length < moveValue) {
                    rtnArr.splice(rtnArr.length, 0, TCCopyArr[i]);
                } else {
                    rtnArr.splice(moveValue, 0, TCCopyArr[i]); 
                }
            } else {
                rtnArr.unshift(TCCopyArr[i]);
            }
            if (TCCopyArr[i]._No == ENo) _CkCnt--;
        }
        TurnCard = [];
        TurnCard = rtnArr;
    }
    if (moveValue < 0) { 
        let ckCount = 0;
        for (let i = 0; i <= TCCopyArr.length - 1; i++) {
            if (TCCopyArr[i]._No == ENo && i != 0 && TCMaisu >= ckCount) {
                if (rtnArr.length + moveValue <= 0) {
                    rtnArr.splice(1, 0, TCCopyArr[i]); 
                } else {
                    rtnArr.splice(rtnArr.length + moveValue, 0, TCCopyArr[i]); 
                }
            } else {
                rtnArr.push(TCCopyArr[i]);
            }
            if (TCCopyArr[i]._No == ENo) ckCount++;
        }
        TurnCard = [];
        TurnCard = rtnArr;
    }
    TCPicNoSetting(); 
    this.TCPicReDraw(); 
}
Game_Interpreter.prototype.SetTCPlayerSkill = function (cardId, setTurn) {
    let setTCData = new TCData(EnemyTCType.PlSkill, "", cardId);
    setTCData._PicNo = TurnCard[11]._PicNo;
    setTCData._PicStr = cardId;
    TurnCard[11]._ViewFlg = false;
    TurnCard[11]._PicNo = -1;
    TurnCard.splice(setTurn, 0, setTCData);
    TCPicNoSetting(); 
    this.TCPicReDraw(); 
}
Game_Interpreter.prototype.SetTCEnemySkill = function (cardId, setTurn) {
    let setTCData = new TCData(EnemyTCType.EmSkill, "", cardId);
    setTCData._PicNo = TurnCard[11]._PicNo;
    setTCData._PicStr = cardId;
    TurnCard[11]._ViewFlg = false;
    TurnCard[11]._PicNo = -1;
    TurnCard.splice(setTurn, 0, setTCData);
    TCPicNoSetting(); 
    this.TCPicReDraw(); 
}
