﻿//=============================================================================
// 遠景のスクロールスピードプラグインです
// parallaxSpeedLimit.js
// Copyright (c) 2018 村人Ａ
//=============================================================================

/*:ja
 * @plugindesc 遠景のスクロールスピードの限界を突破するプラグインです
 * @author 村人A
 *
 * @help
 *
 * マップのメモに以下のように入力:
 *   paraSpeedX60 #遠景のｘ方向へのスクロールスピードを60に設定
 *   paraSpeedY-90 #遠景のｘ方向へのスクロールスピードを-90に設定 
 *   XとY両方に設定するなら改行が必要
 *   マップのデフォルトにもスクロールスピードを設定している時はプラグインが優先
 *   数値、正負の記号は半角で入力
 */

(function() {
    var _Game_Map_setupParallax = Game_Map.prototype.setupParallax;
	Game_Map.prototype.setupParallax = function() {
		_Game_Map_setupParallax.call(this);
		var arr = $dataMap.note.split(/\r\n|\r|\n/);
		for(var i = 0; i < arr.length; i++){
			if(arr[i].match(/paraSpeedX/)){
				var paraspeedx = arr[i].replace( /paraSpeedX/g , "" )
				this._parallaxSx = paraspeedx;
			}
			
			if(arr[i].match(/paraSpeedY/)){
				var paraspeedy = arr[i].replace( /paraSpeedY/g , "" )
				this._parallaxSy = paraspeedy;
			}
		}
	};
})();