
(function() 
{
	window.xoForm = [	{type:"", help:"", x:0, y:0},
				{type:"", help:"", x:0, y:0, w:0, h:0},
				{type:"", help:"", x:0, y:0, w:0, h:0},
				{type:"", help:"", x:0, y:0, w:0, h:0},
				{type:"", help:"", x:0, y:0, w:0, h:0}];

	window.xoFileList = 0,

	window.OkBtnPos     = [10,620];
	window.CancelBtnPos = [80,620];
	window.RandomBtnPos = 0;

	window.RandomList = ["ランダムリスト"];


	

	//===========================================================================================
	//■■■ 入力フォーム情報の初期化 ■■■
	//===========================================================================================
	ResetxoForm = function( )
	{
		//入力フォーム情報を初期化
		for(var i=0; i<5; i++)
		{
		  xoForm[i].type		= 0;
		  xoForm[i].help		= "";
		  xoForm[i].x			= 0;
		  xoForm[i].y			= 0;
		  xoForm[i].w			= 0;
		  xoForm[i].h			= 0;

		  xoForm[i].maxlength	= 0;	//最大文字数

		}
	}

	//===========================================================================================
	//■■■ 特定フォルダのリストの取得 ■■■
	//===========================================================================================
	GetFileList = function(path, type = "'.ogg'") {
		// フォルダパスを指定
		const folderPath = path;

		xoFileList = [];

		// NW.jsのモジュールを使用してファイルシステムにアクセス
		if (Utils.isNwjs()) {
			const fs = require('fs');
			const path = require('path');

			// 指定されたフォルダ内のoggファイルを取得して配列にする
			function getOggFilesFromFolder(folderPath) {
				const absolutePath = path.join(process.cwd(), folderPath); // 絶対パスを作成
				try 
				{
					// フォルダ内のファイルを取得
					const files = fs.readdirSync(absolutePath);
					// 拡張子が.oggのファイルをフィルタリングし、拡張子を除去
					xoFileList = files
						.filter(file => path.extname(file).toLowerCase() === type) // .oggファイルのみフィルタリング
						.map(file => path.basename(file, type)); // 拡張子を除去してファイル名のみ取得
				}
				catch (error)
				{
					console.error("フォルダの読み込みに失敗しました: ", error);
				}
			}

			// OGGファイルの配列を取得してゲーム変数に保存
			getOggFilesFromFolder(folderPath);
			$gameVariables.setValue(1, xoFileList); // 例としてゲーム変数1に保存

		} else {
			console.error("この機能はNW.js環境でのみ動作します。");
		}
	};





	function stopPropagation(event) 
	{
		event.stopPropagation();
	}

	// css追加
	(function()
	{
		var css = document.createElement('link');
		css.rel = "stylesheet";
		css.type = 'text/css';
		css.href = './css/111_InputForm.css';
		var b_top = document.getElementsByTagName('head')[0];
		b_top.appendChild(css);
	})();
	// キー入力不可にする為に
	Input.form_mode = false;
	var _Input_onKeyDown = Input._onKeyDown;
	Input._onKeyDown = function(event) {
		if(Input.form_mode)return;
		_Input_onKeyDown.call(this , event)
	};
	var _Input_onKeyUp = Input._onKeyUp;
	Input._onKeyUp = function(event) {
		if(Input.form_mode)return;
		_Input_onKeyUp.call(this , event)
	};
	// 入力終わるまで次のイベントコマンド読み込まない
	var _Game_Interpreter_updateWaitMode =
			Game_Interpreter.prototype.updateWaitMode;
	Game_Interpreter.prototype.updateWaitMode = function(){
		if(this._waitMode == 'input_form')return true;
		return _Game_Interpreter_updateWaitMode.call(this);
	}

	HTMLElement.prototype.postionAdjust = function(screen_postion , target_postion, unitFontSize){
		this.style.left = screen_postion[0] + target_postion[0] * Graphics._realScale + "px";
		this.style.top  = screen_postion[1] + target_postion[1] * Graphics._realScale + "px";
		this.style.fontSize = (unitFontSize * Graphics._realScale) + "px";
		this.style.maxWidth = 'calc(100% - ' + this.style.left + ')';
		this.style.maxHeight = 'calc(100% - ' + this.style.top + ')';
	};
	// 引数のx=350;y=200;みたいなのを可能にする
	var argHash = function(text , arg_names){
		var _args = new Array(arg_names.length);
		var ary = text.split(";");
		ary.forEach(function(str){
			var s_ary = str.split("=");
			var prop = s_ary[0].toLowerCase();
			var value = s_ary[1];
			_args[arg_names.indexOf(prop)] = value;
		});
		return _args;
	}
	//=============================================================================
	// Game_Interpreter - register plugin commands
	//=============================================================================
	var _Game_Interpreter_pluginCommand =
			Game_Interpreter.prototype.pluginCommand;

	Game_Interpreter.prototype.pluginCommand = function(command, args) {
		_Game_Interpreter_pluginCommand.call(this, command, args);


		if (command === 'InputForm')
		{ this._inputForm(); }

	};

	if (PluginManager.registerCommand) 
	{
		PluginManager.registerCommand("111_InputForm", "show", function(args) 
		{
			var { target_x, target_y, variables_id, max_count, if_switch_id, button_x, button_y, unit_font_size, placeholder } = args;
			this._inputForm2(+target_x, +target_y, +variables_id, +max_count, +if_switch_id, +button_x, +button_y, +unit_font_size, placeholder);
		});
	}

	//===========================================================================================
	//■■■　入力フォームの作成(文章表示)　■■■
	//===========================================================================================
	Game_Interpreter.prototype._inputForm = function() 
	{
		var interpreter = this;

		var gui = {
			inputWnd : [null, null, null, null, null],
			btnOK : null,
			btnRD : null,
			btnNG : null,
			is_pc : true ,
			init : function(){

			console.log(this.inputWnd[0]);

				this.is_pc = Utils.isNwjs();
				this.create();
				this.inputWnd[0].focus();
				this.screenAdjust();
			} ,
			//▼「入力フォーム作成時」-----------------------------------
			create : function()
			{

				//▼入力フォーム
				for(var i=0; i<5; i++)
				{
					switch(xoForm[i].type)
					{

					//▼文章入力用
					case "文章入力":
						this.inputWnd[i] = document.createElement('input');
						//使用するCSS
						this.inputWnd[i].setAttribute('id', "_xo_inputform_number_w150");
						//サイズの指定
						if(xoForm[i].w != 0)
						{ this.inputWnd[i].style.width  = xoForm[i].w+'px'; }
						if(xoForm[i].h != 0)
						{ this.inputWnd[i].style.height = xoForm[i].h+'px'; }
						//ヘルプ文字
						this.inputWnd[i].setAttribute('placeholder', xoForm[i].help);

						//初期値を設定
						if( $gameVariables.value(481+i) != -1 )
						{ this.inputWnd[i].value = $gameVariables.value(481+i); }
						else
						{ this.inputWnd[i].value = ''; }

						// 最大文字数を指定
						if(xoForm[i].maxlength != 0)
						{ this.inputWnd[i].setAttribute('maxlength', ''+xoForm[i].maxlength); }

						// ドキュメントに追加
						document.body.appendChild(this.inputWnd[i]);
						break;

					//▼数値入力用
					case "数値入力":
						this.inputWnd[i] = document.createElement('input');
						this.inputWnd[i].setAttribute('type', 'number'); // 数字のみ入力可能にする
						//使用するCSS
						this.inputWnd[i].setAttribute('id', "_xo_inputform_number_w150");
						//サイズの指定
						if(xoForm[i].w != 0)
						{ this.inputWnd[i].style.width  = xoForm[i].w+'px'; }
						if(xoForm[i].h != 0)
						{ this.inputWnd[i].style.height = xoForm[i].h+'px'; }
						//ヘルプ文字
						this.inputWnd[i].setAttribute('placeholder', xoForm[i].help);
						//初期値を設定
						if( $gameVariables.value(481+i) != -1 )
						{ this.inputWnd[i].value = $gameVariables.value(481+i); }
						else
						{ this.inputWnd[i].value = ''; }
						// 最大文字数を指定
						if(xoForm[i].maxlength != 0)
						{ this.inputWnd[i].setAttribute('maxlength', ''+xoForm[i].maxlength); }

						// ドキュメントに追加
						document.body.appendChild(this.inputWnd[i]);
						break;


					//▼文章表示用
					case "文章入力L":
						this.inputWnd[i] = document.createElement("textarea");
						//行数を制限するイベントリスナーを追加
						this.inputWnd[i].addEventListener('input', function() 
						{
							var maxLines = 4;  // 最大行数
							var text = this.value;
							var lines = text.split('\n');  // 改行で分割して行数をカウント

							//「指定行数を超えた」場合、
							if (lines.length > maxLines) 
							{
								// 超過分を削除
								this.value = lines.slice(0, maxLines).join('\n');
							}
						});
						//使用するCSS
						this.inputWnd[i].setAttribute('id', "_xo_inputform_text");
						//ヘルプ文字
						this.inputWnd[i].setAttribute('placeholder', xoForm[i].help);
						//初期値を設定
						if( $gameVariables.value(481+i) != -1 )	{ this.inputWnd[i].value = $gameVariables.value(481+i); }
						else							{ this.inputWnd[i].value = ''; }
						// ドキュメントに追加
						document.body.appendChild(this.inputWnd[i]);
						break;

					//▼1行テキスト用
					case "文章入力S":
						this.inputWnd[i] = document.createElement('input');
						//使用するCSS
						this.inputWnd[i].setAttribute('id', "_xo_inputform_number_w150");
						//ヘルプ文字
						this.inputWnd[i].setAttribute('placeholder', xoForm[i].help);
						//初期値を設定
						if( $gameVariables.value(481+i) != -1 )
						{ this.inputWnd[i].value = $gameVariables.value(481+i); }
						else
						{ this.inputWnd[i].value = ''; }
						// ドキュメントに追加
						document.body.appendChild(this.inputWnd[i]);
						break;

					//▼1行テキスト用(横長)
					case "文章入力M":
						this.inputWnd[i] = document.createElement('input');
						//使用するCSS
						this.inputWnd[i].setAttribute('id', "_xo_inputform_number_w300");
						//ヘルプ文字
						this.inputWnd[i].setAttribute('placeholder', xoForm[i].help);
						//初期値を設定
						if( $gameVariables.value(481+i) != -1 )	{ this.inputWnd[i].value = $gameVariables.value(481+i); }
						else							{ this.inputWnd[i].value = ''; }
						// ドキュメントに追加
						document.body.appendChild(this.inputWnd[i]);
						break;

					//▼履歴書用
					case "履歴書文字列":
						this.inputWnd[i] = document.createElement('input');
						//使用するCSS
						this.inputWnd[i].setAttribute('id', "_xo_inputform_number_w150");
						//ヘルプ文字
						this.inputWnd[i].setAttribute('placeholder', xoForm[i].help);
						//最大文字数を設定
						this.inputWnd[i].setAttribute('maxlength', '8');

						//初期値を設定
						if( $gameVariables.value(481+i) != -1 )
						{ this.inputWnd[i].value = $gameVariables.value(481+i); }
						else
						{ this.inputWnd[i].value = ''; }
						// ドキュメントに追加
						document.body.appendChild(this.inputWnd[i]);
						break;

					//▼
					case "履歴書数値":
						this.inputWnd[i] = document.createElement('input');
						this.inputWnd[i].setAttribute('type', 'number'); // 数字のみ入力可能にする
						//使用するCSS
						this.inputWnd[i].setAttribute('id', "_xo_inputform_number_w150");
						//ヘルプ文字
						this.inputWnd[i].setAttribute('placeholder', xoForm[i].help);
						//初期値を設定
						if( $gameVariables.value(481+i) != -1 )	{ this.inputWnd[i].value = $gameVariables.value(481+i); }
						else							{ this.inputWnd[i].value = ''; }
						// ドキュメントに追加
						document.body.appendChild(this.inputWnd[i]);
						break;


					//▼プロフィール用
					case "プロフィール":
						this.inputWnd[i] = document.createElement('textarea');
						//使用するCSS
						this.inputWnd[i].setAttribute('id', "_xo_inputform_Profile");
						//サイズの指定
						if(xoForm[i].w != 0)
						{ this.inputWnd[i].style.width  = xoForm[i].w+'px'; }
						if(xoForm[i].h != 0)
						{ this.inputWnd[i].style.height = xoForm[i].h+'px'; }
						//ヘルプ文字
						this.inputWnd[i].setAttribute('placeholder', xoForm[i].help);
						//初期値を設定
						if( $gameVariables.value(481+i) != -1 )
						{ this.inputWnd[i].value = $gameVariables.value(481+i); }
						else
						{ this.inputWnd[i].value = ''; }
						//リサイズの禁止
						this.inputWnd[i].style.resize = 'none';
						// 行数制限イベント
						const maxLines = 4;
						this.inputWnd[i].addEventListener('input', function () {
							const lines = this.value.split('\n');
							if (lines.length > maxLines) {
								// 余分な行を削除
								this.value = lines.slice(0, maxLines).join('\n');
							}
						});
						// 折り返しを無効にするスタイルを設定
						this.inputWnd[i].style.whiteSpace = 'nowrap';
						// スクロールバーを非表示にする
						this.inputWnd[i].style.overflow = 'hidden';
												
						// ドキュメントに追加
						document.body.appendChild(this.inputWnd[i]);
						break;


					//▼数値入力用
					case "数値入力S":
						this.inputWnd[i] = document.createElement('input');

						this.inputWnd[i].setAttribute('type', 'number'); // 数字のみ入力可能にする
						//使用するCSS
						this.inputWnd[i].setAttribute('id', "_xo_inputform_number_w80");
						//ヘルプ文字
						this.inputWnd[i].setAttribute('placeholder', xoForm[i].help);
						//初期値を設定
						if( $gameVariables.value(481+i) != -1 )	{ this.inputWnd[i].value = $gameVariables.value(481+i); }
						else							{ this.inputWnd[i].value = ''; }
						// ドキュメントに追加
						document.body.appendChild(this.inputWnd[i]);
						break;

					case "数値入力L":
						this.inputWnd[i] = document.createElement('input');
						this.inputWnd[i].setAttribute('type', 'number'); // 数字のみ入力可能にする
						//使用するCSS
						this.inputWnd[i].setAttribute('id', "_xo_inputform_number_w150");
						//ヘルプ文字
						this.inputWnd[i].setAttribute('placeholder', xoForm[i].help);
						//初期値を設定
						if( $gameVariables.value(481+i) != -1 )	{ this.inputWnd[i].value = $gameVariables.value(481+i); }
						else							{ this.inputWnd[i].value = ''; }
						// ドキュメントに追加
						document.body.appendChild(this.inputWnd[i]);
						break;


					//▼ドロップダウン
					case "リスト":
					case "BGMリスト":
					case "BGSリスト":
					case "SEリスト":
					case "CGリスト":

						//※あらかじめxoFileListを作っておくこと

						this.inputWnd[i] = document.createElement('select');

						//使用するCSS
						this.inputWnd[i].setAttribute('id', "_xo_dropdown");

						//サイズの指定
						if(xoForm[i].w != 0)
						{ this.inputWnd[i].style.width  = xoForm[i].w+'px'; }
						if(xoForm[i].h != 0)
						{ this.inputWnd[i].style.height = xoForm[i].h+'px'; }

						//ヘルプ文字
						this.inputWnd[i].setAttribute('placeholder', xoForm[i].help);

						//リストの内容を追加
						xoFileList.forEach(function(fileName) 
						{
							var option = document.createElement("option");
							option.value = fileName;
							option.text = fileName;
							this.inputWnd[i].appendChild(option);
						}, this);

						// 初期値を設定
						if( $gameVariables.value(481+i) != -1 )	
						{ this.inputWnd[i].value = $gameVariables.value(481+i); }
						else
						{ this.inputWnd[i].value = xoFileList[0]; }

						xoFileList = [];

						// ドキュメントに追加
						document.body.appendChild(this.inputWnd[i]);
						break;
					}
				}

				//ボタン位置を定位置にしておく

				//▼決定ボタン
				if (OkBtnPos != 0) 
				{
					this.btnOK = document.createElement('input');
					this.btnOK.setAttribute('type', 'submit');
					this.btnOK.setAttribute('id', '_111_submit');
					this.btnOK.setAttribute('value', '　決　定　');
					document.body.appendChild(this.btnOK);
				}

				//▼ランダムボタン
				if ( RandomBtnPos != 0) 
				{
					this.btnRD = document.createElement('input');
					this.btnRD.setAttribute('type', 'submit');
					this.btnRD.setAttribute('id', '_111_submit');
					this.btnRD.setAttribute('value', ' ランダム ');
					document.body.appendChild(this.btnRD);
				}

				//▼キャンセルボタン
				if (CancelBtnPos != 0) 
				{
					this.btnNG = document.createElement('input');
					this.btnNG.setAttribute('type', 'submit');
					this.btnNG.setAttribute('id', '_111_submit');
					this.btnNG.setAttribute('value', 'キャンセル');
					document.body.appendChild(this.btnNG);
				}


			},

			//▼「決定時」-----------------------------------------------
			success : function() {
				$gameSwitches.setValue(7, false); //入力中フラグをfalseに
				$gameSwitches.setValue(9, true);  //入力OKフラグをtrueに
				
				for(var i=0; i<5; i++)
				{
					if( xoForm[i].type != 0 ) 
					{ $gameVariables.setValue(481+i, ""+this.inputWnd[i].value); }
					else
					{ $gameVariables.setValue(481+i, 0); }
				}
				this.end();
			},

			//▼「キャンセル時」-----------------------------------------
			cancel : function() {
				$gameSwitches.setValue(7, false); //入力中フラグをfalseに
				$gameSwitches.setValue(9, false);  //入力OKフラグをfalseに
				for(var i=0; i<5; i++)
				{ $gameVariables.setValue(481+i, 0); }
				 $gameVariables.setValue(482, "キャンセル");

				this.end();
			},



			//▼---------------------------------------------------------
			start : function() {
				interpreter.setWaitMode('input_form');
				Input.clear();
				Input.form_mode = true;
			},
			//▼「終了時」-----------------------------------------------
			end : function() {

				for(var i=0; i<5; i++)
				{
					if (xoForm[i].type != 0) 
					{ this.inputWnd[i].remove(); }
				}
				
				//各種ボタンの消去
				if (this.btnOK != null)	{ this.btnOK.remove(); }
				if (this.btnNG != null)	{ this.btnNG.remove(); }
				if (this.btnRD != null)	{ this.btnRD.remove(); }

				interpreter.setWaitMode('');
				Input.form_mode = false;
			},
			//▼「」-----------------------------------------------------
			screenAdjust : function() {
				var screen_x, screen_y;
				var _canvas = document.getElementById('UpperCanvas') || document.getElementById('gameCanvas');
				var rect = _canvas.getBoundingClientRect();
				screen_x = rect.left;
				screen_y = rect.top;

				// 各種位置調整
				for(var i=0; i<5; i++)
				{
					if (xoForm[i].type != 0) 
					{ this.inputWnd[i].postionAdjust([screen_x,screen_y], [xoForm[i].x, xoForm[i].y], 16); }
				}

				//ボタンの位置設定
				if(this.btnOK != null)	{ this.btnOK.postionAdjust([screen_x,screen_y], OkBtnPos,     16); }
				if(this.btnNG != null)	{ this.btnNG.postionAdjust([screen_x,screen_y], CancelBtnPos, 16); }
				if(this.btnRD != null)	{ this.btnRD.postionAdjust([screen_x,screen_y], RandomBtnPos, 16); }

				//ボタン位置を定位置にしておく
				OkBtnPos     = [10,620];
				CancelBtnPos = [150,620];

				RandomBtnPos = [0,0];

			}
		}



		gui.init();

		//入力枠の分だけ繰り返し
		for(var i=0; i<gui.inputWnd.length; i++)
		{
			if (gui.inputWnd[i] == null) 
			{ continue; }


			gui.inputWnd[i].addEventListener("keydown", function(e) 
			{
				//「決定ボタンが表示されている」
				if( gui.btnOK != null )
				{
					// 「Ctrl+Enter」で決定
					if (e.keyCode  === 13 && e.ctrlKey) 
					{
						Input.clear();
						gui.success();
						e.stopPropagation();
					}
				}

				//「キャンセルボタンが表示されている」
				if( gui.btnNG != null )
				{
					// Escでキャンセル
					if (e.keyCode === 27) 
					{
						Input.clear();
						gui.cancel();
						e.stopPropagation();
					}
				}
			});
		}
		//決定ボタン
		gui.btnOK.addEventListener("click", function() {
			gui.success();
			return false;
		});

		//キャンセルボタン
		//「キャンセルボタンが表示されている」
		if( gui.btnNG != null )
		{
			gui.btnNG.addEventListener("click", function() {
				gui.cancel();
				return false;
			});
		}

		//ランダムボタン
		if( gui.btnRD != null )
		{
			gui.btnRD.addEventListener("click", function() 
			{
				let id = Math.floor(Math.random() * RandomList.length);
				gui.inputWnd[0].value = RandomList[id];
				return false;
			});
		}

		gui.start();

	};
	


})();
