/*:
 * @plugindesc セーブデータをロードした後に指定したスイッチをONにします。
 * @author ChatGPT
 *
 * @param Switch ID
 * @text スイッチID
 * @desc ロード後にONにするスイッチのIDです。
 * @default 1
 *
 * @help このプラグインは、セーブデータのロードが完了した後に指定されたスイッチをONにします。
 * ロードをキャンセルした場合は、スイッチは操作されません。
 *
 * 【使用方法】
 * プラグインマネージャーでこのプラグインを有効にし、
 * 「スイッチID」パラメータにONにしたいスイッチのIDを設定してください。
 */

(function() {
    var parameters = PluginManager.parameters('ActivateSwitchAfterLoad');
    var switchId = Number(parameters['Switch ID'] || 1);

    var _DataManager_loadGame = DataManager.loadGame;
    DataManager.loadGame = function(savefileId) {
        var result = _DataManager_loadGame.call(this, savefileId);
        if (result) 
	{

            $gameSwitches.setValue(switchId, true);
        }
        return result;
    };

})();
