/*:
 * @plugindesc タイトルコマンドを非表示にしつつ、現在の選択位置と「コンティニュー可否」を変数に記録します。
 * @author xo_ekus
 *
 * @param Variable ID
 * @text カーソル位置の変数ID
 * @desc 現在のカーソル位置を記録するゲーム内変数の番号。
 * @default 1
 * @type variable
 *
 * @param ContinueFlag ID
 * @text コンティニュー可否の変数ID
 * @desc コンティニューの有効状態を記録する変数ID。セーブあり=0 / セーブなし=1
 * @default 2
 * @type variable
 *
 * @help
 * ------------------------------------------------------------
 * ■ 機能
 * タイトル画面のコマンドをすべて非表示にしますが、
 * 内部的には通常通り選択・決定が可能です。
 *
 * また以下の情報を変数に記録します。
 *
 * 1. 現在のカーソル位置（Variable ID）
 *     ニューゲーム   → 1
 *     コンティニュー → 2
 *     オプション     → 3
 *
 * 2. コンティニューの有効状態（ContinueFlag ID）
 *     セーブあり → 0
 *     セーブなし → 1
 *
 * ------------------------------------------------------------
 * ■ 注意
 * ・マウス操作はできません。
 * ・カスタムタイトルプラグインとの併用は非推奨。
 * ------------------------------------------------------------
 */

(function() {

    const parameters = PluginManager.parameters('HideTitleCommandEx');
    const variableId = Number(parameters['Variable ID'] || 1);
    const continueFlagId = Number(parameters['ContinueFlag ID'] || 2);

    // Scene_Title 作成時：ウィンドウを透明化
    const _Scene_Title_create = Scene_Title.prototype.create;
    Scene_Title.prototype.create = function() {
        _Scene_Title_create.call(this);
        const w = this._commandWindow;
        if (w) {
            w.opacity = 0;
            w.contentsOpacity = 0;
            w.visible = false;
        }

        // コンティニュー有効/無効を変数に記録
        if ($gameVariables && continueFlagId > 0) {
            const enabled = DataManager.isAnySavefileExists(); // セーブデータがあるか
            $gameVariables.setValue(continueFlagId, enabled ? 0 : 1);
        }
    };

    // Scene_Title 更新：毎フレーム変数に現在インデックスを反映
    const _Scene_Title_update = Scene_Title.prototype.update;
    Scene_Title.prototype.update = function() {
        _Scene_Title_update.call(this);
        const w = this._commandWindow;
        if (w) {
            // 非表示を強制維持
            w.opacity = 0;
            w.contentsOpacity = 0;
            w.visible = false;

            // 現在の選択インデックスを変数に記録
            const index = w.index() + 1;
            if ($gameVariables && variableId > 0) {
                $gameVariables.setValue(variableId, index);
            }
        }
    };

})();

