//=============================================================================
// PictureExtend.js
//
// ----------------------------------------------------------------------------
// by ecf5DTTzl6h6lJj02
// 2023/10/18
// ----------------------------------------------------------------------------
// Copyright (C) 202X ecf5DTTzl6h6lJj02
//	This software is released under the MIT lisence.
//	http://opensource.org/licenses/mit-license.php
//=============================================================================
// ●更新履歴
//
//  2023/10/19 ver 1.0.1
//      ・ピクチャの移動コマンドに『完了までウェイト』をつけ忘れていたので修正。
//      ・ピクチャの移動コマンドが設定した時間以上に時間がかかってしまっていたのを修正。
//  2023/10/18 ver 1.0.0
//      ・初版
//=============================================================================

/*:
 * @plugindesc 拡張されたピクチャの表示・移動を提供するプラグイン
 * @author ecf5DTTzl6h6lJj02
 *
 *
 * @help
 * 拡張されたピクチャの表示・移動をするプラグインコマンドを
 * 提供するプラグインです。
 * 
 * ●プラグインコマンドについて
 * ピクチャを表示するプラグインコマンドと
 * ピクチャの移動を行うプラグインコマンドの
 * 2種類が存在します。
 * 
 * ・ピクチャを表示するコマンド(PICTURE_EX SHOW)
 * 　　書式:
 *     　PICTURE_EX SHOW ピクチャID {設定項目}
 *     
 * 　　ピクチャ表示用のコマンドです。
 * 　　コマンドは大文字、小文字の識別をしていませんので、
 * 　　どちらで書いても大丈夫です。
 * 　　ピクチャID は、通常のピクチャの表示の番号と同様です。
 * 　　設定項目については、後述します。
 * 
 * ・ピクチャを移動するコマンド(PICTURE_EX MOVE)
 * 　　書式:
 * 　　　PICTURE_EX MOVE ピクチャID {設定項目} 時間 完了までウェイト
 * 
 * 　　ピクチャの移動用のコマンドです。
 * 　　コマンドは大文字、小文字の識別をしていませんので、
 * 　　どちらで書いても大丈夫です。
 * 　　ピクチャID は、通常のピクチャの移動の【番号】と同様です。
 * 　　設定項目については後述します。
 * 　　時間は、通常のピクチャの移動の【時間】と同様です。
 * 　　完了までウェイトは、完了までウェイトするかのフラグです。
 * 　　true もしくは false を記述してください。
 * 　　省略することが可能です。
 * 　　省略した場合は true に設定されます。
 * 
 * ・設定項目について
 * 　設定項目は {} の中に、 "項目名":設定値 の形で設定します。
 * 　カンマ(,)区切りで複数設定することができます。
 * 　設定が必要なものだけを記述して下さい。
 * 　記述がないものに関してはデフォルトのモノが設定されます。
 * 　ピクチャの移動コマンドの場合は、コマンド実行前の値が設定されます。
 *   項目名は二重引用符(")で囲う必要があるので注意してください。
 * 　また、プラグインコマンドの記述の性質上、この項目の途中(カンマの後ろなど)に
 * 　スペースを入れることができないので注意してください。
 * 　設定できる項目名は以下の通りです。
 * 　
 * 　　・name (PICUTRE_EX SHOW のみ)
 * 　　　　表示するピクチャの画像ファイルを設定します。
 * 　　　　ピクチャの表示の【画像】と同様です。
 * 　　・origin
 * 　　　　ピクチャの原点を設定します。
 * 　　　　0 で左上、1 で中央にになります。
 * 　　・x
 * 　　　　SHOW の場合は、表示位置のX座標、
 * 　　　　MOVE の場合は、移動後のX座標を設定します。
 *        \\V[n] と記述することでゲーム変数 n 番の値を指定できます。
 * 　　　　\\V[\\V[n]] と二重にすることもできます。(三重以上にはできません)
 * 　　・y
 * 　　　　SHOW の場合は、表示位置のY座標、
 * 　　　　MOVE の場合は、移動後のX座標を設定します。
 *        \\V[n] と記述することでゲーム変数 n 番の値を指定できます。
 * 　　　　\\V[\\V[n]] と二重にすることもできます。(三重以上にはできません)
 * 　　・scaleX
 *　　　　 ピクチャのX方向の拡大率を設定します。％表記として扱います。
 * 　　・scaleY
 * 　　　　ピクチャのY方向の拡大率を設定します。％表記として扱います。
 * 　　・angle
 * 　　　　ピクチャの回転角度を設定します。度数表記で扱います。
 * 　　・skewX
 * 　　　　ピクチャのX方向の歪み(傾き)を設定します。
 * 　　　　この歪み(傾き)とは、シアー(剪断変形)におけるそれです。
 * 　　・skewY
 * 　　　　ピクチャのY方向の歪み(傾き)を設定します。
 * 　　　　この歪み(傾き)とは、シアー(剪断変形)におけるそれです。
 * 　　・opacity
 * 　　　　ピクチャの不透明度を設定します。
 * 　　　　ピクチャの表示や、ピクチャの移動の【不透明度】と同様です。
 * 　　　　0 から 255 の範囲で設定します。
 * 　　・blendMode
 * 　　　　ピクチャの合成方法を設定します。
 * 　　　　0 で通常、1 で加算、2 で乗算、3 でスクリーンとなります。
 * 
 * 　　
 */

(() =>{
    'use strict'

    function convertVariableValue (text) {
        if (text) {
            if (!isNaN(text)) {
                return Number(text);
            }
            text = text.replace(/\\/g, '\x1b');
            text = text.replace(/\x1b\x1b/g, '\\');
            text = text.replace(/\x1bV\[(\d+)\]/gi, function() {
                return $gameVariables.value(parseInt(arguments[1]));
            }.bind(this));
            text = text.replace(/x1bV\[(\d+)\]/gi, function() {
                return $gameVariables.value(parseInt(arguments[1]))
            }.bind(this));
        }
        return text;
    }

    //--------------- プラグインコマンド -----------------------------------------

    const _Game_Interpreter_pluginCommand = Game_Interpreter.prototype.pluginCommand;
    Game_Interpreter.prototype.pluginCommand = function(command, args) {
        _Game_Interpreter_pluginCommand.apply(this, arguments);
        if (command.toUpperCase() === 'PICTURE_EX') {
            if (args[0].toUpperCase() === 'SHOW') {
                const pictureId = $gameScreen.realPictureId(Number(args[1]));
                const picture = new Game_Picture();
                const params = JSON.parse(args[2]);
                console.log(params);
                const name = params.name;
                const origin = Number(params.origin) || 0;
                const x = Number(convertVariableValue(params.x)) || 0;
                const y = Number(convertVariableValue(params.y)) || 0;
                console.log(x, y);
                const scaleX = Number(params.scaleX) || 100;
                const scaleY = Number(params.scaleY) || 100;
                const angle = Number(params.angle) || 0;
                const skewX = Number(params.skewX) || 0;
                const skewY = Number(params.skewY) || 0;
                const opacity = Number(params.opacity) || 255;
                const blendMode = Number(params.blendMode) || 0;
                picture.show(name, origin, x, y, scaleX, scaleY, angle, skewX, skewY, opacity, blendMode);
                $gameScreen._pictures[pictureId] = picture;
            }
            if (args[0].toUpperCase() === 'MOVE') {
                if (isNaN(args[1])) {
                    throw new Error('ピクチャIDが数値ではありません。: ' + args[1]);
                }
                if (isNaN(args[3])) {
                    throw new Error('時間が数値ではありません。: ' + args[3]);
                }
                const picture = $gameScreen.picture(Number(args[1]));
                const params = JSON.parse(args[2]);
                console.log(params);
                const origin = Number(params.origin) || picture.origin();
                const x = Number(convertVariableValue(params.x)) || picture.x();
                const y = Number(convertVariableValue(params.y)) || picture.y();
                console.log(x,y);
                const scaleX = Number(params.scaleX) || picture.scaleX();
                const scaleY = Number(params.scaleY) || picture.scaleY();
                const angle = Number(params.angle) || picture.angle();
                const skewX = Number(params.skewX) || picture.skewX();
                const skewY = Number(params.skewY) || picture.skewY();
                const opacity = Number(params.opacity) || picture.opacity();
                const blendMode = Number(params.blendMode) || picture.blendMode();
                const duration = Number(args[3]);
                picture.move(origin, x, y, scaleX, scaleY, angle, skewX, skewY, opacity, blendMode, duration);
                if (!args[4] || args[4] === 'true') {
                    this.wait(duration);
                }
            }
        }
    };

    //--------------------------------------------------------------------------

    //----------------------Game_Picture----------------------------------------

    Game_Picture.prototype.angle = function() {
        return this._angle;
    };

    Game_Picture.prototype.skewX = function() {
        return this._skewX;
    };

    Game_Picture.prototype.skewY = function() {
        return this._skewY;
    };

    const _Game_Picture_initBasic = Game_Picture.prototype.initBasic;
    Game_Picture.prototype.initBasic = function() {
        _Game_Picture_initBasic.apply(this, arguments);
        this._skewX = 0;
        this._skewY = 0;
        this._angle = 0;
    };

    const _Game_Picture_initTarget = Game_Picture.prototype.initTarget;
    Game_Picture.prototype.initTarget = function() {
        _Game_Picture_initTarget.apply(this, arguments);
        this._targetSkewX = this._skewX;
        this._targetSkewY = this._skewY;
        this._targetAngle = this._angle;
    };

    Game_Picture.prototype.initRotation = function() {
        this._angle = this._targetAngle;
        this._rotationSpeed = 0;
    };

    const _Game_Picture_show = Game_Picture.prototype.show;
    Game_Picture.prototype.show = function(name, origin, x, y, scaleX, scaleY, angle, skewX, skewY,
                                            opacity, blendMode) {
        this._angle = angle;
        this._skewX = skewX;
        this._skewY = skewY;
        _Game_Picture_show.call(this, name, origin, x, y, scaleX, scaleY,
            opacity, blendMode);        
    };

    const _Game_Picture_move = Game_Picture.prototype.move;
    Game_Picture.prototype.move = function(origin, x, y, scaleX, scaleY, angle, skewX, skewY,
                                            opacity, blendMode, duration) {
        _Game_Picture_move.call(this, origin, x, y, scaleX, scaleY,
                                opacity, blendMode, duration);
        if (this._rotationSpeed === 0) {
            this._targetAngle = angle;
        }
        this._targetSkewX = skewX;
        this._targetSkewY = skewY;
    };

    Game_Picture.prototype.updateMove = function() {
        if (this._duration > 0) {
            var d = this._duration;
            this._x = (this._x * (d - 1) + this._targetX) / d;
            this._y = (this._y * (d - 1) + this._targetY) / d;
            this._scaleX = (this._scaleX * (d - 1) + this._targetScaleX) / d;
            this._scaleY = (this._scaleY * (d - 1) + this._targetScaleY) / d;
            if (this._rotationSpeed === 0) {
                this._angle = (this._angle * (d - 1) + this._targetAngle) / d;
            }
            this._skewX = (this._skewX * (d - 1) + this._targetSkewX) / d;
            this._skewY = (this._skewY * (d - 1) + this._targetSkewY) / d;
            this._opacity = (this._opacity * (d - 1) + this._targetOpacity) / d;
            this._duration--;
        }
    };

    //--------------------------------------------------------------------------

    //-----------------Game_Screen----------------------------------------------

    Game_Screen.prototype.showPicture = function(pictureId, name, origin, x, y,
                                                scaleX, scaleY, opacity, blendMode) {
        var realPictureId = this.realPictureId(pictureId);
        var picture = new Game_Picture();
        picture.show(name, origin, x, y, scaleX, scaleY, 0, 0, 0, opacity, blendMode);
        this._pictures[realPictureId] = picture;
    };

    Game_Screen.prototype.movePicture = function(pictureId, origin, x, y, scaleX,
                                                scaleY, opacity, blendMode, duration) {
        var picture = this.picture(pictureId);
        if (picture) {
            picture.move(origin, x, y, scaleX, scaleY, 0, 0, 0, opacity, blendMode, duration);
        }
    };

    //--------------------------------------------------------------------------

    //-------------------Sprite_Picture-----------------------------------------

    Sprite_Picture.prototype.update = function() {
        Sprite.prototype.update.call(this);
        this.updateBitmap();
        if (this.visible) {
            this.updateOrigin();
            this.updatePosition();
            this.updateScale();
            this.updateSkew();
            this.updateTone();
            this.updateOther();
        }
    };

    Sprite_Picture.prototype.updateSkew = function() {
        var picture = this.picture();
        this.skew.x = picture.skewX();
        this.skew.y = picture.skewY();
    };

    //--------------------------------------------------------------------------
})();