/*:
 * @plugindesc セーブ/ロード画面のカスタマイズプラグイン (レイアウト調整)
 * @target MV
 * @param VariableID
 * @desc 表示する従業員数として使う変数のIDを指定します
 * @default 1
 * 
 * @help
 * セーブデータのリストをカスタマイズし、「主人公の名前」「従業員数（変数）」
 * 「所持金」「プレイ時間」を表示します。
 */

(function() {
	const parameters = PluginManager.parameters('SaveFileInfoCustomizer');
	const variableId = Number(parameters['VariableID'] || 1);

	// Window_SavefileListの描画処理を拡張
	const _Window_SavefileList_drawItem = Window_SavefileList.prototype.drawItem;
	Window_SavefileList.prototype.drawItem = function(index) {

		/*
		const id = index + 1;
		const valid = DataManager.isThisGameFile(id);
		const info = DataManager.loadSavefileInfo(id);
		const rect = this.itemRectForText(index);
		const lineHeight = this.lineHeight();

		const x1 = rect.x + 10;
		const x3 = rect.x + 400;

		const y1 = rect.y;
		const y2 = rect.y + lineHeight;
		const y3 = rect.y + lineHeight * 2;
		const y4 = rect.y + lineHeight * 3;
		*/

		const id = index + 1;
		const valid = DataManager.isThisGameFile(id);
		const info = DataManager.loadSavefileInfo(id);
		const rect = this.itemRectForText(index);
		const lineHeight = this.lineHeight();

		const x1 = rect.x + 10;
		const x3 = rect.x + 400;
		const y1 = rect.y;
		const y2 = rect.y + lineHeight;

		this.resetTextColor();
		this.contents.fontSize = 22; // フォントサイズ


		// ファイル番号
		if(id == 1)
		{
			this.changeTextColor(this.textColor(3));
			this.drawText("【Auto】", x1, y1, rect.width - 20);
		}
		else
		{
			this.changeTextColor(this.textColor(14));
			this.drawText("【"+(id-1)+"】", x1, y1, rect.width - 20);
		}

		if (valid && info)
		{
			// 主人公の名前
			this.changeTextColor(this.textColor(0));
			this.drawText(info.playerName, x1 + 100, y1, rect.width - 20);

			// 従業員数（左側）
			this.changeTextColor(this.textColor(4));
			this.drawText("従業員数：",	x1+100, y2, 150);
			this.changeTextColor(this.textColor(0));
			this.drawText(""+info.charaCount+"人",	x1+100, y2, 150, "right");

			// 所持金（中央）
			this.changeTextColor(this.textColor(4));
			this.drawText("所持金：　　　　Ｇ",	x1+300, y2, 250);
			this.changeTextColor(this.textColor(0));
			this.drawText(info.gold+"　",				x1+247, y2, 250, "right");

			//プレイ時間
			this.changeTextColor(this.textColor(0));
			const playtime = info.playtime || "00:00:00";
			this.drawText(playtime, x3, y2, rect.width - 420, "right");

		}
		else
		{
			// 主人公の名前
			this.changeTextColor(this.textColor(0));
			this.drawText("-----", x1+80, y1, rect.width - 20);
		}
	};

	// セーブデータに変数情報を追加
	const _DataManager_makeSavefileInfo = DataManager.makeSavefileInfo;
	DataManager.makeSavefileInfo = function()
	{
		const info = _DataManager_makeSavefileInfo.call(this);
	
		info.playerName	= $gameActors.actor(1).name();
		info.charaCount	= $gameVariables.value(138);
		info.gold		= $gameParty.gold();
		info.playtime	= $gameSystem.playtimeText();
		return info;
	};

	Window_SavefileList.prototype.itemHeight = function() 
	{
		return this.lineHeight() * 2;
	};


})();
