/*:
 * @plugindesc SupponShopStock 売り切れ表記をゲーム中に変更できるようにするパッチ
 * @author you
 * @help
 * 使い方:
 *   $gameSystem.setSupponSSSoldOutLabel("完売");
 *   $gameSystem.setSupponSSStockLabel("在庫"); // ついでに在庫数表記も
 */

(function() {

  // ====== Game_System に保存 ======
  Game_System.prototype.supponSSSoldOutLabel = function() {
    return this._supponSSSoldOutLabel;
  };

  Game_System.prototype.setSupponSSSoldOutLabel = function(text) {
    this._supponSSSoldOutLabel = String(
      (text === undefined || text === null) ? "" : text
    );

    // ショップ表示中なら即反映
    if (SceneManager._scene && SceneManager._scene._buyWindow) {
      SceneManager._scene._buyWindow.refresh();
    }
  };

  // ====== 表示処理の差し替え ======
  const _drawItem = Window_ShopBuy.prototype.drawItem;
  Window_ShopBuy.prototype.drawItem = function(index) {

    if (!SceneManager.isSupponSS || !SceneManager.isSupponSS()) {
      return _drawItem.call(this, index);
    }

    const item = this._data[index];
    const rect = this.itemRect(index);
    const priceWidth = 96;
    rect.width -= this.textPadding();

    let stockNumber = 0;
    const vId = this._shopGoods[index][4];
    if (vId > 0) {
      stockNumber = $gameVariables.value(vId);
    } else if (vId === -1) {
      stockNumber = this._shopGoods[index][5];
    }

    this.changePaintOpacity(this.isEnabled(item) && stockNumber > 0);
    this.drawItemName(item, rect.x, rect.y, rect.width - priceWidth);

    let soldOutText = "売り切れ";
    if ($gameSystem && $gameSystem.supponSSSoldOutLabel()) {
      soldOutText = $gameSystem.supponSSSoldOutLabel();
    }

    const text = (stockNumber > 0 ? this.price(item) : soldOutText);
    this.drawText(text, rect.x + rect.width - priceWidth, rect.y, priceWidth, "right");

    this.changePaintOpacity(true);
  };

})();
