//=============================================================================================
// ■■■ ダイアログボックスを作成 ■■■
//=============================================================================================


function createExternalDialog() 
{
	//削除を許可するかどうかのフラグ
	dlgEnableDelete = true;


	const dialogWindow = window.open('', '', 'width=960,height=800,top=100,left=100,resizable=no,scrollbars=yes');

	dialogWindow.document.write(`
		<html>
			<head>
				<title>あああ</title>

				<style>
					body {
						font-family: Arial, sans-serif;
						margin: 0;
						padding: 0;
						overflow: hidden;
					}
					#dialogBox {
						position: absolute;
						top: 0;
						left: 0;
						width: 100%;
						height: 100%;
						border: 1px solid #ccc;
						background-color: #fff;
						display: flex;
						flex-direction: column;
						padding: 10px;
						box-sizing: border-box;
					}
					
					#listBox option 
					{
						font-weight: bold; /* 太字にする */
						font-size: 16px; /* フォントサイズを変更 */
					}

					#content {
						flex: 1;
						overflow: hidden;
					}
					select {
						width: calc(100% - 20px);
						height: calc(100% - 20px);
						border: 1px solid #ccc;
						box-sizing: border-box;
						font-size: 16px; /* フォントサイズを指定 */
						padding: 5px;
					}

					textarea {
						position: absolute;
						width: 400px;
						height: 30px;
						font-size: 14px;
						padding: 5px;
						resize: none; /* サイズ変更を無効にする */
						box-sizing: border-box;
						white-space: nowrap; /* 改行を無効化 */
						
						word-wrap: normal; /* テキストの折り返しをしない */
						margin-bottom: 10px; /* 下に10pxのスペースを追加 */
					}

					button {
						min-width: 100px;	/* 最小の横幅を固定（英語でもはみ出さない程度に） */
						height: 30px;		/* 高さを固定 */
						width: 150px;		/* 幅を固定 */
						padding: 0 10px;	/* 左右に少し余白を作る */
						white-space: nowrap; /* 改行させない */
						text-align: center;  /* 文字を中央に */
					}

					button:disabled 
					{
						background-color: #aaa; /* 無効化時の背景色 */
					}
				</style>
			</head>


			<body>


				<div id="dialogBox">

					<!-- ▼シナリオ名入力エリア -->

					<label style="position: absolute;  left:10px;  top:20px; ">▼</label>
					<label id="Title" style="position: absolute; left:30px; top:20px;">-----</label>


					<!-- ▼リストボックス -->
					<select id="listBox"
							multiple size="8"
							style= "position: absolute;
									left: 10px; top: 50px;
									width: 580px; height: 700px;">
					</select>



					<!-- ▼リストボックスの上に重ねる半透明の背景 -->
					<div id="listBoxOverlay"
					  style="position: absolute;
						left: 410px; top: 20px;
						width: 500px; height: 740px;
						background-color: rgba(255, 255, 255, 0.95); /* 半透明の背景色 */
						border: 3px solid rgb(200, 200, 200); /* 3pxの縁取り */
						pointer-events: none;
						display: none;">
					</div>


					<div id="BTN_AREA" style="user-select: none;">
						<!-- ▼ボタン1 -->
						<button id="BTN_0"  style="position: absolute; left:610px; top: 50px;">${DLG_TEXTS.BTN._00}</button>
						<button id="BTN_1"  style="position: absolute; left:610px; top: 90px;">${DLG_TEXTS.BTN._01}</button>
						<button id="BTN_2"  style="position: absolute; left:610px; top:130px;">${DLG_TEXTS.BTN._02}</button>
						<button id="BTN_3"  style="position: absolute; left:610px; top:170px;">${DLG_TEXTS.BTN._03}</button>
						<button id="BTN_4"  style="position: absolute; left:610px; top:210px;">${DLG_TEXTS.BTN._04}</button>
						<button id="BTN_5"  style="position: absolute; left:610px; top:250px;">${DLG_TEXTS.BTN._05}</button>
						<button id="BTN_6"  style="position: absolute; left:610px; top:290px;">${DLG_TEXTS.BTN._06}</button>
						<button id="BTN_7"  style="position: absolute; left:610px; top:330px;">${DLG_TEXTS.BTN._07}</button>

						<button id="BTN_10" style="position: absolute; left:610px; top:370px;">${DLG_TEXTS.BTN._10}</button>
						<button id="BTN_11" style="position: absolute; left:610px; top:410px;">${DLG_TEXTS.BTN._11}</button>
						<button id="BTN_12" style="position: absolute; left:610px; top:450px;">${DLG_TEXTS.BTN._12}</button>
						<button id="BTN_PS" style="position: absolute; left:610px; top:490px;">ポーズ(開発用)</button>

						<button id="BTN_13" style="position: absolute; left:780px; top: 50px;">${DLG_TEXTS.BTN._13}</button>
						<button id="BTN_14" style="position: absolute; left:780px; top: 90px;">${DLG_TEXTS.BTN._14}</button>
						<button id="BTN_15" style="position: absolute; left:780px; top:130px;">${DLG_TEXTS.BTN._15}</button>
						<button id="BTN_16" style="position: absolute; left:780px; top:170px;">${DLG_TEXTS.BTN._16}</button>
						<button id="BTN_17" style="position: absolute; left:780px; top:210px;">${DLG_TEXTS.BTN._17}</button>
						<button id="BTN_20" style="position: absolute; left:780px; top:250px;">${DLG_TEXTS.BTN._20}</button>
						<button id="BTN_21" style="position: absolute; left:780px; top:290px;">${DLG_TEXTS.BTN._21}</button>
						<button id="BTN_22" style="position: absolute; left:780px; top:330px;">${DLG_TEXTS.BTN._22}</button>
						<button id="BTN_23" style="position: absolute; left:780px; top:370px;">${DLG_TEXTS.BTN._23}</button>

						<button id="BTN_25" style="position: absolute; left:780px; top:410px;">${DLG_TEXTS.BTN._25}</button>
						<button id="BTN_26" style="position: absolute; left:780px; top:450px;">${DLG_TEXTS.BTN._26}</button>
						<button id="BTN_27" style="position: absolute; left:780px; top:490px;">${DLG_TEXTS.BTN._27}</button>


						<label style="position: absolute; left: 610px; top: 550px; font-size: 14px; line-height: 1.4;">
						${DLG_TEXTS.MAIN._EX1}
						${DLG_TEXTS.MAIN._EX2}<br>
						${DLG_TEXTS.MAIN._EX3}
						${DLG_TEXTS.MAIN._EX4}<br>
						${DLG_TEXTS.MAIN._EX5}
						${DLG_TEXTS.MAIN._EX6}
						</label>

					</div>

				</div>


				<!-- ▼▼▼ メインタイトル ▼▼▼ -->
				<span id="MAIN_TITLE" style="position: absolute; left:440px; top:50px; display: none;">【-----】</span>
			

				<!-- ▼▼▼ 文章表示関係 ▼▼▼ -->
				<div id="MESSAGE_AREA" style="display: none;">
					<div  style="position: absolute; left:430px; top:100px; width:465px; height:40px; background-color: #f0f0f0; box-sizing:border-box;"></div>
					<span style="position: absolute; left:440px; top:110px;">${DLG_TEXTS.DRAW_TEXT._01}</span>

					<label>
						<input type="radio" name="radioGroup0"	style="position: absolute; left: 560px; top: 110px;" value="${ESC._BG_TYPE0[LANGUAGE]}" checked>
						<span  									style="position: absolute; left: 580px; top: 110px;">${DLG_TEXTS.DRAW_TEXT._02}</span>
					</label>
					<label>
						<input type="radio" name="radioGroup0"	style="position: absolute; left: 660px; top: 110px;" value="${ESC._BG_TYPE1[LANGUAGE]}">
						<span									style="position: absolute; left: 680px; top: 110px;">${DLG_TEXTS.DRAW_TEXT._03}</span>
					</label>
					<label>
						<input type="radio" name="radioGroup0"	style="position: absolute; left: 760px; top: 110px;" value="${ESC._BG_TYPE2[LANGUAGE]}">
						<span									style="position: absolute; left: 780px; top: 110px;">${DLG_TEXTS.DRAW_TEXT._04}</span>
					</label>

					<textarea 
						id="textarea0" 
						placeholder=${DLG_TEXTS.DRAW_TEXT._05}
						style="
							position: absolute;
							left: 430px; top: 150px;
							width: 465px; height: 100px; 
							font-size: 12px; 
							padding: 5px; 
							resize: none; 
							box-sizing: border-box;
							line-height: 1.6; /* 行間を設定 */
					">
					</textarea>


					<label style="position: absolute;  left:430px;  top:270px; ">
					<b>${DLG_TEXTS.DRAW_TEXT._10}</b><br>
					${DLG_TEXTS.DRAW_TEXT._11}<br>
					${DLG_TEXTS.DRAW_TEXT._12}<br>
					${DLG_TEXTS.DRAW_TEXT._13}<br>
					${DLG_TEXTS.DRAW_TEXT._14}<br>
					${DLG_TEXTS.DRAW_TEXT._15}<br>
					${DLG_TEXTS.DRAW_TEXT._16}<br>
					${DLG_TEXTS.DRAW_TEXT._17}<br>
					<br>
					<b>${DLG_TEXTS.DRAW_TEXT._20}</b><br>
					${DLG_TEXTS.DRAW_TEXT._21}<br>
					${DLG_TEXTS.DRAW_TEXT._22}<br>
					${DLG_TEXTS.DRAW_TEXT._23}<br>
					${DLG_TEXTS.DRAW_TEXT._24}<br>
					${DLG_TEXTS.DRAW_TEXT._25}<br>
					</label>
				</div>

				<!-- ▼▼▼ CG表示関係 ▼▼▼ -->
				<div id="CG_DRAW_AREA" style="display: none;">
					<select	id= "dropdownCg"
							style=" position: absolute;
									left: 430px; top: 110px;
									width: 400px; height: 40px; ">
					</select>
				</div>




				<!-- ▼▼▼ CG差分関係 ▼▼▼ -->
				<div id="CG_DIFFERENCE_AREA" style="display: none;">
					<!-- 眉 -->
					<span style="position: absolute; left:440px; top:90px; font-size:15px;">${DLG_TEXTS.CG_DIFF._1_T}</span>
					<span style="position: absolute; left:515px; top:90px; font-size:15px;">：</span>
					<select	id= "dropdown_03_A" 
						style="position:absolute; left:540px;top:88px; width:300px; height:28px; font-size:15px; padding:0px 5px;">
						<option value="0" selected>${DLG_TEXTS.CG_DIFF._1_00}</option>
						<option value="1">${DLG_TEXTS.CG_DIFF._1_01}</option>
						<option value="2">${DLG_TEXTS.CG_DIFF._1_02}</option>
						<option value="3">${DLG_TEXTS.CG_DIFF._1_03}</option>
					</select>

					<!-- 右目 -->
					<span style="position: absolute; left:440px; top:120px; font-size:15px;">${DLG_TEXTS.CG_DIFF._2_TR}</span>
					<span style="position: absolute; left:515px; top:120px; font-size:15px;">：</span>
					<select	id= "dropdown_03_B"
						style="position:absolute; left:540px;top:118px; width:300px; height:28px; font-size:15px; padding:0px 5px;">
						<option value="0" selected>${DLG_TEXTS.CG_DIFF._2_00}</option>
						<option value="1">${DLG_TEXTS.CG_DIFF._2_01}</option>
						<option value="2">${DLG_TEXTS.CG_DIFF._2_02}</option>
						<option value="3">${DLG_TEXTS.CG_DIFF._2_03}</option>
						<option value="4">${DLG_TEXTS.CG_DIFF._2_04}</option>
					</select>

					<!-- 左目 -->
					<span style="position: absolute; left:440px; top:150px; font-size:15px;">${DLG_TEXTS.CG_DIFF._2_TL}</span>
					<span style="position: absolute; left:515px; top:150px; font-size:15px;">：</span>
					<select	id= "dropdown_03_C"
						style="position:absolute; left:540px;top:148px; width:300px; height:28px; font-size:15px; padding:0px 5px;">
						<option value="0" selected>${DLG_TEXTS.CG_DIFF._2_00}</option>
						<option value="1">${DLG_TEXTS.CG_DIFF._2_01}</option>
						<option value="2">${DLG_TEXTS.CG_DIFF._2_02}</option>
						<option value="3">${DLG_TEXTS.CG_DIFF._2_03}</option>
						<option value="4">${DLG_TEXTS.CG_DIFF._2_04}</option>
					</select>

					<!-- ハイライト -->
					<span style="position: absolute; left:440px; top:180px; font-size:15px;">${DLG_TEXTS.CG_DIFF._3_T}</span>
					<span style="position: absolute; left:515px; top:180px; font-size:15px;">：</span>
					<select	id= "dropdown_03_J"
						style="position:absolute; left:540px;top:178px; width:300px; height:28px; font-size:15px; padding:0px 5px;">
						<option value="0" selected>${DLG_TEXTS.CG_DIFF._3_00}</option>
						<option value="1">${DLG_TEXTS.CG_DIFF._3_01}</option>
						<option value="2">${DLG_TEXTS.CG_DIFF._3_02}</option>
					</select>

					<!-- 目線 -->
					<span style="position: absolute; left:440px; top:210px; font-size:15px;">${DLG_TEXTS.CG_DIFF._4_T}</span>
					<span style="position: absolute; left:515px; top:210px; font-size:15px;">：</span>
					<select	id= "dropdown_03_D"
						style="position:absolute; left:540px;top:208px; width:300px; height:28px; font-size:15px; padding:0px 5px;">
						<option value="0" selected>${DLG_TEXTS.CG_DIFF._4_00}</option>
						<option value="1">${DLG_TEXTS.CG_DIFF._4_01}</option>
						<option value="2">${DLG_TEXTS.CG_DIFF._4_02}</option>
						<option value="3">${DLG_TEXTS.CG_DIFF._4_03}</option>
						<option value="10">${DLG_TEXTS.CG_DIFF._4_00 + DLG_TEXTS.CG_DIFF._4_X}</option>
						<option value="11">${DLG_TEXTS.CG_DIFF._4_01 + DLG_TEXTS.CG_DIFF._4_X}</option>
						<option value="12">${DLG_TEXTS.CG_DIFF._4_02 + DLG_TEXTS.CG_DIFF._4_X}</option>
						<option value="13">${DLG_TEXTS.CG_DIFF._4_03 + DLG_TEXTS.CG_DIFF._4_X}</option>
					</select>

					<!-- 口 -->
					<span style="position: absolute; left:440px; top:240px; font-size:15px;">${DLG_TEXTS.CG_DIFF._5_T}</span>
					<span style="position: absolute; left:515px; top:240px; font-size:15px;">：</span>
					<select	id= "dropdown_03_E"
						style="position:absolute; left:540px;top:238px; width:300px; height:28px; font-size:15px; padding:0px 5px;">
						<option value="0" selected>${DLG_TEXTS.CG_DIFF._5_00}</option>
						<option value="1" >${DLG_TEXTS.CG_DIFF._5_01}</option>
						<option value="2" >${DLG_TEXTS.CG_DIFF._5_02}</option>
						<option value="3" >${DLG_TEXTS.CG_DIFF._5_03}</option>
						<option value="4" >${DLG_TEXTS.CG_DIFF._5_04}</option>
						<option value="5" >${DLG_TEXTS.CG_DIFF._5_05}</option>
						<option value="6" >${DLG_TEXTS.CG_DIFF._5_06}</option>
						<option value="7" >${DLG_TEXTS.CG_DIFF._5_07}</option>
						<option value="8" >${DLG_TEXTS.CG_DIFF._5_08}</option>
						<option value="18">${DLG_TEXTS.CG_DIFF._5_18}</option>
						<option value="9" >${DLG_TEXTS.CG_DIFF._5_09}</option>
						<option value="10">${DLG_TEXTS.CG_DIFF._5_10}</option>
						<option value="11">${DLG_TEXTS.CG_DIFF._5_11}</option>
						<option value="12">${DLG_TEXTS.CG_DIFF._5_12}</option>
						<option value="13">${DLG_TEXTS.CG_DIFF._5_13}</option>
						<option value="14">${DLG_TEXTS.CG_DIFF._5_14}</option>
						<option value="15">${DLG_TEXTS.CG_DIFF._5_15}</option>
						<option value="16">${DLG_TEXTS.CG_DIFF._5_16}</option>
						<option value="17">${DLG_TEXTS.CG_DIFF._5_17}</option>

						<option value="100">${DLG_TEXTS.CG_DIFF._5_00 + DLG_TEXTS.CG_DIFF._5_X}</option>
						<option value="101">${DLG_TEXTS.CG_DIFF._5_01 + DLG_TEXTS.CG_DIFF._5_X}</option>
						<option value="102">${DLG_TEXTS.CG_DIFF._5_02 + DLG_TEXTS.CG_DIFF._5_X}</option>
						<option value="103">${DLG_TEXTS.CG_DIFF._5_03 + DLG_TEXTS.CG_DIFF._5_X}</option>
						<option value="104">${DLG_TEXTS.CG_DIFF._5_04 + DLG_TEXTS.CG_DIFF._5_X}</option>
						<option value="105">${DLG_TEXTS.CG_DIFF._5_05 + DLG_TEXTS.CG_DIFF._5_X}</option>
						<option value="106">${DLG_TEXTS.CG_DIFF._5_06 + DLG_TEXTS.CG_DIFF._5_X}</option>
						<option value="107">${DLG_TEXTS.CG_DIFF._5_07 + DLG_TEXTS.CG_DIFF._5_X}</option>
						<option value="108">${DLG_TEXTS.CG_DIFF._5_08 + DLG_TEXTS.CG_DIFF._5_X}</option>
						<option value="118">${DLG_TEXTS.CG_DIFF._5_18 + DLG_TEXTS.CG_DIFF._5_X}</option>
						<option value="109">${DLG_TEXTS.CG_DIFF._5_09 + DLG_TEXTS.CG_DIFF._5_X}</option>
						<option value="110">${DLG_TEXTS.CG_DIFF._5_10 + DLG_TEXTS.CG_DIFF._5_X}</option>
						<option value="111">${DLG_TEXTS.CG_DIFF._5_11 + DLG_TEXTS.CG_DIFF._5_X}</option>
						<option value="112">${DLG_TEXTS.CG_DIFF._5_12 + DLG_TEXTS.CG_DIFF._5_X}</option>
						<option value="113">${DLG_TEXTS.CG_DIFF._5_13 + DLG_TEXTS.CG_DIFF._5_X}</option>
						<option value="114">${DLG_TEXTS.CG_DIFF._5_14 + DLG_TEXTS.CG_DIFF._5_X}</option>
						<option value="115">${DLG_TEXTS.CG_DIFF._5_15 + DLG_TEXTS.CG_DIFF._5_X}</option>
						<option value="116">${DLG_TEXTS.CG_DIFF._5_16 + DLG_TEXTS.CG_DIFF._5_X}</option>
						<option value="117">${DLG_TEXTS.CG_DIFF._5_17 + DLG_TEXTS.CG_DIFF._5_X}</option>
					</select>

					<!-- 頬の赤み -->
					<span style="position: absolute; left:440px; top:270px; font-size:15px;">${DLG_TEXTS.CG_DIFF._6_T}</span>
					<span style="position: absolute; left:515px; top:270px; font-size:15px;">：</span>
					<select	id= "dropdown_03_F"
						style="position:absolute; left:540px;top:268px; width:300px; height:28px; font-size:15px; padding:0px 5px;">
						<option value="0" selected>0%</option>
						<option value="51">20%</option>
						<option value="102">40%</option>
						<option value="153">60%</option>
						<option value="204">80%</option>
						<option value="255">100%</option>
					</select>

					<!-- 女性器 -->
					<span style="position: absolute; left:440px; top:300px; font-size:15px;">${DLG_TEXTS.CG_DIFF._7_T}</span>
					<span style="position: absolute; left:515px; top:300px; font-size:15px;">：</span>
					<select	id= "dropdown_03_G"
						style="position:absolute; left:540px;top:298px; width:300px; height:28px; font-size:15px; padding:0px 5px;">
						<option value="0" selected>${DLG_TEXTS.CG_DIFF._7_00}</option>
						<option value="1">${DLG_TEXTS.CG_DIFF._7_01}</option>
						<option value="2">${DLG_TEXTS.CG_DIFF._7_02}</option>
						<option value="3">${DLG_TEXTS.CG_DIFF._7_03}</option>
					</select>

					<!-- 男性器 -->
					<span style="position: absolute; left:440px; top:330px; font-size:15px;">${DLG_TEXTS.CG_DIFF._8_T}</span>
					<span style="position: absolute; left:515px; top:330px; font-size:15px;">：</span>
					<select	id= "dropdown_03_H"
						style="position:absolute; left:540px;top:328px; width:300px; height:28px; font-size:15px; padding:0px 5px;">
						<option value="0" selected>${DLG_TEXTS.CG_DIFF._8_00}</option>
						<option value="1">${DLG_TEXTS.CG_DIFF._8_01}</option>
						<option value="2">${DLG_TEXTS.CG_DIFF._8_02}</option>
					</select>

					<!-- 赤ちゃん -->
					<span style="position: absolute; left:440px; top:360px; font-size:15px;">${DLG_TEXTS.CG_DIFF._9_T}</span>
					<span style="position: absolute; left:515px; top:360px; font-size:15px;">：</span>
					<select	id= "dropdown_03_I"
						style="position:absolute; left:540px;top:358px; width:300px; height:28px; font-size:15px; padding:0px 5px;">
						<option value="0" selected>${DLG_TEXTS.CG_DIFF._9_00}</option>
						<option value="1">${DLG_TEXTS.CG_DIFF._9_01}</option>
						<option value="2">${DLG_TEXTS.CG_DIFF._9_02}</option>
					</select>


					<style>
						.checkbox-label {
							position: absolute;
							width: 200px; /* クリック可能な範囲の幅を固定 */
							height: 28px; /* クリック可能な範囲の高さを固定 */
							display: flex; /* チェックボックスと文字を横並びにする */
							align-items: center; /* 縦位置を中央揃えにする */
							cursor: pointer; /* マウスカーソルをポインタに変更 */
						}
						.checkbox-label input {
							margin-right: 10px; /* チェックボックスと文字の間隔を調整 */
						}
					</style>

					<label class="checkbox-label" style="left: 440px; top: 400px;"><input type="checkbox" id="checkbox_03_0" >${DLG_TEXTS.CG_DIFF._10_00}</label>
					<label class="checkbox-label" style="left: 440px; top: 430px;"><input type="checkbox" id="checkbox_03_1" >${DLG_TEXTS.CG_DIFF._10_01}</label>
					<label class="checkbox-label" style="left: 440px; top: 460px;"><input type="checkbox" id="checkbox_03_2" >${DLG_TEXTS.CG_DIFF._10_02}</label>
					<label class="checkbox-label" style="left: 440px; top: 490px;"><input type="checkbox" id="checkbox_03_19">${DLG_TEXTS.CG_DIFF._10_03}</label>
					<label class="checkbox-label" style="left: 440px; top: 520px;"><input type="checkbox" id="checkbox_03_3" >${DLG_TEXTS.CG_DIFF._10_04}</label>
					<label class="checkbox-label" style="left: 440px; top: 550px;"><input type="checkbox" id="checkbox_03_4" >${DLG_TEXTS.CG_DIFF._10_05}</label>
					<label class="checkbox-label" style="left: 440px; top: 580px;"><input type="checkbox" id="checkbox_03_18">${DLG_TEXTS.CG_DIFF._10_06}</label>
					<label class="checkbox-label" style="left: 440px; top: 610px;"><input type="checkbox" id="checkbox_03_5" >${DLG_TEXTS.CG_DIFF._10_07}</label>
					<label class="checkbox-label" style="left: 440px; top: 640px;"><input type="checkbox" id="checkbox_03_6" >${DLG_TEXTS.CG_DIFF._10_08}</label>
					<label class="checkbox-label" style="left: 440px; top: 670px;"><input type="checkbox" id="checkbox_03_7" >${DLG_TEXTS.CG_DIFF._10_09}</label>

					<label class="checkbox-label" style="left: 650px; top: 400px;"><input type="checkbox" id="checkbox_03_16">${DLG_TEXTS.CG_DIFF._10_10}</label>
					<label class="checkbox-label" style="left: 650px; top: 430px;"><input type="checkbox" id="checkbox_03_17">${DLG_TEXTS.CG_DIFF._10_11}</label>
					<label class="checkbox-label" style="left: 650px; top: 460px;"><input type="checkbox" id="checkbox_03_8" >${DLG_TEXTS.CG_DIFF._10_12}</label>
					<label class="checkbox-label" style="left: 650px; top: 490px;"><input type="checkbox" id="checkbox_03_9" >${DLG_TEXTS.CG_DIFF._10_13}</label>
					<label class="checkbox-label" style="left: 650px; top: 520px;"><input type="checkbox" id="checkbox_03_10">${DLG_TEXTS.CG_DIFF._10_14}</label>
					<label class="checkbox-label" style="left: 650px; top: 550px;"><input type="checkbox" id="checkbox_03_11">${DLG_TEXTS.CG_DIFF._10_15}</label>
					<label class="checkbox-label" style="left: 650px; top: 580px;"><input type="checkbox" id="checkbox_03_12">${DLG_TEXTS.CG_DIFF._10_16}</label>
					<label class="checkbox-label" style="left: 650px; top: 610px;"><input type="checkbox" id="checkbox_03_13">${DLG_TEXTS.CG_DIFF._10_17}</label>
					<label class="checkbox-label" style="left: 650px; top: 640px;"><input type="checkbox" id="checkbox_03_14">${DLG_TEXTS.CG_DIFF._10_18}</label>
					<label class="checkbox-label" style="left: 650px; top: 670px;"><input type="checkbox" id="checkbox_03_15">${DLG_TEXTS.CG_DIFF._10_19}</label>
				</div>


				<!-- ▼▼▼ 選択肢関係 ▼▼▼ -->
				<div id="AREA04" style="display: none;" >

					<div  style="position: absolute; left:430px; top:100px; width:450px; height:40px; background-color: #f0f0f0; box-sizing:border-box;"></div>
					<span style="position: absolute; left:440px; top:110px;">${DLG_TEXTS.CHOICE._01}</span>
					<label>
						<input type="radio" name="radioGroup_04_0"	style="position: absolute; left:560px; top:110px;" value="${ESC._BG_TYPE0[LANGUAGE]}" checked>
						<span										style="position: absolute; left:580px; top:110px;">${DLG_TEXTS.CHOICE._02}</span>
					</label>
					<label>
						<input type="radio" name="radioGroup_04_0"	style="position: absolute; left:660px; top:110px;" value="${ESC._BG_TYPE1[LANGUAGE]}">
						<span										style="position: absolute; left:680px; top:110px;">${DLG_TEXTS.CHOICE._03}</span>
					</label>
					<label>
						<input type="radio" name="radioGroup_04_0"	style="position: absolute; left:760px; top:110px;" value="${ESC._BG_TYPE2[LANGUAGE]}">
						<span										style="position: absolute; left:780px; top:110px;">${DLG_TEXTS.CHOICE._04}</span>
					</label>


					<div  style="position: absolute; left:430px; top:150px; width:450px; height:40px; background-color: #f0f0f0; box-sizing:border-box;"></div>
					<span style="position: absolute; left:440px; top:160px;">${DLG_TEXTS.CHOICE._06}</span>
					<label>
						<input type="radio" name="radioGroup_04_1"	style="position: absolute; left:560px; top:160px;" value="${ESC._POS_L[LANGUAGE]}" checked>
						<span										style="position: absolute; left:580px; top:160px;">${DLG_TEXTS.CHOICE._07}</span>
					</label>
					<label>
						<input type="radio" name="radioGroup_04_1"	style="position: absolute; left:660px; top:160px;" value="${ESC._POS_C[LANGUAGE]}">
						<span										style="position: absolute; left:680px; top:160px;">${DLG_TEXTS.CHOICE._08}</span>
					</label>
					<label>
						<input type="radio" name="radioGroup_04_1"	style="position: absolute; left:760px; top:160px;" value="${ESC._POS_R[LANGUAGE]}">
						<span										style="position: absolute; left:780px; top:160px;">${DLG_TEXTS.CHOICE._09}</span>
					</label>

					<input	id="input_04_0" placeholder="${DLG_TEXTS.CHOICE._05 + 1}" style="position: absolute; left:430; top:210px; width: 400px; height:32px"/>
					<input	id="input_04_1" placeholder="${DLG_TEXTS.CHOICE._05 + 2}" style="position: absolute; left:430; top:245px; width: 400px; height:32px"/>
					<input	id="input_04_2" placeholder="${DLG_TEXTS.CHOICE._05 + 3}" style="position: absolute; left:430; top:280px; width: 400px; height:32px"/>
					<input	id="input_04_3" placeholder="${DLG_TEXTS.CHOICE._05 + 4}" style="position: absolute; left:430; top:315px; width: 400px; height:32px"/>
					<input	id="input_04_4" placeholder="${DLG_TEXTS.CHOICE._05 + 5}" style="position: absolute; left:430; top:350px; width: 400px; height:32px"/>
				</div>



				<!-- ▼▼▼ ウェイト関係 ▼▼▼ -->
				<div id="AREA05" style="display: none;" >
					<span style="position: absolute; left:440px; top:110px;">${DLG_TEXTS.WAIT._01}</span>
					<span style="position: absolute; left:600px; top:145px;">F</span>
					<input	id="input_05_0"
							type="number"
							min="1"
							max="999"
							placeholder="1～999"
							style="position: absolute; left:440px; top:140px;  width: 150px; height:32px"
					/>
					<span style="position: absolute; left:450; top:183px;">${DLG_TEXTS.WAIT._02}</span>
				</div>


				<!-- ▼▼▼ フェード関係 ▼▼▼ -->

				<div id="AREA06" style="display: none;" >
					<div  style="position: absolute; left:430px; top:100px; width:450px; height:40px; background-color: #f0f0f0; box-sizing:border-box;"></div>
					<span style="position: absolute; left:440px; top:110px;">${DLG_TEXTS.FADE._COLOR}</span>
					<label>
						<input type="radio" name="radioGroup_06_0"	style="position: absolute; left:510px; top:110px;" value="${ESC._FADE_B[LANGUAGE]}" checked>
						<span										style="position: absolute; left:530px; top:110px;">${DLG_TEXTS.FADE._BLACK}</span>
					</label>
					<label>
						<input type="radio" name="radioGroup_06_0"	style="position: absolute; left:610px; top:110px;" value="${ESC._FADE_W[LANGUAGE]}">
						<span										style="position: absolute; left:630px; top:110px;">${DLG_TEXTS.FADE._WHITE}</span>
					</label>
					<label>
						<input type="radio" name="radioGroup_06_0"	style="position: absolute; left:710px; top:110px;" value="${ESC._FADE_C[LANGUAGE]}">
						<span										style="position: absolute; left:730px; top:110px;">${DLG_TEXTS.FADE._CLEAR}</span>
					</label>


					<span style="position: absolute; left:440px; top:150px;">${DLG_TEXTS.FADE._FRAME}</span>
					<span style="position: absolute; left:600px; top:185px;">F</span>
					<input	id="input_06_0"
							type="number"
							min="1"
							max="999"
							placeholder="1～999"
							style="position: absolute; left:440px; top:180px;  width: 150px; height:32px"
					/>
					<span style="position: absolute; left:450; top:213px;">${DLG_TEXTS.FADE._FRAME_EX}</span>
				</div>


				<!-- ▼▼▼ サウンド再生関係の共通設定 ▼▼▼ -->
				<div id="AREA_SOUND_PLAY" style="display: none;" >
					<span id="soundTitle" style="position: absolute; left: 430px; top: 110px;">SE:</span>

					<select	id= "dropdown_SoundFile"
							style=" position: absolute;
									left: 440px; top: 140px;
									width: 250px; height: 32px; ">
						<option value="0" selected>0</option>
					</select>

					<button id="BTN_SoundPlay" style="position: absolute; width: 50px; left:700px; top: 143px;">${DLG_TEXTS.SOUND._PLAY}</button>
					<button id="BTN_SoundStop" style="position: absolute; width: 50px; left:810px; top: 143px;">${DLG_TEXTS.SOUND._STOP}</button>

					<span style="position: absolute; left:430px; top:180px;">${DLG_TEXTS.SOUND._VOLUME}</span>
					<span style="position: absolute; left:600px; top:215px;">％</span>
					<input	id="input_SoundVolume"
								type="number"
								min="1" max="100"
								placeholder="1～100"
								style="position: absolute; left:440px; top:210px;  width: 150px; height:32px"/>

					<span style="position: absolute; left:430px; top:260px;">pitch：</span>
					<span style="position: absolute; left:600px; top:295px;">％</span>
					<input	id="input_SoundPitch"
								type="number"
								min="50" max="150"
								placeholder="50～150"
								style="position: absolute; left:440px; top:290px;  width: 150px; height:32px"/>
				</div>


				<!-- ▼▼▼ サウンド停止関係の共通設定 ▼▼▼ -->
				<div id="AREA_SOUND_STOP" style="display: none;" >
					<span style="position: absolute; left:440px; top:110px;">${DLG_TEXTS.SOUND._STOPTIME}</span>
					<span style="position: absolute; left:600px; top:145px;">${DLG_TEXTS.SOUND._SECONDS}</span>
					<input	id="input_SoundStopFrame"
							type="number"
							min="0"
							max="999"
							placeholder="0～999"
							style="position: absolute; left:440px; top:140px;  width: 150px; height:32px"
					/>
					<span style="position: absolute; left:450; top:173px;">${DLG_TEXTS.SOUND._EX}</span>
				</div>


				<!-- ▼▼▼ 背景 ▼▼▼ -->
				<div id="AREA_BACKGROUND" style="display: none;" >
					<span id="BgTitle" style="position: absolute; left: 430px; top: 110px;">${DLG_TEXTS.BACKGROUND._BG}</span>

					<select	id= "dropdown_BgFile"
							style=" position: absolute;
									left: 440px; top: 140px;
									width: 350px; height: 32px; ">
						<option value="0" selected>0</option>
					</select>
				</div>


				<!-- ▼▼▼ コメント ▼▼▼ -->
				<div id="AREA12" style="display: none;" >
					<textarea 
						id="textarea12" 
						placeholder="${DLG_TEXTS.COMMENT._EX}"
						style="
							position: absolute;
							left: 430px; top: 110px;
							width: 400px; height: 100px; 
							font-size: 14px; 
							padding: 5px; 
							resize: none; 
							box-sizing: border-box;
							line-height: 1.6; /* 行間を設定 */
					">
					</textarea>
				</div>


				<!-- ▼▼▼ ラベル ▼▼▼ -->
				<div id="AREA_LABEL" style="display: none;">

					<span id="LabelTitle" style="position: absolute; left: 430px; top: 80px;">ラベル名:</span>

					<textarea 
						id="textareaLavel" 
						placeholder="${DLG_TEXTS.LABEL._EX2}"
						style="
							position: absolute;
							left: 430px; top: 110px;
							width: 400px; height: 30px; 
							font-size: 14px; 
							resize: none; 
							box-sizing: border-box;">
					</textarea>
				</div>


				<!-- ▼▼▼ 開く ▼▼▼ -->
				<div id="FILE_OPEN" style="display: none;">
					<select	id= "dropdown_open"
							style=" position: absolute;
									left: 430px; top: 110px;
									width: 400px; height: 40px; ">
					</select>
				</div>

				<!-- ▼▼▼ 保存 ▼▼▼ -->
				<div id="FILE_SAVE" style="display: none;">
					<textarea 
						id="textareaSave" 
						placeholder="シナリオ名を入力してください"
						style="
							position: absolute;
							left: 430px; top: 110px;
							width: 400px; height: 30px; 
							font-size: 14px; 
							resize: none; 
							box-sizing: border-box;">
					</textarea>
				</div>



				<!-- ▼▼▼ ポーズ変更(開発用) ▼▼▼ -->
				<div id="POSE_SELECT" style="display: none;">
					<select	id= "dropdownPose"
							style=" position: absolute;
									left: 430px; top: 110px;
									width: 400px; height: 40px; ">
						<option value="0" selected	>0</option>
						<option value="1"			>1</option>
						<option value="2"			>2</option>
						<option value="3"			>3</option>
						<option value="4"			>4</option>
					</select>
				</div>

				<!-- ▼▼▼ 決定・キャンセルボタン ▼▼▼ -->
				<div id="BTN_OKNG" style="display: none;">
					<button id="BTN_OK"  style="position: absolute; width:120; Height:30; left:430px; top:650px;">${DLG_TEXTS.BTN._OK}</button>
					<button id="BTN_NG"  style="position: absolute; width:120; Height:30; left:580px; top:650px;">${DLG_TEXTS.BTN._CANCEL}</button>
				</div>


				<!-- ▼▼▼ スクリプト ▼▼▼ -->
				<script>
				</script>
			</body>
		</html>
	`);


	//▼リストボックスを初期化
	const listBox = dialogWindow.document.getElementById('listBox');
	//コメントを1行挿入しておく
	addNewItemAtSelectedPosition(listBox, DLG_TEXTS.MAIN._EX);
	//リストのスタイルを設定
	SetListStyle(listBox);


	// リストボックスの1行目を選択
	listBox.selectedIndex = 0;

	//タイトルを設定
	dialogWindow.document.getElementById('Title').innerText = "-----";
 
	// コピーした内容を保存する変数
	let clipboard = '';



	{
		//CG表示の項目を追加
		let dd = dialogWindow.document.getElementById('dropdownCg');


		//[正常位]は無条件で追加
		AddDropdown( dd, gCgType[0] ); 

		//体験版では無い
		if( !IsTrial() )
		{
			AddDropdown( dd, gCgType[1] ); //[騎乗位]
			AddDropdown( dd, gCgType[2] ); //[後背位]
			AddDropdown( dd, gCgType[3] ); //[フェラ]
			AddDropdown( dd, gCgType[4] ); //[出産]
		}

		//「テストプレイである」
		if (Utils.isOptionValid('test')) 
		{
			AddDropdown( dd, gCgType[5] ); //[立絵]
			AddDropdown( dd, gCgType[6] ); //[立絵(裸)]
		}
	}


	//▼[ポーズ変更]のボタンを消す
	//「テストプレイではない」場合
	if( !Utils.isOptionValid('test') )
	{
		dialogWindow.document.getElementById("BTN_PS").style.display = "none"; 
	}




	//=====================================================================
	// ▼各種イベントを監視  
	//=====================================================================



	// ▼選択位置が変わった時
	listBox.addEventListener("change", (event) => 
	{
		//「編集中状態」の場合、クリックした位置の差分を適用
		if($gameVariables.value(61) == "編集中")
		{ SetBeforeDifference(listBox); }
	});



	//▼各種ボタン
	const Btn0  = dialogWindow.document.getElementById("BTN_0");
	const Btn1  = dialogWindow.document.getElementById("BTN_1");
	const Btn2  = dialogWindow.document.getElementById("BTN_2");
	const Btn3  = dialogWindow.document.getElementById("BTN_3");
	const Btn4  = dialogWindow.document.getElementById("BTN_4");
	const Btn5  = dialogWindow.document.getElementById("BTN_5");
	const Btn6  = dialogWindow.document.getElementById("BTN_6");
	const Btn7  = dialogWindow.document.getElementById("BTN_7");

	const Btn10 = dialogWindow.document.getElementById("BTN_10");
	const Btn11 = dialogWindow.document.getElementById("BTN_11");
	const Btn12 = dialogWindow.document.getElementById("BTN_12");
	const Btn13 = dialogWindow.document.getElementById("BTN_13");
	const Btn14 = dialogWindow.document.getElementById("BTN_14");
	const Btn15 = dialogWindow.document.getElementById("BTN_15");
	const Btn16 = dialogWindow.document.getElementById("BTN_16");
	const Btn17 = dialogWindow.document.getElementById("BTN_17");

	const Btn20 = dialogWindow.document.getElementById("BTN_20");
	const Btn21 = dialogWindow.document.getElementById("BTN_21");
	const Btn22 = dialogWindow.document.getElementById("BTN_22");
	const Btn23 = dialogWindow.document.getElementById("BTN_23");
	//const Btn24 = dialogWindow.document.getElementById("BTN_24");
	const Btn25 = dialogWindow.document.getElementById("BTN_25");
	const Btn26 = dialogWindow.document.getElementById("BTN_26");
	const Btn27 = dialogWindow.document.getElementById("BTN_27");

	const BtnPS = dialogWindow.document.getElementById("BTN_PS");


	const BtnOK = dialogWindow.document.getElementById("BTN_OK");
	const BtnNG = dialogWindow.document.getElementById("BTN_NG");

	const BtnSoundPlay = dialogWindow.document.getElementById("BTN_SoundPlay");
	const BtnSoundStop = dialogWindow.document.getElementById("BTN_SoundStop");


	Btn0.addEventListener("click",  () => { InitVar(); dlgBg =ESC._BG_TYPE0[LANGUAGE]; SetEditor( dialogWindow, ESC._DRAW_TEXT[LANGUAGE] ); });
	Btn1.addEventListener("click",  () => { InitVar(); dlgBg =ESC._BG_TYPE1[LANGUAGE]; SetEditor( dialogWindow, ESC._DRAW_TEXT[LANGUAGE] ); });
	Btn2.addEventListener("click",  () => { InitVar(); dlgBg =ESC._BG_TYPE2[LANGUAGE]; SetEditor( dialogWindow, ESC._DRAW_TEXT[LANGUAGE] ); });
	Btn3.addEventListener("click",  () => { InitVar(); SetEditor( dialogWindow, ESC._DRAW_CG[LANGUAGE] ); });
	Btn4.addEventListener("click",  () => { InitVar(); SetEditor( dialogWindow, ESC._CG_DIFF[LANGUAGE] ); });
	Btn5.addEventListener("click",  () => { dlgOverwrite=false; addNewItemAtSelectedPosition(listBox, ESC._DELETE_CG[LANGUAGE]); });
	Btn6.addEventListener("click",  () => { InitVar(); SetEditor( dialogWindow, ESC._CHOICE[LANGUAGE] ); });
	Btn7.addEventListener("click",  () => { InitVar(); SetEditor( dialogWindow, ESC._WAIT[LANGUAGE] ); });

	
	Btn10.addEventListener("click", () => { InitVar(); dlgText0=ESC._FADE_B[LANGUAGE]; SetEditor( dialogWindow, ESC._FADE[LANGUAGE] ); });
	Btn11.addEventListener("click", () => { InitVar(); dlgText0=ESC._FADE_W[LANGUAGE]; SetEditor( dialogWindow, ESC._FADE[LANGUAGE] ); });
	Btn12.addEventListener("click", () => { InitVar(); dlgText0=ESC._FADE_C[LANGUAGE]; SetEditor( dialogWindow, ESC._FADE[LANGUAGE] ); });
	Btn13.addEventListener("click", () => { InitVar(); SetEditor( dialogWindow, ESC._PLAY_SE[LANGUAGE] ); });
	Btn14.addEventListener("click", () => { InitVar(); SetEditor( dialogWindow, ESC._PLAY_BGM[LANGUAGE] ); });
	Btn15.addEventListener("click", () => { InitVar(); SetEditor( dialogWindow, ESC._STOP_BGM[LANGUAGE] ); });
	Btn16.addEventListener("click", () => { InitVar(); SetEditor( dialogWindow, ESC._PLAY_BGS[LANGUAGE] ); });
	Btn17.addEventListener("click", () => { InitVar(); SetEditor( dialogWindow, ESC._STOP_BGS[LANGUAGE] ); });

	Btn20.addEventListener("click", () => { InitVar(); SetEditor( dialogWindow, "コメント" ); });
	Btn21.addEventListener("click", () => { InitVar(); SetEditor( dialogWindow, ESC._BG[LANGUAGE] ); });
	Btn22.addEventListener("click", () => { InitVar(); SetEditor( dialogWindow, ESC._LABEL[LANGUAGE] ); });
	Btn23.addEventListener("click", () => { InitVar(); SetEditor( dialogWindow, ESC._LABELJUMP[LANGUAGE] ); });
	//Btn24.addEventListener("click", () => { InitVar(); SetEditor( dialogWindow, "-----" ); });
	
	//開くボタン
	Btn25.addEventListener("click", () =>	{ 
												//特定のパーツを操作不可に
												SetPartsEnable(dialogWindow, "BTN_AREA", false);
												SetPartsEnable(dialogWindow, "listBox",  false);

												//開くダイアログを表示
												$gameVariables.setValue(1, 0);
												openFileDialog([".xoes", SCENARIO_DIR]);

												//ダイアログウインドウを閉じるまで待つ処理
												const checkInterval = setInterval(() => 
												{
													//「変数1が0から変かした」場合
													if ($gameVariables.value(1) !== 0)
													{
														// チェック停止
														clearInterval(checkInterval);

														//特定のパーツを操作可能に
														SetPartsEnable(dialogWindow, "BTN_AREA", true);
														SetPartsEnable(dialogWindow, "listBox",  true);
														
														//「キャンセルしていない」場合、指定したファイルを開く
														if ($gameVariables.value(1) !== "cancel")
														{
															EventPath = $gameVariables.value(1);
															DialogOpen( dialogWindow, EventPath ); 
															SetListStyle(listBox);
														}
														else
														{ }
													}
												}, 100); // 0.1秒ごとにチェック
											});
	
	//保存ボタン
	Btn26.addEventListener("click", () =>	{
												//特定のパーツを操作不可に
												SetPartsEnable(dialogWindow, "BTN_AREA", false);
												SetPartsEnable(dialogWindow, "listBox",  false);

												//保存ダイアログを表示
												$gameVariables.setValue(1, 0);
												saveFileDialog([".xoes", SCENARIO_DIR]);

												//ダイアログウインドウを閉じるまで待つ処理
												const checkInterval = setInterval(() => 
												{
													//「変数1が0から変かした」場合
													if ($gameVariables.value(1) !== 0)
													{
														// チェック停止
														clearInterval(checkInterval);

														//特定のパーツを操作可能に
														SetPartsEnable(dialogWindow, "BTN_AREA", true);
														SetPartsEnable(dialogWindow, "listBox",  true);

														//「キャンセルしていない」場合、指定したパスでファイルを保存
														if ($gameVariables.value(1) !== "cancel")
														{
															EventPath = $gameVariables.value(1);
															DialogSave( dialogWindow, EventPath );

															console.log(EventPath);
														}
														else
														{ }
													}
												}, 100); // 0.1秒ごとにチェック
											});


	Btn27.addEventListener("click", () => { TestPlay( dialogWindow ); });

	BtnPS.addEventListener("click", () => { InitVar(); SetEditor( dialogWindow, "ポーズ" ); });


	//▼CG差分関係の監視
	const container = dialogWindow.document.getElementById("CG_DIFFERENCE_AREA");
	container.addEventListener('change', function(event) 
	{
		//▽ドロップダウンの監視
		if (event.target.tagName === 'SELECT') 
		{
			// 変更されたドロップダウンのIDと値から、差分表示用の文字列を作成
			str = event.target.id.substring(12) + event.target.value;

			//「編集中状態」の場合のみ、差分を適用
			if($gameVariables.value(61) == "編集中")
			{
				$gameVariables.setValue(61, "CG差分");
				$gameVariables.setValue(62, str);
			}
		}

		//▽チェックボックスの監視
		if (event.target.tagName === 'INPUT') 
		{
			// 変更されたドロップダウンのIDと値を取得
			const dropdownId = event.target.id;
			const selectedValue = event.target.value;
			let str;

			if(event.target.checked == true)
			{ str = "O"+dropdownId.substring(12); }
			else
			{ str = "X"+dropdownId.substring(12); }

			//「編集中状態」の場合のみ、差分を適用
			if($gameVariables.value(61) == "編集中")
			{
				$gameVariables.setValue(61, "CG差分");
				$gameVariables.setValue(62, str);
			}
		}
	});


	//▼背景関係の監視
	const Bgcontainer = dialogWindow.document.getElementById("dropdown_BgFile");
	Bgcontainer.addEventListener('change', function(event) 
	{
		$gameMap.changeParallax(event.target.value ,false ,false ,0 ,0);
	});


	//▼[OK]クリック
	BtnOK.addEventListener("click", () =>
	{
		DecisionEditor(dialogWindow); 
		//文字色などのスタイルを設定
		SetListStyle(listBox);
	});


	//▼[キャンセル]クリック
	BtnNG.addEventListener("click", () =>
	{
		SetEditor( dialogWindow, "x" );
		//再編集した場合の行選択
		SelectReeditIndex( dialogWindow );
	});


	//▼[再生ボタン]クリック
	BtnSoundPlay.addEventListener("click", () =>
	{
		//各種情報を取得
		let file	= dialogWindow.document.getElementById('dropdown_SoundFile').value;
		let volume	= dialogWindow.document.getElementById('input_SoundVolume').value;
		let pitch	= dialogWindow.document.getElementById('input_SoundPitch').value;
		//上限を設定
		volume = Math.max( 1, Math.min(volume, 100) );
		pitch  = Math.max(50, Math.min(pitch,  150) );

		if (file)
		{ 
			switch (dlgEditType) 
			{ 
			case ESC._PLAY_SE["J"]:		PlaySE(file, volume, pitch);	break;
			case ESC._PLAY_SE["E"]:		PlaySE(file, volume, pitch);	break;
			case ESC._PLAY_SE["C"]:		PlaySE(file, volume, pitch);	break;

			case ESC._PLAY_BGM["J"]:	PlayBGM(file, volume, pitch);	break;
			case ESC._PLAY_BGM["E"]:	PlayBGM(file, volume, pitch);	break;
			case ESC._PLAY_BGM["C"]:	PlayBGM(file, volume, pitch);	break;

			case ESC._PLAY_BGS["J"]:	PlayBGS(file, volume, pitch);	break;
			case ESC._PLAY_BGS["E"]:	PlayBGS(file, volume, pitch);	break;
			case ESC._PLAY_BGS["C"]:	PlayBGS(file, volume, pitch);	break;
			}
			
		}
	});


	//▼[停止ボタン]クリック
	BtnSoundStop.addEventListener("click", () =>
	{
		switch (dlgEditType) 
		{ 
		case ESC._PLAY_BGM["J"]:	PlayBGM("", 100, 100);	break;
		case ESC._PLAY_BGM["E"]:	PlayBGM("", 100, 100);	break;
		case ESC._PLAY_BGM["C"]:	PlayBGM("", 100, 100);	break;

		case ESC._PLAY_BGS["J"]:	PlayBGS("", 100, 100);	break;
		case ESC._PLAY_BGS["E"]:	PlayBGS("", 100, 100);	break;
		case ESC._PLAY_BGS["C"]:	PlayBGS("", 100, 100);	break;
		}
	});



	//▼テキストエリアの行数制限
	const textarea0 = dialogWindow.document.getElementById('textarea0');
	textarea0.addEventListener('input', () => 
	{
		// 改行で分割
		const lines = textarea0.value.split(/\r?\n/);

		// 最初の4行に制限
		if (lines.length > 4) 
		{ textarea0.value = lines.slice(0, 4).join("\n"); }
	});



	//=====================================================================
	// ▼ ダブルクリックイベントを監視  
	//=====================================================================
	listBox.addEventListener('dblclick', function () 
	{
		const selectedOption = listBox.options[listBox.selectedIndex];
		if (selectedOption) 
		{
			
		}
	});

	//=====================================================================
	// ▼ ウインドウを閉じたとき
	//=====================================================================
	dialogWindow.onunload = function () 
	{
		//終了スイッチをtrueに
		$gameSwitches.setValue(81, true);
	};


	//=====================================================================
	// ▼ キーの解放を監視  
	//=====================================================================
	function handleKeyup(event) 
	{
		//▼Shiftキー
		if (event.key === 'Shift')
		{
		}

		//▼Spaceキー
		if (event.key === ' ')
		{
			//「リストボックスをフォーカスしている」場合
			if (dialogWindow.document.activeElement === listBox)
			{
				// 選択されているオプションを取得
				const selectedOptions = Array.from(listBox.selectedOptions);

				//「選択されている行が1行だけではない」場合、処理を中断
				if (selectedOptions.length !== 1) 
				{ return; }

				// 選択している行の情報を取得
				let text = selectedOptions[0].textContent;
				
				//「文字列の先頭が"　"」の場合、それを削除する
				while (text.startsWith("　"))
				{ text = text.substring(1); }

				const ary = text.split("/"); // "/" で区切って配列にする


				//結果の上書きフラグはtrueに
				dlgOverwrite = true;
				//現在の行数を取得しておく
				dlgListIndex = listBox.selectedIndex;

				switch (ary[0]) 
				{
				case ESC._DRAW_TEXT["J"]:
				case ESC._DRAW_TEXT["E"]:
				case ESC._DRAW_TEXT["C"]:
					dlgBg = ary[1];
					//1行目
					dlgText0 = ary[2];
					//2行目以降
					if(ary.length >= 4){ dlgText0 += "\n"+ary[3]; }
					if(ary.length >= 5){ dlgText0 += "\n"+ary[4]; }
					if(ary.length >= 6){ dlgText0 += "\n"+ary[5]; }
					SetEditor( dialogWindow, ESC._DRAW_TEXT[LANGUAGE] );
					break;

				case ESC._DRAW_CG["J"]:
				case ESC._DRAW_CG["E"]:
				case ESC._DRAW_CG["C"]:
					dlgText0 = ary[1];
					SetEditor( dialogWindow, ESC._DRAW_CG[LANGUAGE] );
					break;

				case ESC._CG_DIFF["J"]:
				case ESC._CG_DIFF["E"]:
				case ESC._CG_DIFF["C"]:
					dlgText0 = text;
					SetEditor( dialogWindow, ESC._CG_DIFF[LANGUAGE] );
					break;
				
				case ESC._CHOICE["J"]:
				case ESC._CHOICE["E"]:
				case ESC._CHOICE["C"]:
					dlgBg   =  ary[1];
					dlgPos  =  ary[2];
					dlgText0 = ary[3];
					dlgText1 = ary[4];
					dlgText2 = ary[5];
					dlgText3 = ary[6];
					dlgText4 = ary[7];
					SetEditor( dialogWindow, ESC._CHOICE[LANGUAGE] );
					break;
				
				case ESC._WAIT["J"]:
				case ESC._WAIT["E"]:
				case ESC._WAIT["C"]:
					dlgNum0 = ary[1]-0;
					SetEditor( dialogWindow, ESC._WAIT[LANGUAGE] );
					break;

				case ESC._FADE["J"]:
				case ESC._FADE["E"]:
				case ESC._FADE["C"]:
					console.log(ary);
					dlgText0 = ary[1];
					dlgNum0  = ary[2]-0;
					SetEditor( dialogWindow, ESC._FADE[LANGUAGE] );
					break;

				case ESC._PLAY_SE["J"]:
				case ESC._PLAY_SE["E"]:
				case ESC._PLAY_SE["C"]:
					dlgText0 = ary[1];
					dlgNum0  = ary[2]-0;
					dlgNum1  = ary[3]-0;
					SetEditor( dialogWindow, ESC._PLAY_SE[LANGUAGE] );
					break;

				case ESC._PLAY_BGM["J"]:
				case ESC._PLAY_BGM["E"]:
				case ESC._PLAY_BGM["C"]:
					dlgText0 = ary[1];
					dlgNum0  = ary[2]-0;
					dlgNum1  = ary[3]-0;
					SetEditor( dialogWindow, ESC._PLAY_BGM[LANGUAGE] );
					break;

				case ESC._STOP_BGM["J"]:
				case ESC._STOP_BGM["E"]:
				case ESC._STOP_BGM["C"]:
					dlgNum0  = ary[1]-0;
					SetEditor( dialogWindow, ESC._STOP_BGM[LANGUAGE] );
					break;

				case ESC._PLAY_BGS["J"]:
				case ESC._PLAY_BGS["E"]:
				case ESC._PLAY_BGS["C"]:
					dlgText0 = ary[1];
					dlgNum0  = ary[2]-0;
					dlgNum1  = ary[3]-0;
					SetEditor( dialogWindow, ESC._PLAY_BGS[LANGUAGE] );
					break;

				case ESC._STOP_BGS["J"]:
				case ESC._STOP_BGS["E"]:
				case ESC._STOP_BGS["C"]:
					dlgNum0  = ary[1]-0;
					SetEditor( dialogWindow, ESC._STOP_BGS[LANGUAGE] );
					break;

				case "※":
					//1行目
					dlgText0 = ary[1];
					//2行目以降
					if(ary.length >= 3){ dlgText0 += "\n"+ary[2]; }
					if(ary.length >= 4){ dlgText0 += "\n"+ary[3]; }
					if(ary.length >= 5){ dlgText0 += "\n"+ary[4]; }
					SetEditor( dialogWindow, "コメント" );
					break;

				case ESC._BG["J"]:
				case ESC._BG["E"]:
				case ESC._BG["C"]:
					//1行目
					dlgText0 = ary[1];
					//2行目以降
					if(ary.length >= 3){ dlgText0 += "\n"+ary[2]; }
					if(ary.length >= 4){ dlgText0 += "\n"+ary[3]; }
					if(ary.length >= 5){ dlgText0 += "\n"+ary[4]; }
					SetEditor( dialogWindow, ESC._BG[LANGUAGE] );
					break;

				case ESC._LABEL["J"]:
				case ESC._LABEL["E"]:
				case ESC._LABEL["C"]:
					dlgText0 = ary[1];
					SetEditor( dialogWindow, ESC._LABEL[LANGUAGE] );
					break;

				case ESC._LABELJUMP["J"]:
				case ESC._LABELJUMP["E"]:
				case ESC._LABELJUMP["C"]:
					dlgText0 = ary[1];
					SetEditor( dialogWindow, ESC._LABELJUMP[LANGUAGE] );
					break;

				case "ポーズ":
					dlgText0 = ary[1];
					SetEditor( dialogWindow, "ポーズ" );
					break;
				}
			}
		}
	}
	dialogWindow.addEventListener('keyup', handleKeyup);


	//=====================================================================
	// ▼ キーの押下を監視  
	//=====================================================================
	function handleKeydown(event) 
	{
		//▼Deleteキー
		if (event.key === 'Delete' && dlgEnableDelete == true) 
		{ LB_Delete(); }	

		//▼Crrl+Enterキー
		if (event.ctrlKey && event.key === 'Enter') 
		{
			//「ボタンが非表示ではない」
			if( dialogWindow.document.getElementById("BTN_OKNG").style.display != "none" )
			{
				//決定処理
				DecisionEditor(dialogWindow); 
				//文字色などのスタイルを設定
				SetListStyle(listBox);
			}
		}

		//▼Escキー
		if ( event.key === 'Escape' )
		{
			//「ボタンが非表示ではない」
			if( dialogWindow.document.getElementById("BTN_OKNG").style.display != "none" )
			{
				//キャンセル処理
				SetEditor( dialogWindow, "x" ); 
				//再編集した場合の行選択
				SelectReeditIndex( dialogWindow );
			}
		}




		//▼「Ctrl+S」
		if (event.ctrlKey && event.key === 's') 
		{
			let path = dialogWindow.document.getElementById('Title').innerText

			//タイトルが初期値のままの場合、上書き保存させない
			if(path != "-----")
			{
				//保存
				EventPath = path;
				DialogSave( dialogWindow, EventPath );
			}
			else
			{
				PlaySE("Buzzer1");
			}
		}

		//▼「Ctrl+C」
		if (event.ctrlKey && event.key === 'c') 
		{
			LB_Copy();
		}

		//▼「Ctrl+X」
		if (event.ctrlKey && event.key === 'x') 
		{
			LB_Copy();
			LB_Delete();
		}

		//▼「Ctrl+V」
		if (event.ctrlKey && event.key === 'v') 
		{
			//「リストボックスをフォーカスしている」場合
			if (dialogWindow.document.activeElement === listBox)
			{
				if (clipboard) 
				{
					clipboard.forEach(text => 
						{
							const option = dialogWindow.document.createElement('option');
							option.textContent = text;
							// 選択中の位置の前に挿入
							if (listBox.selectedIndex !== -1) {
								listBox.insertBefore(option, listBox.options[listBox.selectedIndex]);
							}
						});

					//リストのスタイルを設定
					SetListStyle(listBox);
				} 
			}
		}
	}
	dialogWindow.addEventListener('keydown', handleKeydown);


	// ▼リストボックスの選択範囲を消去
	function LB_Delete()
	{
			//「リストボックスをフォーカスしている」場合
			if (dialogWindow.document.activeElement === listBox)
			{
				let selectedOptions = listBox.selectedOptions;

				//「選択範囲が0行(選択してない)」場合、処理をしない
				if (selectedOptions.length <= 0) 
				{ return; }

				//▽選択肢用の削除処理---------------------
				//「1行だけ選択している」
				if (selectedOptions.length === 1) 
				{
					//インデント削除
					let selectedText = selectedOptions[0].text.replace(/^　+/, "");

					//「選択している行が"選択肢/"から始まっている」
					if (selectedText.startsWith(ESC._CHOICE[LANGUAGE]+"/")) 
					{
						let startIndex = selectedOptions[0].index;
						let options = listBox.options;
						let indent = 0;
						let endIndex = -1;

						// ** 対応する "選択肢終" を探す **
						for (let i=startIndex+1; i<options.length; i++) 
						{
							//インデント削除
							let text = options[i].text.replace(/^　+/, "");

							if (text.startsWith(ESC._CHOICE[LANGUAGE]+"/")) 
							{
								indent++; // ネストの開始
							}
							if (text.startsWith(ESC._CHOICE_END[LANGUAGE])) 
							{
								if (indent === 0) 
								{
									endIndex = i;
									break;
								} 
								else 
								{
									indent--; // ネストを閉じる
								}
							}
						}

						//「選択肢終」が見つからなかった場合、リストの最後の行まで削除する
						if (endIndex === -1) 
						{
							endIndex = options.length - 1;
						}

						//削除後に選択する行を決定（削除範囲の次の行を優先）
						let newIndex = endIndex + 1 - (endIndex - startIndex + 1);
						if (newIndex >= options.length) 
						{
							newIndex = startIndex > 0 ? startIndex - 1 : -1; // 最後の行なら前の行
						}

						//「選択肢/」から「選択肢終」まで削除 
						for (let i = endIndex; i >= startIndex; i--) 
						{
							listBox.removeChild(options[i]);
						}

						//リストに要素が残っているなら、新しい選択位置を適用
						if (listBox.options.length > 0 && newIndex !== -1)
						{
							listBox.options[Math.min(newIndex, listBox.options.length - 1)].selected = true;
						}

						// ここで処理終了
						return;
					}
				}

				//▽選択肢用の削除処理--------------------
				if(true)
				{
					// 現在の選択位置を記憶
					const firstSelectedIndex = selectedOptions[0].index;

					// 削除対象のリストを作成（スキップ対象を除外）
					let itemsToRemove = Array.from(selectedOptions).filter(option => {
						// 1. 変数から動的に正規表現を作成
						const choiceWord = ESC._CHOICE[LANGUAGE];
						const choiceEndWord = ESC._CHOICE_END[LANGUAGE];

						// 2. 正規表現のパターンを組み立て
						// | は「または」、^ は「先頭」を意味します
						const pattern = new RegExp("^(" + choiceWord + "\\/|①\\/|②\\/|③\\/|④\\/|⑤\\/|" + choiceEndWord + ")");

						// 3. マッチしない（選択肢以外のコマンドである）ものを抽出
						return !option.text.match(pattern);
					});

					// スキップ対象以外が何もない場合は削除処理をしない
					if (itemsToRemove.length === 0) 
					{ return; }

					// 選択されているが削除対象のアイテムのみ削除
					itemsToRemove.forEach(option => 
					{
						listBox.removeChild(option);
					});

					// 削除後の選択状態を更新
					const newItemCount = listBox.options.length;

					if (newItemCount > 0)
					{
						//新しい選択位置を決定
						const newIndex = Math.min(firstSelectedIndex, newItemCount - 1);
						listBox.options[newIndex].selected = true;
					}
				}
			}

	}


	// ▼リストボックスの選択範囲をコピー
	function LB_Copy()
	{
		//「リストボックスをフォーカスしている」場合
		if (dialogWindow.document.activeElement === listBox)
		{
			// コピー機能
			if (listBox.selectedIndex !== -1) 
			{
				// 現在の言語設定に基づいたワードを取得
				const choiceWord = ESC._CHOICE[LANGUAGE];
				const choiceEndWord = ESC._CHOICE_END[LANGUAGE];

				// 動的に正規表現パターンを作成
				const pattern = new RegExp("^(" + choiceWord + "\\/|①\\/|②\\/|③\\/|④\\/|⑤\\/|" + choiceEndWord + ")");

				clipboard = Array.from(listBox.selectedOptions)
					.map(option => option.text.replace(/^　+/, "")) // 先頭の全角スペースを削除
					.filter(text => !text.match(pattern)); // 動的パターンでスキップ対象を除外
			}
		}
	}

}


//=============================================================================================
// ▼ 新しい要素を現在選択している位置に追加する関数
//=============================================================================================
function addNewItemAtSelectedPosition(listBox, newItemText) 
{
	// 現在選択されている項目のインデックスを取得
	const selectedIndex = listBox.selectedIndex;

	// 新しい項目を作成
	const newOption = document.createElement('option');
	newOption.textContent = newItemText;

	// 特定行の取得用
	let selectedOption;
	


	if (selectedIndex >= 0) 
	{
		//「上書きフラグがfalse(新規に追加)」の場合
		if(dlgOverwrite == false)
		{
			// 選択されている位置の前に新しい項目を挿入
			listBox.add(newOption, listBox.options[selectedIndex]);
		}
		//「上書きフラグがtrue(既存の項目を編集)」の場合
		else
		{
			// 指定した行を取得
			selectedOption = listBox.options[selectedIndex];
			// テキストと値を上書き
			selectedOption.text  = newOption.text  ;
			selectedOption.value = newOption.value ;
		}
	}
	else 
	{
		// 選択項目がない場合は末尾に追加
		listBox.appendChild(newOption);
		//ついでに末尾の行を選択しておく
		listBox.selectedIndex = listBox.options.length - 1;
	}
}

//=============================================================================================
// ▼ リストボックスのスタイルを調整
//=============================================================================================
function SetListStyle(listBox) 
{
	let indent = 0;
	let selfindent = 0;
	let text = "";

	// ループ内の処理
	for (let i = 0; i < listBox.options.length; i++) 
	{
		selectedOption = listBox.options[i];
		text = selectedOption.text;

		//「文字列の戦闘が"　"」の場合、それを削除する
		while (text.startsWith("　"))
		{ text = text.substring(1); }


		//
		switch( text.split("/")[0] )
		{
		case "※":					selectedOption.style.color = "green";		break;

		case ESC._PLAY_SE["J"]:
		case ESC._PLAY_SE["E"]:
		case ESC._PLAY_SE["C"]:		selectedOption.style.color = "magenta";		break;

		case ESC._PLAY_BGM["J"]:
		case ESC._PLAY_BGM["E"]:
		case ESC._PLAY_BGM["C"]:	selectedOption.style.color = "magenta";		break;

		case ESC._STOP_BGM["J"]:
		case ESC._STOP_BGM["E"]:
		case ESC._STOP_BGM["C"]:	selectedOption.style.color = "magenta";		break;

		case ESC._PLAY_BGS["J"]:
		case ESC._PLAY_BGS["E"]:
		case ESC._PLAY_BGS["C"]:	selectedOption.style.color = "magenta";		break;

		case ESC._STOP_BGS["J"]:
		case ESC._STOP_BGS["E"]:
		case ESC._STOP_BGS["C"]:	selectedOption.style.color = "magenta";		break;

		case ESC._DRAW_CG["J"]:
		case ESC._DRAW_CG["E"]:
		case ESC._DRAW_CG["C"]:		selectedOption.style.color = "red";			break;

		case ESC._CG_DIFF["J"]:
		case ESC._CG_DIFF["E"]:
		case ESC._CG_DIFF["C"]:		selectedOption.style.color = "red";			break;

		case ESC._DELETE_CG["J"]:
		case ESC._DELETE_CG["E"]:
		case ESC._DELETE_CG["C"]:	selectedOption.style.color = "red";			break;

		case ESC._WAIT["J"]:
		case ESC._WAIT["E"]:
		case ESC._WAIT["C"]:		selectedOption.style.color = "green";		break;

		case ESC._FADE["J"]:
		case ESC._FADE["E"]:
		case ESC._FADE["C"]:		selectedOption.style.color = "purple";		break;

		case ESC._CHOICE["J"]:
		case ESC._CHOICE["E"]:
		case ESC._CHOICE["C"]:
		case "①":
		case "②":
		case "③":
		case "④":
		case "⑤":
		case ESC._CHOICE_END["J"]:
		case ESC._CHOICE_END["E"]:
		case ESC._CHOICE_END["C"]:	selectedOption.style.color = "blue";		break;

		case ESC._LABEL["J"]:
		case ESC._LABEL["E"]:
		case ESC._LABEL["C"]:		selectedOption.style.color = "orange ";		break;

		case ESC._LABELJUMP["J"]:	
		case ESC._LABELJUMP["E"]:	
		case ESC._LABELJUMP["C"]:	selectedOption.style.color = "orange ";		break;
		}


		selfindent = 0;

		//先頭から通しのインデントと、その行だけのインデントを設定
		switch( text.split("/")[0] )
		{
		case ESC._CHOICE["J"]:		indent++;	selfindent=-1;	break;
		case ESC._CHOICE["E"]:		indent++;	selfindent=-1;	break;
		case ESC._CHOICE["C"]:		indent++;	selfindent=-1;	break;
		case "①":								selfindent=-1;	break;
		case "②":								selfindent=-1;	break;
		case "③":								selfindent=-1;	break;
		case "④":								selfindent=-1;	break;
		case "⑤":								selfindent=-1;	break;
		case ESC._CHOICE_END["J"]:	indent--;					break;
		case ESC._CHOICE_END["E"]:	indent--;					break;
		case ESC._CHOICE_END["C"]:	indent--;					break;
		}

		//インデントの分だけ先頭に"　"をつける
		for(let j=0; j<indent+selfindent; j++)
		{ text = "　"+text; }
		selectedOption.text = text;
	}



}

//=============================================================================================
//■■■ 各種設定用変数を初期化 ■■■
//=============================================================================================
function TestPlay( dialogWindow ) 
{
	//「ファイルパスが設定されていない(ファイルが保存されていない)」
	if(dialogWindow.document.getElementById('Title').innerText == "-----")
	{
		PlaySE("Buzzer1");
	}
	//「ファイルパスが設定されている」
	else
	{
		//テストプレイスイッチをtrueに
		$gameSwitches.setValue(82, true);

		//現在の状態を保存
		DialogSave(dialogWindow, dialogWindow.document.getElementById('Title').innerText);

		//実行するイベント名を設定
		EventPath = dialogWindow.document.getElementById('Title').innerText;
	}
}


//=============================================================================================
//■■■ 特定のパーツの選択可/不可を設定 ■■■
//=============================================================================================
function SetPartsEnable(dialog, name, flg) 
{
	let elem = dialog.document.getElementById(name);

	if(flg == true)
	{
		elem.style.pointerEvents	= "auto";	// マウス操作
		elem.style.userSelect		= "auto";	// テキスト選択
		elem.style.opacity			= "1.0";	// 見た目
	}
	else
	{
		elem.style.pointerEvents	= "none";	// マウス操作
		elem.style.userSelect		= "none";	// テキスト選択
		elem.style.opacity			= "0.6";	// 見た目
	}
}



//=============================================================================================
//■■■ 各種設定用変数を初期化 ■■■
//=============================================================================================
function InitVar( ) 
{
	dlgBg		= "";
	dlgPos		= "";
	dlgText0	= "";
	dlgText1	= "";
	dlgText2	= "";
	dlgText3	= "";
	dlgText4	= "";
	dlgNum0		= 0;
	dlgNum1		= 0;
	dlgOverwrite = false;
}

//=============================================================================================
//■■■ 有効なエディターを設定 ■■■
//=============================================================================================
function SetEditor( dialog, type ) 
{
	//一旦全て非表示に
	let parts = [	"MESSAGE_AREA", 
					"CG_DRAW_AREA",
					"CG_DIFFERENCE_AREA",
					"AREA04",
					"AREA05",
					"AREA06",
					"AREA_SOUND_PLAY",
					"AREA_SOUND_PLAY",
					"AREA_SOUND_STOP",
					"AREA_SOUND_PLAY",
					"AREA_SOUND_STOP",
					"AREA12",
					"FILE_OPEN",
					"FILE_SAVE",
					"MAIN_TITLE",
					"AREA_BACKGROUND",
					"AREA_LABEL",
					"POSE_SELECT",
					"BTN_OKNG"];

	for(let i=0; i<parts.length; i++)
	{ dialog.document.getElementById(parts[i]).style.display = "none"; }


	//編集の種類を記憶
	dlgEditType = type;

	//リストボックスを操作不能にし、色を変更
	dialog.document.getElementById("listBox").style.pointerEvents = 'none';
	dialog.document.getElementById("listBox").style.backgroundColor = '#d3d3d3'; // 薄いグレー

	//背景を表示
	dialog.document.getElementById("listBoxOverlay").style.display	= "block"; 


	for(var i=0; i<3; i++)
	{
		let key = "J";

		switch(i)
		{
		case 1:	key="E";	break;
		case 2:	key="C";	break;
		}

		switch (type) 
		{
		case ESC._DRAW_TEXT[key]:	DialogInit_01(dialog);	i=3;	break;
		case ESC._DRAW_CG[key]:		DialogInit_02(dialog);	i=3;	break;
		case ESC._CG_DIFF[key]:		DialogInit_03(dialog);	i=3;	break;
		case ESC._CHOICE[key]:		DialogInit_04(dialog);	i=3;	break;
		case ESC._WAIT[key]:		DialogInit_05(dialog);	i=3;	break;
		case ESC._FADE[key]:		DialogInit_06(dialog);	i=3;	break;
		case ESC._PLAY_SE[key]:		DialogInit_07(dialog);	i=3;	break;
		case ESC._PLAY_BGM[key]:	DialogInit_08(dialog);	i=3;	break;
		case ESC._STOP_BGM[key]:	DialogInit_09(dialog);	i=3;	break;
		case ESC._PLAY_BGS[key]:	DialogInit_10(dialog);	i=3;	break;
		case ESC._STOP_BGS[key]:	DialogInit_11(dialog);	i=3;	break;
		case "コメント":			DialogInit_12(dialog);	i=3;	break;
		case ESC._LABEL[key]:		DialogInit_16(dialog);	i=3;	break;
		case ESC._LABELJUMP[key]:	DialogInit_16(dialog);	i=3;	break;
		case "開く":				DialogInit_13(dialog);	i=3;	break;
		case "保存":				DialogInit_14(dialog);	i=3;	break;
		case ESC._BG[key]:			DialogInit_15(dialog);	i=3;	break;
		case "ポーズ":				DialogInit_PS(dialog);	i=3;	break;

		default:
			if(i==2)
			{
				//ボタンを表示
				dialog.document.getElementById("BTN_AREA").style.display		= "block"; 
				//背景を非表示
				dialog.document.getElementById("listBoxOverlay").style.display	= "none"; 
				//リストボックスを操作可能にし、色を変更
				dialog.document.getElementById("listBox").style.pointerEvents = 'auto';
				dialog.document.getElementById("listBox").style.backgroundColor = '#ffffff'; // 薄いグレー
			}
			break;
		}
	}

}

//=============================================================================================
//■■■ エディターの決定処理 ■■■
//=============================================================================================
function DecisionEditor( dialog ) 
{
	for(var i=0; i<3; i++)
	{
		let key = "J";

		switch(i)
		{
		case 1:	key="E";	break;
		case 2:	key="C";	break;
		}
		switch (dlgEditType) 
		{ 
		case ESC._DRAW_TEXT[key]:	DialogDecision_01(dialog);	i=3;	break;
		case ESC._DRAW_CG[key]:		DialogDecision_02(dialog);	i=3;	break;
		case ESC._CG_DIFF[key]:		DialogDecision_03(dialog);	i=3;	break;
		case ESC._CHOICE[key]:		DialogDecision_04(dialog);	i=3;	break;
		case ESC._WAIT[key]:		DialogDecision_05(dialog);	i=3;	break;
		case ESC._FADE[key]:		DialogDecision_06(dialog);	i=3;	break;
		case ESC._PLAY_SE[key]:		DialogDecision_07(dialog);	i=3;	break;
		case ESC._PLAY_BGM[key]:	DialogDecision_08(dialog);	i=3;	break;
		case ESC._STOP_BGM[key]:	DialogDecision_09(dialog);	i=3;	break;
		case ESC._PLAY_BGS[key]:	DialogDecision_10(dialog);	i=3;	break;
		case ESC._STOP_BGS[key]:	DialogDecision_11(dialog);	i=3;	break;
		case "コメント":			DialogDecision_12(dialog);	i=3;	break;
		case "開く":				DialogDecision_13(dialog);	i=3;	break;
		case "保存":				DialogDecision_14(dialog);	i=3;	break;
		case ESC._BG[key]:			DialogDecision_15(dialog);	i=3;	break;
		case ESC._LABEL[key]:		DialogDecision_16(dialog);	i=3;	break;
		case ESC._LABELJUMP[key]:	DialogDecision_16(dialog);	i=3;	break;
		case "ポーズ":				DialogDecision_PS(dialog);	i=3;	break;

		}
	}

	SetEditor( dialog, "x" );

	//再編集した場合の行選択
	SelectReeditIndex( dialog );
}


//=============================================================================================
//■■■ それより前のCG差分を適用 ■■■
//=============================================================================================
function SetBeforeDifference( listbox ) 
{
	let index = listbox.selectedIndex;

	//「リストを選択していない」場合、処理をしない
	if(index < 0)
	{ return; }


	// カーソル位置より前の行をループして探索
	for (let i=index; i>=0; i--)
	{
		// 現在の行のテキストを取得
		let text = listbox.options[i].text;
		
		//「文字列の戦闘が"　"」の場合、それを削除する
		while (text.startsWith("　"))
		{ text = text.substring(1); }

		// "CG差分"で始まる行かをチェック
		if (text.startsWith(ESC._CG_DIFF["J"]) ||
			text.startsWith(ESC._CG_DIFF["E"]) ||
			text.startsWith(ESC._CG_DIFF["C"]) ) 
		{
			let ary = text.split("/");

			for(var j=1; j<ary.length; j++)
			{ MgrCG.DifferenceByStr(ary[j]); }

			//見つけたらループを終了
			break;
		}
	}
}

//=============================================================================================
//■■■ 選択範囲を追加で拡張する処理 ■■■
//=============================================================================================
function expandSelectionIfNeeded(listBox)
{
	// 現在選択されている項目のインデックスを全部取得
	const selectedIndices = Array.from(listBox.options)
	.map((opt, i) => opt.selected ? i : -1)
	.filter(i => i >= 0);

	// 選択されている行のなかで、テキストが「選択肢/」で始まるものを探す
	for (const i of selectedIndices) 
	{
		const text = listBox.options[i].text;
		if (text.startsWith(ESC._CHOICE[LANGUAGE]+"/")) 
		{
			// 対応する「選択肢終」を探し、インデックスを返す関数
			const endIndex = findMatchingEndIndex(listBox, i);

			if (endIndex !== -1) 
			{
				// 見つかったら、i～endIndex の範囲をすべて選択状態にする
				for (let idx = i; idx <= endIndex; idx++) 
				{
					listBox.options[idx].selected = true;
				}
			}
		}
	}
}


//=============================================================================================
//■■■ 再編集したリストボックスの行を選択 ■■■
//=============================================================================================
function SelectReeditIndex( dialog ) 
{
	//「上書きフラグがtrue(既存の項目を編集)」の場合
	if(dlgOverwrite == true)
	{
		const list = dialog.document.getElementById('listBox');
		list.focus();
		list.selectedIndex = dlgListIndex;
	}
}

/**
 * 「選択肢/」で始まる行のインデックス startIndex に対応する
 * 「選択肢終」で始まる行のインデックスを、ネストを考慮して探す関数
 * 見つからなければ -1 を返す
 */
function findMatchingEndIndex(listBox, startIndex) 
{
	let depth = 0;
	for (let i = startIndex; i < listBox.options.length; i++) 
	{
		const lineText = listBox.options[i].text;

		// 「選択肢/」なら深さを1つ増やす
		if (lineText.startsWith(ESC._CHOICE[LANGUAGE]+"/")) 
		{
			depth++;
		}
		// 「選択肢終」なら深さを1つ減らす
		else if (lineText.startsWith(ESC._CHOICE_END[LANGUAGE])) 
		{
			depth--;
			// 深さが0に戻ったところがペアになる「選択肢終」
			if (depth === 0) 
			{
				return i;
			}
		}
	}
	// 見つからなかった場合
	return -1;
}

//=============================================================================================
//■■■ ドロップダウンに要素を追加 ■■■
//=============================================================================================
function AddDropdown( dd, str ) 
{
	// 新しい <option> を作成
	let op = document.createElement('option');

	op.value		= str;	// value属性（内部データ）
	op.textContent	= str;	// 表示されるテキスト

	dd.appendChild(op);

}

//=============================================================================================
// ■■■ プラグインコマンドを追加 ■■■
//=============================================================================================
const _Game_Interpreter_pluginCommand = Game_Interpreter.prototype.pluginCommand;
Game_Interpreter.prototype.pluginCommand = function (command, args) {
	_Game_Interpreter_pluginCommand.call(this, command, args);

	if (command === "CreateExternalDialog") {
		createExternalDialog();
	}
};



// グローバル関数として登録
window.dlgEditType	= 0;

window.dlgBg		= 0;
window.dlgPos		= 0;

window.dlgText0		= 0;
window.dlgText1		= 0;
window.dlgText2		= 0;
window.dlgText3		= 0;
window.dlgText4		= 0;
window.dlgNum0		= 0;
window.dlgNum1		= 0;
window.dlgOverwrite	= false;
window.dlgListIndex = 0;


window.BTNs		= 0;
