/*:
 * @plugindesc 文章表示用のダイアログボックス管理
 * @target MV
 * @help
 * 
 */

(function() 
{
	//---------------------------------------------------------------------------------------------
	//■■■ ダイアログ初期化 ■■■
	//---------------------------------------------------------------------------------------------
	DialogInit_01 = function( dialog ) 
	{
	
		//▼ボタンを非表示に
		dialog.document.getElementById("BTN_AREA").style.display = "none"; 

		

		//▼エディター部分を有効に
		dialog.document.getElementById("MESSAGE_AREA").style.display = "block"; 
		dialog.document.getElementById("BTN_OKNG").style.display = "block"; 
		dialog.document.getElementById("MAIN_TITLE").style.display = "block"; 
		dialog.document.getElementById("MAIN_TITLE").textContent = DLG_TEXTS.DRAW_TEXT._TITLE;


		//▼ラジオボタン(背景の種類)の初期値を設定
		let radioButtons = dialog.document.getElementsByName('radioGroup0');

		//一旦初期値を設定
		radioButtons[0].checked = true;

		//dlgBgと一致する項目に設定
		for (let i = 0; i < radioButtons.length; i++) 
		{
			if (radioButtons[i].value === dlgBg) 
			{
				// 一致する場合にチェックを付ける
				radioButtons[i].checked = true;
				// 一致したらループを終了
				break;
			}
		}


		//▼テキストエリア(本文)の初期値を設定
		let textarea = dialog.document.getElementById('textarea0');
		//初期値を設定
		textarea.value = dlgText0;
		// テキストエリアを選択状態にする
		textarea.focus();

	}

	//---------------------------------------------------------------------------------------------
	//■■■ ダイアログ決定 ■■■
	//---------------------------------------------------------------------------------------------
	DialogDecision_01 = function( dialog ) 
	{
		//▼テキストエリアの値を取得
		let text = dialog.document.getElementById('textarea0').value;

		//▼ラジオボタンの値を取得
		const selectedRadio = dialog.document.querySelector('input[name="radioGroup0"]:checked');
		const selectedRadioValue = selectedRadio ? selectedRadio.value : null;



		//▼リストボックスに追加
		if( text != "")
		{
			text = ESC._DRAW_TEXT[LANGUAGE]+"/" + selectedRadioValue + "/" + text.replace(/\n/g, "/");
			addNewItemAtSelectedPosition(dialog.document.getElementById('listBox'), text);
		
		}


		//▼ボタンを表示
		dialog.document.getElementById("BTN_AREA").style.display = "block"; 

		//▼特定のボタンにフォーカスしておく
		switch(selectedRadioValue)
		{
		case ESC._BG_TYPE0[LANGUAGE]:	dialog.document.getElementById('BTN_0').focus();	break;
		case ESC._BG_TYPE1[LANGUAGE]:	dialog.document.getElementById('BTN_1').focus();	break;
		case ESC._BG_TYPE2[LANGUAGE]:	dialog.document.getElementById('BTN_2').focus();	break;
		}
	}

})();


