/*:
 * @plugindesc CG表示用のダイアログボックス管理
 * @target MV
 * @help
 * 
 */

(function() 
{
	//---------------------------------------------------------------------------------------------
	//■■■ ダイアログ初期化 ■■■
	//---------------------------------------------------------------------------------------------
	DialogInit_02 = function( dialog ) 
	{
		//▼ボタンを非表示に
		dialog.document.getElementById("BTN_AREA").style.display = "none"; 

		//▼エディター部分を有効に
		dialog.document.getElementById("CG_DRAW_AREA").style.display = "block"; 
		dialog.document.getElementById("BTN_OKNG").style.display = "block"; 
		dialog.document.getElementById("MAIN_TITLE").style.display = "block"; 
		dialog.document.getElementById("MAIN_TITLE").textContent = DLG_TEXTS.DRAW_CG._TITLE;
	}

	//---------------------------------------------------------------------------------------------
	//■■■ ダイアログ決定 ■■■
	//---------------------------------------------------------------------------------------------
	DialogDecision_02 = function( dialog ) 
	{
		//▼ドロップダウンリストの値を取得
		let text = dialog.document.getElementById('dropdownCg').value;

		//▼リストボックスに追加
		if(text != "")
		{
			addNewItemAtSelectedPosition(dialog.document.getElementById('listBox'), ESC._DRAW_CG[LANGUAGE]+"/" + text);
		}

		//「編集中状態」の場合のみ、CGを再表示
		if($gameVariables.value(61) == "編集中")
		{
			//ゲーム画面の方にCGを表示させる処理
			$gameVariables.setValue(61, "CG表示");
			$gameVariables.setValue(62, text);
		}


		//▼ボタンを表示
		dialog.document.getElementById("BTN_AREA").style.display = "block"; 

		//▼特定のボタンにフォーカスしておく
		//let btn = dialog.document.getElementById('BTN_0');
		//btn.focus();
	}

})();


