/*:
 * @plugindesc CG差分用のダイアログボックス管理
 * @target MV
 * @help
 * 
 */

(function() 
{
	//---------------------------------------------------------------------------------------------
	//■■■ ダイアログ初期化 ■■■
	//---------------------------------------------------------------------------------------------
	DialogInit_03 = function( dialog ) 
	{
		//▼ボタンを非表示に
		dialog.document.getElementById("BTN_AREA").style.display = "none"; 

		//▼エディター部分を有効に
		dialog.document.getElementById("CG_DIFFERENCE_AREA").style.display = "block"; 
		dialog.document.getElementById("BTN_OKNG").style.display = "block"; 
		dialog.document.getElementById("BTN_OK").style.top = "720px"; 
		dialog.document.getElementById("BTN_NG").style.top = "720px"; 
		dialog.document.getElementById("MAIN_TITLE").style.display = "block"; 
		dialog.document.getElementById("MAIN_TITLE").textContent = DLG_TEXTS.CG_DIFF._TITLE;


		//各種ラジオボタンの初期値を設定
		let dd;
		
		dd = dialog.document.getElementById("dropdown_03_A");
		dd.value = MgrCG.emotEyebrow;

		dd = dialog.document.getElementById("dropdown_03_B");
		dd.value = MgrCG.emotEyeR;

		dd = dialog.document.getElementById("dropdown_03_C");
		dd.value = MgrCG.emotEyeL;

		dd = dialog.document.getElementById("dropdown_03_D");
		dd.value = MgrCG.emotPupil;

		dd = dialog.document.getElementById("dropdown_03_E");
		dd.value = MgrCG.emotMouth;

		dd = dialog.document.getElementById("dropdown_03_F");
		dd.value = MgrCG.emotHoho;

		dd = dialog.document.getElementById("dropdown_03_G");
		dd.value = MgrCG.emotVagina;

		dd = dialog.document.getElementById("dropdown_03_H");
		dd.value = MgrCG.emotPenis;

		dd = dialog.document.getElementById("dropdown_03_I");
		dd.value = MgrCG.emotBaby;

		dd = dialog.document.getElementById("dropdown_03_J");
		dd.value = MgrCG.emotHL;



		dialog.document.getElementById("checkbox_03_0").checked = MgrCG.emotEffect[0];
		dialog.document.getElementById("checkbox_03_1").checked = MgrCG.emotEffect[1];
		dialog.document.getElementById("checkbox_03_2").checked = MgrCG.emotEffect[2];
		dialog.document.getElementById("checkbox_03_3").checked = MgrCG.emotEffect[3];
		dialog.document.getElementById("checkbox_03_4").checked = MgrCG.emotEffect[4];
		dialog.document.getElementById("checkbox_03_5").checked = MgrCG.emotEffect[5];
		dialog.document.getElementById("checkbox_03_6").checked = MgrCG.emotEffect[6];
		dialog.document.getElementById("checkbox_03_7").checked = MgrCG.emotEffect[7];
		dialog.document.getElementById("checkbox_03_8").checked = MgrCG.emotEffect[8];
		dialog.document.getElementById("checkbox_03_9").checked = MgrCG.emotEffect[9];
		dialog.document.getElementById("checkbox_03_10").checked = MgrCG.emotEffect[10];
		dialog.document.getElementById("checkbox_03_11").checked = MgrCG.emotEffect[11];
		dialog.document.getElementById("checkbox_03_12").checked = MgrCG.emotEffect[12];
		dialog.document.getElementById("checkbox_03_13").checked = MgrCG.emotEffect[13];
		dialog.document.getElementById("checkbox_03_14").checked = MgrCG.emotEffect[14];
		
		dialog.document.getElementById("checkbox_03_15").checked = MgrCG.isBote();

		dialog.document.getElementById("checkbox_03_16").checked = MgrCG.emotEffect[16];
		dialog.document.getElementById("checkbox_03_17").checked = MgrCG.emotEffect[17];
		dialog.document.getElementById("checkbox_03_18").checked = MgrCG.emotEffect[18];
		dialog.document.getElementById("checkbox_03_19").checked = MgrCG.emotEffect[19];


		//出産の時だけ、赤ちゃん選択肢を有効にする
		if (MgrCG.title == gCgType[4])
		{ dialog.document.getElementById("dropdown_03_I").disabled = false; }
		else
		{ dialog.document.getElementById("dropdown_03_I").disabled = true; }

	}

	//---------------------------------------------------------------------------------------------
	//■■■ ダイアログ決定 ■■■
	//---------------------------------------------------------------------------------------------
	DialogDecision_03 = function( dialog ) 
	{

		let text = "";
		//▼ドロップダウンの値を取得
		text += "A" + dialog.document.getElementById('dropdown_03_A').value + "/";
		text += "B" + dialog.document.getElementById('dropdown_03_B').value + "/";
		text += "C" + dialog.document.getElementById('dropdown_03_C').value + "/";
		text += "D" + dialog.document.getElementById('dropdown_03_D').value + "/";
		text += "E" + dialog.document.getElementById('dropdown_03_E').value + "/";
		text += "F" + dialog.document.getElementById('dropdown_03_F').value + "/";
		text += "G" + dialog.document.getElementById('dropdown_03_G').value + "/";
		text += "H" + dialog.document.getElementById('dropdown_03_H').value + "/";
		text += "I" + dialog.document.getElementById('dropdown_03_I').value + "/"
		text += "J" + dialog.document.getElementById('dropdown_03_J').value;


		//チェックボックスの値を取得
		//※チェックボックスの数はとりあえず20にしておく
		for(var i=0; i<20; i++)
		{
			let c = dialog.document.getElementById("checkbox_03_"+i);

			if (c == null) 
			{ continue; }

			if (c.checked) 
			{ text += "/O" + i; }
			else
			{ text += "/X" + i; }
		}

		addNewItemAtSelectedPosition(dialog.document.getElementById('listBox'), ESC._CG_DIFF[LANGUAGE]+"/" + text);



		//ゲーム画面の方にCGの差分を適用させる処理
		$gameVariables.setValue(61, "CG差分");
		$gameVariables.setValue(62, text);



		//▼ボタンを表示
		dialog.document.getElementById("BTN_AREA").style.display = "block"; 

		//▼特定のボタンにフォーカスしておく
		//let btn = dialog.document.getElementById('BTN_0');
		//btn.focus();
	}

})();


