/*:
 * @plugindesc 選択肢用のダイアログボックス管理
 * @target MV
 * @help
 * 
 */

(function() 
{
	//---------------------------------------------------------------------------------------------
	//■■■ ダイアログ初期化 ■■■
	//---------------------------------------------------------------------------------------------
	DialogInit_04 = function( dialog ) 
	{
		//▼ボタンを非表示に
		dialog.document.getElementById("BTN_AREA").style.display = "none"; 

		//▼エディター部分を有効に
		dialog.document.getElementById("AREA04").style.display = "block"; 
		dialog.document.getElementById("BTN_OKNG").style.display = "block"; 
		dialog.document.getElementById("MAIN_TITLE").style.display = "block"; 
		dialog.document.getElementById("MAIN_TITLE").textContent = DLG_TEXTS.CHOICE._TITLE;


		//▼ラジオボタン(背景の種類)の初期値を設定
		let radioButtons = dialog.document.getElementsByName('radioGroup_04_0');

		//一旦初期値を設定
		radioButtons[0].checked = true;
		//dlgBgと一致する項目に設定
		for (let i = 0; i < radioButtons.length; i++) 
		{
			if (radioButtons[i].value === dlgBg) 
			{
				// 一致する場合にチェックを付ける
				radioButtons[i].checked = true;
				// 一致したらループを終了
				break;
			}
		}
		
		//▼ラジオボタン(表示位置の種類)の初期値を設定
		radioButtons = dialog.document.getElementsByName('radioGroup_04_1');

		//一旦初期値を設定
		radioButtons[0].checked = true;
		//dlgBgと一致する項目に設定
		for (let i = 0; i < radioButtons.length; i++) 
		{
			if (radioButtons[i].value === dlgPos) 
			{
				// 一致する場合にチェックを付ける
				radioButtons[i].checked = true;
				// 一致したらループを終了
				break;
			}
		}


		//▼input(選択肢)の初期値を設定
		let ipt0 = dialog.document.getElementById('input_04_0');
		ipt0.value = dlgText0;
		//選択状態にする
		ipt0.focus();

		let ipt1 = dialog.document.getElementById('input_04_1');
		ipt1.value = dlgText1;

		let ipt2 = dialog.document.getElementById('input_04_2');
		ipt2.value = dlgText2;

		let ipt3 = dialog.document.getElementById('input_04_3');
		ipt3.value = dlgText3;

		let ipt4 = dialog.document.getElementById('input_04_4');
		ipt4.value = dlgText4;

	}

	//---------------------------------------------------------------------------------------------
	//■■■ ダイアログ決定 ■■■
	//---------------------------------------------------------------------------------------------
	DialogDecision_04 = function( dialog ) 
	{
		//▼インプットの値を取得
		//入力されたテキストを取得
		let t = [	dialog.document.getElementById('input_04_0').value,
					dialog.document.getElementById('input_04_1').value,
					dialog.document.getElementById('input_04_2').value,
					dialog.document.getElementById('input_04_3').value,
					dialog.document.getElementById('input_04_4').value];

		let text = "";

		for(let i=0; i<5; i++)
		{ text += "/" + t[i]; }

		//「選択肢が1つも入力されていない」場合、ここで処理終了
		if( text == "/////")
		{ return; }


		//▼ラジオボタンの値を取得
		const r0 = dialog.document.querySelector('input[name="radioGroup_04_0"]:checked').value;
		const r1 = dialog.document.querySelector('input[name="radioGroup_04_1"]:checked').value;
		

		text = ESC._CHOICE[LANGUAGE]+"/" + r0 + "/" + r1 + text;


		let lb = dialog.document.getElementById('listBox');

		//▼リストボックスに追加
		addNewItemAtSelectedPosition(lb, text);

		//「上書き編集」
		if(dlgOverwrite == true)
		{
			// 現在選択中の行インデックス
			let startIndex = lb.selectedIndex+1;
			// 総行数
			let total = lb.options.length;

			let cc = 0;

			// 現在選択行から最終行まで繰り返し
			for (let i = startIndex; i < total; i++) 
			{
				let ary = lb.options[i].text.split("/");


				if(cc == 0)
				{
					console.log("o:"+ary[0]);
					switch( ary[0] )
					{
					case "①": lb.options[i].text = ary[0] + "/" + t[0]; break;
					case "②": lb.options[i].text = ary[0] + "/" + t[1]; break;
					case "③": lb.options[i].text = ary[0] + "/" + t[2]; break;
					case "④": lb.options[i].text = ary[0] + "/" + t[3]; break;
					case "⑤": lb.options[i].text = ary[0] + "/" + t[4]; break;

					case ESC._CHOICE[LANGUAGE]:
						//他の選択肢の内に入ったとしてカウントを+
						cc++;
						break;

					case ESC._CHOICE_END[LANGUAGE]:
						//iを最大数に設定してループを終了
						i = total; 
						break;
					}
				}
				else
				{
					console.log("x:"+ary[0]);
					switch( ary[0] )
					{
					case ESC._CHOICE[LANGUAGE]:
						//他の選択肢の内に入ったとしてカウントを+
						cc++;
						break;

					case ESC._CHOICE_END[LANGUAGE]:
						//他の選択肢の外に出たとしてカウントを-
						cc--;
						break;
					}
				}
			}
		}
		//「上書き編集ではない」
		else
		{
			addNewItemAtSelectedPosition(lb, "①/"+t[0]);
			addNewItemAtSelectedPosition(lb, "②/"+t[1]);
			addNewItemAtSelectedPosition(lb, "③/"+t[2]);
			addNewItemAtSelectedPosition(lb, "④/"+t[3]);
			addNewItemAtSelectedPosition(lb, "⑤/"+t[4]);
			addNewItemAtSelectedPosition(lb, ESC._CHOICE_END[LANGUAGE]);
		}


		//▼ボタンを表示
		dialog.document.getElementById("BTN_AREA").style.display = "block"; 

		//▼特定のボタンにフォーカスしておく
		//let btn = dialog.document.getElementById('BTN_0');
		//btn.focus();
	}

})();





