/*:
 * @plugindesc 待機用のダイアログボックス管理
 * @target MV
 * @help
 * 
 */

(function() 
{
	//---------------------------------------------------------------------------------------------
	//■■■ ダイアログ初期化 ■■■
	//---------------------------------------------------------------------------------------------
	DialogInit_05 = function( dialog ) 
	{
		//▼ボタンを非表示に
		dialog.document.getElementById("BTN_AREA").style.display = "none"; 

		//▼エディター部分を有効に
		dialog.document.getElementById("AREA05").style.display = "block"; 
		dialog.document.getElementById("BTN_OKNG").style.display = "block"; 
		dialog.document.getElementById("MAIN_TITLE").style.display = "block"; 
		dialog.document.getElementById("MAIN_TITLE").textContent = DLG_TEXTS.WAIT._TITLE;


		//▼
		let ipt = dialog.document.getElementById('input_05_0');

		if(dlgNum0 == 0)
		{ ipt.value = ""; }
		else
		{ ipt.value = dlgNum0; }

		//選択状態にする
		ipt.focus();
	}

	//---------------------------------------------------------------------------------------------
	//■■■ ダイアログ決定 ■■■
	//---------------------------------------------------------------------------------------------
	DialogDecision_05 = function( dialog ) 
	{

		//▼インプットの値を取得
		let ipt = dialog.document.getElementById('input_05_0');

		//上限を設定
		ipt.value = Math.min(ipt.value, 999);

		//「待機時間が入力されていない」場合、ここで処理終了
		if( ipt.value <= 0 )
		{ return; }

		//▼リストボックスに追加
		addNewItemAtSelectedPosition(dialog.document.getElementById('listBox'), ESC._WAIT[LANGUAGE]+"/" + ipt.value);


		//▼ボタンを表示
		dialog.document.getElementById("BTN_AREA").style.display = "block"; 

		//▼特定のボタンにフォーカスしておく
		//let btn = dialog.document.getElementById('BTN_0');
		//btn.focus();
	}

})();





