/*:
 * @plugindesc フェード用のダイアログボックス管理
 * @target MV
 * @help
 * 
 */

(function() 
{
	//---------------------------------------------------------------------------------------------
	//■■■ ダイアログ初期化 ■■■
	//---------------------------------------------------------------------------------------------
	DialogInit_06 = function( dialog ) 
	{
		//▼ボタンを非表示に
		dialog.document.getElementById("BTN_AREA").style.display = "none"; 

		//▼エディター部分を有効に
		dialog.document.getElementById("AREA06").style.display = "block"; 
		dialog.document.getElementById("BTN_OKNG").style.display = "block"; 
		dialog.document.getElementById("MAIN_TITLE").style.display = "block"; 
		dialog.document.getElementById("MAIN_TITLE").textContent = DLG_TEXTS.FADE._TITLE;

		
		//▼ラジオボタン(背景の種類)の初期値を設定
		let radioButtons = dialog.document.getElementsByName('radioGroup_06_0');

		//console.log(dlgText0);

		//一旦初期値を設定
		radioButtons[0].checked = true;
		//dlgText0と一致する項目に設定
		for (let i = 0; i < radioButtons.length; i++) 
		{
			if (radioButtons[i].value === dlgText0) 
			{
				// 一致する場合にチェックを付ける
				radioButtons[i].checked = true;
				// 一致したらループを終了
				break;
			}
		}

		//▼数値入力枠の初期値を設定		
		let ipt = dialog.document.getElementById('input_06_0');

		if(dlgNum0 == 0)
		{ ipt.value = "1"; }
		else
		{ ipt.value = dlgNum0; }


		//選択状態にする
		ipt.focus();
	}

	//---------------------------------------------------------------------------------------------
	//■■■ ダイアログ決定 ■■■
	//---------------------------------------------------------------------------------------------
	DialogDecision_06 = function( dialog ) 
	{

		//▼ラジオボタンの値を取得
		const r0 = dialog.document.querySelector('input[name="radioGroup_06_0"]:checked').value;

		//▼インプットの値を取得
		let ipt = dialog.document.getElementById('input_06_0');

		//上限を設定
		ipt.value = Math.min(ipt.value, 999);

		//「待機時間が入力されていない」場合、ここで処理終了
		if( ipt.value <= 0 )
		{ return; }


		//▼リストボックスに追加
		addNewItemAtSelectedPosition(dialog.document.getElementById('listBox'), ESC._FADE[LANGUAGE]+"/" + r0 + "/" + ipt.value);



		//▼ボタンを表示
		dialog.document.getElementById("BTN_AREA").style.display = "block"; 

		//▼特定のボタンにフォーカスしておく
		//let btn = dialog.document.getElementById('BTN_0');
		//btn.focus();
	}

})();





