/*:
 * @plugindesc BGM再生用のダイアログボックス管理
 * @target MV
 * @help
 * 
 */


(function() 
{
	//---------------------------------------------------------------------------------------------
	//■■■ ダイアログ初期化 ■■■
	//---------------------------------------------------------------------------------------------
	DialogInit_08 = function( dialog ) 
	{
		//▼ボタンを非表示に
		dialog.document.getElementById("BTN_AREA").style.display = "none"; 

		//▼エディター部分を有効に
		dialog.document.getElementById("AREA_SOUND_PLAY").style.display = "block"; 
		dialog.document.getElementById("BTN_OKNG").style.display = "block"; 
		dialog.document.getElementById("MAIN_TITLE").style.display = "block"; 
		dialog.document.getElementById("MAIN_TITLE").textContent = DLG_TEXTS.SOUND._TITLE1;


		//▼ファイルの種類を設定
		const title = dialog.document.getElementById("soundTitle");
		title.textContent = "BGM名：";


		//▼ドロップダウンにファイル名を追加
		const dropdown = dialog.document.getElementById("dropdown_SoundFile");

		//ドロップダウンの中身を一旦空に
		while (dropdown.firstChild) 
		{ dropdown.removeChild(dropdown.firstChild); }


		// OGGファイルのフォルダパス
		let folderPath; 

		//テストプレイか製品版かでパスを分岐
		if (Utils.isOptionValid('test')) 
		{ folderPath = "audio/bgm/"; }
		else
		{ folderPath = "www/audio/bgm/"; }

		//BGMファイルのリストを作成
		try
		{
			const fs = require("fs");
			const path = require("path");

			// フォルダ内のファイルを取得
			const files = fs.readdirSync(folderPath);

			files.forEach(file => {
				if (path.extname(file).toLowerCase() === ".ogg") 
				{
					const fileNameWithoutExt = path.basename(file, ".ogg"); // 拡張子を除いたファイル名
					const option = dialog.document.createElement("option");
					option.value       = fileNameWithoutExt;
					option.textContent = fileNameWithoutExt; // 表示名を設定

					dropdown.appendChild(option); // ドロップダウンに追加
				}
			});
		}
		catch (error)
		{
			console.error("フォルダ内のファイルを読み込めませんでした:", error);
		}
		//選択状態にする
		dropdown.focus();


		//▼ドロップダウンの初期値を設定
		for (let i = 0; i < dropdown.options.length; i++)
		{
			if (dropdown.options[i].value == dlgText0)
			 {
				dropdown.selectedIndex = i;
				break;
			 }
		}

		//▼数値入力枠の初期値を設定		
		let ipt = dialog.document.getElementById('input_SoundVolume');
		if(dlgNum0 == 0){ ipt.value = 100; }
		else			{ ipt.value = dlgNum0; }

		ipt = dialog.document.getElementById('input_SoundPitch');
		if(dlgNum1 == 0){ ipt.value = 100; }
		else			{ ipt.value = dlgNum1; }

	}

	//---------------------------------------------------------------------------------------------
	//■■■ ダイアログ決定 ■■■
	//---------------------------------------------------------------------------------------------
	DialogDecision_08 = function( dialog ) 
	{
		//▼ドロップダウンリストの値を取得
		let filename = dialog.document.getElementById('dropdown_SoundFile').value;

		if(filename == "")
		{ return; }


		//▼インプットの値を取得
		let volume	= dialog.document.getElementById('input_SoundVolume').value;
		let pitch	= dialog.document.getElementById('input_SoundPitch').value;

		//上限を設定
		volume = Math.max( 1, Math.min(volume, 100) );
		pitch  = Math.max(50, Math.min(pitch,  150) );



		//▼リストボックスに追加
		addNewItemAtSelectedPosition(dialog.document.getElementById('listBox'), ESC._PLAY_BGM[LANGUAGE]+"/" + filename + "/" + volume + "/" +pitch);



		//▼ボタンを表示
		dialog.document.getElementById("BTN_AREA").style.display = "block"; 

		//▼特定のボタンにフォーカスしておく
		//let btn = dialog.document.getElementById('BTN_0');
		//btn.focus();
	}

})();





