/*:
 * @plugindesc BGM停止用のダイアログボックス管理
 * @target MV
 * @help
 * 
 */


(function() 
{
	//---------------------------------------------------------------------------------------------
	//■■■ ダイアログ初期化 ■■■
	//---------------------------------------------------------------------------------------------
	DialogInit_09 = function( dialog ) 
	{
		//▼ボタンを非表示に
		dialog.document.getElementById("BTN_AREA").style.display = "none"; 

		//▼エディター部分を有効に
		dialog.document.getElementById("AREA_SOUND_STOP").style.display = "block"; 
		dialog.document.getElementById("BTN_OKNG").style.display = "block"; 
		dialog.document.getElementById("MAIN_TITLE").style.display = "block"; 
		dialog.document.getElementById("MAIN_TITLE").textContent = DLG_TEXTS.SOUND._TITLE3;


		//▼数値入力枠の初期値を設定		
		let ipt = dialog.document.getElementById('input_SoundStopFrame');
		if(dlgNum0 == 0){ ipt.value = 1; }
		else			{ ipt.value = dlgNum0; }

		//選択状態にする
		ipt.focus();
	}

	//---------------------------------------------------------------------------------------------
	//■■■ ダイアログ決定 ■■■
	//---------------------------------------------------------------------------------------------
	DialogDecision_09 = function( dialog ) 
	{
		//▼インプットの値を取得
		let frame	= dialog.document.getElementById('input_SoundStopFrame').value;

		//下限・上限を設定
		frame = Math.max( 0, Math.min(frame, 100) );

		//▼リストボックスに追加
		addNewItemAtSelectedPosition(dialog.document.getElementById('listBox'), ESC._STOP_BGM[LANGUAGE]+"/" + frame);



		//▼ボタンを表示
		dialog.document.getElementById("BTN_AREA").style.display = "block"; 

		//▼特定のボタンにフォーカスしておく
		//let btn = dialog.document.getElementById('BTN_0');
		//btn.focus();
	}

})();





