/*:
 * @plugindesc コメント用のダイアログボックス管理
 * @target MV
 * @help
 * 
 */

(function() 
{
	//---------------------------------------------------------------------------------------------
	//■■■ ダイアログ初期化 ■■■
	//---------------------------------------------------------------------------------------------
	DialogInit_12 = function( dialog ) 
	{
		//▼ボタンを非表示に
		dialog.document.getElementById("BTN_AREA").style.display = "none"; 

		//▼エディター部分を有効に
		dialog.document.getElementById("AREA12").style.display = "block"; 
		dialog.document.getElementById("BTN_OKNG").style.display = "block"; 
		dialog.document.getElementById("MAIN_TITLE").style.display = "block"; 
		dialog.document.getElementById("MAIN_TITLE").textContent = DLG_TEXTS.COMMENT._TITLE;


		//▼テキストエリア(本文)の初期値を設定
		let textarea = dialog.document.getElementById('textarea12');
		//初期値を設定
		textarea.value = dlgText0;
		// テキストエリアを選択状態にする
		textarea.focus();

	}

	//---------------------------------------------------------------------------------------------
	//■■■ ダイアログ決定 ■■■
	//---------------------------------------------------------------------------------------------
	DialogDecision_12 = function( dialog ) 
	{
		console.log("12");

		//▼テキストエリアの値を取得
		let text = dialog.document.getElementById('textarea12').value;


		//▼リストボックスに追加
		if( text != "")
		{
			text = "※/" + text.replace(/\n/g, "/");
			addNewItemAtSelectedPosition(dialog.document.getElementById('listBox'), text);
		}
	}

})();


