/*:
 * @plugindesc ファイルを開くダイアログボックス管理
 * @target MV
 * @help
 * 
 */

(function() 
{

	//---------------------------------------------------------------------------------------------
	//■■■ ダイアログ初期化 ■■■
	//---------------------------------------------------------------------------------------------
	DialogInit_13 = function( dialog ) 
	{

	}

	//---------------------------------------------------------------------------------------------
	//■■■ ダイアログ決定 ■■■
	//---------------------------------------------------------------------------------------------
	DialogDecision_13 = function( dialog ) 
	{

	}


	//---------------------------------------------------------------------------------------------
	//■■■ 開く ■■■
	//---------------------------------------------------------------------------------------------
	DialogOpen = function( dialog, path ) 
	{
		//現在のファイル名・タイトルを変更
		dialog.document.getElementById('Title').innerText = path;
		
		const fs = require("fs");
		try 
		{
			const content = fs.readFileSync(path, "utf8");

			// リストボックスの全てのオプションを削除
			let lb = dialog.document.getElementById("listBox");
			lb.options.length = 0;

			// テキストを1行ずつリストボックスに追加
			const lines = content.split("\n"); // 改行で分割

			lines.forEach(line => 
			{
				if (line.trim())
				{
					// 空行を無視する場合
					const option = document.createElement("option");
					option.textContent = line.trim();
					lb.appendChild(option);
				}
			});


			PlaySE("Load");
		}
		catch (error)
		{
			console.error("ファイルの読み込み中にエラーが発生しました:", error);
		}


		//▼CGを表示
		// リストボックス要素を取得
		let lb = dialog.document.getElementById("listBox");

		// 全ての項目を取得
		let options = lb.options;

		// "CG表示"から始まる行を確認
		for (let i = 0; i < options.length; i++) 
		{
			let text = options[i].text;

			if (text.startsWith(ESC._DRAW_CG["J"]+"/") ||
				text.startsWith(ESC._DRAW_CG["E"]+"/") ||
				text.startsWith(ESC._DRAW_CG["C"]+"/") ) 
			{
				$gameVariables.setValue(61, "CG表示")
				$gameVariables.setValue(62, text.split("/")[1] );

				break;
			}
		}
	}







	

})();


