/*:
 * @plugindesc ファイルを保存するダイアログボックス管理
 * @target MV
 * @help
 * 
 */



(function() 
{
	//---------------------------------------------------------------------------------------------
	//■■■ ダイアログ初期化 ■■■
	//---------------------------------------------------------------------------------------------
	DialogInit_14 = function( dialog ) 
	{
	}

	//---------------------------------------------------------------------------------------------
	//■■■ 文章表示ダイアログ決定 ■■■
	//---------------------------------------------------------------------------------------------
	DialogDecision_14 = function( dialog ) 
	{

	}


	//---------------------------------------------------------------------------------------------
	//■■■ 保存 ■■■
	//---------------------------------------------------------------------------------------------
	DialogSave = function( dialog, title ) 
	{
		//現在のファイル名・タイトルを変更
		dialog.document.getElementById('Title').innerText = title;


		//中身のテキストを作成
		let content = "";

		// リストボックスの全オプションを取得
		let lb = dialog.document.getElementById('listBox');
		for (let i = 0; i < lb.options.length; i++) 
		{ content += lb.options[i].textContent + "\n"; }

		// 最後の改行を削除する
		content = content.trim();

		//ファイルを保存
		fs.writeFileSync(title, content, 'utf8');
		console.log(`ファイルが保存されました: ${title}`);

		PlaySE("Save");
	}

})();
