/*:
 * @plugindesc 背景変更用のダイアログボックス管理
 * @target MV
 * @help
 * 
 */


(function() 
{
	//---------------------------------------------------------------------------------------------
	//■■■ ダイアログ初期化 ■■■
	//---------------------------------------------------------------------------------------------
	DialogInit_15 = function( dialog ) 
	{

		//▼ボタンを非表示に
		dialog.document.getElementById("BTN_AREA").style.display = "none"; 

		//▼エディター部分を有効に
		dialog.document.getElementById("AREA_BACKGROUND").style.display = "block"; 
		dialog.document.getElementById("BTN_OKNG").style.display = "block"; 
		dialog.document.getElementById("MAIN_TITLE").style.display = "block"; 
		dialog.document.getElementById("MAIN_TITLE").textContent = DLG_TEXTS.BACKGROUND._TITLE;



		//▼ドロップダウンにファイル名を追加
		const dropdown = dialog.document.getElementById("dropdown_BgFile");

		//ドロップダウンの中身を一旦空に
		while (dropdown.firstChild) 
		{ dropdown.removeChild(dropdown.firstChild); }




		// 背景ファイルのフォルダパス
		let folderPath;
		let extension;

		//テストプレイか製品版かでパスを分岐
		if (Utils.isOptionValid('test')) 
		{
			folderPath = "img/parallaxes/"; 
			extension  = ".png";
		}
		else
		{
			folderPath = "www/img/parallaxes/";
			extension  = ".rpgmvp";
		}


		//BGSファイルのリストを作成
		try
		{
			const fs = require("fs");
			const path = require("path");

			// フォルダ内のファイルを取得
			const files = fs.readdirSync(folderPath);

			files.forEach(file => {
				if (path.extname(file).toLowerCase() === extension) 
				{
					const fileNameWithoutExt = path.basename(file, extension); // 拡張子を除いたファイル名
					const option = dialog.document.createElement("option");
					option.value       = fileNameWithoutExt;
					option.textContent = fileNameWithoutExt; // 表示名を設定

					dropdown.appendChild(option); // ドロップダウンに追加
				}
			});
		}
		catch (error)
		{
			console.error("フォルダ内のファイルを読み込めませんでした:", error);
		}
		//選択状態にする
		dropdown.focus();

		//▼ドロップダウンの初期値を設定
		for (let i = 0; i < dropdown.options.length; i++)
		{
			if (dropdown.options[i].value == dlgText0)
			 {
				dropdown.selectedIndex = i;
				break;
			 }
		}
	}

	//---------------------------------------------------------------------------------------------
	//■■■ ダイアログ決定 ■■■
	//---------------------------------------------------------------------------------------------
	DialogDecision_15 = function( dialog ) 
	{
		//▼ドロップダウンリストの値を取得
		let filename = dialog.document.getElementById('dropdown_BgFile').value;

		if(filename == "")
		{ return; }



		//▼リストボックスに追加
		addNewItemAtSelectedPosition(dialog.document.getElementById('listBox'), ESC._BG[LANGUAGE]+"/" + filename);



		//▼ボタンを表示
		dialog.document.getElementById("BTN_AREA").style.display = "block"; 

		//▼特定のボタンにフォーカスしておく
		//let btn = dialog.document.getElementById('BTN_0');
		//btn.focus();
	}

})();





