/*:
 * @plugindesc ラベル・ラベルジャンプ用のダイアログボックス管理
 * @target MV
 * @help
 * 
 */


(function() 
{
	//---------------------------------------------------------------------------------------------
	//■■■ ダイアログ初期化 ■■■
	//---------------------------------------------------------------------------------------------
	DialogInit_16 = function( dialog ) 
	{
		//▼ボタンを非表示に
		dialog.document.getElementById("BTN_AREA").style.display = "none"; 

		//▼エディター部分を有効に
		dialog.document.getElementById("AREA_LABEL").style.display = "block"; 
		dialog.document.getElementById("BTN_OKNG").style.display = "block"; 

		//▼リストボックスに追加
		if(dlgEditType == "ラベル")
		{ dialog.document.getElementById("LabelTitle").textContent = DLG_TEXTS.LABEL._EX0; }
		if(dlgEditType == "ラベルジャンプ")
		{ dialog.document.getElementById("LabelTitle").textContent = DLG_TEXTS.LABEL._EX1; }

		


		//▼テキストエリア(本文)の初期値を設定
		let textarea = dialog.document.getElementById('textareaLavel');
		if (textarea)
		{
			//初期値は空白
			textarea.value = "";

			//設定がある場合、それを設定
			if (dlgText0 != 0)
			{ textarea.value = dlgText0; }

			// テキストエリアを選択状態にする
			textarea.focus();
		}

	}

	//---------------------------------------------------------------------------------------------
	//■■■ ダイアログ決定 ■■■
	//---------------------------------------------------------------------------------------------
	DialogDecision_16 = function( dialog ) 
	{
		//▼ドロップダウンリストの値を取得
		let lavel = dialog.document.getElementById('textareaLavel').value;

		if(lavel == "")
		{ return; }

		console.log(dlgEditType);
		console.log(lavel);


		//▼リストボックスに追加
		addNewItemAtSelectedPosition(dialog.document.getElementById('listBox'), dlgEditType+"/" + lavel);


		//▼ボタンを表示
		dialog.document.getElementById("BTN_AREA").style.display = "block"; 
	}

})();





