

class cEditPanel_C 
{

	//=================================================================================
	//■■■　コンストラクタ　■■■
	//=================================================================================
	constructor()
	{
		//カーソルが有効な箇所
		this.cursorEnable = [1,0,1,1,1,1,0,0,1,1];

		//操作対象のID
		this.targetId = 201;

		//操作モード
		// 0 : 肌
		// 1 : 乳首
		// 2 : 髪
		// 3 : 瞳
		// 4 : 耳
		// 5 : 角
		this.EditMode = 0;
		
		//表示座標
		this.x = 500;
		this.y = 60;

		//カーソル位置
		this.cursorX = 0;
		this.cursorY = 0;


		this.PID_BG		= 70;
		this.PID_TITLE	= 71;
		this.PID_VALUE	= 72;
		this.PID_SAMPLE_0	= 73;
		this.PID_SAMPLE_1	= 74;
		this.PID_SAMPLE_2	= 75;
		this.PID_SAMPLE_3	= 76;
		this.PID_SAMPLE_4	= 77;
		this.PID_SAMPLE_5	= 78;
		this.PID_SAMPLE_6	= 79;
		this.PID_SAMPLE_7	= 80;
		this.PID_SAMPLE_8	= 81;
		this.PID_SAMPLE_9	= 82;
		this.PID_SAMPLE_10= 83;
		this.PID_SAMPLE_11= 84;
		this.PID_CURSOR	= 100;


		//肌色サンプル
		this.SampleColor0 = [	[255,243,219], [243,225,210], [231,207,201],  [231,201,179], [231,195,156], [218,177,149],
						[204,159,144], [179,140,128], [153,120,120],  [137,101,101], [120, 87, 87], [ 72, 54, 54]];
		//乳首色サンプル
		this.SampleColor1 = [	[255,234,234], [255,225,225], [255,216,216],  [243,204,198], [231,189,177], [216,172,157],
						[198,156,138], [180,132,120], [159,108, 99],  [144, 96, 84], [132, 78, 69], [102, 66, 63]];
		//髪色サンプル
		this.SampleColor2 = [	[255,249,153], [255,180,120], [249,123,108],  [240,156,159], [150, 90,159], [135,171,216],
						[135,201,150], [210,168,114], [150,108, 51],  [ 90, 72, 63], [210,210,210], [ 81, 81, 81]];
		//瞳色サンプル
		this.SampleColor3 = [	[255,249,153], [255,180,120], [249,123,108],  [240,156,159], [150, 90,159], [135,171,216],
						[135,201,150], [210,168,114], [150,108, 51],  [ 90, 72, 63], [210,210,210], [ 81, 81, 81]];
		//耳色サンプル
		this.SampleColor4 = [	[255,249,153], [255,180,120], [249,123,108],  [240,156,159], [150, 90,159], [135,171,216],
						[135,201,150], [210,168,114], [150,108, 51],  [ 90, 72, 63], [210,210,210], [ 81, 81, 81]];
		//角色サンプル
		this.SampleColor5 = [	[255,249,153], [255,180,120], [249,123,108],  [240,156,159], [150, 90,159], [135,171,216],
						[135,201,150], [210,168,114], [150,108, 51],  [ 90, 72, 63], [210,210,210], [ 81, 81, 81]];

	}


	//=================================================================================
	//■■■ 初期化 ■■■
	//=================================================================================
	Init(gi)
	{
		this.gi = gi;
	}

	//=================================================================================
	//■■■ 更新 ■■■
	//=================================================================================
	Exec()
	{
		//カーソルの移動
		if( xoInput.isTrigger("up") )
		{
			PlaySE("Cursor1");
			//カーソル位置の変更
			do 
			{
				this.cursorY += 9;
				this.cursorY %= 10;
			}while( this.cursorEnable[this.cursorY] == 0)
			//カーソルの表示
			this.DrawCursor();
			return 0;
		}

		if( xoInput.isTrigger("down") )
		{
			PlaySE("Cursor1");
			//カーソル位置の変更
			do 
			{
				this.cursorY += 1;
				this.cursorY %= 10;
			}while( this.cursorEnable[this.cursorY] == 0)
			//カーソルの表示
			this.DrawCursor();
			return 0;
		}


		//キャンセル
		if( xoInput.isTrigger("cancel") )
		{
			return "キャンセル";
		}


		//各種 値の操作
		//カーソル位置で処理を分岐
		switch (this.cursorY) 
		{
		//編集モード
		case 0:
			this.ExecMode();
			break;

		//色相
		case 2:
			this.ExecHue();
			break;

		//RGB
		case 3:
		case 4:
		case 5:
			this.ExecColor();
			break;

		//サンプルカラー
		case 8:
		case 9:
			this.ExecSampleColor();
			break;
		}
	}

	//=========================================================================================
	//■■■ 更新:モード ■■■
	//=========================================================================================
	ExecMode()
	{
		var v = 0;

		if( xoInput.isTrigger("right") )
		{ v = 1; }

		if( xoInput.isTrigger("left") )
		{ v = 5; }

		if (v != 0) 
		{
			PlaySE("Cursor1");
			this.EditMode += v;
			this.EditMode %= 6;
			//数値の再描画
			this.DrawValue();
			//サンプルカラーの再描画
			this.DrawSample();
		}
	}

	//=========================================================================================
	//■■■ 更新:色相 ■■■
	//=========================================================================================
	ExecHue()
	{
		var chr = $gameVariables.value(201);

		var col;
		switch (this.EditMode) 
		{
		case 0:	col = chr.skinColor;	break;
		case 1:	col = chr.nippleColor;	break;
		case 2:	col = chr.hairColor;	break;
		case 3:	col = chr.eyeColor;	break;
		case 4:	col = chr.earColor;	break;
		case 5:	col = chr.hornColor;	break;
		}

		var v = 0;
		if( xoInput.isPressTimer("right") )
		{ v = 10; }
		if( xoInput.isPressTimer("left") )
		{ v = 350; }


		if(v != 0)
		{
			PlaySE("Cursor1");
			col[0] += v;
			col[0] %= 360;

			//数値の再描画
			this.DrawValue();
			//サンプルカラーの再描画
			this.DrawSample();
		}

		//▼各種色設定
		switch (this.EditMode) 
		{
		case 0:	MgrCG.SetSkinColor();	break;
		case 1:	MgrCG.SetNippleColor();	break;
		case 2:	MgrCG.SetHairColor();	break;
		case 3:	MgrCG.SetEyeColor();	break;
		case 4:		break;
		case 5:	MgrCG.SetHornColor();	break;
		}
		//耳の色は複数のカラーを参照するので常に実行
		MgrCG.SetEarColor();

	}


	//=========================================================================================
	//■■■ 更新:カラー ■■■
	//=========================================================================================
	ExecColor()
	{
		var chr = $gameVariables.value(201);

		var col;
		switch (this.EditMode) 
		{
		case 0:	col = chr.skinColor;	break;
		case 1:	col = chr.nippleColor;	break;
		case 2:	col = chr.hairColor;	break;
		case 3:	col = chr.eyeColor;	break;
		case 4:	col = chr.earColor;	break;
		case 5:	col = chr.hornColor;	break;
		}


	
		var id = this.cursorY -2;

		var v = 0;
		if( xoInput.isPressTimer("right") )
		{
			if(col[id] != 255)
			{ v = 3; } 
		}
		if( xoInput.isPressTimer("left") )
		if( xoInput.isPressTimer("left") )
		{
			if(col[id] != 0)
			{ v = -3; } 
		}

		if(v != 0)
		{
			PlaySE("Cursor1");

			col[id] += v;

			//0～255で調整
			col[id] = Math.min(Math.max(col[id], 0), 255);

			//数値の再描画
			this.DrawValue();


			//▼各種色設定
			switch (this.EditMode) 
			{
			case 0:	MgrCG.SetSkinColor();	break;
			case 1:	MgrCG.SetNippleColor();	break;
			case 2:	MgrCG.SetHairColor();	break;
			case 3:	MgrCG.SetEyeColor();	break;
			case 4:		break;
			case 5:	MgrCG.SetHornColor();	break;
			}
			//耳の色は複数のカラーを参照するので常に実行
			MgrCG.SetEarColor();
		}
	}


	//=========================================================================================
	//■■■ 更新:サンプルカラー ■■■
	//=========================================================================================
	ExecSampleColor()
	{
	
		var v = 0;
		if( xoInput.isPressTimer("right") )
		{ v = 1; }
		if( xoInput.isPressTimer("left") )
		{ v = -1; }

		if(v != 0)
		{
			PlaySE("Cursor1");
			this.cursorX = (this.cursorX + v + 6) % 6
			//カーソルの再描画
			this.DrawCursor();
			return 0;
		}



		if( xoInput.isPressTimer("set") )
		{
			PlaySE("Cursor2");

			var chr = $gameVariables.value(201);
			var id = ((this.cursorY-8) * 6) + this.cursorX;


			//▼編集モード別にサンプルカラーを設定して、各種色設定
			switch (this.EditMode) 
			{
			//肌色
			case 0:
				chr.skinColor[1] = this.SampleColor0[id][0];
				chr.skinColor[2] = this.SampleColor0[id][1];
				chr.skinColor[3] = this.SampleColor0[id][2];
				MgrCG.SetSkinColor();
				MgrCG.SetEarColor();
				break;
			//乳首色
			case 1:
				chr.nippleColor[1] = this.SampleColor1[id][0];
				chr.nippleColor[2] = this.SampleColor1[id][1];
				chr.nippleColor[3] = this.SampleColor1[id][2];
				MgrCG.SetNippleColor();
				break;
			//髪色
			case 2:
				chr.hairColor[1] = this.SampleColor2[id][0];
				chr.hairColor[2] = this.SampleColor2[id][1];
				chr.hairColor[3] = this.SampleColor2[id][2];
				MgrCG.SetHairColor();
				MgrCG.SetEarColor();
				break;
			//瞳色
			case 3:
				chr.eyeColor[1] = this.SampleColor3[id][0];
				chr.eyeColor[2] = this.SampleColor3[id][1];
				chr.eyeColor[3] = this.SampleColor3[id][2];
				MgrCG.SetEyeColor();
				break;
			//耳色
			case 4:
				chr.earColor[1] = this.SampleColor4[id][0];
				chr.earColor[2] = this.SampleColor4[id][1];
				chr.earColor[3] = this.SampleColor4[id][2];
				MgrCG.SetEarColor();
				break;
			//角色
			case 5:
				chr.hornColor[1] = this.SampleColor5[id][0];
				chr.hornColor[2] = this.SampleColor5[id][1];
				chr.hornColor[3] = this.SampleColor5[id][2];
				MgrCG.SetHornColor();
				break;
			}

			//数値の再描画
			this.DrawValue();

		}
		
	}



	//=========================================================================================
	//■■■ 表示 ■■■
	//=========================================================================================
	Draw()
	{
		this.DrawBG();

		this.DrawCursor();

		this.DrawSample();

		this.DrawValue();
	}

	//=========================================================================================
	//■■■ 背景表示 ■■■
	//=========================================================================================
	DrawBG()
	{
		this.gi.pluginCommand("D_TEXT_SETTING", ["WINDOW", "ON"]);
		this.gi.pluginCommand("D_TEXT_SETTING", ["ALIGN", "0"]);
		this.gi.pluginCommand("D_TEXT", ["　　　　　　　　　　　　　　　", "22"]);
		this.gi.pluginCommand("D_TEXT", ["　"]);
		this.gi.pluginCommand("D_TEXT", ["　"]);
		this.gi.pluginCommand("D_TEXT", ["　"]);
		this.gi.pluginCommand("D_TEXT", ["　"]);
		this.gi.pluginCommand("D_TEXT", ["　"]);
		this.gi.pluginCommand("D_TEXT", ["　"]);
		this.gi.pluginCommand("D_TEXT", ["　"]);
		this.gi.pluginCommand("D_TEXT", ["　"]);
		this.gi.pluginCommand("D_TEXT", ["　"]);
		this.gi.pluginCommand("D_TEXT", ["　"]);
		this.gi.pluginCommand("D_TEXT", ["　"]);
		this.gi.pluginCommand("D_TEXT", ["　"]);
		this.gi.pluginCommand("D_TEXT", ["　"]);
		$gameScreen.showPicture(this.PID_BG,	"",  "lt", this.x, this.y, 100, 100, 255, 0);


		this.gi.pluginCommand("D_TEXT_SETTING", ["WINDOW", "OFF"]);
		this.gi.pluginCommand("D_TEXT_SETTING", ["ALIGN", "0"]);
		this.gi.pluginCommand("D_TEXT", [" 【 色調設定 】 ", "22"]);
		this.gi.pluginCommand("D_TEXT", ["　"]);
		this.gi.pluginCommand("D_TEXT", ["　　対象："]);
		this.gi.pluginCommand("D_TEXT", ["　"]);
		this.gi.pluginCommand("D_TEXT", ["　　色相："]);
		this.gi.pluginCommand("D_TEXT", ["　　Ｒ　："]);
		this.gi.pluginCommand("D_TEXT", ["　　Ｇ　："]);
		this.gi.pluginCommand("D_TEXT", ["　　Ｂ　："]);
		this.gi.pluginCommand("D_TEXT", ["　"]);
		this.gi.pluginCommand("D_TEXT", ["　[カラーサンプル]"]);
		$gameScreen.showPicture(this.PID_TITLE,	"",  "lt", this.x, this.y, 100, 100, 255, 0);
	}


	//=========================================================================================
	//■■■ サンプル表示 ■■■
	//=========================================================================================
	DrawSample()
	{
		var chr = $gameVariables.value(201);
		var hue;
		var rgb;


		$gameScreen.showPicture(this.PID_SAMPLE_0,	"sampleColor",  "lt", this.x+45+(40*0), this.y+300, 100, 100, 255, 0);
		$gameScreen.showPicture(this.PID_SAMPLE_1,	"sampleColor",  "lt", this.x+45+(40*1), this.y+300, 100, 100, 255, 0);
		$gameScreen.showPicture(this.PID_SAMPLE_2,	"sampleColor",  "lt", this.x+45+(40*2), this.y+300, 100, 100, 255, 0);
		$gameScreen.showPicture(this.PID_SAMPLE_3,	"sampleColor",  "lt", this.x+45+(40*3), this.y+300, 100, 100, 255, 0);
		$gameScreen.showPicture(this.PID_SAMPLE_4,	"sampleColor",  "lt", this.x+45+(40*4), this.y+300, 100, 100, 255, 0);
		$gameScreen.showPicture(this.PID_SAMPLE_5,	"sampleColor",  "lt", this.x+45+(40*5), this.y+300, 100, 100, 255, 0);

		$gameScreen.showPicture(this.PID_SAMPLE_6,	"sampleColor",  "lt", this.x+45+(40*0), this.y+340, 100, 100, 255, 0);
		$gameScreen.showPicture(this.PID_SAMPLE_7,	"sampleColor",  "lt", this.x+45+(40*1), this.y+340, 100, 100, 255, 0);
		$gameScreen.showPicture(this.PID_SAMPLE_8,	"sampleColor",  "lt", this.x+45+(40*2), this.y+340, 100, 100, 255, 0);
		$gameScreen.showPicture(this.PID_SAMPLE_9,	"sampleColor",  "lt", this.x+45+(40*3), this.y+340, 100, 100, 255, 0);
		$gameScreen.showPicture(this.PID_SAMPLE_10,	"sampleColor",  "lt", this.x+45+(40*4), this.y+340, 100, 100, 255, 0);
		$gameScreen.showPicture(this.PID_SAMPLE_11,	"sampleColor",  "lt", this.x+45+(40*5), this.y+340, 100, 100, 255, 0);

		switch(this.EditMode)
		{
		//肌色
		case 0:	hue = chr.skinColor[0];		rgb = this.SampleColor0;	break;
		//乳首色
		case 1:	hue = chr.nippleColor[0];	rgb = this.SampleColor1;	break;
		//髪色
		case 2:	hue = chr.hairColor[0];		rgb = this.SampleColor2;	break;
		//瞳色
		case 3:	hue = chr.eyeColor[0];		rgb = this.SampleColor3;	break;
		//耳色
		case 4:	hue = chr.earColor[0];		rgb = this.SampleColor4;	break;
		//角色
		case 5:	hue = chr.hornColor[0];		rgb = this.SampleColor5;	break;
		}


		//サンプルカラーの色相を設定
		for(var i=0; i<12; i++)
		{
			this.gi.pluginCommand("RotateHue", [""+(this.PID_SAMPLE_0+i), ""+hue ]);
			this.gi.pluginCommand("SetTint",   [""+(this.PID_SAMPLE_0+i), ""+rgb[i][0], ""+rgb[i][1], ""+rgb[i][2]]);
		}
	}

	//=========================================================================================
	//■■■ 値表示 ■■■
	//=========================================================================================
	DrawValue()
	{
		var chr = $gameVariables.value(201);

		var col;
		var txt= " ";
		switch (this.EditMode) 
		{
		case 0:
			col = chr.skinColor;
			txt = "肌色　";
			break;

		case 1:
			col = chr.nippleColor;
			txt = "乳首色";
			break;

		case 2:
			col = chr.hairColor;
			txt = "髪色　";
			break;

		case 3:
			col = chr.eyeColor;
			txt = "瞳色　";
			break;

		case 4:
			col = chr.earColor;
			txt = "耳色　";
			break;

		case 5:
			col = chr.hornColor;
			txt = "角色　";
			break;
		}

		this.gi.pluginCommand("D_TEXT_SETTING", ["WINDOW", "OFF"]);
		this.gi.pluginCommand("D_TEXT_SETTING", ["ALIGN", "1"]);
		this.gi.pluginCommand("D_TEXT", ["　　　　　　", "22"]);
		this.gi.pluginCommand("D_TEXT", ["　"]);
		this.gi.pluginCommand("D_TEXT", ["　"+txt+"　"]);
		this.gi.pluginCommand("D_TEXT", ["　"]);
		this.gi.pluginCommand("D_TEXT", ["　"+col[0]+"　"]);		//色相
		this.gi.pluginCommand("D_TEXT", ["　"+col[1]+"　"]);		//R
		this.gi.pluginCommand("D_TEXT", ["　"+col[2]+"　"]);		//G
		this.gi.pluginCommand("D_TEXT", ["　"+col[3]+"　"]);		//B

		$gameScreen.showPicture(this.PID_VALUE,	"",  "lt", this.x+120, this.y, 100, 100, 255, 0);
	}


	//=========================================================================================
	//■■■ カーソル表示 ■■■
	//=========================================================================================
	DrawCursor()
	{
		var x = this.cursorX * 40;
		var y = this.cursorY * 30;


		this.gi.pluginCommand("D_TEXT_SETTING", ["WINDOW", "OFF"]);
		this.gi.pluginCommand("D_TEXT_SETTING", ["ALIGN", "0"]);
		this.gi.pluginCommand("D_TEXT", [" ➡ ", "22"]);


		switch( this.cursorY )
		{
		case 0:
		case 1:
		case 2:
		case 3:
		case 4:
		case 5:
		case 6:
		case 7:
			$gameScreen.showPicture(this.PID_CURSOR,	"",  "lt", this.x, this.y+60+y, 100, 100, 255, 0);
			break;
		case 8:
			$gameScreen.showPicture(this.PID_CURSOR,	"",  "lt", this.x+30+x, this.y+65+y, 100, 100, 255, 0);
			break;
		case 9:
			$gameScreen.showPicture(this.PID_CURSOR,	"",  "lt", this.x+30+x, this.y+75+y, 100, 100, 255, 0);
			break;
		}
	}




	//=========================================================================================
	//■■■ 消去 ■■■
	//=========================================================================================
	Delete()
	{
		$gameScreen.erasePicture(this.PID_BG		);
		$gameScreen.erasePicture(this.PID_TITLE		);
		$gameScreen.erasePicture(this.PID_VALUE		);
		$gameScreen.erasePicture(this.PID_SAMPLE_0	);
		$gameScreen.erasePicture(this.PID_SAMPLE_1	);
		$gameScreen.erasePicture(this.PID_SAMPLE_2	);
		$gameScreen.erasePicture(this.PID_SAMPLE_3	);
		$gameScreen.erasePicture(this.PID_SAMPLE_4	);
		$gameScreen.erasePicture(this.PID_SAMPLE_5	);
		$gameScreen.erasePicture(this.PID_SAMPLE_6	);
		$gameScreen.erasePicture(this.PID_SAMPLE_7	);
		$gameScreen.erasePicture(this.PID_SAMPLE_8	);
		$gameScreen.erasePicture(this.PID_SAMPLE_9	);
		$gameScreen.erasePicture(this.PID_SAMPLE_10	);
		$gameScreen.erasePicture(this.PID_SAMPLE_11	);
		$gameScreen.erasePicture(this.PID_CURSOR		);

	}
}


(function () {




	// グローバルスコープに公開する
	window.cEditPanel_C = cEditPanel_C;
	// インスタンスを作成し、グローバルスコープに公開する
	window.EditPanel_C = new cEditPanel_C();
})();

