/*:
 * @plugindesc 
 * イベント編集用プラグイン
 * 
 * @help
 * 色々なところで使う変数や定数なんかを突っ込んでおく用
 * 使わないものも残ってるかも
 * 
 * 
 * @author ekus
 * @version 1.0
 * 
 * 
 */

class cEventEdit
{
	//=================================================================================
	//■■■ コンストラクタ ■■■
	//=================================================================================
	constructor()
	{
		this.Init();
	}

	//=================================================================================
	//■■■ コンストラクタ ■■■
	//=================================================================================
	Init()
	{
		this.LineHead	= 0;
		this.LineMax	= 200;
		this.Cursor		= 0;

	}
	//===========================================================================================
	//■■■ エディットリストの更新 ■■■
	//===========================================================================================
	Exec(t)
	{
		var cursorMv = 0;
		
		if (xoInput.isPressTimer("up")) 
		{ cursorMv = -1; }
		if (xoInput.isPressTimer("down")) 
		{ cursorMv = 1; }
		if (xoInput.isTrigger("pageup")) 
		{ cursorMv = -20; }
		if (xoInput.isTrigger("pagedown")) 
		{ cursorMv = 20; }

		if(cursorMv != 0)
		{
			PlaySE("Cursor1");


			//リストの先頭を移動
			this.Cursor += cursorMv;

			this.Cursor = Math.max(this.Cursor,  0);
			this.Cursor = Math.min(this.Cursor, this.LineMax-1);


			//空のラインに移動した場合、上にカーソルをずらす
			while( $gameVariables.value(501+this.Cursor) == 0 )
			{ this.Cursor--; }

			//「カーソル位置が、リストの先頭より上か末尾より下になった」場合、リストの先頭を移動
			while ((this.Cursor - this.LineHead) < 0) 
			{ this.LineHead -= 1; }
			while ((this.Cursor - this.LineHead) > 19) 
			{ this.LineHead += 1; }






			//リストを再描画
			this.Draw(t);
			return 0;
		}


		if (xoInput.isPressTimer("ok")) 
		{
			return "決定";
		}

		if (xoInput.isPressTimer("shift")) 
		{
			return "シフト";
		}


		if (xoInput.isTrigger("delete")) 
		{
			return "消去";
		}
	}

	//===========================================================================================
	//■■■ エディットリストの表示 ■■■
	//===========================================================================================
	Draw(t)
	{
		var txt;
		var cmnd;
		var col;

		$gameVariables.setValue(12, 0);


		//▼テキストラインの一覧
		t.pluginCommand("D_TEXT_SETTING", ["BG_COLOR", "rgba(0,0,0,0.5)"]);
		t.pluginCommand("D_TEXT_SETTING", ["ALIGN", "0"]);
		t.pluginCommand( "D_TEXT", [" \\oc[rgb(0,0,0)]", "22"]);

		for(var i=0; i<20; i++)
		{
			txt = $gameVariables.value(501 + this.LineHead + i);

			if( txt == 0)
			{ t.pluginCommand("D_TEXT", ["　　\\c[0]" + Get3keta(this.LineHead+i)  + ":---"]); }
			else
			{
				switch( txt.split(",")[0] )
				{
				case "※":
					col = "\\c[3]";
					break;

				case "CG差分":
				case "CG表示":
				case "CG消去":
					col = "\\c[1]";
					break;

				case "SE再生":
				case "BGM再生":
				case "BGM停止":
				case "BGS再生":
				case "BGS停止":
					col = "\\c[2]";
					break;

				case "シーン":
					col = "\\c[14]";
					break;

				case "選択":
				case "①":
				case "②":
				case "③":
				case "④":
				case "⑤":
				case "選択終":
					col = "\\c[24]";
					break;


				case "待機":
					col = "\\c[6]";
					break;

				case "フェード":
					col = "\\c[5]";
					break;

				default:
					col = "\\c[0]";
					break;
				}

				if (txt.length > 20) 
				{ txt = txt.slice(0, 20) + "..."; }
				
				t.pluginCommand("D_TEXT", ["　　" + col + Get3keta(this.LineHead+i)  + ":"+txt]);
			}
		}
		t.pluginCommand( "D_TEXT", ["　　　　　　　　　　　　　　　　　　　　　　　"]);

		$gameScreen.showPicture(99, "", "lt", 500,20,  100,100,  255,  0);

		//▼カーソル
		t.pluginCommand("D_TEXT_SETTING", ["WINDOW", "OFF"]);
		t.pluginCommand("D_TEXT_SETTING", ["ALIGN", "0"]);
		t.pluginCommand("D_TEXT", [" ➡", "22"]);
		$gameScreen.showPicture(100, "", "lt", 500,50+((this.Cursor-this.LineHead)*30),  100,100,  255,  0);

	} 

	//===========================================================================================
	//■■■ イベントの追加 ■■■
	//===========================================================================================
	Add(str)
	{

	}

	//===========================================================================================
	//■■■ イベントの追加 ■■■
	//===========================================================================================
	Add(str)
	{
		var l = $gameVariables.value(501+this.Cursor)
		var tmp;


		//「カーソル位置が0(空白)ではない」の場合、末尾から1つずつずらして空白を作る
		if(l != 0)
		{
			for(var i=this.LineMax-1; i>this.Cursor; i--)
			{
				tmp = $gameVariables.value(501+i-1);
				$gameVariables.setValue(501+i, tmp);
			}
		}

		$gameVariables.setValue(501+this.Cursor, str);
	}

	//===========================================================================================
	//■■■ イベントの上書き ■■■
	//===========================================================================================
	Overwrite(str)
	{
		$gameVariables.setValue(501+this.Cursor, str);
	}


	//===========================================================================================
	//■■■ イベントラインの消去■■■
	//===========================================================================================
	DeleteLine()
	{
		var tmp;

		for(var i=this.Cursor; i<this.LineMax-1; i++)
		{
			tmp = $gameVariables.value(501+i+1);
			$gameVariables.setValue(501+i, tmp);
		}

		$gameVariables.setValue(501+this.LineMax-1, 0);
	}


	//===========================================================================================
	//■■■ 消去 ■■■
	//===========================================================================================
	Delete()
	{
		$gameScreen.erasePicture(99);
		$gameScreen.erasePicture(100);
	}

}




(function () {
	




	// グローバルスコープに公開する
	window.cEventEdit = cEventEdit;
	// インスタンスを作成し、グローバルスコープに公開する
	window.xoEventEdit = new cEventEdit();



})();


