(function () {
	const path = require('path');
	const fs = require('fs');

	//========================================================================
	// ■ 共通処理：基準ディレクトリの取得
	//========================================================================
	const getBaseDir = function() {
		try {
			// 実行ファイル(Game.exe または nw.exe)の場所を取得
			const execPath = (typeof process !== 'undefined' && process.execPath) ? process.execPath : "";
			const execDir = path.dirname(execPath);

			// テストプレイ環境（エディタからの起動）かどうかの判定
			// 実行パスに「nwjs-win-test」が含まれる場合はプロジェクトフォルダ(cwd)を返す
			if (execDir.includes('nwjs-win-test')) {
				return process.cwd();
			}

			// 製品版：Game.exe がある階層を返す
			if (execPath) {
				return execDir;
			}
		} catch (e) {
			console.error("getBaseDir Error:", e);
		}
		return process.cwd();
	};

	//========================================================================
	// ■ 共通処理：入力リセットとフォーカス復帰
	//========================================================================
	const finalizeInput = function() {
		setTimeout(() => {
			if (typeof require === 'function') {
				try {
					const gui = require('nw.gui');
					gui.Window.get().focus();
				} catch (e) {}
			}
			window.focus();

			if (window.Input) {
				Input.clear();
				Input._currentState = {};
				Input._previousState = {};
				Input._latestButton = null;
				Input.update(); 
			}

			if (window.Graphics && typeof Graphics._updateCanvas === "function") {
				Graphics._updateCanvas();
			}
		}, 300);
	};

	const setupFocusHandler = function(input, state) {
		const onFocus = () => {
			setTimeout(() => {
				if (!state.selected && $gameVariables.value(1) === 0) {
					$gameVariables.setValue(1, "cancel");
				}
				finalizeInput();
				if (document.body.contains(input)) {
					document.body.removeChild(input);
				}
				window.removeEventListener('focus', onFocus);
			}, 200);
		};
		window.addEventListener('focus', onFocus);
	};

	//========================================================================
	// ■「開く」ダイアログ
	//========================================================================
	window.openFileDialog = function(args) {
		$gameVariables.setValue(1, 0);

		const input = document.createElement('input');
		input.type = 'file';
		input.accept = args && args[0] ? args[0] : '*/*';
        
		// パスの解決
		if (args && args[1]) {
			const absolutePath = path.join(getBaseDir(), args[1]);
			input.setAttribute('nwworkingdir', absolutePath);
		}

		input.style.display = 'none';
		document.body.appendChild(input);

		let state = { selected: false };

		input.addEventListener('change', () => {
			const file = input.files[0];
			if (file) {
				$gameVariables.setValue(1, file.path || file.name);
				state.selected = true;
				finalizeInput();
			}
		});

		setupFocusHandler(input, state);
		input.value = '';
		input.click();
	};

	//========================================================================
	// ■「名前を付けて保存」ダイアログ
	//========================================================================
	window.saveFileDialog = function(args, filename = "new_file") {
		$gameVariables.setValue(1, 0);

		const ext = args && args[0] ? args[0] : ".xos";
		const dir = args && args[1] ? args[1] : "";
        
		const input = document.createElement('input');
		input.type = 'file';

		let defaultName = filename;
		if (window.EventPath && window.EventPath !== "") {
			defaultName = window.EventPath.split(/\\|\//).pop();
		}
		if (!defaultName.endsWith(ext)) { defaultName += ext; }

		// パスの解決とフォルダの自動生成（念のため）
		const absoluteDir = path.join(getBaseDir(), dir);
		if (!fs.existsSync(absoluteDir)) {
			try {
				fs.mkdirSync(absoluteDir, { recursive: true });
			} catch (e) {
				console.error("Folder Create Error:", e);
			}
		}

		const fullSavePath = path.join(absoluteDir, defaultName);
		input.setAttribute('nwsaveas', fullSavePath);
		input.setAttribute('nwworkingdir', absoluteDir);
        
		input.accept = ext;
		input.style.display = 'none';
		document.body.appendChild(input);

		let state = { selected: false };

		input.addEventListener('change', () => {
			if (state.selected) return;
			const file = input.files[0];
			if (file) {
				$gameVariables.setValue(1, file.path || file.name);
				state.selected = true;
				finalizeInput();
			}
		});

		setupFocusHandler(input, state);
		input.value = '';
		input.click();
	};

	window.CHARA_DIR    = "MyCharacter/"
	window.SCENARIO_DIR = "MyScenario/"

})();