/*:
 * @plugindesc 任意の数値でゲージを表示・更新する簡易プラグイン（最大30本）ver1.1
 * @author ChatGPT
 *
 * @help
 * ◆使い方（スクリプトコマンドで使用）：
 *
 * ゲージを表示：
 *   showGauge(ID, x, y, width, height, min, max, value, color1, color2)
 * ゲージを表示(縦)：
 *   showGauge2(ID, x, y, width, height, min, max, value, color1, color2)
 *
 * ゲージを更新：
 *   updateGauge(ID, value)
 *
 * ゲージを消去：
 *   hideGauge(ID)
 */

(function () {
    const gaugeSprites = {};

    window.showGauge = function (id, x, y, width, height, min, max, value, color1, color2) {
        if (id < 1 || id > 30) return;

        const scene = SceneManager._scene;
        if (!scene || !scene.addChild) return;

        // 既存ゲージがある場合は削除
        if (gaugeSprites[id]) {
            scene.removeChild(gaugeSprites[id].sprite);
            delete gaugeSprites[id];
        }

        const sprite = new Sprite(new Bitmap(width, height));
        sprite.x = x;
        sprite.y = y;

        const data = {
            sprite: sprite,
            x: x,
            y: y,
            width: width,
            height: height,
            min: min,
            max: max,
            value: value,
            color1: color1,
            color2: color2
        };

        gaugeSprites[id] = data;
        scene.addChild(sprite);

        drawGauge(id);
    };


	window.showGauge2 = function (id, x, y, width, height, min, max, value, color1, color2) {
		if (id < 1 || id > 30) return;

		const scene = SceneManager._scene;
		if (!scene || !scene.addChild) return;

		// 既存ゲージがある場合は削除
		if (gaugeSprites[id]) {
			scene.removeChild(gaugeSprites[id].sprite);
			delete gaugeSprites[id];
		}

		const sprite = new Sprite(new Bitmap(width, height));
		sprite.x = x;
		sprite.y = y;

		const data = {
			sprite: sprite,
			x: x,
			y: y,
			width: width,
			height: height,
			min: min,
			max: max,
			value: value,
			color1: color1,
			color2: color2,
			vertical: true   // 縦方向のフラグ
		};

		gaugeSprites[id] = data;
		scene.addChild(sprite);

		drawGauge(id);
	};


    window.updateGauge = function (id, value) {
        const data = gaugeSprites[id];
        if (!data) return;
        data.value = value;
        drawGauge(id);
    };

    window.hideGauge = function (id) {
        const scene = SceneManager._scene;
        if (!scene || !scene.removeChild) return;
        const data = gaugeSprites[id];
        if (data) {
            scene.removeChild(data.sprite);
            delete gaugeSprites[id];
        }
    };

	function drawGauge(id) {
		const data = gaugeSprites[id];
		if (!data) return;

		const rate = (data.value - data.min) / (data.max - data.min);
		const clampedRate = rate.clamp(0, 1);
		const bitmap = data.sprite.bitmap;
		bitmap.clear();

		// 背景
		bitmap.fillRect(0, 0, data.width, data.height, "#000000");

		if (data.vertical) {
			// 縦ゲージ（下から上に）
			const fillH = Math.floor(clampedRate * data.height);
			const y = data.height - fillH;
			const grad = bitmap._context.createLinearGradient(0, data.height, 0, 0);
			grad.addColorStop(0, data.color1);
			grad.addColorStop(1, data.color2);
			bitmap._context.fillStyle = grad;
			bitmap._context.fillRect(0, y, data.width, fillH);
		} else {
			// 横ゲージ（左から右に）※既存の処理
			const fillW = Math.floor(clampedRate * data.width);
			const grad = bitmap._context.createLinearGradient(0, 0, data.width, 0);
			grad.addColorStop(0, data.color1);
			grad.addColorStop(1, data.color2);
			bitmap._context.fillStyle = grad;
			bitmap._context.fillRect(0, 0, fillW, data.height);
		}

		bitmap._setDirty();
	}


    // clamp補助
    Number.prototype.clamp = function(min, max) {
        return Math.min(Math.max(this, min), max);
    };
})();
