﻿/*:
 * @plugindesc Inputオブジェクトに新しいキーを追加するプラグイン
 * @author YourName
 *
 * @help このプラグインを使うことで、デフォルトでサポートされていないキーを追加し、
 * RPGツクールMVで簡単にそのキー入力を取得できるようにします。
 *
 * キー一覧:
 * 'p' - Pキー
 * 'alt' - Altキー
 * 他のキーも簡単に追加可能です。
 */

(function() {
	

	//===========================================================================================
	// 追加するキーとその対応するキーコードのマッピングを作成
	//===========================================================================================
	const additionalKeys = 
	{
		'x'		: 'KeyX',		// キー
		's'		: 'KeyS',		// キー
		'c'		: 'KeyC',		// キー
		'v'		: 'KeyV',		// キー
		'p'		: 'KeyP',		// キー
		'alt'		: 'AltLeft',	// 左Altキー
		'altRight'	: 'AltRight',	// 右Altキー
		'ctrl_L'	: 'ControlLeft',	// 左Ctrlキー
		'ctrl_R'	: 'ControlRight',	// 右Ctrlキー
		'delete'	: 'Delete'		// Deleteキーを追加
		// 他のキーを追加可能
	};

	//===========================================================================================
	// キーコードから対応するキー名を取得するための関数
	//===========================================================================================
	Input._additionalKeyMapper = function(event)
	{
		for (const key in additionalKeys)
		{
			if (event.code === additionalKeys[key])
			{
				return key;
			}
		}
		return null;
	};

	//===========================================================================================
	// オリジナルのonKeyDownに新しいキーリストの処理を追加
	//===========================================================================================
	const _Input_onKeyDown = Input._onKeyDown;
	Input._onKeyDown = function(event)
	{
		const keyName = Input._additionalKeyMapper(event);

		if (keyName)
		{
			this._currentState[keyName] = true;
		}

		// 元の処理を呼び出す
		_Input_onKeyDown.call(this, event);
	};

	//===========================================================================================
	// オリジナルのonKeyUpに新しいキーリストの処理を追加
	//===========================================================================================
	const _Input_onKeyUp = Input._onKeyUp;
	Input._onKeyUp = function(event)
	{
		const keyName = Input._additionalKeyMapper(event);

		if (keyName) 
		{
			this._currentState[keyName] = false;
		}

		// 元の処理を呼び出す
		_Input_onKeyUp.call(this, event);
	};

})();
