/*:
 * @plugindesc 
 * CGの表示を管理するクラス
 * 
 * @help
 * CGの表示を管理するクラス
 * 
 * 
 * @author ekus
 * @version 1.0
 * 
 * 
 */



class cMgrCg 
{

	//=================================================================================
	//■■■　コンストラクタ　■■■
	//=================================================================================
	constructor()
	{
		//眉のデータ
		this.EyebrowL = {name:"左眉", x:0, y:0, sx:100, sy:100, rot:0};
		this.EyebrowR = {name:"右眉", x:0, y:0, sx:100, sy:100, rot:0};
		//目のデータ
		this.EyeL = {name:"左目", x:0, y:0, sx:100, sy:100, rot:0};
		this.EyeR = {name:"右目", x:0, y:0, sx:100, sy:100, rot:0};
		//瞳のデータ
		//目線0
		this.PupilL0 = {name:"左瞳0", x:0, y:0, sx:100, sy:100, rot:0};
		this.PupilR0 = {name:"右瞳0", x:0, y:0, sx:100, sy:100, rot:0};
		//目線1
		this.PupilL1 = {name:"左瞳1", x:0, y:0, sx:100, sy:100, rot:0};
		this.PupilR1 = {name:"右瞳1", x:0, y:0, sx:100, sy:100, rot:0};
		//目線2
		this.PupilL2 = {name:"左瞳2", x:0, y:0, sx:100, sy:100, rot:0};
		this.PupilR2 = {name:"右瞳2", x:0, y:0, sx:100, sy:100, rot:0};
		//目線
		this.PupilL = {name:"左瞳2", x:0, y:0, sx:100, sy:100, rot:0};
		this.PupilR = {name:"右瞳2", x:0, y:0, sx:100, sy:100, rot:0};

		this.Edit;
	}

	 

	
	//=================================================================================
	//■■■ 初期化 ■■■
	//=================================================================================
	Init(gi, title, x, y)
	{
		this.gi = gi;

		//表示座標を設定
		this.x = x;
		this.y = y;

		//拡大率
		this.Scale		= 100;

		this.maskFlg = false;

		//指定されたCGのタイトルを記録しておく
		this.title = title;



		//特定の文字の場合、対象となるフォルダ名を設定
		var dir = title;
		switch(title)
		{
		case gCgType[0]:	dir = "sexA";	break;
		case gCgType[1]:	dir = "sexB";	break;
		case gCgType[2]:	dir = "sexC";	break;
		case gCgType[3]:	dir = "sexD";	break;
		case gCgType[4]:	dir = "sexZ";	break;
		case gCgType[5]:	dir = "stand";	break;
		case gCgType[6]:	dir = "stand";	break;
		case "edit":		dir = "stand";	break;
		}

		//対象となるフォルダ名を設定
		this.dir   = dir + "_" + Target.bodyType;


		//▼画像番号
		//全ての画像番号を初期化
		this.ResetPictId();

		//表示する種類別に番号を設定
		switch(dir)
		{
		case "stand":
			this.SetPictId_Edit();
			//表示座標を設定
			this.x = 168;
			this.y = 0;
			break;
		case "sexA":	this.SetPictId_SexA();	break;
		case "sexB":	this.SetPictId_SexB();	break;
		case "sexC":	this.SetPictId_SexC();	break;
		case "sexD":	this.SetPictId_SexD();	break;
		case "sexZ":	this.SetPictId_SexZ();	break;
		default:		console.log("※無効な読込を行おうとしました ["+dir+"]");
		}


		//差分関係
		this.emotEyebrow	= 0;
		this.emotEyeR		= 0;
		this.emotEyeL		= 0;
		this.emotPupil		= 0;
		this.emotMouth		= 0;
		this.emotHoho		= 0;
		this.emotVagina		= 0;
		this.emotPenis		= 0;
		this.emotBaby		= 0;
		this.emotHL			= 0;

		//ポーズ
		this.pose		= 0;


		this.emotEffect		= [	false, false, false, false, false,
								false, false, false, false, false,
								false, false, false, false, false,
								false, false, false, false, false];

		//着衣フラグ
		this.IsClothed = false;
	}

	//=================================================================================
	//■■■ 初期化 ■■■
	//=================================================================================
	ResetDir()
	{
		//表示する種類別に番号を設定
		switch(this.dir2)
		{
		case "stand":	this.SetPictId_Stand();	break;
		case "edit":	this.SetPictId_Edit();	break;
		case "sexA":	this.SetPictId_SexA();	break;
		case "sexB":	this.SetPictId_SexB();	break;
		case "sexC":	this.SetPictId_SexC();	break;
		case "sexD":	this.SetPictId_SexD();	break;
		case "sexZ":	this.SetPictId_SexZ();	break;
		}
	}

	//=========================================================================================
	//■■■ 消去 ■■■
	//=========================================================================================
	Delete()
	{
		//※画像が表示されていない場合は処理をしない

		//頬のマスクを解除
		if( $gameScreen.picture(this.PID_HOHO) )
		{ this.gi.pluginCommand("UnmaskPicture", [""+this.PID_HOHO]); }

		//瞳のマスクを解除
		if( $gameScreen.picture(this.PID_PUPIL_L) )
		{ this.gi.pluginCommand("UnmaskPicture", [""+this.PID_PUPIL_L]); }
		if( $gameScreen.picture(this.PID_PUPIL_R) )
		{ this.gi.pluginCommand("UnmaskPicture", [""+this.PID_PUPIL_R]); }
		
		//ハイライトのマスクを解除
		if ($gameScreen.picture(this.PID_PUPIL_LIGHT)) 
		{ this.gi.pluginCommand("UnmaskPicture", [""+this.PID_PUPIL_LIGHT]); }


		for (var i = this.PID_START; i <= this.PID_END; i++) 
		{ $gameScreen.erasePicture(i); }


		//フェード用の画像
		$gameScreen.erasePicture(this.PID_FADE);
	}

	//=========================================================================================
	//■■■ 消去(フェードは残す) ■■■
	//=========================================================================================
	Delete2()
	{
		//※画像が表示されていない場合は処理をしない

		//頬のマスクを解除
		if( $gameScreen.picture(this.PID_HOHO) )
		{ this.gi.pluginCommand("UnmaskPicture", [""+this.PID_HOHO]); }

		//瞳のマスクを解除
		if( $gameScreen.picture(this.PID_PUPIL_L) )
		{ this.gi.pluginCommand("UnmaskPicture", [""+this.PID_PUPIL_L]); }
		if( $gameScreen.picture(this.PID_PUPIL_R) )
		{ this.gi.pluginCommand("UnmaskPicture", [""+this.PID_PUPIL_R]); }
		
		//ハイライトのマスクを解除
		if ($gameScreen.picture(this.PID_PUPIL_LIGHT)) 
		{ this.gi.pluginCommand("UnmaskPicture", [""+this.PID_PUPIL_LIGHT]); }


		for (var i = this.PID_START; i <= this.PID_END; i++) 
		{ $gameScreen.erasePicture(i); }
	}

	//=========================================================================================
	//■■■ 移動 ■■■
	//=========================================================================================
	Move(x, y, f)
	{
		let p;

		for (var i = this.PID_START; i <= this.PID_END; i++) 
		{
			p = $gameScreen.picture(i);


			if(p != null)
			{
				$gameScreen.movePicture(i,
										p._origin,
										p._x+x, p._y+y,
										p._scaleX, p._scaleY,
										p._opacity,
										p._blendMode,
										f);
			}
		}
	}


	Move2(x, y)
	{
		let p;

		for (var i = this.PID_START; i <= this.PID_END; i++) 
		{
			p = $gameScreen.picture(i);


			if(p != null)
			{
				p._x += x;
				p._y += y;
			}
		}

		//基準位置もずらしておく
		this.x += x;
		this.y += y;
	}



	//=========================================================================================
	//■■■ 色調を設定 ■■■
	//=========================================================================================
	SetTint(color, list)
	{

		//色調値
		var r = color[1];
		var g = color[2];
		var b = color[3];


		for (var i = 0; i < list.length; i++) 
		{ 
			//「無効な値ではない」
			if (list[i] != 0) 
			{
				//「ピクチャが表示されている」
				if($gameScreen.picture(list[i]))
				{
					waitForPictureReady(list[i], this.gi.pluginCommand("SetTint", [""+list[i], ""+r, ""+g, ""+b]));
				}
			}
		}
	}
	//=========================================================================================
	//■■■ 色調を設定(光沢用) ■■■
	//=========================================================================================
	SetTint_Light(color, list)
	{

		//色調値
		var r = Math.floor((color[1]+255)/2);
		var g = Math.floor((color[2]+255)/2);
		var b = Math.floor((color[3]+255)/2);

		for (var i = 0; i < list.length; i++) 
		{ 
			//「無効な値ではない」
			if (list[i] != 0) 
			{
				//「ピクチャが表示されている」
				if($gameScreen.picture(list[i]))
				{
					waitForPictureReady(list[i], this.gi.pluginCommand("SetTint", [""+list[i], ""+r, ""+g, ""+b]));
				}
			}
		}
	}

	//=========================================================================================
	//■■■ 色相を設定 ■■■
	//=========================================================================================
	SetHue(color, list)
	{
		//色相値
		var v = color[0];

		for (var i = 0; i <list.length; i++) 
		{ 
			//「無効な値ではない」
			if (list[i] != 0) 
			{
				//「ピクチャが表示されている」
				if($gameScreen.picture(list[i]))
				{
					waitForPictureReady(list[i], this.gi.pluginCommand("RotateHue", [""+list[i], ""+v]) );
				}
			}
		}
	}
	//=========================================================================================
	//■■■ 色相を設定 ■■■
	//=========================================================================================
	SetGray(color, list)
	{
		//色相値
		var v = color[4];

		for (var i = 0; i <list.length; i++) 
		{ 
			//「無効な値ではない」
			if (list[i] != 0) 
			{
				//「ピクチャが表示されている」
				if($gameScreen.picture(list[i]))
				{
					waitForPictureReady(list[i], this.gi.pluginCommand("SetGray", [""+list[i], ""+v])) ;
				}
			}
		}
	}

	//=========================================================================================
	//■■■ 肌の色調設定(縮小版) ■■■
	//=========================================================================================
	SetSkinTint_Mini()
	{
		var list1 =[this.PID_BODY,
					this.PID_BOTE,
					this.PID_BUST,
					this.PID_HAIR_US,
					this.PID_EYE_L,
					this.PID_EYE_R,
					this.PID_MOUTH_S,
					this.PID_POSE];

		var list2 =[this.PID_BODY_LIGHT,
					this.PID_BUST_LIGHT];

		//色調設定
		this.SetTint(Target.skinColor, list1)
		this.SetTint_Light(Target.skinColor, list2);
	}
	SetSkinHue_Mini()
	{
		var list1 =[this.PID_BODY,
					this.PID_BOTE,
					this.PID_BUST,
					this.PID_HAIR_US,
					this.PID_EYE_L,
					this.PID_EYE_R,
					this.PID_MOUTH_S,
					this.PID_POSE];

		var list2 =[this.PID_BODY_LIGHT,
					this.PID_BUST_LIGHT];

		//色相設定
		this.SetHue(Target.skinColor, list1)
		this.SetHue(Target.skinColor, list2)
	}
	SetSkinGray()
	{
		var list = [this.PID_BODY,
					this.PID_BOTE,
					this.PID_BUST,
					this.PID_HAIR_US,
					this.PID_EYE_L,
					this.PID_EYE_R,
					this.PID_MOUTH_S,
					this.PID_POSE];
		//色相設定
		this.SetGray(Target.skinColor, list)
	}

	//=========================================================================================
	//■■■ 乳首色を変更 ■■■
	//=========================================================================================
	SetNippleTint()
	{
		var list = [this.PID_NIPPLE];
		//色調設定
		this.SetTint(Target.nippleColor, list)
	}
	SetNippleHue()
	{
		var list = [this.PID_NIPPLE];
		//色相設定
		this.SetHue(Target.nippleColor, list);
	}
	SetNippleGray()
	{
		var list = [this.PID_NIPPLE];
		//色相設定
		this.SetGray(Target.nippleColor, list);
	}
	//=========================================================================================
	//■■■ 髪色を変更 ■■■
	//=========================================================================================
	SetHairTint()
	{
		var list1 =[this.PID_HAIR_F, 
					this.PID_HAIR_S,
					this.PID_HAIR_B,
					this.PID_HAIR_T];

		var list2 =[this.PID_HAIR_F_LIGHT, 
					this.PID_HAIR_B_LIGHT];

		//色調設定
		this.SetTint(Target.hairColor, list1)
		this.SetTint_Light(Target.hairColor, list2);
	}

	SetHairHue()
	{
		var list1 =[this.PID_HAIR_F, 
					this.PID_HAIR_S,
					this.PID_HAIR_B,
					this.PID_HAIR_T];

		var list2 =[this.PID_HAIR_F_LIGHT, 
					this.PID_HAIR_B_LIGHT];

		//色相設定
		this.SetHue(Target.hairColor, list1);
		this.SetHue(Target.hairColor, list2);
	}

	SetHairGray()
	{
		var list1 =[this.PID_HAIR_F, 
					this.PID_HAIR_S,
					this.PID_HAIR_B,
					this.PID_HAIR_T];

		var list2 =[this.PID_HAIR_F_LIGHT, 
					this.PID_HAIR_B_LIGHT];

		//色相設定
		this.SetGray(Target.hairColor, list1);
		this.SetGray(Target.hairColor, list2);
	}
	//=========================================================================================
	//■■■ 眉色を変更 ■■■
	//=========================================================================================
	SetEyebrowTint()
	{
		this.SetTint(Target.eyebrowColor, [	this.PID_EYEBROW_L,
											this.PID_EYEBROW_R]);
	}
	SetEyebrowHue()
	{
		this.SetHue(Target.eyebrowColor, [	this.PID_EYEBROW_L,
											this.PID_EYEBROW_R]);
	}
	SetEyebrowGray()
	{
		this.SetGray(Target.eyebrowColor, [	this.PID_EYEBROW_L,
											this.PID_EYEBROW_R]);
	}
	//=========================================================================================
	//■■■ 白目色を変更 ■■■
	//=========================================================================================
	SetWeyeTint()
	{
		this.SetTint(Target.weyeColor, [this.PID_EYE_W_L,
										this.PID_EYE_W_R]);
	}
	SetWeyeHue()
	{
		this.SetHue(Target.weyeColor, [this.PID_EYE_W_L,
										this.PID_EYE_W_R]);
	}
	SetWeyeGray()
	{
		this.SetGray(Target.weyeColor, [this.PID_EYE_W_L,
										this.PID_EYE_W_R]);
	}
	//=========================================================================================
	//■■■ 瞳色を変更 ■■■
	//=========================================================================================
	SetPupilTint()
	{
		this.SetTint(Target.eyeColor, [	this.PID_PUPIL_R,
										this.PID_PUPIL_L]);
	}
	SetPupilHue()
	{
		this.SetHue(Target.eyeColor, [	this.PID_PUPIL_R,
										this.PID_PUPIL_L]);
	}
	SetPupilGray()
	{
		this.SetGray(Target.eyeColor, [	this.PID_PUPIL_R,
										this.PID_PUPIL_L]);
	}

	//=========================================================================================
	//■■■ 耳色を変更 ■■■
	//=========================================================================================
	SetEarTint()
	{
		var col;
		switch(Target.earType)
		{
		case 0:		col = Target.skinColor;		break;//人
		case 1:		col = Target.skinColor;		break;//エルフ
		case 2:		col = Target.hairColor;		break;//獣
		case 3:		col = [0, 255, 255, 255];	break;//牛
		case 6:		col = Target.hairColor;		break;//キツネ
		default:	col = Target.earColor;		break;//その他
		}
		//色調設定
		this.SetTint(col, [this.PID_EAR])
		this.SetTint(Target.earColorB, [this.PID_EAR_B])


	}
	SetEarHue()
	{
		var list = [this.PID_EAR];
		var col;
		switch(Target.earType)
		{
		case 0:		col = Target.skinColor;		break;//人
		case 1:		col = Target.skinColor;		break;//エルフ
		case 2:		col = Target.hairColor;		break;//獣
		case 3:		col = [0, 255, 255, 255];	break;//牛
		case 6:		col = Target.hairColor;		break;//キツネ
		default:	col = Target.earColor;		break;//その他
		}

		this.SetHue(col, list);
		this.SetHue(Target.earColorB, [this.PID_EAR_B])
	}
	SetEarGray()
	{
		var list = [this.PID_EAR];
		var col;
		switch(Target.earType)
		{
		case 0:		col = Target.skinColor;		break;//人
		case 1:		col = Target.skinColor;		break;//エルフ
		case 2:		col = Target.hairColor;		break;//獣
		case 3:		col = [0, 255, 255, 255];	break;//牛
		case 6:		col = Target.hairColor;		break;//キツネ
		default:	col = Target.earColor;		break;//その他
		}
		this.SetGray(col, list);
		this.SetGray(Target.earColorB, [this.PID_EAR_B])
	}




	//=========================================================================================
	//■■■ 角色を変更 ■■■
	//=========================================================================================
	SetHornTint()
	{
		this.SetTint(Target.hornColor, [this.PID_HORN]);
	}
	SetHornHue()
	{
		this.SetHue(Target.hornColor, [this.PID_HORN]);
	}
	SetHornGray()
	{
		this.SetGray(Target.hornColor, [this.PID_HORN]);
	}

	//=========================================================================================
	//■■■ 尻尾色を変更 ■■■
	//=========================================================================================
	SetTailTint()
	{
		var list = [this.PID_TAIL];
		var col = Target.tailColor;

		switch(Target.tailType)
		{
		case 0:		return;						break;//無し
		case 3:		col = [0, 255, 255, 255];	break;//牛
		default:	col = Target.tailColor;		break;//その他
		}
		this.SetTint(col, list);
	}
	SetTailHue()
	{
		var list = [this.PID_TAIL];
		var col = Target.tailColor;

		switch(Target.tailType)
		{
		case 0:		return;						break;//無し
		case 3:		col = [0, 255, 255, 255];	break;//牛
		default:	col = Target.tailColor;		break;//その他
		}
		this.SetHue(col, list);
	}
	SetTailGray()
	{
		var list = [this.PID_TAIL];
		var col = Target.tailColor;

		switch(Target.tailType)
		{
		case 0:		return;						break;//無し
		case 3:		col = [0, 255, 255, 255];	break;//牛
		default:	col = Target.tailColor;		break;//その他
		}
		this.SetGray(col, list);
	}

	//=========================================================================================
	//■■■ 陰毛色を変更 ■■■
	//=========================================================================================
	SetUnderHairTint()
	{
		//影の色調設定
		this.SetTint(Target.skinColor, [this.PID_HAIR_US])
		//陰毛の色調設定
		this.SetTint(Target.uHairColor, [this.PID_HAIR_U])
	}
	SetUnderHairHue()
	{
		//影の色相設定
		this.SetHue(Target.skinColor, [this.PID_HAIR_US])
		//陰毛の色相設定
		this.SetHue(Target.uHairColor, [this.PID_HAIR_U])
	}
	SetUnderHairGray()
	{
		//影の色相設定
		this.SetGray(Target.skinColor, [this.PID_HAIR_US])
		//陰毛の色相設定
		this.SetGray(Target.uHairColor, [this.PID_HAIR_U])
	}

	//=========================================================================================
	//■■■ 顔装飾色を変更 ■■■
	//=========================================================================================
	SetFaceAccrTint()
	{ 
		this.SetTint(Target.fAccrColor0, [this.PID_FACE_ACCR_0]); 
		this.SetTint(Target.fAccrColor1, [this.PID_FACE_ACCR_1]); 
	}
	SetFaceAccrHue()
	{
		this.SetHue(Target.fAccrColor0, [this.PID_FACE_ACCR_0]);
		this.SetHue(Target.fAccrColor1, [this.PID_FACE_ACCR_1]);
	}
	SetFaceAccrGray()
	{
		this.SetGray(Target.fAccrColor0, [this.PID_FACE_ACCR_0]);
		this.SetGray(Target.fAccrColor1, [this.PID_FACE_ACCR_1]);
	}

	//=========================================================================================
	//■■■ 顔装飾色を変更 ■■■
	//=========================================================================================
	SetBodyAccrTint()
	{ 
		this.SetTint(Target.bAccrColor, [	this.PID_BODY_ACCR_A,
											this.PID_BODY_ACCR_B,
											this.PID_BODY_ACCR_C,
											this.PID_BODY_ACCR_D,
											this.PID_BODY_ACCR_P]); 
	}
	SetBodyAccrHue()
	{
		this.SetHue(Target.bAccrColor, [	this.PID_BODY_ACCR_A,
											this.PID_BODY_ACCR_B,
											this.PID_BODY_ACCR_C,
											this.PID_BODY_ACCR_D,
											this.PID_BODY_ACCR_P]); 
	}
	SetBodyAccrGray()
	{
		this.SetGray(Target.bAccrColor, [	this.PID_BODY_ACCR_A,
											this.PID_BODY_ACCR_B,
											this.PID_BODY_ACCR_C,
											this.PID_BODY_ACCR_D,
											this.PID_BODY_ACCR_P]); 
	}


	//=========================================================================================
	//■■■ 淫紋色を変更 ■■■
	//=========================================================================================
	SetTattooTint()
	{ 
		this.SetTint(Target.TattooColor0, [ this.PID_TATTOO_N_0, this.PID_TATTOO_P_0 ]); 
		this.SetTint(Target.TattooColor1, [ this.PID_TATTOO_N_1, this.PID_TATTOO_P_1 ]); 
	}
	SetTattooHue()
	{
		this.SetHue(Target.TattooColor0, [ this.PID_TATTOO_N_0, this.PID_TATTOO_P_0 ]); 
		this.SetHue(Target.TattooColor1, [ this.PID_TATTOO_N_1, this.PID_TATTOO_P_1 ]); 
	}
	SetTattooGray()
	{
		this.SetGray(Target.TattooColor0, [ this.PID_TATTOO_N_0, this.PID_TATTOO_P_0 ]); 
		this.SetGray(Target.TattooColor1, [ this.PID_TATTOO_N_1, this.PID_TATTOO_P_1 ]); 
	}










}


(function () 
{
	// グローバルスコープに公開する
	window.cMgrCg = cMgrCg;
	// インスタンスを作成し、グローバルスコープに公開する
	window.MgrCG = new cMgrCg();
})();

