/*:
 * @plugindesc 
 * CGの表示を管理するクラス(差分関係)
 * 
 * @help
 * CGの表示を管理するクラスの内、差分表示に関する関数を入れておく
 * 
 * 
 * @author ekus
 * @version 1.0
 * 
 * 
 */


//
cMgrCg.prototype.DifferenceByStr = function(str)
{

	let type = str.substring(1) - 0;

	switch(str[0])
	{
	/*眉		*/case "A":	this.DifferenceEyebrow( type );		break;
	/*右目		*/case "B":	this.DifferenceEyeR( type );		break;
	/*左目		*/case "C":	this.DifferenceEyeL( type );		break;

	/*瞳		*/case "D":	this.DifferencePupil( type );		break;
	/*口		*/case "E":	this.DifferenceMouth( type );		break;
	/*頬		*/case "F":	this.DifferenceHoto( type );		break;

	/*女性器	*/case "G":	this.DifferenceVagina( type );		break;
	/*男性器	*/case "H":	this.DifferencePenis( type );		break;
	/*赤ちゃん	*/case "I":	this.DifferenceBaby( type );		break;

	/*ハイライト*/case "J":	this.DifferencePupilLight( type );	break;

	//各種エフェクト
	case "O":
	case "o":	this.DifferenceEffect( type, true);	break;
	case "X":
	case "x":	this.DifferenceEffect( type, false);	break;
	}
}



//-----------------------------------------------------------------------------------------
//■■■ 目の移動・拡縮・回転を設定 ■■■
//	※デバッグ用
//-----------------------------------------------------------------------------------------
cMgrCg.prototype.MoveEyes = function()
{
	this.MoveEyebrow();
	this.MoveEye();
	this.MovePupil(this.emotPupil); 
}

cMgrCg.prototype.SetMoveData = function (list, data) 
{
	for( var i=0; i<list.length; i++)
	{
		if($gameScreen.picture(list[i]) != null)
		{
			$gameScreen.picture(list[i])._x			= data.x+this.x;
			$gameScreen.picture(list[i])._y			= data.y+this.y;
			$gameScreen.picture(list[i])._scaleX	= data.sx;
			$gameScreen.picture(list[i])._scaleY	= data.sy;
			$gameScreen.picture(list[i])._angle		= data.rot;
		}
	}
}
//▼眉
cMgrCg.prototype.MoveEyebrow = function() 
{
	this.SetMoveData([this.PID_EYEBROW_L], this.EyebrowL); 
	this.SetMoveData([this.PID_EYEBROW_R], this.EyebrowR); 
}
//▼目
cMgrCg.prototype.MoveEye = function() 
{
	this.SetMoveData([	this.PID_EYEMASK_L, this.PID_EYE_W_L, this.PID_EYE_L], this.EyeL);
	this.SetMoveData([	this.PID_EYEMASK_R, this.PID_EYE_W_R, this.PID_EYE_R], this.EyeR);
}
//▼瞳
cMgrCg.prototype.MovePupil = function(type) 
{
	var d;

	//視線の種類
	switch(type % 10)
	{
	case 0:  d = this.PupilL0; break;
	case 1:  d = this.PupilL1; break;
	case 2:  d = this.PupilL2; break;
	case 3:  d = this.PupilL3; break;
	}


	//サイズの調整(10の位が設定されているかどうかで分岐)
	if(type < 10)
	{ d.sx = d.sy = 100; }
	else 
	{ d.sx = d.sy = 60; }

	//座標・拡縮・回転を計算
	this.PupilL.x   = this.EyeL.x   + d.x;
	this.PupilL.y   = this.EyeL.y   + d.y;
	this.PupilL.sx  = Math.floor(( this.EyeL.sx  * d.sx ) / -100);
	this.PupilL.sy  = Math.floor(( this.EyeL.sy  * d.sy ) / 100);
	this.PupilL.rot = this.EyeL.rot + d.rot;
	this.SetMoveData([this.PID_PUPIL_L, this.PID_PUPILLIGHT_L], this.PupilL);


	//右瞳
	switch(type%10)
	{
	case 0:  d=this.PupilR0; break;
	case 1:  d=this.PupilR1; break;
	case 2:  d=this.PupilR2; break;
	case 3:  d=this.PupilR3; break;
	}
	if(type < 10)
	{ d.sx = d.sy = 100; }
	else 
	{ d.sx = d.sy = 60; }

	this.PupilR.x   = this.EyeR.x   + d.x;
	this.PupilR.y   = this.EyeR.y   + d.y;
	this.PupilR.sx  = Math.floor(( this.EyeR.sx  * d.sx ) / 100);
	this.PupilR.sy  = Math.floor(( this.EyeR.sy  * d.sy ) / 100);
	this.PupilR.rot = this.EyeR.rot + d.rot;
	this.SetMoveData([this.PID_PUPIL_R, this.PID_PUPILLIGHT_R], this.PupilR);
}


//-----------------------------------------------------------------------------------------
//■■■ 表情の一括設定 ■■■
//-----------------------------------------------------------------------------------------
cMgrCg.prototype.changeFace = function (ary) 
{
	var str;
	var id;

	for(var i=0; i<ary.length; i++)
	{
		str = ary[i];
		v   = ary[i].slice(2)-0;

		//眉毛
		if( str.startsWith("EB") == true )
		{
			this.DifferenceEyebrow(v);
			continue;
		}

		//目
		if( str.startsWith("EY") == true )
		{
			this.DifferenceEye(v);
			continue;
		}

		//瞳のハイライト
		if( str.startsWith("PL") == true )
		{
			this.DifferencePupilLight(v);
			continue;
		}

		//瞳
		if( str.startsWith("PP") == true )
		{
			this.MovePupil(v);
			continue;
		}

		//頬
		if( str.startsWith("HH") == true )
		{
			this.DifferenceHoto(v)
			continue;
		}

		//口
		if( str.startsWith("MT") == true )
		{
			this.DifferenceMouth(v);
			continue;
		}
	}

	
	


}

//-----------------------------------------------------------------------------------------
//■■■ 眉 ■■■
//-----------------------------------------------------------------------------------------
cMgrCg.prototype.DifferenceEyebrow = function( emot = null ) 
{
	if (emot != null)
	{ this.emotEyebrow = emot; }


	var fn = "Eyes/m" + Target.eyebrowType +""+ this.emotEyebrow;

	//眉の読込
	//通常の読込
	$gameScreen.showPicture(this.PID_EYEBROW_L,			fn,		"cc", 0,0,  100,100, 255, 0);
	$gameScreen.showPicture(this.PID_EYEBROW_R,			fn,		"cc", 0,0,  100,100, 255, 0);

	//▼眉の色を設定
	this.SetEyebrowTint();
	this.SetEyebrowHue();
	this.SetEyebrowGray();

	//位置を調整	
	this.MoveEyebrow();
}


//-----------------------------------------------------------------------------------------
//■■■ 目 ■■■
//-----------------------------------------------------------------------------------------
cMgrCg.prototype.DifferenceEye = function(emot = null) 
{
	this.DifferenceEyeR(emot);
	this.DifferenceEyeL(emot);
}
cMgrCg.prototype.DifferenceEyeR = function(emot = null) 
{
	if (emot != null)
	{ this.emotEyeR = emot; }

	//通常の読込
	var fn = "Eyes/" + Target.eyeType　 +"" + this.emotEyeR;

	//白目(マスク用)
	$gameScreen.showPicture(this.PID_EYEMASK_R,			fn+"w",		"cc", 0,0,  100,100, 255, 0);
	//白目(表示用)
	$gameScreen.showPicture(this.PID_EYE_W_R,			fn+"w",		"cc", 0,0,  100,100, 255, 0);
	//目
	$gameScreen.showPicture(this.PID_EYE_R,				fn,			"cc", 0,0,  100,100, 255, 2);

	//▼白目の色を設定
	this.SetWeyeTint();
	this.SetWeyeHue();
	this.SetWeyeGray();

	//▼目の色を設定
	this.SetTint(Target.skinColor, [this.PID_EYE_R]);
	this.SetHue(Target.skinColor, [this.PID_EYE_R]);
	this.SetGray(Target.skinColor, [this.PID_EYE_R]);
	//位置を調整	
	this.MoveEye(); 
}

cMgrCg.prototype.DifferenceEyeL = function(emot = null) 
{
	if (emot != null)
	{ this.emotEyeL = emot; }

	//通常の読込
	var fn = "Eyes/" + Target.eyeType　 +"" + this.emotEyeL;

	//白目(マスク用)
	$gameScreen.showPicture(this.PID_EYEMASK_L,			fn+"w",		"cc", 0,0,  100,100, 255, 0);
	//白目(表示用)
	$gameScreen.showPicture(this.PID_EYE_W_L,			fn+"w",		"cc", 0,0,  100,100, 255, 0);
	//目
	$gameScreen.showPicture(this.PID_EYE_L,				fn,			"cc", 0,0,  100,100, 255, 2);

	//▼白目の色を設定
	this.SetWeyeTint();
	this.SetWeyeHue();
	this.SetWeyeGray();

	//▼目の色を設定
	this.SetTint(Target.skinColor, [this.PID_EYE_L]);
	this.SetHue(Target.skinColor, [this.PID_EYE_L]);
	this.SetGray(Target.skinColor, [this.PID_EYE_L]);

	//位置を調整	
	this.MoveEye(); 
}


//-----------------------------------------------------------------------------------------
//■■■ 瞳 ■■■
//-----------------------------------------------------------------------------------------
cMgrCg.prototype.DifferencePupil = function(type = null) 
{
	if (type != null)
	{ this.emotPupil = type; }

	this.MovePupil(this.emotPupil);
} 
//-----------------------------------------------------------------------------------------
//■■■ 瞳のハイライトの変更 ■■■
//-----------------------------------------------------------------------------------------
cMgrCg.prototype.DifferencePupilLight = function(type) 
{
	var pict;
	var x;
	var y;
	var sx;
	var sy;
	var angle;

	this.emotHL = type;



	switch (type) 
	{
	//標準
	case 0:	type = Target.pLightType;	break;
	//無し
	case 1: type = 1;	break;
	//♥
	case 2: type = 99;	break;
	}



	pict = $gameScreen.picture( this.PID_PUPILLIGHT_L );
	if(pict != null)
	{
		//必要な情報を取得
		x     = pict._x;
		y     = pict._y;
		sx    = pict._scaleX;
		sy    = pict._scaleY;
		angle = pict._angle;
		//指定の画像を読込
		$gameScreen.showPicture(this.PID_PUPILLIGHT_L,	"Eyes/pl"+type,	"cc", 30,30, 100,100, 255, 0);

		//元の情報を適用
		pict = $gameScreen.picture( this.PID_PUPILLIGHT_L );
		pict._x			= x;
		pict._y			= y;
		pict._scaleX	= sx;
		pict._scaleY	= sy;
		pict._angle		= angle;
	}
	
	pict = $gameScreen.picture( this.PID_PUPILLIGHT_R );
	if(pict != null)
	{
		//必要な情報を取得
		x     = pict._x;
		y     = pict._y;
		sx    = pict._scaleX;
		sy    = pict._scaleY;
		angle = pict._angle;
		//指定の画像を読込
		$gameScreen.showPicture(this.PID_PUPILLIGHT_R,	"Eyes/pl"+type,	"cc", 0,0, 100,100, 255, 0);

		//元の情報を適用
		pict = $gameScreen.picture( this.PID_PUPILLIGHT_R );
		pict._x			= x;
		pict._y			= y;
		pict._scaleX	= sx;
		pict._scaleY	= sy;
		pict._angle		= angle;
	}

	//ハイライトをマスク
	this.gi.pluginCommand("MaskPicture", [""+this.PID_PUPILLIGHT_L, ""+this.PID_EYEMASK_L]);
	this.gi.pluginCommand("MaskPicture", [""+this.PID_PUPILLIGHT_R, ""+this.PID_EYEMASK_R]);


}



//-----------------------------------------------------------------------------------------
//■■■ 頬(の不透明度) ■■■
//-----------------------------------------------------------------------------------------
cMgrCg.prototype.DifferenceHoto = function(alpha = null) 
{
	if (alpha != null) 
	{ this.emotHoho = alpha; }

	$gameScreen.movePicture(this.PID_HOHO, "lt", this.x,this.y,  this.Scale,this.Scale,  this.emotHoho,   2, 1);
}


//-----------------------------------------------------------------------------------------
//■■■ 口 ■■■
//-----------------------------------------------------------------------------------------
cMgrCg.prototype.DifferenceMouth = function(type = null) 
{
	if (type != null)
	{ this.emotMouth = type; }

	$gameScreen.showPicture(this.PID_MOUTH,			this.dir+"/mouth/"+(this.emotMouth%100),		"lt", this.x,this.y, this.Scale,this.Scale, 255, 0);
	$gameScreen.showPicture(this.PID_MOUTH_S,		this.dir+"/mouth/"+(this.emotMouth%100)+"s",	"lt", this.x,this.y, this.Scale,this.Scale, 255, 0);

	if (this.emotMouth >= 100)
	{ $gameScreen.showPicture(this.PID_MOUTH_Y,		this.dir+"/mouth/"+(this.emotMouth%100)+"y",	"lt", this.x,this.y, this.Scale,this.Scale, 255, 0); }
	else
	{ $gameScreen.showPicture(this.PID_MOUTH_Y,		this.dir+"/mouth/"+(this.emotMouth%100)+"y",	"lt", this.x,this.y, this.Scale,this.Scale, 0, 0); }



	//色調設定
	this.SetTint(Target.skinColor, [this.PID_MOUTH_S]);
	this.SetHue(Target.skinColor, [	this.PID_MOUTH_S]);
	this.SetGray(Target.skinColor, [	this.PID_MOUTH_S]);
}


//-----------------------------------------------------------------------------------------
//■■■ ボテ腹 ■■■
//-----------------------------------------------------------------------------------------
cMgrCg.prototype.DifferenceBote = function( flg ) 
{
	this.emotEffect[15] = flg;


	if(this.emotEffect[15] == true)
	{
		//ボテ腹と光沢を表示
		$gameScreen.movePicture(this.PID_BOTE,			"lt", this.x,this.y,  this.Scale,this.Scale, 255,   0, 1);
		$gameScreen.movePicture(this.PID_BOTE_LIGHT,	"lt", this.x,this.y,  this.Scale,this.Scale, 255,   0, 1);
		//対象の淫紋を表示
		$gameScreen.movePicture(this.PID_TATTOO_N_0,	"lt", this.x,this.y,  this.Scale,this.Scale,   0,   0, 1);
		$gameScreen.movePicture(this.PID_TATTOO_N_1,	"lt", this.x,this.y,  this.Scale,this.Scale,   0,   0, 1);
		$gameScreen.movePicture(this.PID_TATTOO_P_0,	"lt", this.x,this.y,  this.Scale,this.Scale, 255,   0, 1);
		$gameScreen.movePicture(this.PID_TATTOO_P_1,	"lt", this.x,this.y,  this.Scale,this.Scale, 255,   0, 1);

		//体装飾(下半身)の切り替え
		$gameScreen.movePicture(this.PID_BODY_ACCR_C,	"lt", this.x,this.y,  this.Scale,this.Scale,   0,   0, 1);
		$gameScreen.movePicture(this.PID_BODY_ACCR_D,	"lt", this.x,this.y,  this.Scale,this.Scale, 255,   0, 1);

	}
	else
	{
		//ボテ腹と光沢を透明化
		$gameScreen.movePicture(this.PID_BOTE,			"lt", this.x,this.y,  this.Scale,this.Scale,   0,   0, 1);
		$gameScreen.movePicture(this.PID_BOTE_LIGHT,	"lt", this.x,this.y,  this.Scale,this.Scale,   0,   0, 1);
		//対象の淫紋を表示
		$gameScreen.movePicture(this.PID_TATTOO_N_0,	"lt", this.x,this.y,  this.Scale,this.Scale, 255,   0, 1);
		$gameScreen.movePicture(this.PID_TATTOO_N_1,	"lt", this.x,this.y,  this.Scale,this.Scale, 255,   0, 1);
		$gameScreen.movePicture(this.PID_TATTOO_P_0,	"lt", this.x,this.y,  this.Scale,this.Scale,   0,   0, 1);
		$gameScreen.movePicture(this.PID_TATTOO_P_1,	"lt", this.x,this.y,  this.Scale,this.Scale,   0,   0, 1);

		//体装飾(下半身)の切り替え
		$gameScreen.movePicture(this.PID_BODY_ACCR_C,	"lt", this.x,this.y,  this.Scale,this.Scale, 255,   0, 1);
		$gameScreen.movePicture(this.PID_BODY_ACCR_D,	"lt", this.x,this.y,  this.Scale,this.Scale,   0,   0, 1);
	}

	//「着衣フラグがtrue」
	if( this.IsClothed == true )
	{
		//対象の淫紋を全て非表示に
		$gameScreen.movePicture(this.PID_TATTOO_N_0,	"lt", this.x,this.y,  this.Scale,this.Scale,   0,   0, 1);
		$gameScreen.movePicture(this.PID_TATTOO_N_1,	"lt", this.x,this.y,  this.Scale,this.Scale,   0,   0, 1);
		$gameScreen.movePicture(this.PID_TATTOO_P_0,	"lt", this.x,this.y,  this.Scale,this.Scale,   0,   0, 1);
		$gameScreen.movePicture(this.PID_TATTOO_P_1,	"lt", this.x,this.y,  this.Scale,this.Scale,   0,   0, 1);
		return;
	}

	//ぶっかけの表示を設定
	this.DifferenceEffect(18, this.emotEffect[18]); 
}


//ボテ腹が有効か無効か判定
cMgrCg.prototype.isBote = function( ) 
{
	return this.emotEffect[15];
}

//-----------------------------------------------------------------------------------------
//■■■ 男性器 ■■■
//-----------------------------------------------------------------------------------------
cMgrCg.prototype.DifferencePenis = function( type = null ) 
{
	if ( type != null )
	{ this.emotPenis = type; }


	//全パーツを一旦非表示に
	$gameScreen.movePicture(this.PID_PENIS_0, "lt", this.x,this.y,  this.Scale,this.Scale,    0,   0, 1);
	$gameScreen.movePicture(this.PID_PENIS_1, "lt", this.x,this.y,  this.Scale,this.Scale,    0,   0, 1);

	//特定のパーツだけ表示
	switch( this.emotPenis )
	{
	case 0:
		$gameScreen.movePicture(this.PID_PENIS_0, "lt", this.x,this.y,  this.Scale,this.Scale,  255,   0, 1);
		break;
	case 1:
		$gameScreen.movePicture(this.PID_PENIS_1, "lt", this.x,this.y,  this.Scale,this.Scale,  255,   0, 1);
		break;
	}
}
//-----------------------------------------------------------------------------------------
//■■■ 女性器 ■■■
//-----------------------------------------------------------------------------------------
cMgrCg.prototype.DifferenceVagina = function( type = null ) 
{
	if ( type != null )
	{ this.emotVagina = type; }

	//全パーツを一旦非表示に
	$gameScreen.movePicture(this.PID_VAGINA_0S, "lt", this.x,this.y,  this.Scale,this.Scale, 0,   0, 1);
	$gameScreen.movePicture(this.PID_VAGINA_0,  "lt", this.x,this.y,  this.Scale,this.Scale, 0,   0, 1);
	$gameScreen.movePicture(this.PID_VAGINA_1S, "lt", this.x,this.y,  this.Scale,this.Scale, 0,   0, 1);
	$gameScreen.movePicture(this.PID_VAGINA_1,  "lt", this.x,this.y,  this.Scale,this.Scale, 0,   0, 1);
	$gameScreen.movePicture(this.PID_VAGINA_2S, "lt", this.x,this.y,  this.Scale,this.Scale, 0,   0, 1);
	$gameScreen.movePicture(this.PID_VAGINA_2,  "lt", this.x,this.y,  this.Scale,this.Scale, 0,   0, 1);
	$gameScreen.movePicture(this.PID_VAGINA_3S, "lt", this.x,this.y,  this.Scale,this.Scale, 0,   0, 1);
	$gameScreen.movePicture(this.PID_VAGINA_3,  "lt", this.x,this.y,  this.Scale,this.Scale, 0,   0, 1);

	//
	switch( this.emotVagina )
	{
	case 0:
		$gameScreen.movePicture(this.PID_VAGINA_0S, "lt", this.x,this.y,  this.Scale,this.Scale,  255,   0, 1);
		$gameScreen.movePicture(this.PID_VAGINA_0,  "lt", this.x,this.y,  this.Scale,this.Scale,  255,   0, 1);
		break;
	case 1:
		$gameScreen.movePicture(this.PID_VAGINA_1S, "lt", this.x,this.y,  this.Scale,this.Scale,  255,   0, 1);
		$gameScreen.movePicture(this.PID_VAGINA_1,  "lt", this.x,this.y,  this.Scale,this.Scale,  255,   0, 1);
		break;
	case 2:
		$gameScreen.movePicture(this.PID_VAGINA_2S, "lt", this.x,this.y,  this.Scale,this.Scale,  255,   0, 1);
		$gameScreen.movePicture(this.PID_VAGINA_2,  "lt", this.x,this.y,  this.Scale,this.Scale,  255,   0, 1);
		break;
	case 3:
		$gameScreen.movePicture(this.PID_VAGINA_3S, "lt", this.x,this.y,  this.Scale,this.Scale,  255,   0, 1);
		$gameScreen.movePicture(this.PID_VAGINA_3,  "lt", this.x,this.y,  this.Scale,this.Scale,  255,   0, 1);
		break;
	}

}


//-----------------------------------------------------------------------------------------
//■■■ その他エフェクト ■■■
//-----------------------------------------------------------------------------------------
cMgrCg.prototype.DifferenceEffect = function(type, enable) 
{
	//特定の番号はボテ腹用
	if(type == 15)
	{
		this.DifferenceBote(enable);
		return;
	}


	if (enable == true) 
	{ this.emotEffect[type] = true; }
	else
	{ this.emotEffect[type] = false; }
 

	let alpha = 0;

	if (enable == true) 
	{ alpha = 255; }

	switch(type)
	{
	case  0: $gameScreen.movePicture(this.PID_E_ASE0,		 "lt", this.x,this.y,  this.Scale,this.Scale, alpha,   0, 1);	break;
	case  1: $gameScreen.movePicture(this.PID_E_ASE1,		 "lt", this.x,this.y,  this.Scale,this.Scale, alpha,   0, 1);	break;

	case  2: $gameScreen.movePicture(this.PID_E_SEMEN0,		 "lt", this.x,this.y,  this.Scale,this.Scale, alpha,   0, 1);	break;

	case  3: $gameScreen.movePicture(this.PID_E_SEMEN_V,	 "lt", this.x,this.y,  this.Scale,this.Scale, alpha,   0, 1);	break;
	case  4: $gameScreen.movePicture(this.PID_E_SEMEN_P,	 "lt", this.x,this.y,  this.Scale,this.Scale, alpha,   0, 1);	break;


	case  5: $gameScreen.movePicture(this.PID_E_LOVEJUICE0,	 "lt", this.x,this.y,  this.Scale,this.Scale, alpha,   0, 1);	break;
	case  6: $gameScreen.movePicture(this.PID_E_LOVEJUICE1,	 "lt", this.x,this.y,  this.Scale,this.Scale, alpha,   0, 1);	break;
	case  7: $gameScreen.movePicture(this.PID_E_LOVEJUICE2,	 "lt", this.x,this.y,  this.Scale,this.Scale, alpha,   0, 1);	break;
	case  8: $gameScreen.movePicture(this.PID_E_TITS,		 "lt", this.x,this.y,  this.Scale,this.Scale, alpha,   0, 1);	break;
	case  9: $gameScreen.movePicture(this.PID_E_TITSLINE,	 "lt", this.x,this.y,  this.Scale,this.Scale, alpha,   0, 1);	break;

	case 10: $gameScreen.movePicture(this.PID_E_BIKUN,		 "lt", this.x,this.y,  this.Scale,this.Scale, alpha,   0, 1);	break;
	case 11: $gameScreen.movePicture(this.PID_E_BIKUNLINE,	 "lt", this.x,this.y,  this.Scale,this.Scale, alpha,   0, 1);	break;
	case 12: $gameScreen.movePicture(this.PID_E_MOVELINE0,	 "lt", this.x,this.y,  this.Scale,this.Scale, alpha,   0, 1);	break;
	case 13: $gameScreen.movePicture(this.PID_E_MOVELINE1,	 "lt", this.x,this.y,  this.Scale,this.Scale, alpha,   0, 1);	break;
	case 14: $gameScreen.movePicture(this.PID_E_BREATH,		 "lt", this.x,this.y,  this.Scale,this.Scale, alpha,   0, 1);	break;

	case 16: $gameScreen.movePicture(this.PID_E_HEAD0,		 "lt", this.x,this.y,  this.Scale,this.Scale, alpha,   0, 1);	break;
	case 17: $gameScreen.movePicture(this.PID_E_HEAD1,		 "lt", this.x,this.y,  this.Scale,this.Scale, alpha,   0, 1);	break;

	//ぶっかけ
	case 18:
		$gameScreen.movePicture(this.PID_E_SEMEN_Bp,		 "lt", this.x,this.y,  this.Scale,this.Scale, 0,   0, 1);
		$gameScreen.movePicture(this.PID_E_SEMEN_B,			 "lt", this.x,this.y,  this.Scale,this.Scale, 0,   0, 1);
		//「ボテ腹が有効か無効か」で分岐
		if(this.isBote() == true)
		{ $gameScreen.movePicture(this.PID_E_SEMEN_Bp,		 "lt", this.x,this.y,  this.Scale,this.Scale, alpha,   0, 1); }
		else
		{ $gameScreen.movePicture(this.PID_E_SEMEN_B,		 "lt", this.x,this.y,  this.Scale,this.Scale, alpha,   0, 1); }
		break;


	case 19: $gameScreen.movePicture(this.PID_E_SEMEN1,	 "lt", this.x,this.y,  this.Scale,this.Scale, alpha,   0, 1);		break;

	}
}


//-----------------------------------------------------------------------------------------
//■■■ 赤ちゃんの差分 ■■■
//-----------------------------------------------------------------------------------------
cMgrCg.prototype.DifferenceBaby= function(type) 
{
	this.emotBaby		= type;

	$gameScreen.movePicture(this.PID_BABY_A0, "lt", this.x,this.y,  this.Scale,this.Scale,    0,   0, 1); 
	$gameScreen.movePicture(this.PID_BABY_B0, "lt", this.x,this.y,  this.Scale,this.Scale,    0,   0, 1); 
	$gameScreen.movePicture(this.PID_BABY_B1, "lt", this.x,this.y,  this.Scale,this.Scale,    0,   0, 1); 
	$gameScreen.movePicture(this.PID_HESONOO, "lt", this.x,this.y,  this.Scale,this.Scale,    0,   0, 1); 

	switch(type) 
	{ 
	case 1:
		$gameScreen.movePicture(this.PID_BABY_A0, "lt", this.x,this.y,  this.Scale,this.Scale,    255,   0, 1); 
		break;

	case 2:
		$gameScreen.movePicture(this.PID_BABY_B0, "lt", this.x,this.y,  this.Scale,this.Scale,    255,   0, 1); 
		$gameScreen.movePicture(this.PID_BABY_B1, "lt", this.x,this.y,  this.Scale,this.Scale,    255,   0, 1); 
		$gameScreen.movePicture(this.PID_HESONOO, "lt", this.x,this.y,  this.Scale,this.Scale,    255,   0, 1); 
		break;
	}
}